/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.jena.util.QuadUtils;
import org.aksw.commons.util.Pair;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfViewPattern;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.core.RdfView;
import org.aksw.sparqlify.core.RdfViewConjunction;
import org.aksw.sparqlify.core.RdfViewInstance;
import org.aksw.sparqlify.core.RdfViewSystem;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.ReplaceConstants;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.EqualsConstraint;
import org.aksw.sparqlify.database.FilterPlacementOptimizer2;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.NestedNormalForm;
import org.aksw.sparqlify.database.NestedStack;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.aksw.sparqlify.database.PrefixIndex;
import org.aksw.sparqlify.database.PrefixIndexMetaFactory;
import org.aksw.sparqlify.database.StartsWithConstraint;
import org.aksw.sparqlify.database.Table;
import org.aksw.sparqlify.database.TableBuilder;
import org.aksw.sparqlify.database.TreeIndex;
import org.aksw.sparqlify.database.VariableConstraint;
import org.aksw.sparqlify.database.ViewQuad;
import org.aksw.sparqlify.expr.util.NodeValueUtils;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.aksw.sparqlify.sparqlview.View;
import org.apache.commons.collections15.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.TwoWayBinding;

public class RdfViewSystem2
implements RdfViewSystem {
    private Logger logger = LoggerFactory.getLogger(RdfViewSystem2.class);
    private int viewId = 1;
    private Table<Object> table;
    PrefixIndex<Object> idxTest;
    private Set<RdfView> views = new HashSet<RdfView>();
    private static final String[] columnNames = new String[]{"g_prefix", "s_prefix", "p_prefix", "o_prefix"};

    public RdfViewSystem2() {
        TableBuilder<Object> builder = new TableBuilder<Object>();
        builder.addColumn("g_prefix", String.class);
        builder.addColumn("s_prefix", String.class);
        builder.addColumn("p_prefix", String.class);
        builder.addColumn("o_type", Integer.class);
        builder.addColumn("o_prefix", String.class);
        builder.addColumn("view", ViewQuad.class);
        this.table = builder.create();
        Transformer<Object, Set<String>> prefixExtractor = new Transformer<Object, Set<String>>(){

            public Set<String> transform(Object input) {
                return Collections.singleton(input.toString());
            }
        };
        PrefixIndexMetaFactory factory = new PrefixIndexMetaFactory(prefixExtractor);
        IndexMetaNode root = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "s_prefix");
        IndexMetaNode s = IndexMetaNode.create(root, (MetaIndexFactory)factory, "p_prefix");
        TreeIndex.attach(this.table, root);
        IndexMetaNode root2 = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "p_prefix");
        IndexMetaNode s2 = IndexMetaNode.create(root2, (MetaIndexFactory)factory, "s_prefix");
        TreeIndex.attach(this.table, root2);
    }

    @Override
    public void addView(RdfView view) {
        ++this.viewId;
        Set<Var> vars = view.getVarsMentioned();
        HashMap<Var, Var> rename = new HashMap<Var, Var>();
        for (Var var : vars) {
            rename.put(var, Var.alloc((String)("view" + this.viewId + "_" + var.getName())));
        }
        View copy = view.copySubstitute(rename);
        this.views.add((RdfView)copy);
        this.index((RdfView)copy);
    }

    public static Constraint deriveConstraint(Expr expr) {
        if (expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive) {
            return RdfViewSystem2.deriveConstraint(expr);
        }
        return null;
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcat expr) {
        return RdfViewSystem2.deriveConstraint(expr);
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcatPermissive expr) {
        return RdfViewSystem2.deriveConstraint(expr);
    }

    public static StartsWithConstraint deriveConstraintConcat(ExprFunction concat) {
        Expr arg;
        String prefix = "";
        Iterator i$ = concat.getArgs().iterator();
        while (i$.hasNext() && (arg = (Expr)i$.next()).isConstant()) {
            prefix = prefix + arg.getConstant().asUnquotedString();
        }
        return new StartsWithConstraint(prefix);
    }

    public Map<Var, RdfTermType> deriveTypeConstraints(RdfView view) {
        HashMap<Var, RdfTermType> result = new HashMap<Var, RdfTermType>();
        for (Map.Entry<Node, Expr> entry : view.getBinding().entrySet()) {
            Var var = (Var)entry.getKey();
            ExprFunction termCtor = (ExprFunction)entry.getValue();
            String functionIri = termCtor.getFunctionSymbol().getSymbol();
            if (functionIri.equals("http://aksw.org/sparqlify/rdfTerm")) {
                Expr arg = termCtor.getArg(1);
                if (!arg.isConstant()) continue;
                Object o = NodeValueUtils.getValue(arg.getConstant());
                Number number = (Number)o;
                switch (number.intValue()) {
                    case 1: {
                        result.put(var, RdfTermType.URI);
                        break;
                    }
                    case 2: 
                    case 3: {
                        result.put(var, RdfTermType.LITERAL);
                    }
                }
                continue;
            }
            if (functionIri.equals("http://aksw.org/sparqlify/uri")) {
                result.put(var, RdfTermType.URI);
                continue;
            }
            if (!functionIri.equals("http://aksw.org/sparqlify/plainLiteral") && !functionIri.equals("http://aksw.org/sparqlify/typedLiteral")) continue;
            result.put(var, RdfTermType.LITERAL);
        }
        return result;
    }

    public void deriveRestrictions(RdfView view) {
        RestrictionManagerImpl restrictions = view.getRestrictions();
        for (Map.Entry<Var, PrefixSet> entry : view.getConstraints().getVarPrefixConstraints().entrySet()) {
            restrictions.stateUriPrefixes(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Var, PrefixSet> entry : view.getBinding().entrySet()) {
            Var var = entry.getKey();
            ExprFunction termCtor = (ExprFunction)entry.getValue();
            Expr expr = (Expr)termCtor.getArgs().get(1);
            if (!(expr instanceof E_StrConcat) && !(expr instanceof E_StrConcatPermissive)) continue;
            StartsWithConstraint constraint = RdfViewSystem2.deriveConstraintConcat((ExprFunction)expr);
            restrictions.stateUriPrefixes(var, new PrefixSet(constraint.getPrefix()));
        }
    }

    public static RdfTermType getType(Node node, RestrictionManagerImpl restrictions) {
        if (node.isVariable()) {
            RestrictionImpl r = restrictions.getRestriction((Var)node);
            if (r != null) {
                return r.getType();
            }
        } else {
            if (node.isURI()) {
                return RdfTermType.URI;
            }
            if (node.isLiteral()) {
                return RdfTermType.LITERAL;
            }
        }
        return RdfTermType.UNKNOWN;
    }

    private void index(RdfView view) {
        RestrictionManagerImpl restrictions = new RestrictionManagerImpl();
        view.setRestrictions(restrictions);
        this.deriveRestrictions(view);
        Map<Var, PrefixSet> prefixConstraints = view.getConstraints().getVarPrefixConstraints();
        for (Map.Entry<Var, PrefixSet> entry : prefixConstraints.entrySet()) {
            restrictions.stateUriPrefixes(entry.getKey(), entry.getValue());
        }
        Map<Var, RdfTermType> typeConstraints = this.deriveTypeConstraints(view);
        for (Map.Entry<Var, RdfTermType> entry : typeConstraints.entrySet()) {
            restrictions.stateType(entry.getKey(), entry.getValue());
        }
        for (Quad quad : view.getQuadPattern()) {
            ArrayList<Collection<Object>> collections = new ArrayList<Collection<Object>>();
            for (int i = 0; i < 4; ++i) {
                Node node = QuadUtils.getNode((Quad)quad, (int)i);
                if (i == 3) {
                    RdfTermType type = RdfViewSystem2.getType(node, restrictions);
                    switch (type) {
                        case URI: {
                            collections.add(Collections.singleton(1));
                            break;
                        }
                        case LITERAL: {
                            collections.add(Collections.singleton(2));
                            break;
                        }
                        default: {
                            collections.add(Arrays.asList(1, 2));
                        }
                    }
                }
                if (node.isVariable()) {
                    PrefixSet p = prefixConstraints.get(node);
                    if (p != null) {
                        collections.add(p.getSet());
                        continue;
                    }
                    collections.add(Collections.singleton(""));
                    continue;
                }
                if (node.isURI()) {
                    collections.add(Collections.singleton(node.getURI()));
                    continue;
                }
                throw new RuntimeException("Should not happen");
            }
            ViewQuad viewQuad = new ViewQuad(view, quad);
            CartesianProduct cartesian = new CartesianProduct(collections);
            for (List item : cartesian) {
                ArrayList<ViewQuad> row = new ArrayList<ViewQuad>(item);
                row.add(viewQuad);
                this.table.add(row);
            }
        }
    }

    @Override
    public Op getApplicableViews(Query query) {
        Op optimizedFilters;
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        op = ReplaceConstants.replace(op);
        if (query.isSelectType() && query.isQueryResultStar()) {
            List vars = query.getProjectVars();
            op = new OpProject(op, vars);
        }
        Op augmented = this._getApplicableViews(op);
        Op result = optimizedFilters = FilterPlacementOptimizer2.optimize(augmented);
        return result;
    }

    public static VariableConstraint deriveIsPrefixOfConstraint(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Object value = NodeValueUtils.getValue(b.getConstant());
        return new VariableConstraint(a.getVarName(), new IsPrefixOfConstraint(value.toString()));
    }

    public static VariableConstraint deriveViewLookupConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            VariableConstraint c = RdfViewSystem2.deriveIsPrefixOfConstraint(e.getArg1(), e.getArg2());
            if (c == null) {
                c = RdfViewSystem2.deriveIsPrefixOfConstraint(e.getArg2(), e.getArg1());
            }
            return c;
        }
        return null;
    }

    public List<RdfViewConjunction> getApplicableViewsBase(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        ArrayList<RdfViewConjunction> result = new ArrayList<RdfViewConjunction>();
        QuadPattern queryQuads = op.getPattern();
        Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad>>> candidates = this.findQuadWithFewestViewCandidates(queryQuads, restrictions);
        NavigableMap nToQuads = (NavigableMap)candidates.getKey();
        Map quadToCandidates = (Map)candidates.getValue();
        ArrayList<Quad> order = new ArrayList<Quad>();
        for (Set quads : nToQuads.values()) {
            order.addAll(quads);
        }
        Set viewQuads = (Set)quadToCandidates.get(order.get(0));
        this.getApplicableViewsRec2(0, order, viewQuads, quadToCandidates, restrictions, null, result);
        return result;
    }

    public Set<ViewQuad> findCandidates(Quad quad, RestrictionManagerImpl restrictions) {
        HashSet constraints = new HashSet();
        Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
        Set<Clause> dnf = restrictions.getEffectiveDnf(quadVars);
        RestrictionImpl[] termRestriction = new RestrictionImpl[4];
        for (Clause clause : dnf) {
            HashMap<String, Constraint> hashMap = new HashMap<String, Constraint>();
            for (int i = 0; i < 4; ++i) {
                RestrictionImpl r;
                Node n = QuadUtils.getNode((Quad)quad, (int)i);
                Var var = (Var)QuadUtils.getNode((Quad)quad, (int)i);
                termRestriction[i] = r = clause.getRestriction(var);
                if (r == null || !r.getType().equals((Object)RdfTermType.URI) || !r.hasConstant()) continue;
                String columnName = columnNames[i];
                hashMap.put(columnName, new IsPrefixOfConstraint(r.getNode().getURI()));
            }
            RestrictionImpl r = termRestriction[3];
            if (r != null) {
                switch (r.getType()) {
                    case URI: {
                        hashMap.put("o_type", new EqualsConstraint(1));
                        break;
                    }
                    case LITERAL: {
                        hashMap.put("o_type", new EqualsConstraint(2));
                    }
                }
            }
            constraints.add(hashMap);
        }
        HashSet<ViewQuad> viewQuads = new HashSet<ViewQuad>();
        if (constraints.isEmpty()) {
            constraints.add(new HashMap());
        }
        for (Map map : constraints) {
            Collection<List<Object>> rows = this.table.select(map);
            for (List<Object> row : rows) {
                ViewQuad viewQuad = (ViewQuad)row.get(row.size() - 1);
                viewQuads.add(viewQuad);
            }
        }
        return viewQuads;
    }

    public Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad>>> findQuadWithFewestViewCandidates(QuadPattern queryQuads, RestrictionManagerImpl restrictions) {
        TreeMap<Integer, HashSet<Quad>> nToQuads = new TreeMap<Integer, HashSet<Quad>>();
        HashMap<Quad, Set<ViewQuad>> quadToCandidates = new HashMap<Quad, Set<ViewQuad>>();
        for (Quad quad : queryQuads) {
            if (quadToCandidates.containsKey(quad)) continue;
            Set<ViewQuad> viewQuads = this.findCandidates(quad, restrictions);
            int n = viewQuads.size();
            HashSet<Quad> nQuads = (HashSet<Quad>)nToQuads.get(n);
            if (nQuads == null) {
                nQuads = new HashSet<Quad>();
                nToQuads.put(n, nQuads);
            }
            nQuads.add(quad);
            quadToCandidates.put(quad, viewQuads);
        }
        return Pair.create(nToQuads, quadToCandidates);
    }

    public static List<String> getCandidateNames(NestedStack<RdfViewInstance> instances) {
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (RdfViewInstance instance : instances.asList()) {
                viewNames.add(instance.getParent().getName());
            }
        }
        return viewNames;
    }

    public void getApplicableViewsRec2(int index, List<Quad> quadOrder, Set<ViewQuad> viewQuads, Map<Quad, Set<ViewQuad>> candidates, RestrictionManagerImpl restrictions, NestedStack<RdfViewInstance> instances, List<RdfViewConjunction> result) {
        List<String> debug = Arrays.asList("view_nodes", "node_tags_resource_kv");
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (RdfViewInstance instance : instances.asList()) {
                viewNames.add(instance.getParent().getName());
            }
        }
        if (index >= quadOrder.size()) {
            throw new RuntimeException("Should not happen");
        }
        int nextIndex = index + 1;
        boolean isRecursionEnd = nextIndex == quadOrder.size();
        Quad queryQuad = quadOrder.get(index);
        int subId = 0;
        for (ViewQuad viewQuad : viewQuads) {
            ++subId;
            String viewName = viewQuad.getView().getName();
            RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(restrictions);
            RestrictionManagerImpl viewRestrictions = viewQuad.getView().getRestrictions();
            for (int i = 0; i < 4; ++i) {
                Var queryVar = (Var)QuadUtils.getNode((Quad)queryQuad, (int)i);
                Node viewNode = QuadUtils.getNode((Quad)viewQuad.getQuad(), (int)i);
                if (viewNode.isVariable()) {
                    Var viewVar = (Var)viewNode;
                    RestrictionImpl viewRs = viewRestrictions.getRestriction(viewVar);
                    if (viewRs != null) {
                        subRestrictions.stateRestriction(queryVar, viewRs);
                    }
                    if (subRestrictions.isUnsatisfiable() || subRestrictions.isUnsatisfiable()) {
                        break;
                    }
                } else {
                    subRestrictions.stateNode(queryVar, viewNode);
                }
                if (subRestrictions.isUnsatisfiable()) break;
            }
            if (subRestrictions.isUnsatisfiable()) continue;
            TwoWayBinding binding = TwoWayBinding.getVarMappingTwoWay(queryQuad, viewQuad.getQuad());
            int instanceId = index;
            RdfViewInstance instance = new RdfViewInstance(queryQuad, viewQuad.getQuad(), instanceId, subId, viewQuad.getView(), binding);
            NestedStack<RdfViewInstance> nextInstances = new NestedStack<RdfViewInstance>(instances, instance);
            if (isRecursionEnd) {
                RdfViewConjunction viewConjunction = new RdfViewConjunction(nextInstances.asList(), subRestrictions);
                RdfViewSystemOld.merge(viewConjunction);
                result.add(viewConjunction);
                continue;
            }
            Quad nextQuad = quadOrder.get(nextIndex);
            Set<ViewQuad> nextCandidates = this.findCandidates(nextQuad, subRestrictions);
            this.getApplicableViewsRec2(nextIndex, quadOrder, nextCandidates, candidates, subRestrictions, nextInstances, result);
        }
    }

    public Op getApplicableViews(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        List<RdfViewConjunction> conjunctions = this.getApplicableViewsBase(op, restrictions);
        OpDisjunction result = OpDisjunction.create();
        for (RdfViewConjunction item : conjunctions) {
            OpRdfViewPattern tmp = new OpRdfViewPattern(item);
            result.add((Op)tmp);
        }
        return result;
    }

    public static boolean isSatisfiable(List<RdfViewInstance> list) {
        TwoWayBinding completeBinding = new TwoWayBinding();
        boolean isOk = true;
        for (RdfViewInstance item : list) {
            if (!completeBinding.isCompatible(item.getBinding())) {
                isOk = false;
                break;
            }
            completeBinding.addAll(item.getBinding());
        }
        return isOk;
    }

    public Op _getApplicableViews(Op op) {
        return this._getApplicableViews(op, new RestrictionManagerImpl());
    }

    public Op _getApplicableViews(Op op, RestrictionManagerImpl restrictions) {
        return (Op)MultiMethod.invoke((Object)this, (String)"getApplicableViews", (Object[])new Object[]{op, restrictions});
    }

    public Op getApplicableViews(OpProject op, RestrictionManagerImpl restrictions) {
        return new OpProject(this._getApplicableViews(op.getSubOp(), restrictions), op.getVars());
    }

    public Op getApplicableViews(OpOrder op, RestrictionManagerImpl restrictions) {
        return new OpOrder(this._getApplicableViews(op.getSubOp(), restrictions), op.getConditions());
    }

    public Op getApplicableViews(OpGroup op, RestrictionManagerImpl restrictions) {
        return new OpGroup(this._getApplicableViews(op.getSubOp(), restrictions), op.getGroupVars(), op.getAggregators());
    }

    public Op getApplicableViews(OpExtend op, RestrictionManagerImpl _restrictions) {
        RestrictionManagerImpl restrictions = new RestrictionManagerImpl(_restrictions);
        for (Var var : op.getVarExprList().getVars()) {
            Expr expr = op.getVarExprList().getExpr(var);
            E_Equals item = new E_Equals((Expr)new ExprVar(var), expr);
            restrictions.stateExpr((Expr)item);
        }
        OpFilterIndexed filter = OpFilterIndexed.filter(restrictions, this._getApplicableViews(op.getSubOp(), restrictions));
        Op result = op.copy((Op)filter);
        return result;
    }

    public Op getApplicableViews(OpFilter op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(restrictions);
        for (Expr expr : op.getExprs()) {
            subRestrictions.stateExpr(expr);
        }
        return OpFilterIndexed.filter(subRestrictions, this._getApplicableViews(op.getSubOp(), subRestrictions));
    }

    public Op getApplicableViews(OpUnion op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl subRestrictionsLeft = new RestrictionManagerImpl(restrictions);
        RestrictionManagerImpl subRestrictionsRight = new RestrictionManagerImpl(restrictions);
        return OpDisjunction.create((Op)this._getApplicableViews(op.getLeft(), subRestrictionsLeft), (Op)this._getApplicableViews(op.getRight(), subRestrictionsRight));
    }

    public Op getApplicableViews(OpJoin op, RestrictionManagerImpl restrictions) {
        return OpJoin.create((Op)this._getApplicableViews(op.getLeft(), restrictions), (Op)this._getApplicableViews(op.getRight(), restrictions));
    }

    public static RestrictionManagerImpl filterRestrictionsBound(RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl result = new RestrictionManagerImpl();
        for (Clause clause : restrictions.getCnf()) {
            if (FilterPlacementOptimizer2.doesClauseContainBoundExpr(clause)) continue;
            result.stateCnf(new NestedNormalForm(Collections.singleton(clause)));
        }
        return result;
    }

    public Op getApplicableViews(OpLeftJoin op, RestrictionManagerImpl restrictions) {
        Op left = this._getApplicableViews(op.getLeft(), restrictions);
        RestrictionManagerImpl subRestrictions = RdfViewSystem2.filterRestrictionsBound(restrictions);
        RestrictionManagerImpl moreRestrictions = RdfViewSystem2.filterRestrictionsBound(RdfViewSystem2.getRestrictions2(left));
        if (moreRestrictions != null) {
            subRestrictions.stateRestriction(moreRestrictions);
        }
        if (op.getExprs() != null) {
            for (Expr expr : op.getExprs()) {
                subRestrictions.stateExpr(expr);
            }
        }
        Op right = this._getApplicableViews(op.getRight(), subRestrictions);
        return OpLeftJoin.create((Op)left, (Op)right, (ExprList)new ExprList());
    }

    public Op getApplicableViews(OpSlice op, RestrictionManagerImpl restrictions) {
        return new OpSlice(this._getApplicableViews(op.getSubOp(), restrictions), op.getStart(), op.getLength());
    }

    public Op getApplicableViews(OpDistinct op, RestrictionManagerImpl restrictions) {
        return new OpDistinct(this._getApplicableViews(op.getSubOp(), restrictions));
    }

    public static RestrictionManagerImpl getRestrictions2(Op op) {
        if (op instanceof OpFilterIndexed) {
            return ((OpFilterIndexed)op).getRestrictions();
        }
        if (op instanceof Op1) {
            return RdfViewSystem2.getRestrictions2(((Op1)op).getSubOp());
        }
        if (op instanceof OpJoin) {
            throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
        }
        if (op instanceof OpLeftJoin) {
            return RdfViewSystem2.getRestrictions2(((OpLeftJoin)op).getLeft());
        }
        if (op instanceof OpDisjunction) {
            return null;
        }
        if (op instanceof OpRdfViewPattern) {
            return null;
        }
        throw new RuntimeException("Should not happen");
    }

    public static List<RestrictionManagerImpl> getRestrictions(Op op) {
        ArrayList<RestrictionManagerImpl> result = new ArrayList<RestrictionManagerImpl>();
        RdfViewSystem2.getRestrictions(op, result);
        return result;
    }

    public static void getRestrictions(Op op, Collection<RestrictionManagerImpl> result) {
        if (op instanceof Op1) {
            RdfViewSystem2.getRestrictions(((Op1)op).getSubOp(), result);
        } else {
            if (op instanceof OpJoin) {
                throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
            }
            if (op instanceof OpLeftJoin) {
                RdfViewSystem2.getRestrictions(((OpLeftJoin)op).getLeft(), result);
            } else if (op instanceof OpDisjunction) {
                OpDisjunction o = (OpDisjunction)op;
                for (Op subOp : o.getElements()) {
                    RdfViewSystem2.getRestrictions(subOp, result);
                }
            } else if (op instanceof OpRdfViewPattern) {
                OpRdfViewPattern o = (OpRdfViewPattern)op;
                result.add(o.getConjunction().getRestrictions());
            } else {
                throw new RuntimeException("Should not happen");
            }
        }
    }

    @Override
    public Collection<RdfView> getViews() {
        return this.views;
    }
}

