/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.hp.hpl.jena.query.Query;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionFactoryBackQuery;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.sparqlify.core.interfaces.SparqlSqlStringRewriter;
import org.aksw.sparqlify.core.sparql.QueryExecutionSparqlify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionFactorySparqlifyDs
extends QueryExecutionFactoryBackQuery {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionFactorySparqlifyDs.class);
    private SparqlSqlStringRewriter rewriter;
    private DataSource dataSource;

    public QueryExecutionFactorySparqlifyDs(SparqlSqlStringRewriter rewriter, DataSource dataSource) {
        this.rewriter = rewriter;
        this.dataSource = dataSource;
    }

    public QueryExecutionStreaming createQueryExecution(Query query) {
        logger.info("Created qef for query: " + query);
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            logger.debug("Opened connection: [" + conn + "]");
            conn.setAutoCommit(false);
            QueryExecutionSparqlify result = new QueryExecutionSparqlify(this.rewriter, conn, true, query, (QueryExecutionFactory)this);
            return result;
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                    conn.close();
                }
                catch (SQLException f) {
                    throw new RuntimeException(f);
                }
            }
            throw new RuntimeException(e);
        }
    }

    public String getId() {
        throw new RuntimeException("Implement properly");
    }

    public String getState() {
        throw new RuntimeException("Implement properly");
    }
}

