/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.sparqlify.core.MakeExprPermissive;
import org.aksw.sparqlify.core.MakeNodeValue;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.openjena.riot.pipeline.normalize.CanonicalizeLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorResultSetSparqlifyBinding
extends SinglePrefetchIterator<Binding> {
    private static final Logger logger = LoggerFactory.getLogger(IteratorResultSetSparqlifyBinding.class);
    private CanonicalizeLiteral canonicalizer = CanonicalizeLiteral.get();
    private Connection conn;
    private ResultSet rs;
    private Multimap<Var, RestrictedExpr> sparqlVarMap;
    private long nextRowId;
    private Var rowIdVar;

    public static boolean isCharType(String typeName) {
        String tmp = typeName.toLowerCase();
        HashSet<String> charNames = new HashSet<String>(Arrays.asList("char"));
        boolean result = charNames.contains(tmp);
        return result;
    }

    public IteratorResultSetSparqlifyBinding(Connection conn, ResultSet rs, Multimap<Var, RestrictedExpr> sparqlVarMap) {
        this(conn, rs, sparqlVarMap, 0L, null);
    }

    public IteratorResultSetSparqlifyBinding(Connection conn, ResultSet rs, Multimap<Var, RestrictedExpr> sparqlVarMap, long nextRowId, String rowIdName) {
        this.conn = conn;
        this.rs = rs;
        this.sparqlVarMap = sparqlVarMap;
        this.nextRowId = nextRowId;
        this.rowIdVar = rowIdName == null ? null : Var.alloc((String)rowIdName);
    }

    protected Binding prefetch() throws Exception {
        if (!this.rs.next()) {
            return (Binding)super.finish();
        }
        ResultSetMetaData meta = this.rs.getMetaData();
        BindingHashMap binding = new BindingHashMap();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            NodeValue nodeValue;
            String tmp;
            String colName = meta.getColumnLabel(i);
            Object colValue = this.rs.getObject(i);
            if (colValue instanceof Date) {
                tmp = colValue.toString();
                nodeValue = NodeValue.makeDate((String)tmp);
            } else if (colValue instanceof Timestamp) {
                tmp = colValue.toString();
                String val = tmp.replace(' ', 'T');
                nodeValue = NodeValue.makeDateTime((String)val);
            } else {
                nodeValue = MakeNodeValue.makeNodeValue(colValue);
            }
            if (nodeValue == null) continue;
            Node node = nodeValue.asNode();
            Var indexVar = Var.alloc((String)("" + i));
            binding.add(indexVar, node);
            Var colVar = Var.alloc((String)colName);
            if (binding.contains(colVar)) continue;
            binding.add(colVar, node);
        }
        if (this.rowIdVar != null) {
            long rowId = this.nextRowId++;
            Node node = NodeValue.makeInteger((long)rowId).asNode();
            binding.add(this.rowIdVar, node);
        }
        boolean debugMode = true;
        BindingHashMap result = new BindingHashMap();
        for (Map.Entry entry : this.sparqlVarMap.asMap().entrySet()) {
            Node resultValue;
            Var bindingVar = (Var)entry.getKey();
            Collection candidateExprs = (Collection)entry.getValue();
            NodeValue value = null;
            HashSet usedVars = new HashSet();
            for (RestrictedExpr def : candidateExprs) {
                Expr expr = def.getExpr();
                boolean allBound = true;
                Set exprVars = expr.getVarsMentioned();
                for (Var var : exprVars) {
                    if (binding.contains(var)) continue;
                    allBound = false;
                    break;
                }
                if (!allBound) continue;
                if (value != null) {
                    if (usedVars.containsAll(expr.getVarsMentioned())) continue;
                    if (usedVars.equals(expr.getVarsMentioned())) {
                        throw new RuntimeException("Multiple expressions binding the variable (ambiguity) " + bindingVar + ": " + entry.getValue());
                    }
                    if (!expr.getVarsMentioned().containsAll(usedVars)) {
                        throw new RuntimeException("Multiple expressions binding the variable (overlap) " + bindingVar + ": " + entry.getValue());
                    }
                }
                expr = MakeExprPermissive.getInstance().deepCopy(expr);
                value = ExprUtils.eval((Expr)expr, (Binding)binding);
                if (debugMode) continue;
                break;
            }
            Node node = resultValue = value == null ? null : value.asNode();
            if (resultValue == null) {
                logger.trace("Null node for variable " + bindingVar + " - Might be undesired.");
                continue;
            }
            boolean isDatatypeCanonicalization = false;
            Node canonResultValue = this.canonicalizer.convert(resultValue);
            if (!isDatatypeCanonicalization && canonResultValue.isLiteral()) {
                String lex = canonResultValue.getLiteralLexicalForm();
                if (resultValue.isLiteral()) {
                    RDFDatatype originalType = resultValue.getLiteralDatatype();
                    if (originalType != null) {
                        canonResultValue = Node.createLiteral((String)lex, (RDFDatatype)originalType);
                    }
                } else {
                    throw new RuntimeException("Should not happen: Non-literal canonicalized to literal: " + resultValue + " became " + canonResultValue);
                }
            }
            result.add(bindingVar, canonResultValue);
        }
        return result;
    }

    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.conn != null) {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

