/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.domain.input;

import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.aksw.commons.jena.util.QuadUtils;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpLeaf;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpTable;
import org.aksw.sparqlify.core.algorithms.MappingOpsImpl;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewReference;
import org.aksw.sparqlify.core.interfaces.IViewDef;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.openjena.atlas.io.IndentedWriter;

public class ViewDefinition
implements IViewDef {
    public static final ViewDefinition emptyViewDefinition = new ViewDefinition("emptyView", new QuadPattern(), null, MappingOpsImpl.createEmptyMapping(), null);
    private String name;
    private QuadPattern template;
    private Mapping mapping;
    private Map<String, ViewReference> viewReferences;
    private RestrictionManagerImpl varRestrictions;
    private Object source;

    public ViewDefinition(String name, QuadPattern template, Map<String, ViewReference> viewReferences, Mapping mapping, Object source) {
        this(name, template, viewReferences, mapping, null, source);
    }

    public ViewDefinition(String name, QuadPattern template, Map<String, ViewReference> viewReferences, Mapping mapping, RestrictionManagerImpl varRestrictions, Object source) {
        this.name = name;
        this.template = template;
        this.mapping = mapping;
        this.viewReferences = viewReferences;
        this.varRestrictions = varRestrictions;
        this.source = source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QuadPattern getTemplate() {
        return this.template;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Map<String, ViewReference> getViewReferences() {
        return this.viewReferences;
    }

    public Object getSource() {
        return this.source;
    }

    @Override
    public ViewDefinition copyRenameVars(Map<Var, Var> oldToNew) {
        QuadPattern newTemplate = QuadUtils.copySubstitute((QuadPattern)this.template, oldToNew);
        VarDefinition varDef = this.mapping.getVarDefinition().copyRenameVars(oldToNew);
        Mapping m = new Mapping(varDef, this.mapping.getSqlOp());
        ViewDefinition result = new ViewDefinition(this.name, newTemplate, this.viewReferences, m, this);
        return result;
    }

    @Override
    public RestrictionManagerImpl getVarRestrictions() {
        return this.varRestrictions;
    }

    public void write(IndentedWriter writer) {
        SqlOp op;
        writer.println((Object)("Create View " + this.name + " As"));
        writer.incIndent();
        writer.println((Object)"Construct {");
        writer.incIndent();
        for (Quad quad : this.template) {
            writer.println((Object)quad);
        }
        writer.decIndent();
        writer.println((Object)"}");
        if (!this.mapping.getVarDefinition().isEmpty()) {
            writer.println((Object)"With");
            writer.incIndent();
            for (Map.Entry entry : this.mapping.getVarDefinition().getMap().entries()) {
                Var var = (Var)entry.getKey();
                RestrictedExpr rexpr = (RestrictedExpr)entry.getValue();
                writer.println((Object)(var + " = " + rexpr.getExpr() + "; Constraints " + rexpr.getRestrictions()));
            }
            writer.decIndent();
        }
        if ((op = this.mapping.getSqlOp()) != null) {
            SqlOpLeaf tmp;
            writer.println((Object)"From");
            writer.incIndent();
            if (op instanceof SqlOpTable) {
                tmp = (SqlOpTable)op;
                writer.println((Object)tmp.getTableName());
            } else if (op instanceof SqlOpQuery) {
                tmp = (SqlOpQuery)op;
                writer.println((Object)("[[" + tmp + "]]"));
            } else {
                writer.println((Object)op);
            }
            writer.decIndent();
        }
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IndentedWriter writer = new IndentedWriter((OutputStream)out);
        this.write(writer);
        writer.flush();
        writer.close();
        String result = out.toString();
        return result;
    }

    @Override
    public VarDefinition getVarDefinition() {
        return this.mapping.getVarDefinition();
    }

    public int hashCode() {
        throw new RuntimeException("Don't compare views with equal - use their name instead");
    }

    public boolean equals(Object obj) {
        throw new RuntimeException("Don't compare views with equal - use their name instead");
    }
}

