/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.datatypes.CoercionSystemOld;
import org.aksw.sparqlify.core.datatypes.TypeDistance;
import org.aksw.sparqlify.core.datatypes.TypeSystem;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.core.datatypes.XMethod;

public class XClassUtils {
    public static Integer getRelation(TypeDistance a, TypeDistance b) {
        int result = a.getCoercion() == null ? (b.getCoercion() == null ? a.getInheritanceDepth() - b.getInheritanceDepth() : -1) : (b.getCoercion() == null ? 1 : b.getInheritanceDepth() - a.getInheritanceDepth());
        return result;
    }

    public static Integer getRelation(TypeDistance[] a, TypeDistance[] b) {
        boolean hasGreater = false;
        boolean hasLess = false;
        for (int i = 0; i < a.length; ++i) {
            TypeDistance x = a[i];
            TypeDistance y = a[i];
            if (x == null || y == null) {
                throw new NullPointerException();
            }
            int d = XClassUtils.getRelation(x, y);
            if (d > 0) {
                hasGreater = true;
                continue;
            }
            if (d >= 0) continue;
            hasLess = true;
        }
        if (hasGreater && hasLess) {
            return null;
        }
        if (hasGreater) {
            return 1;
        }
        if (hasLess) {
            return -1;
        }
        return 0;
    }

    public static TypeDistance[] getTypeDistance(XClass[] a, XClass[] b, CoercionSystemOld coercions) {
        int n = Math.min(a.length, b.length);
        TypeDistance[] result = new TypeDistance[n];
        for (int i = 0; i < n; ++i) {
            XClass given = a[i];
            result[i] = given == null ? new TypeDistance(0, null) : XClassUtils.getTypeDistance(given, b[i], coercions);
        }
        return result;
    }

    public static TypeDistance getTypeDistance(XClass source, XClass target, CoercionSystemOld coercions) {
        Integer depth = XClassUtils.getDistance(source, target);
        TypeDistance result = depth != null ? new TypeDistance(depth, null) : XClassUtils.findCoercion(source, target, coercions);
        return result;
    }

    public static List<XClass> resolve(TypeSystem datatypeSystem, Collection<TypeToken> typeNames) {
        ArrayList<XClass> result = new ArrayList<XClass>(typeNames.size());
        for (TypeToken typeName : typeNames) {
            XClass tmp = datatypeSystem.getByName(typeName);
            if (tmp == null) {
                throw new RuntimeException("Could not resolve: " + typeName);
            }
            result.add(tmp);
        }
        return result;
    }

    public static Integer getDistance(XClass given, XClass there) {
        Integer result = XClassUtils._getDistanceInterface(given, there, 0);
        return result == Integer.MAX_VALUE ? null : result;
    }

    public static TypeDistance findCoercion(XClass source, XClass target, CoercionSystemOld coercions) {
        ArrayList<XClass> open = new ArrayList<XClass>();
        ArrayList<XClass> next = null;
        open.add(source);
        int depth = 0;
        while (!open.isEmpty()) {
            XMethod method = null;
            for (XClass item : open) {
                XMethod tmp = coercions.lookup(source, target);
                if (tmp != null && method != null) {
                    throw new RuntimeException("Multiple candidates: " + tmp + ", " + item);
                }
                method = tmp;
            }
            if (method != null) {
                TypeDistance result = new TypeDistance(depth, method);
                return result;
            }
            ++depth;
            if (next == null) {
                next = new ArrayList<XClass>();
            } else {
                next.clear();
            }
            for (XClass item : open) {
                next.addAll(item.getDirectSuperClasses());
            }
            ArrayList<XClass> swap = open;
            open = next;
            next = swap;
        }
        return null;
    }

    private static int _getDistanceInterface(XClass given, XClass there, int depth) {
        if (given == there) {
            return depth;
        }
        ++depth;
        int result = Integer.MAX_VALUE;
        for (XClass item : given.getDirectSuperClasses()) {
            result = Math.min(result, XClassUtils._getDistanceInterface(item, there, depth));
        }
        return result;
    }

    public static Integer[] getDistance(XClass[] a, XClass[] b) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n];
        for (int i = 0; i < n; ++i) {
            XClass given = a[i];
            result[i] = given == null ? Integer.valueOf(0) : XClassUtils.getDistance(given, b[i]);
        }
        return result;
    }

    public static Integer[] getDistance(XClass ra, XClass rb, XClass[] a, XClass[] b) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n + 1];
        result[0] = XClassUtils.getDistance(rb, ra);
        for (int i = 0; i < n; ++i) {
            Integer d;
            result[i + 1] = d = XClassUtils.getDistance(a[i], b[i]);
        }
        return result;
    }
}

