/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import com.hp.hpl.jena.graph.Node;
import java.util.List;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.datatypes.TypeSystem;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.core.datatypes.XClassUtils;

public class XClassImpl
implements XClass {
    private TypeSystem datatypeSystem;
    private TypeToken typeToken;
    private Node xsd;
    private Class<?> correspondingClass;

    public Node getXsd() {
        return this.xsd;
    }

    public XClassImpl(TypeSystem datatypeSytem, TypeToken typeToken, Node xsd, Class<?> correspondingClass) {
        this.datatypeSystem = datatypeSytem;
        this.typeToken = typeToken;
        this.correspondingClass = correspondingClass;
        this.xsd = xsd;
    }

    @Override
    public List<XClass> getDirectSuperClasses() {
        List<TypeToken> types = this.datatypeSystem.getDirectSuperClasses(this.typeToken);
        List<XClass> result = XClassUtils.resolve(this.datatypeSystem, types);
        return result;
    }

    public TypeSystem getDatatypeSystem() {
        return this.datatypeSystem;
    }

    @Override
    public String getName() {
        return this.typeToken.toString();
    }

    @Override
    public TypeToken getToken() {
        return this.typeToken;
    }

    public String toString() {
        return this.typeToken.toString();
    }

    @Override
    public Class<?> getCorrespondingClass() {
        return this.correspondingClass;
    }

    @Override
    public boolean isAssignableFrom(XClass that) {
        if (!(that instanceof XClassImpl)) {
            return false;
        }
        XClassImpl t = (XClassImpl)that;
        boolean result = this.datatypeSystem.isSuperClassOf(this.typeToken, t.typeToken);
        return result;
    }
}

