/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.util.MapReader;
import org.aksw.sparqlify.algebra.sparql.transform.MethodSignature;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.CandidateMethod;
import org.aksw.sparqlify.core.cast.DirectSuperTypeProvider;
import org.aksw.sparqlify.core.cast.FunctionModel;
import org.aksw.sparqlify.core.cast.MethodDistance;
import org.aksw.sparqlify.core.cast.MethodEntry;
import org.aksw.sparqlify.core.cast.ParamDistance;
import org.aksw.sparqlify.core.cast.TypeHierarchyProviderImpl;
import org.aksw.sparqlify.core.cast.TypeHierarchyUtils;
import org.aksw.sparqlify.core.cast.TypeSystemImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionModelImpl<T>
implements FunctionModel<T> {
    private static final Logger logger = LoggerFactory.getLogger(FunctionModel.class);
    private Map<String, MethodEntry<T>> idToMethodEntry = new HashMap<String, MethodEntry<T>>();
    private Multimap<String, String> nameToIds = HashMultimap.create();
    private DirectSuperTypeProvider<T> typeHierarchyProvider;
    private Multimap<T, MethodEntry<T>> sourceToTargets = ArrayListMultimap.create();
    private Map<String, String> inverses = new HashMap<String, String>();

    @Override
    public Map<String, String> getInverses() {
        return this.inverses;
    }

    @Override
    public String getNameById(String id) {
        String result = null;
        for (Map.Entry entry : this.nameToIds.entries()) {
            String tmpId = (String)entry.getValue();
            String name = (String)entry.getKey();
            if (!id.equals(tmpId)) continue;
            result = name;
            break;
        }
        return result;
    }

    public FunctionModelImpl(DirectSuperTypeProvider<T> typeHierarchyProvider) {
        this.typeHierarchyProvider = typeHierarchyProvider;
    }

    @Override
    public Collection<String> getIdsByName(String name) {
        Collection result = this.nameToIds.get((Object)name);
        return result;
    }

    public static void main(String[] args) throws IOException {
        Map typeHierarchy = MapReader.readFromResource((String)"/type-hierarchy.default.tsv");
        Map typeMap = MapReader.readFromResource((String)"/type-map.h2.tsv");
        typeMap.put("INTEGER", "int");
        typeHierarchy.putAll(typeMap);
        IBiSetMultimap<TypeToken, TypeToken> h = TypeSystemImpl.createHierarchyMap(typeHierarchy);
        TypeHierarchyProviderImpl thp = new TypeHierarchyProviderImpl(h);
        FunctionModelImpl<TypeToken> model = new FunctionModelImpl<TypeToken>(thp);
        model.registerFunction("plus_int", "+", MethodSignature.create(false, TypeToken.Int, TypeToken.Int, TypeToken.Int));
        model.registerCoercion("to_int", "to_int", MethodSignature.create(false, TypeToken.Int, TypeToken.Double));
        TypeToken Geometry = TypeToken.alloc("geometry");
        TypeToken Geography = TypeToken.alloc("geography");
        model.registerFunction("st_intersects_geometry", "st_intersects", MethodSignature.create(false, Geometry, Geometry));
        model.registerFunction("st_intersects_geography", "st_intersects", MethodSignature.create(false, Geography, Geography));
        Collection<CandidateMethod<TypeToken>> cands = model.lookupByName("+", Arrays.asList(Geometry, Geometry));
        System.out.println("Number of candidates: " + cands.size());
        System.out.println(cands);
    }

    public void lookupCoercionRec(T argType, T targetType, int depth, Set<CandidateMethod<T>> result) {
        Collection targets = this.sourceToTargets.get(argType);
        if (targets != null) {
            boolean found = false;
            for (MethodEntry target : targets) {
                Object tt = target.getSignature().getReturnType();
                Integer distance = TypeHierarchyUtils.getDistance(targetType, tt, this.typeHierarchyProvider);
                if (distance == null) continue;
                MethodDistance md = new MethodDistance(distance, depth);
                CandidateMethod candidate = new CandidateMethod(target, null, md);
                result.add(candidate);
                found = true;
            }
            if (found) {
                return;
            }
        }
        Collection<T> superTypes = this.typeHierarchyProvider.getDirectSuperTypes(argType);
        for (Object superType : superTypes) {
            this.lookupCoercionRec(superType, targetType, depth + 1, result);
        }
    }

    public Set<CandidateMethod<T>> lookupCoercions(T argType, T targetType) {
        HashSet<CandidateMethod<T>> result = new HashSet<CandidateMethod<T>>();
        this.lookupCoercionRec(argType, targetType, 0, result);
        return result;
    }

    public CandidateMethod<T> lookupCoercion(T argType, T targetType) {
        Set<CandidateMethod<T>> tmp = this.lookupCoercions(argType, targetType);
        CandidateMethod<T> result = tmp.size() != 1 ? null : tmp.iterator().next();
        return result;
    }

    @Override
    public void registerFunction(String id, String name, MethodSignature<T> signature) {
        MethodEntry<T> entry = new MethodEntry<T>(id, name, signature);
        this.idToMethodEntry.put(id, entry);
        this.nameToIds.put((Object)name, (Object)id);
    }

    @Override
    public void registerCoercion(String id, String name, MethodSignature<T> signature) {
        List<T> paramTypes = signature.getParameterTypes();
        if (paramTypes.size() != 1) {
            throw new RuntimeException("Coercions must only have 1 paramater");
        }
        T sourceType = paramTypes.get(0);
        Collection targets = this.sourceToTargets.get(sourceType);
        MethodEntry<T> entry = new MethodEntry<T>(id, name, signature);
        targets.add(entry);
        this.idToMethodEntry.put(id, entry);
    }

    @Override
    public MethodEntry<T> lookupById(String id) {
        MethodEntry<T> result = this.idToMethodEntry.get(id);
        return result;
    }

    public Collection<MethodEntry<T>> lookupByName(String name) {
        ArrayList<MethodEntry<T>> result = new ArrayList<MethodEntry<T>>();
        Collection ids = this.nameToIds.get((Object)name);
        for (String id : ids) {
            MethodEntry<T> method = this.idToMethodEntry.get(id);
            if (method == null) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    public Collection<CandidateMethod<T>> lookupByName(String functionName, List<T> argTypes) {
        Collection<MethodEntry<T>> signatures = this.lookupByName(functionName);
        Collection<CandidateMethod<T>> result = this.lookup(signatures, argTypes);
        return result;
    }

    @Override
    public Collection<CandidateMethod<T>> lookup(Collection<MethodEntry<T>> candidates, List<T> argTypes) {
        ArrayList<CandidateMethod<T>> result = new ArrayList<CandidateMethod<T>>();
        for (MethodEntry<T> candidate : candidates) {
            MethodSignature<T> signature = candidate.getSignature();
            List<T> paramTypes = signature.getParameterTypes();
            if (paramTypes.size() > argTypes.size() || !signature.isVararg() && paramTypes.size() < argTypes.size()) continue;
            int n = argTypes.size();
            int m = paramTypes.size();
            boolean isCandidate = true;
            ArrayList<ParamDistance> distances = new ArrayList<ParamDistance>(argTypes.size());
            ArrayList coercions = new ArrayList();
            for (int i = 0; i < n; ++i) {
                T paramType = i < m ? paramTypes.get(i) : signature.getVarArgType();
                T argType = argTypes.get(i);
                boolean usesCoercion = false;
                Integer distance = TypeHierarchyUtils.getDistance(argType, paramType, this.typeHierarchyProvider);
                CandidateMethod<T> coercion = null;
                if (distance == null) {
                    coercion = this.lookupCoercion(argType, paramType);
                    if (coercion == null) {
                        isCandidate = false;
                    } else {
                        distance = coercion.getDistance().getArgTypeDistances().get(0).getDistance();
                        usesCoercion = true;
                    }
                }
                coercions.add(coercion);
                ParamDistance dist = new ParamDistance(distance, usesCoercion);
                distances.add(dist);
                if (!isCandidate) break;
            }
            if (!isCandidate) continue;
            MethodDistance distance = new MethodDistance(new ParamDistance(0, false), distances);
            CandidateMethod<T> tmp = new CandidateMethod<T>(candidate, coercions, distance);
            result.add(tmp);
        }
        return result;
    }
}

