/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprFunction;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprVar;

@Deprecated
public class SqlExprSubstitutor {
    private Map<String, ? extends SqlExpr> map;

    public SqlExprSubstitutor(Map<String, ? extends SqlExpr> map) {
        this.map = map;
    }

    public List<SqlExpr> substitute(List<SqlExpr> exprs) {
        ArrayList<SqlExpr> result = new ArrayList<SqlExpr>(exprs.size());
        for (SqlExpr expr : exprs) {
            SqlExpr newExpr = this.substitute(expr);
            result.add(newExpr);
        }
        return result;
    }

    public SqlExpr substitute(SqlExpr expr) {
        SqlExpr result;
        if (expr == null) {
            throw new NullPointerException();
        }
        assert (expr != null) : "Expr must not be null";
        assert (expr.getType() != null) : "Type of exprs must not be null";
        switch (expr.getType()) {
            case Constant: {
                result = expr;
                break;
            }
            case Function: {
                SqlExprFunction fn = expr.asFunction();
                List<SqlExpr> args = fn.getArgs();
                assert (!Iterables.contains(args, null)) : "Null argument in expr: " + fn;
                List<SqlExpr> newArgs = this.substitute(args);
                result = fn.copy(newArgs);
                break;
            }
            case Variable: {
                SqlExprVar var = expr.asVariable();
                String name = var.getVarName();
                SqlExpr substitute = this.map.get(name);
                if (substitute != null) {
                    result = substitute;
                    break;
                }
                result = expr;
                break;
            }
            default: {
                throw new RuntimeException("Should not happen");
            }
        }
        return result;
    }

    public SqlExpr trySubstitute(S_ColumnRef sqlExpr) {
        SqlExpr substitute = this.map.get(sqlExpr);
        return substitute == null ? sqlExpr : substitute;
    }

    public static SqlExprSubstitutor create(Map<String, SqlExpr> map) {
        SqlExprSubstitutor result = new SqlExprSubstitutor(map);
        return result;
    }
}

