/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprConstant;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprFunction;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.FunctionRegistrySql;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.datatypes.Invocable;
import org.aksw.sparqlify.core.datatypes.SqlMethodCandidate;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.core.transformations.ExprEvaluatorPartial;

public class ExprEvaluatorSql {
    private ExprEvaluatorPartial subEvaluator;
    private FunctionRegistrySql sqlFunctionRegistry;
    private TypeSystem datatypeSystem;

    public ExprEvaluatorSql(TypeSystem datatypeSystem, FunctionRegistrySql sqlFunctionRegistry) {
        this.datatypeSystem = datatypeSystem;
        this.sqlFunctionRegistry = sqlFunctionRegistry;
    }

    public List<SqlExpr> transform(Iterable<SqlExpr> exprs, Map<String, XClass> typeMap) {
        ArrayList<SqlExpr> result = new ArrayList<SqlExpr>();
        for (SqlExpr expr : exprs) {
            SqlExpr evaledExpr = this.eval(expr, typeMap);
            result.add(evaledExpr);
        }
        return result;
    }

    public SqlExpr eval(SqlExpr expr, Map<String, XClass> typeMap) {
        SqlExprFunction result;
        if (expr.isFunction()) {
            SqlExprFunction fn = expr.asFunction();
            List<SqlExpr> transformedArgs = this.transform(expr.getArgs(), typeMap);
            ArrayList<TypeToken> argTypes = new ArrayList<TypeToken>(transformedArgs.size());
            for (SqlExpr arg : transformedArgs) {
                argTypes.add(arg.getDatatype());
            }
            SqlMethodCandidate method = null;
            if (method == null) {
                throw new RuntimeException("SPARQL Function " + fn.getName() + " not declared");
            }
            Invocable invocable = method.getInvocable();
            if (invocable != null && ExprEvaluatorSql.isConstantsOnly(transformedArgs)) {
                Object[] argValues = new Object[transformedArgs.size()];
                for (int i = 0; i < transformedArgs.size(); ++i) {
                    Object value;
                    SqlExpr tmp = transformedArgs.get(i);
                    SqlExprConstant c = tmp.asConstant();
                    SqlValue sqlValue = c.getValue();
                    argValues[i] = value = sqlValue.getValue();
                }
                Object fnResult = invocable.invoke(argValues);
                throw new RuntimeException("Is this still in use?");
            }
            result = fn;
        } else {
            if (expr.isConstant()) {
                return expr;
            }
            if (expr.isVariable()) {
                result = null;
            } else {
                throw new RuntimeException("Should not happen");
            }
        }
        return result;
    }

    public static boolean isConstantsOnly(Iterable<SqlExpr> exprs) {
        for (SqlExpr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantArgsOnly(SqlExprFunction fn) {
        boolean result = ExprEvaluatorSql.isConstantsOnly(fn.getArgs());
        return result;
    }
}

