/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.util.factory.Factory1;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.DatatypeToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeToStringPostgres
implements DatatypeToString {
    private static final Logger logger = LoggerFactory.getLogger(DatatypeToStringPostgres.class);
    private Map<String, String> nameToPostgres = new HashMap<String, String>();

    public DatatypeToStringPostgres() {
        this.nameToPostgres.put("boolean", "boolean");
        this.nameToPostgres.put("float", "double precision");
        this.nameToPostgres.put("double", "double precision");
        this.nameToPostgres.put("integer", "integer");
        this.nameToPostgres.put("string", "text");
        this.nameToPostgres.put("geometry", "geometry");
        this.nameToPostgres.put("geography", "geography");
        this.nameToPostgres.put("int", "integer");
        this.nameToPostgres.put("long", "bigint");
        this.nameToPostgres.put("datetime", "date");
        this.nameToPostgres.put("dateTime", "date");
        this.nameToPostgres.put("timestamp", "timestamp");
        this.nameToPostgres.put("int4", "int4");
        this.nameToPostgres.put("text", "text");
        this.nameToPostgres.put("VARCHAR", "VARCHAR");
        this.nameToPostgres.put("DOUBLE", "DOUBLE");
        this.nameToPostgres.put("INTEGER", "INTEGER");
        this.nameToPostgres.put("BIGINT", "BIGINT");
        this.nameToPostgres.put("REAL", "REAL");
        this.nameToPostgres.put("TIMESTAMP", "TIMESTAMP");
        this.nameToPostgres.put("DATE", "DATE");
        this.nameToPostgres.put("BOOLEAN", "BOOLEAN");
        this.nameToPostgres.put("VARBINARY", "VARBINARY");
        this.nameToPostgres.put("CHAR", "CHAR");
    }

    @Override
    public Factory1<String> asString(TypeToken datatype) {
        String tmp = this.nameToPostgres.get(datatype.getName());
        if (tmp == null) {
            tmp = datatype.getName();
            logger.trace("WARNING: Datatype not checked for db support");
        }
        final String result = tmp;
        return new Factory1<String>(){

            public String create(String a) {
                return a + "::" + result;
            }
        };
    }

    public Factory1<String> formatString(TypeToken datatype) {
        if (datatype.getName().equals("geometry") || datatype.getName().equals("geography")) {
            return new Factory1<String>(){

                public String create(String a) {
                    return "ST_AsText(" + a + ")";
                }
            };
        }
        final String result = this.nameToPostgres.get(datatype.getName());
        if (result == null) {
            throw new RuntimeException("No string representation for " + datatype.getName());
        }
        return new Factory1<String>(){

            public String create(String a) {
                return a + "::" + result;
            }
        };
    }
}

