/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.jena.util.QuadUtils;
import org.aksw.commons.util.Pair;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfViewPattern;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.core.ReplaceConstants;
import org.aksw.sparqlify.core.algorithms.NestedStack;
import org.aksw.sparqlify.core.algorithms.OpViewInstanceJoin;
import org.aksw.sparqlify.core.algorithms.SelfJoinEliminator;
import org.aksw.sparqlify.core.algorithms.VarBinding;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizer;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizerImpl;
import org.aksw.sparqlify.core.algorithms.ViewInstance;
import org.aksw.sparqlify.core.algorithms.ViewInstanceJoin;
import org.aksw.sparqlify.core.algorithms.ViewQuad;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.CandidateViewSelectorOld;
import org.aksw.sparqlify.core.interfaces.IViewDef;
import org.aksw.sparqlify.core.interfaces.MappingOps;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.EqualsConstraint;
import org.aksw.sparqlify.database.FilterPlacementOptimizer2;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.NestedNormalForm;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.aksw.sparqlify.database.PrefixIndex;
import org.aksw.sparqlify.database.PrefixIndexMetaFactory;
import org.aksw.sparqlify.database.StartsWithConstraint;
import org.aksw.sparqlify.database.Table;
import org.aksw.sparqlify.database.TableBuilder;
import org.aksw.sparqlify.database.TreeIndex;
import org.aksw.sparqlify.database.VariableConstraint;
import org.aksw.sparqlify.expr.util.NodeValueUtils;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.Restriction;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.apache.commons.collections15.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateViewSelectorImplUseTheGenericImplInstead
implements CandidateViewSelectorOld {
    private Logger logger = LoggerFactory.getLogger(CandidateViewSelectorImplUseTheGenericImplInstead.class);
    private int viewId = 1;
    private Table<Object> table;
    PrefixIndex<Object> idxTest;
    private Set<ViewDefinition> views = new HashSet<ViewDefinition>();
    private MappingOps mappingOps;
    private ViewDefinitionNormalizer<ViewDefinition> viewDefinitionNormalizer = new ViewDefinitionNormalizerImpl();
    private static final String[] columnNames = new String[]{"g_prefix", "s_prefix", "p_prefix", "o_prefix"};

    public CandidateViewSelectorImplUseTheGenericImplInstead(MappingOps mappingOps) {
        this.mappingOps = mappingOps;
        TableBuilder<Object> builder = new TableBuilder<Object>();
        builder.addColumn("g_prefix", String.class);
        builder.addColumn("s_prefix", String.class);
        builder.addColumn("p_prefix", String.class);
        builder.addColumn("o_type", Integer.class);
        builder.addColumn("o_prefix", String.class);
        builder.addColumn("view", ViewQuad.class);
        this.table = builder.create();
        Transformer<Object, Set<String>> prefixExtractor = new Transformer<Object, Set<String>>(){

            public Set<String> transform(Object input) {
                return Collections.singleton(input.toString());
            }
        };
        PrefixIndexMetaFactory factory = new PrefixIndexMetaFactory(prefixExtractor);
        IndexMetaNode root = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "s_prefix");
        IndexMetaNode s = IndexMetaNode.create(root, (MetaIndexFactory)factory, "p_prefix");
        TreeIndex.attach(this.table, root);
        IndexMetaNode root2 = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "p_prefix");
        IndexMetaNode s2 = IndexMetaNode.create(root2, (MetaIndexFactory)factory, "s_prefix");
        TreeIndex.attach(this.table, root2);
    }

    @Override
    public void addView(ViewDefinition viewDef) {
        ++this.viewId;
        Set vars = QuadUtils.getVarsMentioned((QuadPattern)viewDef.getTemplate());
        HashMap<Var, Var> oldToNew = new HashMap<Var, Var>();
        for (Var var : vars) {
            oldToNew.put(var, Var.alloc((String)("view" + this.viewId + "_" + var.getName())));
        }
        IViewDef copy = viewDef.copyRenameVars(oldToNew);
        this.index((ViewDefinition)copy);
    }

    public static Constraint deriveConstraint(Expr expr) {
        if (expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive) {
            return CandidateViewSelectorImplUseTheGenericImplInstead.deriveConstraint(expr);
        }
        return null;
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcat expr) {
        return CandidateViewSelectorImplUseTheGenericImplInstead.deriveConstraint(expr);
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcatPermissive expr) {
        return CandidateViewSelectorImplUseTheGenericImplInstead.deriveConstraint(expr);
    }

    public static RdfTermType getType(Node node, RestrictionManagerImpl restrictions) {
        if (node.isVariable()) {
            RestrictionImpl r = restrictions.getRestriction((Var)node);
            if (r != null) {
                return r.getType();
            }
        } else {
            if (node.isURI()) {
                return RdfTermType.URI;
            }
            if (node.isLiteral()) {
                return RdfTermType.LITERAL;
            }
        }
        return RdfTermType.UNKNOWN;
    }

    private void index(ViewDefinition view) {
        ViewDefinition normalized = this.viewDefinitionNormalizer.normalize(view);
        this.logger.debug("Normalized view:\n" + normalized);
        RestrictionManagerImpl varRestrictions = normalized.getVarRestrictions();
        this.views.add(normalized);
        for (Quad quad : normalized.getTemplate()) {
            ArrayList<Collection<Object>> collections = new ArrayList<Collection<Object>>();
            for (int i = 0; i < 4; ++i) {
                Node node = QuadUtils.getNode((Quad)quad, (int)i);
                if (i == 3) {
                    RdfTermType type = CandidateViewSelectorImplUseTheGenericImplInstead.getType(node, varRestrictions);
                    switch (type) {
                        case URI: {
                            collections.add(Collections.singleton(1));
                            break;
                        }
                        case LITERAL: {
                            collections.add(Collections.singleton(2));
                            break;
                        }
                        default: {
                            collections.add(Arrays.asList(1, 2));
                        }
                    }
                }
                if (node.isVariable()) {
                    Var var = (Var)node;
                    Collection<RestrictedExpr> restExprs = normalized.getMapping().getVarDefinition().getDefinitions(var);
                    PrefixSet p = null;
                    for (RestrictedExpr restExpr : restExprs) {
                        PrefixSet tmp = restExpr.getRestrictions().getUriPrefixes();
                        if (p == null) {
                            p = tmp;
                            continue;
                        }
                        p.addAll(tmp);
                    }
                    if (p != null) {
                        collections.add(p.getSet());
                        continue;
                    }
                    collections.add(Collections.singleton(""));
                    continue;
                }
                if (!node.isURI()) continue;
                collections.add(Collections.singleton(node.getURI()));
            }
            ViewQuad<ViewDefinition> viewQuad = new ViewQuad<ViewDefinition>(normalized, quad);
            CartesianProduct cartesian = new CartesianProduct(collections);
            for (List item : cartesian) {
                ArrayList<ViewQuad<ViewDefinition>> row = new ArrayList<ViewQuad<ViewDefinition>>(item);
                row.add(viewQuad);
                this.table.add(row);
            }
        }
    }

    @Override
    public Op getApplicableViews(Query query) {
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        if (query.isSelectType() && query.isQueryResultStar()) {
            List vars = query.getProjectVars();
            op = new OpProject(op, vars);
        }
        op = Algebra.optimize((Op)op);
        this.logger.debug("[Algebra] Jena Optimized: " + op);
        op = ReplaceConstants.replace(op);
        this.logger.debug("[Algebra] ConstantsEleminated: " + op);
        Op augmented = this._getApplicableViews(op);
        this.logger.debug("[Algebra] View Candidates: " + augmented);
        Op optimizedFilters = FilterPlacementOptimizer2.optimize(augmented);
        this.logger.debug("[Algebra] Filter Placement Optimized: " + optimizedFilters);
        Op result = optimizedFilters;
        return result;
    }

    public static VariableConstraint deriveIsPrefixOfConstraint(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Object value = NodeValueUtils.getValue(b.getConstant());
        return new VariableConstraint(a.getVarName(), new IsPrefixOfConstraint(value.toString()));
    }

    public static VariableConstraint deriveViewLookupConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            VariableConstraint c = CandidateViewSelectorImplUseTheGenericImplInstead.deriveIsPrefixOfConstraint(e.getArg1(), e.getArg2());
            if (c == null) {
                c = CandidateViewSelectorImplUseTheGenericImplInstead.deriveIsPrefixOfConstraint(e.getArg2(), e.getArg1());
            }
            return c;
        }
        return null;
    }

    public List<ViewInstanceJoin> getApplicableViewsBase(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        ArrayList<ViewInstanceJoin> result = new ArrayList<ViewInstanceJoin>();
        QuadPattern queryQuads = op.getPattern();
        Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad>>> candidates = this.findQuadWithFewestViewCandidates(queryQuads, restrictions);
        NavigableMap nToQuads = (NavigableMap)candidates.getKey();
        Map quadToCandidates = (Map)candidates.getValue();
        ArrayList<Quad> order = new ArrayList<Quad>();
        for (Set quads : nToQuads.values()) {
            order.addAll(quads);
        }
        Set viewQuads = (Set)quadToCandidates.get(order.get(0));
        this.getApplicableViewsRec2(0, order, viewQuads, quadToCandidates, restrictions, null, result, null);
        return result;
    }

    public Set<ViewQuad> findCandidates(Quad quad, RestrictionManagerImpl restrictions) {
        Object r;
        HashSet constraints = new HashSet();
        Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
        Set<Clause> dnf = restrictions.getEffectiveDnf(quadVars);
        Object[] termRestriction = new RestrictionImpl[4];
        for (int i = 0; i < 4; ++i) {
            Node n = QuadUtils.getNode((Quad)quad, (int)i);
            Var var = (Var)n;
            termRestriction[i] = r = restrictions.getRestriction(var);
        }
        this.logger.debug("\nTerm restrictions for " + quad + ":\n" + StringUtils.itemPerLine((Object[])termRestriction));
        for (Clause clause : dnf) {
            HashMap<String, Constraint> hashMap = new HashMap<String, Constraint>();
            for (int i = 0; i < 4; ++i) {
                RestrictionImpl r2;
                Node n = QuadUtils.getNode((Quad)quad, (int)i);
                Var var = (Var)n;
                RestrictionImpl clauseRest = clause.getRestriction(var);
                Object bindRest = termRestriction[i];
                if (bindRest == null) {
                    RestrictionImpl r22 = clauseRest;
                } else if (clauseRest != null) {
                    r2 = ((RestrictionImpl)bindRest).clone();
                    r2.stateRestriction(clauseRest);
                } else {
                    r2 = null;
                }
                if (r2 == null) continue;
                termRestriction[i] = r2;
                if (!r2.getRdfTermTypes().contains((Object)RdfTermType.URI) || !r2.hasConstant()) continue;
                String columnName = columnNames[i];
                hashMap.put(columnName, new IsPrefixOfConstraint(r2.getNode().getURI()));
            }
            r = termRestriction[3];
            if (r != null) {
                switch (((RestrictionImpl)r).getType()) {
                    case URI: {
                        hashMap.put("o_type", new EqualsConstraint(1));
                        break;
                    }
                    case LITERAL: {
                        hashMap.put("o_type", new EqualsConstraint(2));
                    }
                }
            }
            constraints.add(hashMap);
        }
        HashSet<ViewQuad> viewQuads = new HashSet<ViewQuad>();
        if (constraints.isEmpty()) {
            constraints.add(new HashMap());
        }
        for (Map map : constraints) {
            Collection<List<Object>> rows = this.table.select(map);
            for (List<Object> row : rows) {
                ViewQuad viewQuad = (ViewQuad)row.get(row.size() - 1);
                viewQuads.add(viewQuad);
            }
        }
        int filterCount = 0;
        Iterator iterator = viewQuads.iterator();
        while (iterator.hasNext()) {
            ViewQuad viewQuad = (ViewQuad)iterator.next();
            Quad q = viewQuad.getQuad();
            boolean isUnsatisfiable = false;
            for (int i = 0; i < 4; ++i) {
                RestrictionImpl viewRest;
                Object queryRest = termRestriction[i];
                Node n = QuadUtils.getNode((Quad)q, (int)i);
                if (n.isVariable()) {
                    Var var = (Var)n;
                    viewRest = viewQuad.getView().getVarRestrictions().getRestriction(var);
                } else if (n.isURI()) {
                    viewRest = new RestrictionImpl();
                    viewRest.stateNode(n);
                } else {
                    viewRest = null;
                }
                if (viewRest == null || queryRest == null) continue;
                RestrictionImpl tmp = viewRest.clone();
                tmp.stateRestriction((Restriction)queryRest);
                if (!tmp.isUnsatisfiable()) continue;
                isUnsatisfiable = true;
                break;
            }
            if (!isUnsatisfiable) continue;
            ++filterCount;
            iterator.remove();
        }
        int total = viewQuads.size() + filterCount;
        this.logger.debug(viewQuads.size() + " of " + total + " candidates remaining (" + filterCount + " filtered)");
        return viewQuads;
    }

    public Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad>>> findQuadWithFewestViewCandidates(QuadPattern queryQuads, RestrictionManagerImpl restrictions) {
        TreeMap<Integer, HashSet<Quad>> nToQuads = new TreeMap<Integer, HashSet<Quad>>();
        HashMap<Quad, Set<ViewQuad>> quadToCandidates = new HashMap<Quad, Set<ViewQuad>>();
        for (Quad quad : queryQuads) {
            if (quadToCandidates.containsKey(quad)) continue;
            Set<ViewQuad> viewQuads = this.findCandidates(quad, restrictions);
            int n = viewQuads.size();
            HashSet<Quad> nQuads = (HashSet<Quad>)nToQuads.get(n);
            if (nQuads == null) {
                nQuads = new HashSet<Quad>();
                nToQuads.put(n, nQuads);
            }
            nQuads.add(quad);
            quadToCandidates.put(quad, viewQuads);
        }
        return Pair.create(nToQuads, quadToCandidates);
    }

    public static List<String> getCandidateNames(NestedStack<ViewInstance> instances) {
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (ViewInstance instance : instances.asList()) {
                viewNames.add(instance.getViewDefinition().getName());
            }
        }
        return viewNames;
    }

    public void getApplicableViewsRec2(int index, List<Quad> quadOrder, Set<ViewQuad> viewQuads, Map<Quad, Set<ViewQuad>> candidates, RestrictionManagerImpl restrictions, NestedStack<ViewInstance> instances, List<ViewInstanceJoin> result, Mapping baseMapping) {
        List<String> debug = Arrays.asList("view_nodes", "node_tags_resource_kv");
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (ViewInstance instance : instances.asList()) {
                viewNames.add(instance.getViewDefinition().getName());
            }
        }
        if (index >= quadOrder.size()) {
            throw new RuntimeException("Should not happen");
        }
        int nextIndex = index + 1;
        boolean isRecursionEnd = nextIndex == quadOrder.size();
        Quad queryQuad = quadOrder.get(index);
        for (ViewQuad viewQuad : viewQuads) {
            RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(restrictions);
            RestrictionManagerImpl viewRestrictions = viewQuad.getView().getVarRestrictions();
            if (viewRestrictions == null) {
                throw new NullPointerException();
            }
            for (int i = 0; i < 4; ++i) {
                Var queryVar = (Var)QuadUtils.getNode((Quad)queryQuad, (int)i);
                Node viewNode = QuadUtils.getNode((Quad)viewQuad.getQuad(), (int)i);
                if (viewNode.isVariable()) {
                    Var viewVar = (Var)viewNode;
                    RestrictionImpl viewRs = viewRestrictions.getRestriction(viewVar);
                    if (viewRs != null) {
                        subRestrictions.stateRestriction(queryVar, viewRs);
                    }
                    if (subRestrictions.isUnsatisfiable() || subRestrictions.isUnsatisfiable()) {
                        break;
                    }
                } else {
                    subRestrictions.stateNode(queryVar, viewNode);
                }
                if (subRestrictions.isUnsatisfiable()) break;
            }
            if (subRestrictions.isUnsatisfiable()) continue;
            VarBinding binding = VarBinding.create(queryQuad, viewQuad.getQuad());
            if (binding == null) {
                throw new RuntimeException("Null binding");
            }
            int instanceId = index;
            ViewInstance<ViewDefinition> instance = new ViewInstance<ViewDefinition>((ViewDefinition)viewQuad.getView(), binding);
            NestedStack<ViewInstance> nextInstances = new NestedStack<ViewInstance>(instances, instance);
            Mapping nextMapping = null;
            boolean enablePruningMappingRewrite = true;
            if (enablePruningMappingRewrite && this.mappingOps != null) {
                Mapping mapping = this.mappingOps.createMapping(instance);
                nextMapping = baseMapping == null ? mapping : this.mappingOps.join(baseMapping, mapping);
                if (nextMapping.isEmpty()) continue;
            }
            if (isRecursionEnd) {
                ViewInstanceJoin viewConjunction = new ViewInstanceJoin(nextInstances.asList(), subRestrictions);
                SelfJoinEliminator.merge(viewConjunction);
                result.add(viewConjunction);
                continue;
            }
            Quad nextQuad = quadOrder.get(nextIndex);
            Set<ViewQuad> nextCandidates = this.findCandidates(nextQuad, subRestrictions);
            this.getApplicableViewsRec2(nextIndex, quadOrder, nextCandidates, candidates, subRestrictions, nextInstances, result, nextMapping);
        }
    }

    public Op getApplicableViews(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        List<ViewInstanceJoin> conjunctions = this.getApplicableViewsBase(op, restrictions);
        OpDisjunction result = OpDisjunction.create();
        for (ViewInstanceJoin item : conjunctions) {
            OpViewInstanceJoin tmp = new OpViewInstanceJoin(item);
            result.add(tmp);
        }
        return result;
    }

    public static boolean isSatisfiable(List<ViewInstance> list) {
        return true;
    }

    public Op _getApplicableViews(Op op) {
        return this._getApplicableViews(op, new RestrictionManagerImpl());
    }

    public Op _getApplicableViews(Op op, RestrictionManagerImpl restrictions) {
        return (Op)MultiMethod.invoke((Object)this, (String)"getApplicableViews", (Object[])new Object[]{op, restrictions});
    }

    public Op getApplicableViews(OpSequence op, RestrictionManagerImpl restrictions) {
        List members = op.getElements();
        ArrayList<Op> newMembers = new ArrayList<Op>(members.size());
        for (Op member : members) {
            Op newMember = this._getApplicableViews(member, restrictions);
            newMembers.add(newMember);
        }
        Op result = OpSequence.create().copy(newMembers);
        return result;
    }

    public Op getApplicableViews(OpProject op, RestrictionManagerImpl restrictions) {
        return new OpProject(this._getApplicableViews(op.getSubOp(), restrictions), op.getVars());
    }

    public Op getApplicableViews(OpOrder op, RestrictionManagerImpl restrictions) {
        return new OpOrder(this._getApplicableViews(op.getSubOp(), restrictions), op.getConditions());
    }

    public Op getApplicableViews(OpGroup op, RestrictionManagerImpl restrictions) {
        return new OpGroup(this._getApplicableViews(op.getSubOp(), restrictions), op.getGroupVars(), op.getAggregators());
    }

    public Op getApplicableViews(OpExtend op, RestrictionManagerImpl _restrictions) {
        Op result = this.processOpExtend(op.getSubOp(), op.getVarExprList(), _restrictions);
        return result;
    }

    public Op getApplicableViews(OpAssign op, RestrictionManagerImpl _restrictions) {
        Op result = this.processOpExtend(op.getSubOp(), op.getVarExprList(), _restrictions);
        return result;
    }

    public Op processOpExtend(Op subOp, VarExprList varExprs, RestrictionManagerImpl _restrictions) {
        Op newSubOp = this._getApplicableViews(subOp, _restrictions);
        Op result = OpExtend.extend((Op)newSubOp, (VarExprList)varExprs);
        return result;
    }

    public Op getApplicableViews(OpFilter op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl combinedRestrictions = new RestrictionManagerImpl(restrictions);
        RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl();
        for (Expr expr : op.getExprs()) {
            subRestrictions.stateExpr(expr);
            combinedRestrictions.stateExpr(expr);
        }
        Op newSubOp = this._getApplicableViews(op.getSubOp(), combinedRestrictions);
        OpFilterIndexed result = OpFilterIndexed.filter(subRestrictions, newSubOp);
        return result;
    }

    public Op getApplicableViews(OpUnion op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl subRestrictionsLeft = new RestrictionManagerImpl(restrictions);
        RestrictionManagerImpl subRestrictionsRight = new RestrictionManagerImpl(restrictions);
        return OpDisjunction.create((Op)this._getApplicableViews(op.getLeft(), subRestrictionsLeft), (Op)this._getApplicableViews(op.getRight(), subRestrictionsRight));
    }

    public Op getApplicableViews(OpJoin op, RestrictionManagerImpl restrictions) {
        return OpJoin.create((Op)this._getApplicableViews(op.getLeft(), restrictions), (Op)this._getApplicableViews(op.getRight(), restrictions));
    }

    public static RestrictionManagerImpl filterRestrictionsBound(RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl result = new RestrictionManagerImpl();
        for (Clause clause : restrictions.getCnf()) {
            if (FilterPlacementOptimizer2.doesClauseContainBoundExpr(clause)) continue;
            result.stateCnf(new NestedNormalForm(Collections.singleton(clause)));
        }
        return result;
    }

    public Op getApplicableViews(OpLeftJoin op, RestrictionManagerImpl restrictions) {
        OpLeftJoin result = this.processLeftJoin(op.getLeft(), op.getRight(), (Iterable<Expr>)op.getExprs(), restrictions);
        return result;
    }

    public Op getApplicableViews(OpConditional op, RestrictionManagerImpl restrictions) {
        OpLeftJoin tmp = this.processLeftJoin(op.getLeft(), op.getRight(), null, restrictions);
        OpConditional result = new OpConditional(tmp.getLeft(), tmp.getRight());
        return result;
    }

    public OpLeftJoin processLeftJoin(Op left, Op right, Iterable<Expr> exprs, RestrictionManagerImpl restrictions) {
        Op newLeft = this._getApplicableViews(left, restrictions);
        RestrictionManagerImpl subRestrictions = CandidateViewSelectorImplUseTheGenericImplInstead.filterRestrictionsBound(restrictions);
        RestrictionManagerImpl moreRestrictions = CandidateViewSelectorImplUseTheGenericImplInstead.filterRestrictionsBound(CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions2(newLeft));
        if (moreRestrictions != null) {
            subRestrictions.stateRestriction(moreRestrictions);
        }
        if (exprs != null) {
            for (Expr expr : exprs) {
                subRestrictions.stateExpr(expr);
            }
        }
        Op newRight = this._getApplicableViews(right, subRestrictions);
        OpLeftJoin result = (OpLeftJoin)OpLeftJoin.create((Op)newLeft, (Op)newRight, (ExprList)new ExprList());
        return result;
    }

    public Op getApplicableViews(OpSlice op, RestrictionManagerImpl restrictions) {
        return new OpSlice(this._getApplicableViews(op.getSubOp(), restrictions), op.getStart(), op.getLength());
    }

    public Op getApplicableViews(OpDistinct op, RestrictionManagerImpl restrictions) {
        return new OpDistinct(this._getApplicableViews(op.getSubOp(), restrictions));
    }

    public static RestrictionManagerImpl getRestrictions2(Op op) {
        if (op instanceof OpFilterIndexed) {
            return ((OpFilterIndexed)op).getRestrictions();
        }
        if (op instanceof Op1) {
            return CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions2(((Op1)op).getSubOp());
        }
        if (op instanceof OpJoin) {
            throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
        }
        if (op instanceof OpLeftJoin) {
            return CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions2(((OpLeftJoin)op).getLeft());
        }
        if (op instanceof OpConditional) {
            return CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions2(((OpConditional)op).getLeft());
        }
        if (op instanceof OpDisjunction) {
            return null;
        }
        if (op instanceof OpRdfViewPattern) {
            return null;
        }
        throw new RuntimeException("Should not happen: Unhandled Op: " + op.getClass() + " --- " + op);
    }

    public static List<RestrictionManagerImpl> getRestrictions(Op op) {
        ArrayList<RestrictionManagerImpl> result = new ArrayList<RestrictionManagerImpl>();
        CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions(op, result);
        return result;
    }

    public static void getRestrictions(Op op, Collection<RestrictionManagerImpl> result) {
        if (op instanceof Op1) {
            CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions(((Op1)op).getSubOp(), result);
        } else {
            if (op instanceof OpJoin) {
                throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
            }
            if (op instanceof OpLeftJoin) {
                CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions(((OpLeftJoin)op).getLeft(), result);
            } else if (op instanceof OpDisjunction) {
                OpDisjunction o = (OpDisjunction)op;
                for (Op subOp : o.getElements()) {
                    CandidateViewSelectorImplUseTheGenericImplInstead.getRestrictions(subOp, result);
                }
            } else if (op instanceof OpRdfViewPattern) {
                OpRdfViewPattern o = (OpRdfViewPattern)op;
                result.add(o.getConjunction().getRestrictions());
            } else {
                throw new RuntimeException("Should not happen");
            }
        }
    }

    @Override
    public Collection<ViewDefinition> getViews() {
        return this.views;
    }
}

