/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import java.util.Map;
import org.aksw.commons.factory.Factory1;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;

class AliasSubstitutor
implements Factory1<SqlExpr> {
    private Map<String, String> aliasMap;

    public AliasSubstitutor(Map<String, String> aliasMap) {
        this.aliasMap = aliasMap;
    }

    @Override
    public SqlExpr create(SqlExpr a) {
        SqlExpr result;
        switch (a.getType()) {
            case Variable: {
                S_ColumnRef cr = (S_ColumnRef)a;
                String alias = cr.getRelationAlias();
                if (this.aliasMap.containsKey(alias)) {
                    String newAlias = this.aliasMap.get(alias);
                    result = new S_ColumnRef(cr.getDatatype(), cr.getColumnName(), newAlias);
                    break;
                }
                result = a;
                break;
            }
            default: {
                result = a;
            }
        }
        return result;
    }
}

