/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sparql.transform;

import java.util.Arrays;
import java.util.List;

public class MethodSignature<T> {
    private T returnType;
    private List<T> paramTypes;
    private T varArgType;

    public MethodSignature(T returnType, List<T> paramTypes, T varArgType) {
        this.returnType = returnType;
        this.paramTypes = paramTypes;
        this.varArgType = varArgType;
    }

    public T getReturnType() {
        return this.returnType;
    }

    public List<T> getParameterTypes() {
        return this.paramTypes;
    }

    public T getVarArgType() {
        return this.varArgType;
    }

    public boolean isVararg() {
        return this.varArgType != null;
    }

    public static <T> MethodSignature<T> create(T returnType, List<T> parameterTypes, T varArgType) {
        return new MethodSignature<T>(returnType, parameterTypes, varArgType);
    }

    public static <T> MethodSignature<T> create(boolean isVarArg, T returnType, T ... paramTypes) {
        T varArgType = null;
        List<T> fixedArgTypes = Arrays.asList(paramTypes);
        if (isVarArg) {
            if (paramTypes.length == 0) {
                throw new RuntimeException("Need a type for varArgs");
            }
            int lastIndex = paramTypes.length - 1;
            varArgType = paramTypes[lastIndex];
            fixedArgTypes = fixedArgTypes.subList(0, lastIndex);
        }
        MethodSignature<Object> result = MethodSignature.create(returnType, fixedArgTypes, varArgType);
        return result;
    }

    public String toString() {
        return "MethodSignature [returnType=" + this.returnType + ", paramTypes=" + this.paramTypes + ", varArgType=" + this.varArgType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.paramTypes == null ? 0 : this.paramTypes.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 31 * result + (this.varArgType == null ? 0 : this.varArgType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        if (this.paramTypes == null ? other.paramTypes != null : !this.paramTypes.equals(other.paramTypes)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        return !(this.varArgType == null ? other.varArgType != null : !this.varArgType.equals(other.varArgType));
    }
}

