/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.changesets;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.aksw.changesets.BackedPartition;
import org.aksw.changesets.FileLineIterable;
import org.aksw.changesets.FileLinePartitionFactory;
import org.aksw.changesets.Partition;

public class Partitioner {
    public static Map<Integer, Partition<String>> partitionFile(File sourceFile, String tmpDir, int numPartitions) {
        HashMap<Integer, Partition<String>> result = new HashMap<Integer, Partition<String>>();
        for (String line : new FileLineIterable(sourceFile)) {
            int rawHash = line.hashCode();
            int normalizedHash = rawHash % numPartitions;
            BackedPartition<String> partition = (BackedPartition<String>)result.get(normalizedHash);
            if (partition == null) {
                File file = new File(tmpDir + "/" + normalizedHash + ".part");
                file.getParentFile().mkdirs();
                partition = new BackedPartition<String>(new FileLinePartitionFactory(file));
                partition.open();
                result.put(normalizedHash, partition);
            }
            partition.add(line);
        }
        for (Partition partition : result.values()) {
            partition.flush();
            partition.close();
        }
        return result;
    }
}

