/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.changesets;

import java.util.ArrayList;
import org.aksw.changesets.Partition;
import org.aksw.changesets.PartitionCollection;
import org.aksw.changesets.PartitionDecorator;
import org.aksw.changesets.PartitionFactory;

public class BackedPartition<T>
extends PartitionDecorator<T> {
    private int maxPartitionSize = 10000;
    private boolean usesPersistentBackend = false;
    private PartitionFactory<T> partitionFactory;
    private Partition<T> inMemory;

    public BackedPartition(PartitionFactory<T> partitionFactory) {
        this.decoratee = this.inMemory = new PartitionCollection(new ArrayList());
        this.partitionFactory = partitionFactory;
    }

    @Override
    public boolean add(T item) {
        if (((Partition)this.decoratee).size() > this.maxPartitionSize && !this.usesPersistentBackend) {
            this.makePersistent();
        }
        return ((Partition)this.decoratee).add(item);
    }

    @Override
    public void clear() {
        ((Partition)this.decoratee).clear();
        this.inMemory.clear();
        this.decoratee = this.inMemory;
    }

    public void makePersistent() {
        Partition<T> persist = this.partitionFactory.create();
        for (Object x : (Partition)this.decoratee) {
            persist.add(x);
        }
        ((Partition)this.decoratee).clear();
        this.decoratee = persist;
        this.usesPersistentBackend = true;
    }
}

