// $ANTLR 3.5 org/aksw/sparqlify/config/lang/SparqlifyConfig.g 2013-07-25 18:54:02

    package org.aksw.sparqlify.config.lang;
    
    import org.slf4j.Logger;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
 * @author Simone Tripodi   (simone.tripodi)
 * @author Michele Mostarda (michele.mostarda)
 * @author Juergen Pfundt   (Juergen.Pfundt)
 * @version $Id$
 */
@SuppressWarnings("all")
public class SparqlifyConfigParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABS", "ADD", "ALIASED_LOGICAL_TABLE", 
		"ALIASED_VAR", "ALL", "AND", "ANY", "ARG_LIST", "AS", "ASC", "ASK", "ASTERISK", 
		"AVG", "BASE", "BIND", "BINDINGS", "BINDING_VALUE", "BLANK_NODE", "BLANK_NODE_LABEL", 
		"BNODE", "BOUND", "BY", "CEIL", "CLEAR", "CLOSE_BRACE", "CLOSE_CURLY_BRACE", 
		"CLOSE_SQUARE_BRACKET", "COALESCE", "COLLECTION", "COMMA", "COMMENT", 
		"CONCAT", "CONSTRAIN", "CONSTRAINTS", "CONSTRUCT", "CONSTRUCT_QUADS", 
		"CONSTRUCT_TRIPLES", "CONSTRUCT_VIEW_DEFINITION", "CONTAINS", "COPY", 
		"COUNT", "CREATE", "DATA", "DATATYPE", "DAY", "DECIMAL", "DECIMAL_NEGATIVE", 
		"DECIMAL_POSITIVE", "DECLARE", "DEFAULT", "DEFINE", "DELETE", "DESC", 
		"DESCRIBE", "DIGIT", "DISTINCT", "DIVIDE", "DOT", "DOUBLE", "DOUBLE_NEGATIVE", 
		"DOUBLE_POSITIVE", "DROP", "ECHAR", "ENCODE_FOR_URI", "EOL", "EQUAL", 
		"EXISTS", "EXPONENT", "EXPRESSION_LIST", "FALSE", "FILTER", "FLOOR", "FROM", 
		"FULL_JOIN", "FUNCTION", "FUNCTION_DECLARATION", "FUNCTION_SIGNATURE", 
		"FUNCTION_TEMPLATE", "GRAPH", "GRAPH_TOKEN", "GREATER", "GREATER_EQUAL", 
		"GROUP", "GROUP_BY", "GROUP_CONCAT", "GROUP_GRAPH_PATTERN", "HAVING", 
		"HOURS", "IF", "IMPORT", "IN", "INSERT", "INTEGER", "INTEGER_NEGATIVE", 
		"INTEGER_POSITIVE", "INTO", "INVERSE", "IRI", "IRI_REF", "IRI_REF_CHARACTERS", 
		"ISBLANK", "ISIRI", "ISLITERAL", "ISNUMERIC", "ISURI", "JOIN_MEMBER", 
		"LANG", "LANGMATCHES", "LANGTAG", "LCASE", "LESS", "LESS_EQUAL", "LIMIT", 
		"LOAD", "MACRO_DEF", "MAX", "MD5", "MIN", "MINUS", "MINUS_KEYWORD", "MINUTES", 
		"MODIFY", "MONTH", "MOVE", "NAME", "NAMED", "NAMED_VIEW_TEMPLATE_DEFINITION", 
		"NAME_SUFFIX", "NEGATION", "NESTED_ML_COMMENT", "NOT", "NOT_EQUAL", "NOT_EXISTS", 
		"NOW", "OBJECT", "OFFSET", "OPEN_BRACE", "OPEN_CURLY_BRACE", "OPEN_SQUARE_BRACKET", 
		"OPTIONAL", "OR", "ORDER", "ORDER_BY", "ORDER_CONDITION", "PARAM_TYPE", 
		"PARAM_TYPE_LIST", "PATH", "PATH_NEGATED", "PATH_PRIMARY", "PIPE", "PLAIN_LITERAL", 
		"PLUS", "PNAME_LN", "PNAME_NS", "PN_CHARS", "PN_CHARS_BASE", "PN_CHARS_U", 
		"PN_LOCAL", "PN_PREFIX", "PREDICATE", "PREFIX", "PREFIX_CONSTRAINT", "PREFIX_DECL", 
		"PROLOGUE", "PROPERTY_LIST", "QUERY", "QUESTION_MARK", "RAND", "REDUCED", 
		"REFERENCE", "REGEX", "REGEX_CONSTRAINT", "RELATION_REF", "ROUND", "SAMETERM", 
		"SAMPLE", "SECONDS", "SELECT", "SELECT_CLAUSE", "SEMICOLON", "SEPARATOR", 
		"SERVICE", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SIGN", "SILENT", 
		"SINGLE_LINE_COMMENT", "SQL_QUERY", "SQL_RELATION", "SQL_TABLE", "STR", 
		"STRDT", "STRENDS", "STRING_LIST", "STRING_LITERAL1", "STRING_LITERAL2", 
		"STRING_LITERAL_LONG1", "STRING_LITERAL_LONG2", "STRLANG", "STRLEN", "STRSTARTS", 
		"SUBJECT", "SUBSELECT", "SUBSTR", "SUM", "TEMPLATE", "TIMEZONE", "TO", 
		"TODO", "TRIPLE", "TRIPLES_BLOCK", "TRIPLES_TEMPLATE", "TRUE", "TYPED_LITERAL", 
		"TZ", "UCASE", "UNARY", "UNARY_MINUS", "UNARY_NOT", "UNARY_PLUS", "UNDEF", 
		"UNION", "UPDATE", "URI", "USING", "VAR", "VAR1", "VAR2", "VAR3", "VARNAME", 
		"VAR_BINDING", "VAR_BINDINGS", "VAR_HEAD", "VIEW", "VIEW_DEFINITION", 
		"VIEW_TEMPLATE_DEFINITION", "WHERE", "WHERE_CLAUSE", "WITH", "WS", "YEAR"
	};
	public static final int EOF=-1;
	public static final int A=4;
	public static final int ABS=5;
	public static final int ADD=6;
	public static final int ALIASED_LOGICAL_TABLE=7;
	public static final int ALIASED_VAR=8;
	public static final int ALL=9;
	public static final int AND=10;
	public static final int ANY=11;
	public static final int ARG_LIST=12;
	public static final int AS=13;
	public static final int ASC=14;
	public static final int ASK=15;
	public static final int ASTERISK=16;
	public static final int AVG=17;
	public static final int BASE=18;
	public static final int BIND=19;
	public static final int BINDINGS=20;
	public static final int BINDING_VALUE=21;
	public static final int BLANK_NODE=22;
	public static final int BLANK_NODE_LABEL=23;
	public static final int BNODE=24;
	public static final int BOUND=25;
	public static final int BY=26;
	public static final int CEIL=27;
	public static final int CLEAR=28;
	public static final int CLOSE_BRACE=29;
	public static final int CLOSE_CURLY_BRACE=30;
	public static final int CLOSE_SQUARE_BRACKET=31;
	public static final int COALESCE=32;
	public static final int COLLECTION=33;
	public static final int COMMA=34;
	public static final int COMMENT=35;
	public static final int CONCAT=36;
	public static final int CONSTRAIN=37;
	public static final int CONSTRAINTS=38;
	public static final int CONSTRUCT=39;
	public static final int CONSTRUCT_QUADS=40;
	public static final int CONSTRUCT_TRIPLES=41;
	public static final int CONSTRUCT_VIEW_DEFINITION=42;
	public static final int CONTAINS=43;
	public static final int COPY=44;
	public static final int COUNT=45;
	public static final int CREATE=46;
	public static final int DATA=47;
	public static final int DATATYPE=48;
	public static final int DAY=49;
	public static final int DECIMAL=50;
	public static final int DECIMAL_NEGATIVE=51;
	public static final int DECIMAL_POSITIVE=52;
	public static final int DECLARE=53;
	public static final int DEFAULT=54;
	public static final int DEFINE=55;
	public static final int DELETE=56;
	public static final int DESC=57;
	public static final int DESCRIBE=58;
	public static final int DIGIT=59;
	public static final int DISTINCT=60;
	public static final int DIVIDE=61;
	public static final int DOT=62;
	public static final int DOUBLE=63;
	public static final int DOUBLE_NEGATIVE=64;
	public static final int DOUBLE_POSITIVE=65;
	public static final int DROP=66;
	public static final int ECHAR=67;
	public static final int ENCODE_FOR_URI=68;
	public static final int EOL=69;
	public static final int EQUAL=70;
	public static final int EXISTS=71;
	public static final int EXPONENT=72;
	public static final int EXPRESSION_LIST=73;
	public static final int FALSE=74;
	public static final int FILTER=75;
	public static final int FLOOR=76;
	public static final int FROM=77;
	public static final int FULL_JOIN=78;
	public static final int FUNCTION=79;
	public static final int FUNCTION_DECLARATION=80;
	public static final int FUNCTION_SIGNATURE=81;
	public static final int FUNCTION_TEMPLATE=82;
	public static final int GRAPH=83;
	public static final int GRAPH_TOKEN=84;
	public static final int GREATER=85;
	public static final int GREATER_EQUAL=86;
	public static final int GROUP=87;
	public static final int GROUP_BY=88;
	public static final int GROUP_CONCAT=89;
	public static final int GROUP_GRAPH_PATTERN=90;
	public static final int HAVING=91;
	public static final int HOURS=92;
	public static final int IF=93;
	public static final int IMPORT=94;
	public static final int IN=95;
	public static final int INSERT=96;
	public static final int INTEGER=97;
	public static final int INTEGER_NEGATIVE=98;
	public static final int INTEGER_POSITIVE=99;
	public static final int INTO=100;
	public static final int INVERSE=101;
	public static final int IRI=102;
	public static final int IRI_REF=103;
	public static final int IRI_REF_CHARACTERS=104;
	public static final int ISBLANK=105;
	public static final int ISIRI=106;
	public static final int ISLITERAL=107;
	public static final int ISNUMERIC=108;
	public static final int ISURI=109;
	public static final int JOIN_MEMBER=110;
	public static final int LANG=111;
	public static final int LANGMATCHES=112;
	public static final int LANGTAG=113;
	public static final int LCASE=114;
	public static final int LESS=115;
	public static final int LESS_EQUAL=116;
	public static final int LIMIT=117;
	public static final int LOAD=118;
	public static final int MACRO_DEF=119;
	public static final int MAX=120;
	public static final int MD5=121;
	public static final int MIN=122;
	public static final int MINUS=123;
	public static final int MINUS_KEYWORD=124;
	public static final int MINUTES=125;
	public static final int MODIFY=126;
	public static final int MONTH=127;
	public static final int MOVE=128;
	public static final int NAME=129;
	public static final int NAMED=130;
	public static final int NAMED_VIEW_TEMPLATE_DEFINITION=131;
	public static final int NAME_SUFFIX=132;
	public static final int NEGATION=133;
	public static final int NESTED_ML_COMMENT=134;
	public static final int NOT=135;
	public static final int NOT_EQUAL=136;
	public static final int NOT_EXISTS=137;
	public static final int NOW=138;
	public static final int OBJECT=139;
	public static final int OFFSET=140;
	public static final int OPEN_BRACE=141;
	public static final int OPEN_CURLY_BRACE=142;
	public static final int OPEN_SQUARE_BRACKET=143;
	public static final int OPTIONAL=144;
	public static final int OR=145;
	public static final int ORDER=146;
	public static final int ORDER_BY=147;
	public static final int ORDER_CONDITION=148;
	public static final int PARAM_TYPE=149;
	public static final int PARAM_TYPE_LIST=150;
	public static final int PATH=151;
	public static final int PATH_NEGATED=152;
	public static final int PATH_PRIMARY=153;
	public static final int PIPE=154;
	public static final int PLAIN_LITERAL=155;
	public static final int PLUS=156;
	public static final int PNAME_LN=157;
	public static final int PNAME_NS=158;
	public static final int PN_CHARS=159;
	public static final int PN_CHARS_BASE=160;
	public static final int PN_CHARS_U=161;
	public static final int PN_LOCAL=162;
	public static final int PN_PREFIX=163;
	public static final int PREDICATE=164;
	public static final int PREFIX=165;
	public static final int PREFIX_CONSTRAINT=166;
	public static final int PREFIX_DECL=167;
	public static final int PROLOGUE=168;
	public static final int PROPERTY_LIST=169;
	public static final int QUERY=170;
	public static final int QUESTION_MARK=171;
	public static final int RAND=172;
	public static final int REDUCED=173;
	public static final int REFERENCE=174;
	public static final int REGEX=175;
	public static final int REGEX_CONSTRAINT=176;
	public static final int RELATION_REF=177;
	public static final int ROUND=178;
	public static final int SAMETERM=179;
	public static final int SAMPLE=180;
	public static final int SECONDS=181;
	public static final int SELECT=182;
	public static final int SELECT_CLAUSE=183;
	public static final int SEMICOLON=184;
	public static final int SEPARATOR=185;
	public static final int SERVICE=186;
	public static final int SHA1=187;
	public static final int SHA224=188;
	public static final int SHA256=189;
	public static final int SHA384=190;
	public static final int SHA512=191;
	public static final int SIGN=192;
	public static final int SILENT=193;
	public static final int SINGLE_LINE_COMMENT=194;
	public static final int SQL_QUERY=195;
	public static final int SQL_RELATION=196;
	public static final int SQL_TABLE=197;
	public static final int STR=198;
	public static final int STRDT=199;
	public static final int STRENDS=200;
	public static final int STRING_LIST=201;
	public static final int STRING_LITERAL1=202;
	public static final int STRING_LITERAL2=203;
	public static final int STRING_LITERAL_LONG1=204;
	public static final int STRING_LITERAL_LONG2=205;
	public static final int STRLANG=206;
	public static final int STRLEN=207;
	public static final int STRSTARTS=208;
	public static final int SUBJECT=209;
	public static final int SUBSELECT=210;
	public static final int SUBSTR=211;
	public static final int SUM=212;
	public static final int TEMPLATE=213;
	public static final int TIMEZONE=214;
	public static final int TO=215;
	public static final int TODO=216;
	public static final int TRIPLE=217;
	public static final int TRIPLES_BLOCK=218;
	public static final int TRIPLES_TEMPLATE=219;
	public static final int TRUE=220;
	public static final int TYPED_LITERAL=221;
	public static final int TZ=222;
	public static final int UCASE=223;
	public static final int UNARY=224;
	public static final int UNARY_MINUS=225;
	public static final int UNARY_NOT=226;
	public static final int UNARY_PLUS=227;
	public static final int UNDEF=228;
	public static final int UNION=229;
	public static final int UPDATE=230;
	public static final int URI=231;
	public static final int USING=232;
	public static final int VAR=233;
	public static final int VAR1=234;
	public static final int VAR2=235;
	public static final int VAR3=236;
	public static final int VARNAME=237;
	public static final int VAR_BINDING=238;
	public static final int VAR_BINDINGS=239;
	public static final int VAR_HEAD=240;
	public static final int VIEW=241;
	public static final int VIEW_DEFINITION=242;
	public static final int VIEW_TEMPLATE_DEFINITION=243;
	public static final int WHERE=244;
	public static final int WHERE_CLAUSE=245;
	public static final int WITH=246;
	public static final int WS=247;
	public static final int YEAR=248;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public SparqlifyConfigParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public SparqlifyConfigParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return SparqlifyConfigParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org/aksw/sparqlify/config/lang/SparqlifyConfig.g"; }


	    private Logger logger = null;

	    public void setLogger(Logger logger) {
	        this.logger = logger;
	    }

	    public void emitErrorMessage(String msg) {
	        if(this.logger != null) {
	        	this.logger.error(msg);
	        } else {
	        	System.err.println(msg);
	        }
	    }

		public String getErrorMessage(RecognitionException e, String[] tokenNames)
		{
		    List stack = getRuleInvocationStack(e, this.getClass().getName());
		    String msg = null;
		    if ( e instanceof NoViableAltException ) {
		       NoViableAltException nvae = (NoViableAltException)e;
		       msg = " no viable alt; token="+e.token+
		          " (decision="+nvae.decisionNumber+
		          " state "+nvae.stateNumber+")"+
		          " decision=<<"+nvae.grammarDecisionDescription+">>";
		    }
		    else if(  e instanceof FailedPredicateException  ) {
		       FailedPredicateException fpe = (FailedPredicateException)e;
		       msg = "failed predicate; token="+fpe.token+
		              " (rule="+fpe.ruleName+" predicate="+fpe.predicateText+")";
		    }
		    else {
		       msg = super.getErrorMessage(e, tokenNames);
		    }
		    return stack+" "+msg;
		}
		public String getTokenErrorDisplay(Token t) {
		    return t.toString();
		}   


	public static class sparqlifyConfig_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "sparqlifyConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:164:1: sparqlifyConfig : ( sparqlifyConfigStmt )+ EOF !;
	public final SparqlifyConfigParser.sparqlifyConfig_return sparqlifyConfig() throws RecognitionException {
		SparqlifyConfigParser.sparqlifyConfig_return retval = new SparqlifyConfigParser.sparqlifyConfig_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF2=null;
		ParserRuleReturnScope sparqlifyConfigStmt1 =null;

		CommonTree EOF2_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:165:5: ( ( sparqlifyConfigStmt )+ EOF !)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:165:7: ( sparqlifyConfigStmt )+ EOF !
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:165:7: ( sparqlifyConfigStmt )+
			int cnt1=0;
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DEFINE||LA1_0==PREFIX) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:165:7: sparqlifyConfigStmt
					{
					pushFollow(FOLLOW_sparqlifyConfigStmt_in_sparqlifyConfig268);
					sparqlifyConfigStmt1=sparqlifyConfigStmt();
					state._fsp--;

					adaptor.addChild(root_0, sparqlifyConfigStmt1.getTree());

					}
					break;

				default :
					if ( cnt1 >= 1 ) break loop1;
					EarlyExitException eee = new EarlyExitException(1, input);
					throw eee;
				}
				cnt1++;
			}

			EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_sparqlifyConfig271); 
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sparqlifyConfig"


	public static class constructViewConfig_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructViewConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:169:1: constructViewConfig : ( constructViewConfigStmt )+ EOF !;
	public final SparqlifyConfigParser.constructViewConfig_return constructViewConfig() throws RecognitionException {
		SparqlifyConfigParser.constructViewConfig_return retval = new SparqlifyConfigParser.constructViewConfig_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF4=null;
		ParserRuleReturnScope constructViewConfigStmt3 =null;

		CommonTree EOF4_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:170:5: ( ( constructViewConfigStmt )+ EOF !)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:170:7: ( constructViewConfigStmt )+ EOF !
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:170:7: ( constructViewConfigStmt )+
			int cnt2=0;
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( (LA2_0==CREATE||LA2_0==PREFIX) ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:170:7: constructViewConfigStmt
					{
					pushFollow(FOLLOW_constructViewConfigStmt_in_constructViewConfig290);
					constructViewConfigStmt3=constructViewConfigStmt();
					state._fsp--;

					adaptor.addChild(root_0, constructViewConfigStmt3.getTree());

					}
					break;

				default :
					if ( cnt2 >= 1 ) break loop2;
					EarlyExitException eee = new EarlyExitException(2, input);
					throw eee;
				}
				cnt2++;
			}

			EOF4=(Token)match(input,EOF,FOLLOW_EOF_in_constructViewConfig293); 
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructViewConfig"


	public static class constructViewConfigStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructViewConfigStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:173:1: constructViewConfigStmt : ( viewDefStmtConstruct | prefixDefStmt );
	public final SparqlifyConfigParser.constructViewConfigStmt_return constructViewConfigStmt() throws RecognitionException {
		SparqlifyConfigParser.constructViewConfigStmt_return retval = new SparqlifyConfigParser.constructViewConfigStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope viewDefStmtConstruct5 =null;
		ParserRuleReturnScope prefixDefStmt6 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:174:5: ( viewDefStmtConstruct | prefixDefStmt )
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==CREATE) ) {
				alt3=1;
			}
			else if ( (LA3_0==PREFIX) ) {
				alt3=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 3, 0, input);
				throw nvae;
			}

			switch (alt3) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:174:7: viewDefStmtConstruct
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_viewDefStmtConstruct_in_constructViewConfigStmt312);
					viewDefStmtConstruct5=viewDefStmtConstruct();
					state._fsp--;

					adaptor.addChild(root_0, viewDefStmtConstruct5.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:175:7: prefixDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixDefStmt_in_constructViewConfigStmt320);
					prefixDefStmt6=prefixDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, prefixDefStmt6.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructViewConfigStmt"


	public static class sparqlifyConfigStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "sparqlifyConfigStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:181:1: sparqlifyConfigStmt : ( viewDefStmt | prefixDefStmt | macroStmt | functionDeclarationStmt );
	public final SparqlifyConfigParser.sparqlifyConfigStmt_return sparqlifyConfigStmt() throws RecognitionException {
		SparqlifyConfigParser.sparqlifyConfigStmt_return retval = new SparqlifyConfigParser.sparqlifyConfigStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope viewDefStmt7 =null;
		ParserRuleReturnScope prefixDefStmt8 =null;
		ParserRuleReturnScope macroStmt9 =null;
		ParserRuleReturnScope functionDeclarationStmt10 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:182:5: ( viewDefStmt | prefixDefStmt | macroStmt | functionDeclarationStmt )
			int alt4=4;
			switch ( input.LA(1) ) {
			case CREATE:
				{
				alt4=1;
				}
				break;
			case PREFIX:
				{
				alt4=2;
				}
				break;
			case DEFINE:
				{
				alt4=3;
				}
				break;
			case DECLARE:
				{
				alt4=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:182:7: viewDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_viewDefStmt_in_sparqlifyConfigStmt341);
					viewDefStmt7=viewDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, viewDefStmt7.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:183:7: prefixDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixDefStmt_in_sparqlifyConfigStmt349);
					prefixDefStmt8=prefixDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, prefixDefStmt8.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:184:7: macroStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_macroStmt_in_sparqlifyConfigStmt357);
					macroStmt9=macroStmt();
					state._fsp--;

					adaptor.addChild(root_0, macroStmt9.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:185:7: functionDeclarationStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_functionDeclarationStmt_in_sparqlifyConfigStmt365);
					functionDeclarationStmt10=functionDeclarationStmt();
					state._fsp--;

					adaptor.addChild(root_0, functionDeclarationStmt10.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sparqlifyConfigStmt"


	public static class functionDeclarationStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionDeclarationStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:197:1: functionDeclarationStmt : DECLARE FUNCTION functionSignature AS functionTemplate ( ';' )? -> ^( FUNCTION_DECLARATION functionSignature functionTemplate ) ;
	public final SparqlifyConfigParser.functionDeclarationStmt_return functionDeclarationStmt() throws RecognitionException {
		SparqlifyConfigParser.functionDeclarationStmt_return retval = new SparqlifyConfigParser.functionDeclarationStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DECLARE11=null;
		Token FUNCTION12=null;
		Token AS14=null;
		Token char_literal16=null;
		ParserRuleReturnScope functionSignature13 =null;
		ParserRuleReturnScope functionTemplate15 =null;

		CommonTree DECLARE11_tree=null;
		CommonTree FUNCTION12_tree=null;
		CommonTree AS14_tree=null;
		CommonTree char_literal16_tree=null;
		RewriteRuleTokenStream stream_FUNCTION=new RewriteRuleTokenStream(adaptor,"token FUNCTION");
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_DECLARE=new RewriteRuleTokenStream(adaptor,"token DECLARE");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleSubtreeStream stream_functionSignature=new RewriteRuleSubtreeStream(adaptor,"rule functionSignature");
		RewriteRuleSubtreeStream stream_functionTemplate=new RewriteRuleSubtreeStream(adaptor,"rule functionTemplate");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:198:5: ( DECLARE FUNCTION functionSignature AS functionTemplate ( ';' )? -> ^( FUNCTION_DECLARATION functionSignature functionTemplate ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:198:7: DECLARE FUNCTION functionSignature AS functionTemplate ( ';' )?
			{
			DECLARE11=(Token)match(input,DECLARE,FOLLOW_DECLARE_in_functionDeclarationStmt386);  
			stream_DECLARE.add(DECLARE11);

			FUNCTION12=(Token)match(input,FUNCTION,FOLLOW_FUNCTION_in_functionDeclarationStmt388);  
			stream_FUNCTION.add(FUNCTION12);

			pushFollow(FOLLOW_functionSignature_in_functionDeclarationStmt390);
			functionSignature13=functionSignature();
			state._fsp--;

			stream_functionSignature.add(functionSignature13.getTree());
			AS14=(Token)match(input,AS,FOLLOW_AS_in_functionDeclarationStmt392);  
			stream_AS.add(AS14);

			pushFollow(FOLLOW_functionTemplate_in_functionDeclarationStmt394);
			functionTemplate15=functionTemplate();
			state._fsp--;

			stream_functionTemplate.add(functionTemplate15.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:198:62: ( ';' )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==SEMICOLON) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:198:62: ';'
					{
					char_literal16=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_functionDeclarationStmt396);  
					stream_SEMICOLON.add(char_literal16);

					}
					break;

			}

			// AST REWRITE
			// elements: functionTemplate, functionSignature
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 199:9: -> ^( FUNCTION_DECLARATION functionSignature functionTemplate )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:199:12: ^( FUNCTION_DECLARATION functionSignature functionTemplate )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION_DECLARATION, "FUNCTION_DECLARATION"), root_1);
				adaptor.addChild(root_1, stream_functionSignature.nextTree());
				adaptor.addChild(root_1, stream_functionTemplate.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionDeclarationStmt"


	public static class functionSignature_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionSignature"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:202:1: functionSignature : NAME iriRef parameterTypeList -> ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? ) ;
	public final SparqlifyConfigParser.functionSignature_return functionSignature() throws RecognitionException {
		SparqlifyConfigParser.functionSignature_return retval = new SparqlifyConfigParser.functionSignature_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NAME17=null;
		ParserRuleReturnScope iriRef18 =null;
		ParserRuleReturnScope parameterTypeList19 =null;

		CommonTree NAME17_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");
		RewriteRuleSubtreeStream stream_parameterTypeList=new RewriteRuleSubtreeStream(adaptor,"rule parameterTypeList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:203:5: ( NAME iriRef parameterTypeList -> ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:203:7: NAME iriRef parameterTypeList
			{
			NAME17=(Token)match(input,NAME,FOLLOW_NAME_in_functionSignature432);  
			stream_NAME.add(NAME17);

			pushFollow(FOLLOW_iriRef_in_functionSignature434);
			iriRef18=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef18.getTree());
			pushFollow(FOLLOW_parameterTypeList_in_functionSignature436);
			parameterTypeList19=parameterTypeList();
			state._fsp--;

			stream_parameterTypeList.add(parameterTypeList19.getTree());
			// AST REWRITE
			// elements: parameterTypeList, iriRef, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 204:9: -> ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:204:12: ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION_SIGNATURE, "FUNCTION_SIGNATURE"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_iriRef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:204:45: ( parameterTypeList )?
				if ( stream_parameterTypeList.hasNext() ) {
					adaptor.addChild(root_1, stream_parameterTypeList.nextTree());
				}
				stream_parameterTypeList.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionSignature"


	public static class parameterTypeList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "parameterTypeList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:207:1: parameterTypeList : ( nil -> ^( PARAM_TYPE_LIST nil ) | OPEN_BRACE parameterType ( COMMA parameterType )* CLOSE_BRACE -> ^( PARAM_TYPE_LIST ( parameterType )+ ) );
	public final SparqlifyConfigParser.parameterTypeList_return parameterTypeList() throws RecognitionException {
		SparqlifyConfigParser.parameterTypeList_return retval = new SparqlifyConfigParser.parameterTypeList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE21=null;
		Token COMMA23=null;
		Token CLOSE_BRACE25=null;
		ParserRuleReturnScope nil20 =null;
		ParserRuleReturnScope parameterType22 =null;
		ParserRuleReturnScope parameterType24 =null;

		CommonTree OPEN_BRACE21_tree=null;
		CommonTree COMMA23_tree=null;
		CommonTree CLOSE_BRACE25_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_parameterType=new RewriteRuleSubtreeStream(adaptor,"rule parameterType");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:208:2: ( nil -> ^( PARAM_TYPE_LIST nil ) | OPEN_BRACE parameterType ( COMMA parameterType )* CLOSE_BRACE -> ^( PARAM_TYPE_LIST ( parameterType )+ ) )
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==OPEN_BRACE) ) {
				int LA7_1 = input.LA(2);
				if ( (LA7_1==CLOSE_BRACE) ) {
					alt7=1;
				}
				else if ( (LA7_1==NAME) ) {
					alt7=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 7, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 7, 0, input);
				throw nvae;
			}

			switch (alt7) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:208:4: nil
					{
					pushFollow(FOLLOW_nil_in_parameterTypeList471);
					nil20=nil();
					state._fsp--;

					stream_nil.add(nil20.getTree());
					// AST REWRITE
					// elements: nil
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 209:6: -> ^( PARAM_TYPE_LIST nil )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:209:9: ^( PARAM_TYPE_LIST nil )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PARAM_TYPE_LIST, "PARAM_TYPE_LIST"), root_1);
						adaptor.addChild(root_1, stream_nil.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:210:7: OPEN_BRACE parameterType ( COMMA parameterType )* CLOSE_BRACE
					{
					OPEN_BRACE21=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_parameterTypeList493);  
					stream_OPEN_BRACE.add(OPEN_BRACE21);

					pushFollow(FOLLOW_parameterType_in_parameterTypeList495);
					parameterType22=parameterType();
					state._fsp--;

					stream_parameterType.add(parameterType22.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:210:32: ( COMMA parameterType )*
					loop6:
					while (true) {
						int alt6=2;
						int LA6_0 = input.LA(1);
						if ( (LA6_0==COMMA) ) {
							alt6=1;
						}

						switch (alt6) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:210:33: COMMA parameterType
							{
							COMMA23=(Token)match(input,COMMA,FOLLOW_COMMA_in_parameterTypeList498);  
							stream_COMMA.add(COMMA23);

							pushFollow(FOLLOW_parameterType_in_parameterTypeList500);
							parameterType24=parameterType();
							state._fsp--;

							stream_parameterType.add(parameterType24.getTree());
							}
							break;

						default :
							break loop6;
						}
					}

					CLOSE_BRACE25=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_parameterTypeList504);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE25);

					// AST REWRITE
					// elements: parameterType
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 211:9: -> ^( PARAM_TYPE_LIST ( parameterType )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:211:12: ^( PARAM_TYPE_LIST ( parameterType )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PARAM_TYPE_LIST, "PARAM_TYPE_LIST"), root_1);
						if ( !(stream_parameterType.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_parameterType.hasNext() ) {
							adaptor.addChild(root_1, stream_parameterType.nextTree());
						}
						stream_parameterType.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parameterTypeList"


	public static class parameterType_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "parameterType"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:214:1: parameterType : NAME var -> ^( PARAM_TYPE NAME var ) ;
	public final SparqlifyConfigParser.parameterType_return parameterType() throws RecognitionException {
		SparqlifyConfigParser.parameterType_return retval = new SparqlifyConfigParser.parameterType_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NAME26=null;
		ParserRuleReturnScope var27 =null;

		CommonTree NAME26_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:215:5: ( NAME var -> ^( PARAM_TYPE NAME var ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:215:7: NAME var
			{
			NAME26=(Token)match(input,NAME,FOLLOW_NAME_in_parameterType538);  
			stream_NAME.add(NAME26);

			pushFollow(FOLLOW_var_in_parameterType540);
			var27=var();
			state._fsp--;

			stream_var.add(var27.getTree());
			// AST REWRITE
			// elements: var, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 216:9: -> ^( PARAM_TYPE NAME var )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:216:12: ^( PARAM_TYPE NAME var )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PARAM_TYPE, "PARAM_TYPE"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parameterType"


	public static class functionTemplate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:219:1: functionTemplate : NAME expressionList -> ^( FUNCTION_TEMPLATE NAME expressionList ) ;
	public final SparqlifyConfigParser.functionTemplate_return functionTemplate() throws RecognitionException {
		SparqlifyConfigParser.functionTemplate_return retval = new SparqlifyConfigParser.functionTemplate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NAME28=null;
		ParserRuleReturnScope expressionList29 =null;

		CommonTree NAME28_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:220:5: ( NAME expressionList -> ^( FUNCTION_TEMPLATE NAME expressionList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:220:7: NAME expressionList
			{
			NAME28=(Token)match(input,NAME,FOLLOW_NAME_in_functionTemplate576);  
			stream_NAME.add(NAME28);

			pushFollow(FOLLOW_expressionList_in_functionTemplate578);
			expressionList29=expressionList();
			state._fsp--;

			stream_expressionList.add(expressionList29.getTree());
			// AST REWRITE
			// elements: expressionList, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 221:9: -> ^( FUNCTION_TEMPLATE NAME expressionList )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:221:12: ^( FUNCTION_TEMPLATE NAME expressionList )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION_TEMPLATE, "FUNCTION_TEMPLATE"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_expressionList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionTemplate"


	public static class templateConfig_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "templateConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:231:1: templateConfig : ( templateConfigStmt )+ EOF !;
	public final SparqlifyConfigParser.templateConfig_return templateConfig() throws RecognitionException {
		SparqlifyConfigParser.templateConfig_return retval = new SparqlifyConfigParser.templateConfig_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF31=null;
		ParserRuleReturnScope templateConfigStmt30 =null;

		CommonTree EOF31_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:232:2: ( ( templateConfigStmt )+ EOF !)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:232:4: ( templateConfigStmt )+ EOF !
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:232:4: ( templateConfigStmt )+
			int cnt8=0;
			loop8:
			while (true) {
				int alt8=2;
				int LA8_0 = input.LA(1);
				if ( (LA8_0==CREATE||LA8_0==PREFIX) ) {
					alt8=1;
				}

				switch (alt8) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:232:4: templateConfigStmt
					{
					pushFollow(FOLLOW_templateConfigStmt_in_templateConfig613);
					templateConfigStmt30=templateConfigStmt();
					state._fsp--;

					adaptor.addChild(root_0, templateConfigStmt30.getTree());

					}
					break;

				default :
					if ( cnt8 >= 1 ) break loop8;
					EarlyExitException eee = new EarlyExitException(8, input);
					throw eee;
				}
				cnt8++;
			}

			EOF31=(Token)match(input,EOF,FOLLOW_EOF_in_templateConfig616); 
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "templateConfig"


	public static class templateConfigStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "templateConfigStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:235:1: templateConfigStmt : ( viewTemplateDefStmt | prefixDefStmt );
	public final SparqlifyConfigParser.templateConfigStmt_return templateConfigStmt() throws RecognitionException {
		SparqlifyConfigParser.templateConfigStmt_return retval = new SparqlifyConfigParser.templateConfigStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope viewTemplateDefStmt32 =null;
		ParserRuleReturnScope prefixDefStmt33 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:236:2: ( viewTemplateDefStmt | prefixDefStmt )
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==CREATE) ) {
				alt9=1;
			}
			else if ( (LA9_0==PREFIX) ) {
				alt9=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 9, 0, input);
				throw nvae;
			}

			switch (alt9) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:236:4: viewTemplateDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_viewTemplateDefStmt_in_templateConfigStmt629);
					viewTemplateDefStmt32=viewTemplateDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, viewTemplateDefStmt32.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:237:4: prefixDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixDefStmt_in_templateConfigStmt634);
					prefixDefStmt33=prefixDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, prefixDefStmt33.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "templateConfigStmt"


	public static class importStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "importStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:240:1: importStmt : IMPORT iriOrFileRef ;
	public final SparqlifyConfigParser.importStmt_return importStmt() throws RecognitionException {
		SparqlifyConfigParser.importStmt_return retval = new SparqlifyConfigParser.importStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token IMPORT34=null;
		ParserRuleReturnScope iriOrFileRef35 =null;

		CommonTree IMPORT34_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:241:5: ( IMPORT iriOrFileRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:241:7: IMPORT iriOrFileRef
			{
			root_0 = (CommonTree)adaptor.nil();


			IMPORT34=(Token)match(input,IMPORT,FOLLOW_IMPORT_in_importStmt648); 
			IMPORT34_tree = (CommonTree)adaptor.create(IMPORT34);
			adaptor.addChild(root_0, IMPORT34_tree);

			pushFollow(FOLLOW_iriOrFileRef_in_importStmt650);
			iriOrFileRef35=iriOrFileRef();
			state._fsp--;

			adaptor.addChild(root_0, iriOrFileRef35.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "importStmt"


	public static class iriOrFileRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "iriOrFileRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:244:1: iriOrFileRef : iriRef ;
	public final SparqlifyConfigParser.iriOrFileRef_return iriOrFileRef() throws RecognitionException {
		SparqlifyConfigParser.iriOrFileRef_return retval = new SparqlifyConfigParser.iriOrFileRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef36 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:245:5: ( iriRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:245:7: iriRef
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_iriRef_in_iriOrFileRef667);
			iriRef36=iriRef();
			state._fsp--;

			adaptor.addChild(root_0, iriRef36.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "iriOrFileRef"


	public static class viewDefStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewDefStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:248:1: viewDefStmt : CREATE VIEW NAME AS CONSTRUCT viewTemplateDef ( varConstraintsClause )? ( FROM relationRef )? ( ';' )? -> ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? ) ;
	public final SparqlifyConfigParser.viewDefStmt_return viewDefStmt() throws RecognitionException {
		SparqlifyConfigParser.viewDefStmt_return retval = new SparqlifyConfigParser.viewDefStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE37=null;
		Token VIEW38=null;
		Token NAME39=null;
		Token AS40=null;
		Token CONSTRUCT41=null;
		Token FROM44=null;
		Token char_literal46=null;
		ParserRuleReturnScope viewTemplateDef42 =null;
		ParserRuleReturnScope varConstraintsClause43 =null;
		ParserRuleReturnScope relationRef45 =null;

		CommonTree CREATE37_tree=null;
		CommonTree VIEW38_tree=null;
		CommonTree NAME39_tree=null;
		CommonTree AS40_tree=null;
		CommonTree CONSTRUCT41_tree=null;
		CommonTree FROM44_tree=null;
		CommonTree char_literal46_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_VIEW=new RewriteRuleTokenStream(adaptor,"token VIEW");
		RewriteRuleTokenStream stream_FROM=new RewriteRuleTokenStream(adaptor,"token FROM");
		RewriteRuleSubtreeStream stream_relationRef=new RewriteRuleSubtreeStream(adaptor,"rule relationRef");
		RewriteRuleSubtreeStream stream_viewTemplateDef=new RewriteRuleSubtreeStream(adaptor,"rule viewTemplateDef");
		RewriteRuleSubtreeStream stream_varConstraintsClause=new RewriteRuleSubtreeStream(adaptor,"rule varConstraintsClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:5: ( CREATE VIEW NAME AS CONSTRUCT viewTemplateDef ( varConstraintsClause )? ( FROM relationRef )? ( ';' )? -> ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:7: CREATE VIEW NAME AS CONSTRUCT viewTemplateDef ( varConstraintsClause )? ( FROM relationRef )? ( ';' )?
			{
			CREATE37=(Token)match(input,CREATE,FOLLOW_CREATE_in_viewDefStmt684);  
			stream_CREATE.add(CREATE37);

			VIEW38=(Token)match(input,VIEW,FOLLOW_VIEW_in_viewDefStmt686);  
			stream_VIEW.add(VIEW38);

			NAME39=(Token)match(input,NAME,FOLLOW_NAME_in_viewDefStmt688);  
			stream_NAME.add(NAME39);

			AS40=(Token)match(input,AS,FOLLOW_AS_in_viewDefStmt690);  
			stream_AS.add(AS40);

			CONSTRUCT41=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_viewDefStmt692);  
			stream_CONSTRUCT.add(CONSTRUCT41);

			pushFollow(FOLLOW_viewTemplateDef_in_viewDefStmt694);
			viewTemplateDef42=viewTemplateDef();
			state._fsp--;

			stream_viewTemplateDef.add(viewTemplateDef42.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:53: ( varConstraintsClause )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==CONSTRAIN) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:53: varConstraintsClause
					{
					pushFollow(FOLLOW_varConstraintsClause_in_viewDefStmt696);
					varConstraintsClause43=varConstraintsClause();
					state._fsp--;

					stream_varConstraintsClause.add(varConstraintsClause43.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:75: ( FROM relationRef )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==FROM) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:76: FROM relationRef
					{
					FROM44=(Token)match(input,FROM,FOLLOW_FROM_in_viewDefStmt700);  
					stream_FROM.add(FROM44);

					pushFollow(FOLLOW_relationRef_in_viewDefStmt702);
					relationRef45=relationRef();
					state._fsp--;

					stream_relationRef.add(relationRef45.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:95: ( ';' )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==SEMICOLON) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:249:95: ';'
					{
					char_literal46=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_viewDefStmt706);  
					stream_SEMICOLON.add(char_literal46);

					}
					break;

			}

			// AST REWRITE
			// elements: viewTemplateDef, varConstraintsClause, NAME, relationRef
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 250:6: -> ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:250:9: ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VIEW_DEFINITION, "VIEW_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_viewTemplateDef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:250:48: ( varConstraintsClause )?
				if ( stream_varConstraintsClause.hasNext() ) {
					adaptor.addChild(root_1, stream_varConstraintsClause.nextTree());
				}
				stream_varConstraintsClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:250:70: ( relationRef )?
				if ( stream_relationRef.hasNext() ) {
					adaptor.addChild(root_1, stream_relationRef.nextTree());
				}
				stream_relationRef.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewDefStmt"


	public static class viewDefStmtConstruct_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewDefStmtConstruct"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:253:1: viewDefStmtConstruct : CREATE CONSTRUCT VIEW NAME AS SQL_QUERY ( ';' )? -> ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY ) ;
	public final SparqlifyConfigParser.viewDefStmtConstruct_return viewDefStmtConstruct() throws RecognitionException {
		SparqlifyConfigParser.viewDefStmtConstruct_return retval = new SparqlifyConfigParser.viewDefStmtConstruct_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE47=null;
		Token CONSTRUCT48=null;
		Token VIEW49=null;
		Token NAME50=null;
		Token AS51=null;
		Token SQL_QUERY52=null;
		Token char_literal53=null;

		CommonTree CREATE47_tree=null;
		CommonTree CONSTRUCT48_tree=null;
		CommonTree VIEW49_tree=null;
		CommonTree NAME50_tree=null;
		CommonTree AS51_tree=null;
		CommonTree SQL_QUERY52_tree=null;
		CommonTree char_literal53_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_SQL_QUERY=new RewriteRuleTokenStream(adaptor,"token SQL_QUERY");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_VIEW=new RewriteRuleTokenStream(adaptor,"token VIEW");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:254:5: ( CREATE CONSTRUCT VIEW NAME AS SQL_QUERY ( ';' )? -> ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:254:7: CREATE CONSTRUCT VIEW NAME AS SQL_QUERY ( ';' )?
			{
			CREATE47=(Token)match(input,CREATE,FOLLOW_CREATE_in_viewDefStmtConstruct745);  
			stream_CREATE.add(CREATE47);

			CONSTRUCT48=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_viewDefStmtConstruct747);  
			stream_CONSTRUCT.add(CONSTRUCT48);

			VIEW49=(Token)match(input,VIEW,FOLLOW_VIEW_in_viewDefStmtConstruct749);  
			stream_VIEW.add(VIEW49);

			NAME50=(Token)match(input,NAME,FOLLOW_NAME_in_viewDefStmtConstruct751);  
			stream_NAME.add(NAME50);

			AS51=(Token)match(input,AS,FOLLOW_AS_in_viewDefStmtConstruct753);  
			stream_AS.add(AS51);

			SQL_QUERY52=(Token)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_viewDefStmtConstruct755);  
			stream_SQL_QUERY.add(SQL_QUERY52);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:254:47: ( ';' )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==SEMICOLON) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:254:47: ';'
					{
					char_literal53=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_viewDefStmtConstruct757);  
					stream_SEMICOLON.add(char_literal53);

					}
					break;

			}

			// AST REWRITE
			// elements: SQL_QUERY, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 255:6: -> ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:255:9: ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRUCT_VIEW_DEFINITION, "CONSTRUCT_VIEW_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_SQL_QUERY.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewDefStmtConstruct"


	public static class varConstraintsClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varConstraintsClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:261:1: varConstraintsClause : CONSTRAIN ( varConstraint )+ -> ^( CONSTRAINTS ( varConstraint )* ) ;
	public final SparqlifyConfigParser.varConstraintsClause_return varConstraintsClause() throws RecognitionException {
		SparqlifyConfigParser.varConstraintsClause_return retval = new SparqlifyConfigParser.varConstraintsClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CONSTRAIN54=null;
		ParserRuleReturnScope varConstraint55 =null;

		CommonTree CONSTRAIN54_tree=null;
		RewriteRuleTokenStream stream_CONSTRAIN=new RewriteRuleTokenStream(adaptor,"token CONSTRAIN");
		RewriteRuleSubtreeStream stream_varConstraint=new RewriteRuleSubtreeStream(adaptor,"rule varConstraint");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:262:5: ( CONSTRAIN ( varConstraint )+ -> ^( CONSTRAINTS ( varConstraint )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:262:7: CONSTRAIN ( varConstraint )+
			{
			CONSTRAIN54=(Token)match(input,CONSTRAIN,FOLLOW_CONSTRAIN_in_varConstraintsClause793);  
			stream_CONSTRAIN.add(CONSTRAIN54);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:262:17: ( varConstraint )+
			int cnt14=0;
			loop14:
			while (true) {
				int alt14=2;
				int LA14_0 = input.LA(1);
				if ( ((LA14_0 >= VAR1 && LA14_0 <= VAR3)) ) {
					alt14=1;
				}

				switch (alt14) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:262:17: varConstraint
					{
					pushFollow(FOLLOW_varConstraint_in_varConstraintsClause795);
					varConstraint55=varConstraint();
					state._fsp--;

					stream_varConstraint.add(varConstraint55.getTree());
					}
					break;

				default :
					if ( cnt14 >= 1 ) break loop14;
					EarlyExitException eee = new EarlyExitException(14, input);
					throw eee;
				}
				cnt14++;
			}

			// AST REWRITE
			// elements: varConstraint
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 263:6: -> ^( CONSTRAINTS ( varConstraint )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:263:9: ^( CONSTRAINTS ( varConstraint )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRAINTS, "CONSTRAINTS"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:263:23: ( varConstraint )*
				while ( stream_varConstraint.hasNext() ) {
					adaptor.addChild(root_1, stream_varConstraint.nextTree());
				}
				stream_varConstraint.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varConstraintsClause"


	public static class varConstraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:266:1: varConstraint : ( regexValueConstraint | prefixValueConstraint );
	public final SparqlifyConfigParser.varConstraint_return varConstraint() throws RecognitionException {
		SparqlifyConfigParser.varConstraint_return retval = new SparqlifyConfigParser.varConstraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope regexValueConstraint56 =null;
		ParserRuleReturnScope prefixValueConstraint57 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:267:5: ( regexValueConstraint | prefixValueConstraint )
			int alt15=2;
			switch ( input.LA(1) ) {
			case VAR1:
				{
				int LA15_1 = input.LA(2);
				if ( (LA15_1==REGEX) ) {
					alt15=1;
				}
				else if ( (LA15_1==PREFIX) ) {
					alt15=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 15, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case VAR2:
				{
				int LA15_2 = input.LA(2);
				if ( (LA15_2==REGEX) ) {
					alt15=1;
				}
				else if ( (LA15_2==PREFIX) ) {
					alt15=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 15, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case VAR3:
				{
				int LA15_3 = input.LA(2);
				if ( (LA15_3==REGEX) ) {
					alt15=1;
				}
				else if ( (LA15_3==PREFIX) ) {
					alt15=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 15, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}
			switch (alt15) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:267:7: regexValueConstraint
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_regexValueConstraint_in_varConstraint827);
					regexValueConstraint56=regexValueConstraint();
					state._fsp--;

					adaptor.addChild(root_0, regexValueConstraint56.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:268:7: prefixValueConstraint
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixValueConstraint_in_varConstraint835);
					prefixValueConstraint57=prefixValueConstraint();
					state._fsp--;

					adaptor.addChild(root_0, prefixValueConstraint57.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varConstraint"


	public static class regexValueConstraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "regexValueConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:276:1: regexValueConstraint : var REGEX string -> ^( REGEX_CONSTRAINT var string ) ;
	public final SparqlifyConfigParser.regexValueConstraint_return regexValueConstraint() throws RecognitionException {
		SparqlifyConfigParser.regexValueConstraint_return retval = new SparqlifyConfigParser.regexValueConstraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token REGEX59=null;
		ParserRuleReturnScope var58 =null;
		ParserRuleReturnScope string60 =null;

		CommonTree REGEX59_tree=null;
		RewriteRuleTokenStream stream_REGEX=new RewriteRuleTokenStream(adaptor,"token REGEX");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:278:5: ( var REGEX string -> ^( REGEX_CONSTRAINT var string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:278:7: var REGEX string
			{
			pushFollow(FOLLOW_var_in_regexValueConstraint864);
			var58=var();
			state._fsp--;

			stream_var.add(var58.getTree());
			REGEX59=(Token)match(input,REGEX,FOLLOW_REGEX_in_regexValueConstraint866);  
			stream_REGEX.add(REGEX59);

			pushFollow(FOLLOW_string_in_regexValueConstraint868);
			string60=string();
			state._fsp--;

			stream_string.add(string60.getTree());
			// AST REWRITE
			// elements: var, string
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 279:9: -> ^( REGEX_CONSTRAINT var string )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:279:12: ^( REGEX_CONSTRAINT var string )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(REGEX_CONSTRAINT, "REGEX_CONSTRAINT"), root_1);
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_1, stream_string.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "regexValueConstraint"


	public static class prefixValueConstraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixValueConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:282:1: prefixValueConstraint : var PREFIX stringList -> ^( PREFIX_CONSTRAINT var stringList ) ;
	public final SparqlifyConfigParser.prefixValueConstraint_return prefixValueConstraint() throws RecognitionException {
		SparqlifyConfigParser.prefixValueConstraint_return retval = new SparqlifyConfigParser.prefixValueConstraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token PREFIX62=null;
		ParserRuleReturnScope var61 =null;
		ParserRuleReturnScope stringList63 =null;

		CommonTree PREFIX62_tree=null;
		RewriteRuleTokenStream stream_PREFIX=new RewriteRuleTokenStream(adaptor,"token PREFIX");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_stringList=new RewriteRuleSubtreeStream(adaptor,"rule stringList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:283:5: ( var PREFIX stringList -> ^( PREFIX_CONSTRAINT var stringList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:283:7: var PREFIX stringList
			{
			pushFollow(FOLLOW_var_in_prefixValueConstraint903);
			var61=var();
			state._fsp--;

			stream_var.add(var61.getTree());
			PREFIX62=(Token)match(input,PREFIX,FOLLOW_PREFIX_in_prefixValueConstraint905);  
			stream_PREFIX.add(PREFIX62);

			pushFollow(FOLLOW_stringList_in_prefixValueConstraint907);
			stringList63=stringList();
			state._fsp--;

			stream_stringList.add(stringList63.getTree());
			// AST REWRITE
			// elements: var, stringList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 284:9: -> ^( PREFIX_CONSTRAINT var stringList )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:284:12: ^( PREFIX_CONSTRAINT var stringList )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PREFIX_CONSTRAINT, "PREFIX_CONSTRAINT"), root_1);
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_1, stream_stringList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixValueConstraint"


	public static class stringList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "stringList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:287:1: stringList : string ( ( COMMA )? string )* -> ^( STRING_LIST ( string )* ) ;
	public final SparqlifyConfigParser.stringList_return stringList() throws RecognitionException {
		SparqlifyConfigParser.stringList_return retval = new SparqlifyConfigParser.stringList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COMMA65=null;
		ParserRuleReturnScope string64 =null;
		ParserRuleReturnScope string66 =null;

		CommonTree COMMA65_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:288:5: ( string ( ( COMMA )? string )* -> ^( STRING_LIST ( string )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:288:7: string ( ( COMMA )? string )*
			{
			pushFollow(FOLLOW_string_in_stringList942);
			string64=string();
			state._fsp--;

			stream_string.add(string64.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:288:14: ( ( COMMA )? string )*
			loop17:
			while (true) {
				int alt17=2;
				int LA17_0 = input.LA(1);
				if ( (LA17_0==COMMA||(LA17_0 >= STRING_LITERAL1 && LA17_0 <= STRING_LITERAL_LONG2)) ) {
					alt17=1;
				}

				switch (alt17) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:288:15: ( COMMA )? string
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:288:15: ( COMMA )?
					int alt16=2;
					int LA16_0 = input.LA(1);
					if ( (LA16_0==COMMA) ) {
						alt16=1;
					}
					switch (alt16) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:288:15: COMMA
							{
							COMMA65=(Token)match(input,COMMA,FOLLOW_COMMA_in_stringList945);  
							stream_COMMA.add(COMMA65);

							}
							break;

					}

					pushFollow(FOLLOW_string_in_stringList948);
					string66=string();
					state._fsp--;

					stream_string.add(string66.getTree());
					}
					break;

				default :
					break loop17;
				}
			}

			// AST REWRITE
			// elements: string
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 289:6: -> ^( STRING_LIST ( string )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:289:9: ^( STRING_LIST ( string )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(STRING_LIST, "STRING_LIST"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:289:23: ( string )*
				while ( stream_string.hasNext() ) {
					adaptor.addChild(root_1, stream_string.nextTree());
				}
				stream_string.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "stringList"


	public static class memberAccess_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "memberAccess"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:293:1: memberAccess : '.' NAME ;
	public final SparqlifyConfigParser.memberAccess_return memberAccess() throws RecognitionException {
		SparqlifyConfigParser.memberAccess_return retval = new SparqlifyConfigParser.memberAccess_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token char_literal67=null;
		Token NAME68=null;

		CommonTree char_literal67_tree=null;
		CommonTree NAME68_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:294:5: ( '.' NAME )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:294:7: '.' NAME
			{
			root_0 = (CommonTree)adaptor.nil();


			char_literal67=(Token)match(input,DOT,FOLLOW_DOT_in_memberAccess982); 
			char_literal67_tree = (CommonTree)adaptor.create(char_literal67);
			adaptor.addChild(root_0, char_literal67_tree);

			NAME68=(Token)match(input,NAME,FOLLOW_NAME_in_memberAccess984); 
			NAME68_tree = (CommonTree)adaptor.create(NAME68);
			adaptor.addChild(root_0, NAME68_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "memberAccess"


	public static class viewTemplateDefStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewTemplateDefStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:297:1: viewTemplateDefStmt : CREATE VIEW TEMPLATE NAME AS CONSTRUCT viewTemplateDef ( ';' )? -> ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef ) ;
	public final SparqlifyConfigParser.viewTemplateDefStmt_return viewTemplateDefStmt() throws RecognitionException {
		SparqlifyConfigParser.viewTemplateDefStmt_return retval = new SparqlifyConfigParser.viewTemplateDefStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE69=null;
		Token VIEW70=null;
		Token TEMPLATE71=null;
		Token NAME72=null;
		Token AS73=null;
		Token CONSTRUCT74=null;
		Token char_literal76=null;
		ParserRuleReturnScope viewTemplateDef75 =null;

		CommonTree CREATE69_tree=null;
		CommonTree VIEW70_tree=null;
		CommonTree TEMPLATE71_tree=null;
		CommonTree NAME72_tree=null;
		CommonTree AS73_tree=null;
		CommonTree CONSTRUCT74_tree=null;
		CommonTree char_literal76_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_VIEW=new RewriteRuleTokenStream(adaptor,"token VIEW");
		RewriteRuleTokenStream stream_TEMPLATE=new RewriteRuleTokenStream(adaptor,"token TEMPLATE");
		RewriteRuleSubtreeStream stream_viewTemplateDef=new RewriteRuleSubtreeStream(adaptor,"rule viewTemplateDef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:298:5: ( CREATE VIEW TEMPLATE NAME AS CONSTRUCT viewTemplateDef ( ';' )? -> ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:298:7: CREATE VIEW TEMPLATE NAME AS CONSTRUCT viewTemplateDef ( ';' )?
			{
			CREATE69=(Token)match(input,CREATE,FOLLOW_CREATE_in_viewTemplateDefStmt1001);  
			stream_CREATE.add(CREATE69);

			VIEW70=(Token)match(input,VIEW,FOLLOW_VIEW_in_viewTemplateDefStmt1003);  
			stream_VIEW.add(VIEW70);

			TEMPLATE71=(Token)match(input,TEMPLATE,FOLLOW_TEMPLATE_in_viewTemplateDefStmt1005);  
			stream_TEMPLATE.add(TEMPLATE71);

			NAME72=(Token)match(input,NAME,FOLLOW_NAME_in_viewTemplateDefStmt1007);  
			stream_NAME.add(NAME72);

			AS73=(Token)match(input,AS,FOLLOW_AS_in_viewTemplateDefStmt1009);  
			stream_AS.add(AS73);

			CONSTRUCT74=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_viewTemplateDefStmt1011);  
			stream_CONSTRUCT.add(CONSTRUCT74);

			pushFollow(FOLLOW_viewTemplateDef_in_viewTemplateDefStmt1013);
			viewTemplateDef75=viewTemplateDef();
			state._fsp--;

			stream_viewTemplateDef.add(viewTemplateDef75.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:298:62: ( ';' )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==SEMICOLON) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:298:62: ';'
					{
					char_literal76=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_viewTemplateDefStmt1015);  
					stream_SEMICOLON.add(char_literal76);

					}
					break;

			}

			// AST REWRITE
			// elements: NAME, viewTemplateDef
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 299:6: -> ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:299:9: ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NAMED_VIEW_TEMPLATE_DEFINITION, "NAMED_VIEW_TEMPLATE_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_viewTemplateDef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewTemplateDefStmt"


	public static class viewTemplateDef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewTemplateDef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:302:1: viewTemplateDef : constructTemplateQuads ( varBindingPart )? -> ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? ) ;
	public final SparqlifyConfigParser.viewTemplateDef_return viewTemplateDef() throws RecognitionException {
		SparqlifyConfigParser.viewTemplateDef_return retval = new SparqlifyConfigParser.viewTemplateDef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope constructTemplateQuads77 =null;
		ParserRuleReturnScope varBindingPart78 =null;

		RewriteRuleSubtreeStream stream_constructTemplateQuads=new RewriteRuleSubtreeStream(adaptor,"rule constructTemplateQuads");
		RewriteRuleSubtreeStream stream_varBindingPart=new RewriteRuleSubtreeStream(adaptor,"rule varBindingPart");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:303:2: ( constructTemplateQuads ( varBindingPart )? -> ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:303:4: constructTemplateQuads ( varBindingPart )?
			{
			pushFollow(FOLLOW_constructTemplateQuads_in_viewTemplateDef1045);
			constructTemplateQuads77=constructTemplateQuads();
			state._fsp--;

			stream_constructTemplateQuads.add(constructTemplateQuads77.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:303:27: ( varBindingPart )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==WITH) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:303:27: varBindingPart
					{
					pushFollow(FOLLOW_varBindingPart_in_viewTemplateDef1047);
					varBindingPart78=varBindingPart();
					state._fsp--;

					stream_varBindingPart.add(varBindingPart78.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: varBindingPart, constructTemplateQuads
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 304:3: -> ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:304:6: ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VIEW_TEMPLATE_DEFINITION, "VIEW_TEMPLATE_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_constructTemplateQuads.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:304:56: ( varBindingPart )?
				if ( stream_varBindingPart.hasNext() ) {
					adaptor.addChild(root_1, stream_varBindingPart.nextTree());
				}
				stream_varBindingPart.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewTemplateDef"


	public static class prefixDefStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixDefStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:308:1: prefixDefStmt : prefixDecl ;
	public final SparqlifyConfigParser.prefixDefStmt_return prefixDefStmt() throws RecognitionException {
		SparqlifyConfigParser.prefixDefStmt_return retval = new SparqlifyConfigParser.prefixDefStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope prefixDecl79 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:309:5: ( prefixDecl )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:309:7: prefixDecl
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_prefixDecl_in_prefixDefStmt1076);
			prefixDecl79=prefixDecl();
			state._fsp--;

			adaptor.addChild(root_0, prefixDecl79.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixDefStmt"


	public static class macroStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "macroStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:312:1: macroStmt : DEFINE expression -> ^( MACRO_DEF expression ) ;
	public final SparqlifyConfigParser.macroStmt_return macroStmt() throws RecognitionException {
		SparqlifyConfigParser.macroStmt_return retval = new SparqlifyConfigParser.macroStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DEFINE80=null;
		ParserRuleReturnScope expression81 =null;

		CommonTree DEFINE80_tree=null;
		RewriteRuleTokenStream stream_DEFINE=new RewriteRuleTokenStream(adaptor,"token DEFINE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:313:5: ( DEFINE expression -> ^( MACRO_DEF expression ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:313:7: DEFINE expression
			{
			DEFINE80=(Token)match(input,DEFINE,FOLLOW_DEFINE_in_macroStmt1097);  
			stream_DEFINE.add(DEFINE80);

			pushFollow(FOLLOW_expression_in_macroStmt1099);
			expression81=expression();
			state._fsp--;

			stream_expression.add(expression81.getTree());
			// AST REWRITE
			// elements: expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 313:25: -> ^( MACRO_DEF expression )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:313:28: ^( MACRO_DEF expression )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(MACRO_DEF, "MACRO_DEF"), root_1);
				adaptor.addChild(root_1, stream_expression.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "macroStmt"


	public static class relationRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "relationRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:316:1: relationRef : a= joinClause ( WHERE b= expression )? -> ^( RELATION_REF $a ( $b)? ) ;
	public final SparqlifyConfigParser.relationRef_return relationRef() throws RecognitionException {
		SparqlifyConfigParser.relationRef_return retval = new SparqlifyConfigParser.relationRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WHERE82=null;
		ParserRuleReturnScope a =null;
		ParserRuleReturnScope b =null;

		CommonTree WHERE82_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_joinClause=new RewriteRuleSubtreeStream(adaptor,"rule joinClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:317:5: (a= joinClause ( WHERE b= expression )? -> ^( RELATION_REF $a ( $b)? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:317:7: a= joinClause ( WHERE b= expression )?
			{
			pushFollow(FOLLOW_joinClause_in_relationRef1126);
			a=joinClause();
			state._fsp--;

			stream_joinClause.add(a.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:317:20: ( WHERE b= expression )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==WHERE) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:317:21: WHERE b= expression
					{
					WHERE82=(Token)match(input,WHERE,FOLLOW_WHERE_in_relationRef1129);  
					stream_WHERE.add(WHERE82);

					pushFollow(FOLLOW_expression_in_relationRef1133);
					b=expression();
					state._fsp--;

					stream_expression.add(b.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: a, b
			// token labels: 
			// rule labels: retval, b, a
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_b=new RewriteRuleSubtreeStream(adaptor,"rule b",b!=null?b.getTree():null);
			RewriteRuleSubtreeStream stream_a=new RewriteRuleSubtreeStream(adaptor,"rule a",a!=null?a.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 317:42: -> ^( RELATION_REF $a ( $b)? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:317:45: ^( RELATION_REF $a ( $b)? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(RELATION_REF, "RELATION_REF"), root_1);
				adaptor.addChild(root_1, stream_a.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:317:64: ( $b)?
				if ( stream_b.hasNext() ) {
					adaptor.addChild(root_1, stream_b.nextTree());
				}
				stream_b.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "relationRef"


	public static class joinClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "joinClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:321:1: joinClause : ( joinClauseMember |a= joinClauseMember COMMA b= joinClause -> ^( FULL_JOIN $a $b) );
	public final SparqlifyConfigParser.joinClause_return joinClause() throws RecognitionException {
		SparqlifyConfigParser.joinClause_return retval = new SparqlifyConfigParser.joinClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COMMA84=null;
		ParserRuleReturnScope a =null;
		ParserRuleReturnScope b =null;
		ParserRuleReturnScope joinClauseMember83 =null;

		CommonTree COMMA84_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_joinClauseMember=new RewriteRuleSubtreeStream(adaptor,"rule joinClauseMember");
		RewriteRuleSubtreeStream stream_joinClause=new RewriteRuleSubtreeStream(adaptor,"rule joinClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:322:2: ( joinClauseMember |a= joinClauseMember COMMA b= joinClause -> ^( FULL_JOIN $a $b) )
			int alt21=2;
			switch ( input.LA(1) ) {
			case SQL_QUERY:
				{
				switch ( input.LA(2) ) {
				case AS:
					{
					int LA21_4 = input.LA(3);
					if ( (LA21_4==NAME) ) {
						int LA21_5 = input.LA(4);
						if ( (LA21_5==EOF||LA21_5==CREATE||LA21_5==DECLARE||LA21_5==DEFINE||LA21_5==PREFIX||LA21_5==SEMICOLON||LA21_5==WHERE) ) {
							alt21=1;
						}
						else if ( (LA21_5==COMMA) ) {
							alt21=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 21, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA21_4==A) ) {
						int LA21_6 = input.LA(4);
						if ( (LA21_6==EOF||LA21_6==CREATE||LA21_6==DECLARE||LA21_6==DEFINE||LA21_6==PREFIX||LA21_6==SEMICOLON||LA21_6==WHERE) ) {
							alt21=1;
						}
						else if ( (LA21_6==COMMA) ) {
							alt21=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 21, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case NAME:
					{
					int LA21_5 = input.LA(3);
					if ( (LA21_5==EOF||LA21_5==CREATE||LA21_5==DECLARE||LA21_5==DEFINE||LA21_5==PREFIX||LA21_5==SEMICOLON||LA21_5==WHERE) ) {
						alt21=1;
					}
					else if ( (LA21_5==COMMA) ) {
						alt21=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case A:
					{
					int LA21_6 = input.LA(3);
					if ( (LA21_6==EOF||LA21_6==CREATE||LA21_6==DECLARE||LA21_6==DEFINE||LA21_6==PREFIX||LA21_6==SEMICOLON||LA21_6==WHERE) ) {
						alt21=1;
					}
					else if ( (LA21_6==COMMA) ) {
						alt21=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case EOF:
				case CREATE:
				case DECLARE:
				case DEFINE:
				case PREFIX:
				case SEMICOLON:
				case WHERE:
					{
					alt21=1;
					}
					break;
				case COMMA:
					{
					alt21=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 21, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case AS:
					{
					int LA21_4 = input.LA(3);
					if ( (LA21_4==NAME) ) {
						int LA21_5 = input.LA(4);
						if ( (LA21_5==EOF||LA21_5==CREATE||LA21_5==DECLARE||LA21_5==DEFINE||LA21_5==PREFIX||LA21_5==SEMICOLON||LA21_5==WHERE) ) {
							alt21=1;
						}
						else if ( (LA21_5==COMMA) ) {
							alt21=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 21, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA21_4==A) ) {
						int LA21_6 = input.LA(4);
						if ( (LA21_6==EOF||LA21_6==CREATE||LA21_6==DECLARE||LA21_6==DEFINE||LA21_6==PREFIX||LA21_6==SEMICOLON||LA21_6==WHERE) ) {
							alt21=1;
						}
						else if ( (LA21_6==COMMA) ) {
							alt21=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 21, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case NAME:
					{
					int LA21_5 = input.LA(3);
					if ( (LA21_5==EOF||LA21_5==CREATE||LA21_5==DECLARE||LA21_5==DEFINE||LA21_5==PREFIX||LA21_5==SEMICOLON||LA21_5==WHERE) ) {
						alt21=1;
					}
					else if ( (LA21_5==COMMA) ) {
						alt21=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case A:
					{
					int LA21_6 = input.LA(3);
					if ( (LA21_6==EOF||LA21_6==CREATE||LA21_6==DECLARE||LA21_6==DEFINE||LA21_6==PREFIX||LA21_6==SEMICOLON||LA21_6==WHERE) ) {
						alt21=1;
					}
					else if ( (LA21_6==COMMA) ) {
						alt21=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case EOF:
				case CREATE:
				case DECLARE:
				case DEFINE:
				case PREFIX:
				case SEMICOLON:
				case WHERE:
					{
					alt21=1;
					}
					break;
				case COMMA:
					{
					alt21=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 21, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case STRING_LITERAL2:
				{
				switch ( input.LA(2) ) {
				case AS:
					{
					int LA21_4 = input.LA(3);
					if ( (LA21_4==NAME) ) {
						int LA21_5 = input.LA(4);
						if ( (LA21_5==EOF||LA21_5==CREATE||LA21_5==DECLARE||LA21_5==DEFINE||LA21_5==PREFIX||LA21_5==SEMICOLON||LA21_5==WHERE) ) {
							alt21=1;
						}
						else if ( (LA21_5==COMMA) ) {
							alt21=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 21, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA21_4==A) ) {
						int LA21_6 = input.LA(4);
						if ( (LA21_6==EOF||LA21_6==CREATE||LA21_6==DECLARE||LA21_6==DEFINE||LA21_6==PREFIX||LA21_6==SEMICOLON||LA21_6==WHERE) ) {
							alt21=1;
						}
						else if ( (LA21_6==COMMA) ) {
							alt21=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 21, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case NAME:
					{
					int LA21_5 = input.LA(3);
					if ( (LA21_5==EOF||LA21_5==CREATE||LA21_5==DECLARE||LA21_5==DEFINE||LA21_5==PREFIX||LA21_5==SEMICOLON||LA21_5==WHERE) ) {
						alt21=1;
					}
					else if ( (LA21_5==COMMA) ) {
						alt21=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case A:
					{
					int LA21_6 = input.LA(3);
					if ( (LA21_6==EOF||LA21_6==CREATE||LA21_6==DECLARE||LA21_6==DEFINE||LA21_6==PREFIX||LA21_6==SEMICOLON||LA21_6==WHERE) ) {
						alt21=1;
					}
					else if ( (LA21_6==COMMA) ) {
						alt21=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 21, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case EOF:
				case CREATE:
				case DECLARE:
				case DEFINE:
				case PREFIX:
				case SEMICOLON:
				case WHERE:
					{
					alt21=1;
					}
					break;
				case COMMA:
					{
					alt21=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 21, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}
			switch (alt21) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:322:4: joinClauseMember
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_joinClauseMember_in_joinClause1163);
					joinClauseMember83=joinClauseMember();
					state._fsp--;

					adaptor.addChild(root_0, joinClauseMember83.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:323:4: a= joinClauseMember COMMA b= joinClause
					{
					pushFollow(FOLLOW_joinClauseMember_in_joinClause1170);
					a=joinClauseMember();
					state._fsp--;

					stream_joinClauseMember.add(a.getTree());
					COMMA84=(Token)match(input,COMMA,FOLLOW_COMMA_in_joinClause1172);  
					stream_COMMA.add(COMMA84);

					pushFollow(FOLLOW_joinClause_in_joinClause1176);
					b=joinClause();
					state._fsp--;

					stream_joinClause.add(b.getTree());
					// AST REWRITE
					// elements: b, a
					// token labels: 
					// rule labels: retval, b, a
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_b=new RewriteRuleSubtreeStream(adaptor,"rule b",b!=null?b.getTree():null);
					RewriteRuleSubtreeStream stream_a=new RewriteRuleSubtreeStream(adaptor,"rule a",a!=null?a.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 323:42: -> ^( FULL_JOIN $a $b)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:323:45: ^( FULL_JOIN $a $b)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FULL_JOIN, "FULL_JOIN"), root_1);
						adaptor.addChild(root_1, stream_a.nextTree());
						adaptor.addChild(root_1, stream_b.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "joinClause"


	public static class joinClauseMember_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "joinClauseMember"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:326:1: joinClauseMember : a= logicalTable ( ( AS )? b= name )? -> ^( JOIN_MEMBER $a ( $b)? ) ;
	public final SparqlifyConfigParser.joinClauseMember_return joinClauseMember() throws RecognitionException {
		SparqlifyConfigParser.joinClauseMember_return retval = new SparqlifyConfigParser.joinClauseMember_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token AS85=null;
		ParserRuleReturnScope a =null;
		ParserRuleReturnScope b =null;

		CommonTree AS85_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleSubtreeStream stream_logicalTable=new RewriteRuleSubtreeStream(adaptor,"rule logicalTable");
		RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:5: (a= logicalTable ( ( AS )? b= name )? -> ^( JOIN_MEMBER $a ( $b)? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:7: a= logicalTable ( ( AS )? b= name )?
			{
			pushFollow(FOLLOW_logicalTable_in_joinClauseMember1209);
			a=logicalTable();
			state._fsp--;

			stream_logicalTable.add(a.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:22: ( ( AS )? b= name )?
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( (LA23_0==A||LA23_0==AS||LA23_0==NAME) ) {
				alt23=1;
			}
			switch (alt23) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:23: ( AS )? b= name
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:23: ( AS )?
					int alt22=2;
					int LA22_0 = input.LA(1);
					if ( (LA22_0==AS) ) {
						alt22=1;
					}
					switch (alt22) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:23: AS
							{
							AS85=(Token)match(input,AS,FOLLOW_AS_in_joinClauseMember1212);  
							stream_AS.add(AS85);

							}
							break;

					}

					pushFollow(FOLLOW_name_in_joinClauseMember1217);
					b=name();
					state._fsp--;

					stream_name.add(b.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: a, b
			// token labels: 
			// rule labels: retval, b, a
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_b=new RewriteRuleSubtreeStream(adaptor,"rule b",b!=null?b.getTree():null);
			RewriteRuleSubtreeStream stream_a=new RewriteRuleSubtreeStream(adaptor,"rule a",a!=null?a.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 327:36: -> ^( JOIN_MEMBER $a ( $b)? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:39: ^( JOIN_MEMBER $a ( $b)? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(JOIN_MEMBER, "JOIN_MEMBER"), root_1);
				adaptor.addChild(root_1, stream_a.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:327:57: ( $b)?
				if ( stream_b.hasNext() ) {
					adaptor.addChild(root_1, stream_b.nextTree());
				}
				stream_b.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "joinClauseMember"


	public static class name_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "name"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:330:1: name : ( NAME |a= A -> ^( NAME[$a] ) );
	public final SparqlifyConfigParser.name_return name() throws RecognitionException {
		SparqlifyConfigParser.name_return retval = new SparqlifyConfigParser.name_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token a=null;
		Token NAME86=null;

		CommonTree a_tree=null;
		CommonTree NAME86_tree=null;
		RewriteRuleTokenStream stream_A=new RewriteRuleTokenStream(adaptor,"token A");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:331:5: ( NAME |a= A -> ^( NAME[$a] ) )
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==NAME) ) {
				alt24=1;
			}
			else if ( (LA24_0==A) ) {
				alt24=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 24, 0, input);
				throw nvae;
			}

			switch (alt24) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:331:7: NAME
					{
					root_0 = (CommonTree)adaptor.nil();


					NAME86=(Token)match(input,NAME,FOLLOW_NAME_in_name1249); 
					NAME86_tree = (CommonTree)adaptor.create(NAME86);
					adaptor.addChild(root_0, NAME86_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:332:7: a= A
					{
					a=(Token)match(input,A,FOLLOW_A_in_name1259);  
					stream_A.add(a);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 332:11: -> ^( NAME[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:332:14: ^( NAME[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NAME, a), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "name"


	public static class logicalTable_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "logicalTable"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:336:1: logicalTable : (a= SQL_QUERY -> ^( SQL_RELATION SQL_QUERY[$a] ) |a= NAME -> ^( SQL_RELATION SQL_TABLE[$a] ) |a= STRING_LITERAL2 -> ^( SQL_RELATION SQL_TABLE[$a] ) );
	public final SparqlifyConfigParser.logicalTable_return logicalTable() throws RecognitionException {
		SparqlifyConfigParser.logicalTable_return retval = new SparqlifyConfigParser.logicalTable_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token a=null;

		CommonTree a_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_SQL_QUERY=new RewriteRuleTokenStream(adaptor,"token SQL_QUERY");
		RewriteRuleTokenStream stream_STRING_LITERAL2=new RewriteRuleTokenStream(adaptor,"token STRING_LITERAL2");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:337:5: (a= SQL_QUERY -> ^( SQL_RELATION SQL_QUERY[$a] ) |a= NAME -> ^( SQL_RELATION SQL_TABLE[$a] ) |a= STRING_LITERAL2 -> ^( SQL_RELATION SQL_TABLE[$a] ) )
			int alt25=3;
			switch ( input.LA(1) ) {
			case SQL_QUERY:
				{
				alt25=1;
				}
				break;
			case NAME:
				{
				alt25=2;
				}
				break;
			case STRING_LITERAL2:
				{
				alt25=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 25, 0, input);
				throw nvae;
			}
			switch (alt25) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:337:7: a= SQL_QUERY
					{
					a=(Token)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_logicalTable1286);  
					stream_SQL_QUERY.add(a);

					// AST REWRITE
					// elements: SQL_QUERY
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 337:19: -> ^( SQL_RELATION SQL_QUERY[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:337:22: ^( SQL_RELATION SQL_QUERY[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SQL_RELATION, "SQL_RELATION"), root_1);
						adaptor.addChild(root_1, (CommonTree)adaptor.create(SQL_QUERY, a));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:338:7: a= NAME
					{
					a=(Token)match(input,NAME,FOLLOW_NAME_in_logicalTable1305);  
					stream_NAME.add(a);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 338:14: -> ^( SQL_RELATION SQL_TABLE[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:338:17: ^( SQL_RELATION SQL_TABLE[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SQL_RELATION, "SQL_RELATION"), root_1);
						adaptor.addChild(root_1, (CommonTree)adaptor.create(SQL_TABLE, a));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:339:7: a= STRING_LITERAL2
					{
					a=(Token)match(input,STRING_LITERAL2,FOLLOW_STRING_LITERAL2_in_logicalTable1324);  
					stream_STRING_LITERAL2.add(a);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 339:25: -> ^( SQL_RELATION SQL_TABLE[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:339:28: ^( SQL_RELATION SQL_TABLE[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SQL_RELATION, "SQL_RELATION"), root_1);
						adaptor.addChild(root_1, (CommonTree)adaptor.create(SQL_TABLE, a));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "logicalTable"


	public static class varBindingPart_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varBindingPart"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:356:1: varBindingPart : WITH ( varBinding )+ -> ^( VAR_BINDINGS ( varBinding )+ ) ;
	public final SparqlifyConfigParser.varBindingPart_return varBindingPart() throws RecognitionException {
		SparqlifyConfigParser.varBindingPart_return retval = new SparqlifyConfigParser.varBindingPart_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WITH87=null;
		ParserRuleReturnScope varBinding88 =null;

		CommonTree WITH87_tree=null;
		RewriteRuleTokenStream stream_WITH=new RewriteRuleTokenStream(adaptor,"token WITH");
		RewriteRuleSubtreeStream stream_varBinding=new RewriteRuleSubtreeStream(adaptor,"rule varBinding");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:357:5: ( WITH ( varBinding )+ -> ^( VAR_BINDINGS ( varBinding )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:357:7: WITH ( varBinding )+
			{
			WITH87=(Token)match(input,WITH,FOLLOW_WITH_in_varBindingPart1357);  
			stream_WITH.add(WITH87);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:357:12: ( varBinding )+
			int cnt26=0;
			loop26:
			while (true) {
				int alt26=2;
				int LA26_0 = input.LA(1);
				if ( ((LA26_0 >= VAR1 && LA26_0 <= VAR3)) ) {
					alt26=1;
				}

				switch (alt26) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:357:12: varBinding
					{
					pushFollow(FOLLOW_varBinding_in_varBindingPart1359);
					varBinding88=varBinding();
					state._fsp--;

					stream_varBinding.add(varBinding88.getTree());
					}
					break;

				default :
					if ( cnt26 >= 1 ) break loop26;
					EarlyExitException eee = new EarlyExitException(26, input);
					throw eee;
				}
				cnt26++;
			}

			// AST REWRITE
			// elements: varBinding
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 357:24: -> ^( VAR_BINDINGS ( varBinding )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:357:27: ^( VAR_BINDINGS ( varBinding )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR_BINDINGS, "VAR_BINDINGS"), root_1);
				if ( !(stream_varBinding.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_varBinding.hasNext() ) {
					adaptor.addChild(root_1, stream_varBinding.nextTree());
				}
				stream_varBinding.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varBindingPart"


	public static class varBinding_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varBinding"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:366:1: varBinding : var '=' typeCtorExpression -> ^( VAR_BINDING var typeCtorExpression ) ;
	public final SparqlifyConfigParser.varBinding_return varBinding() throws RecognitionException {
		SparqlifyConfigParser.varBinding_return retval = new SparqlifyConfigParser.varBinding_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token char_literal90=null;
		ParserRuleReturnScope var89 =null;
		ParserRuleReturnScope typeCtorExpression91 =null;

		CommonTree char_literal90_tree=null;
		RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
		RewriteRuleSubtreeStream stream_typeCtorExpression=new RewriteRuleSubtreeStream(adaptor,"rule typeCtorExpression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:367:5: ( var '=' typeCtorExpression -> ^( VAR_BINDING var typeCtorExpression ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:367:7: var '=' typeCtorExpression
			{
			pushFollow(FOLLOW_var_in_varBinding1389);
			var89=var();
			state._fsp--;

			stream_var.add(var89.getTree());
			char_literal90=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_varBinding1391);  
			stream_EQUAL.add(char_literal90);

			pushFollow(FOLLOW_typeCtorExpression_in_varBinding1393);
			typeCtorExpression91=typeCtorExpression();
			state._fsp--;

			stream_typeCtorExpression.add(typeCtorExpression91.getTree());
			// AST REWRITE
			// elements: var, typeCtorExpression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 367:34: -> ^( VAR_BINDING var typeCtorExpression )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:367:37: ^( VAR_BINDING var typeCtorExpression )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR_BINDING, "VAR_BINDING"), root_1);
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_1, stream_typeCtorExpression.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varBinding"


	public static class typeCtorExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "typeCtorExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:370:1: typeCtorExpression : ( BNODE '(' expression ')' -> ^( BNODE expression ) | URI '(' expression ( COMMA expression )* ')' -> ^( URI ^( EXPRESSION_LIST ( expression )* ) ) | PLAIN_LITERAL '(' expression ( ',' expression )? ')' -> ^( PLAIN_LITERAL expression ( expression )? ) | TYPED_LITERAL '(' expression ',' expression ')' -> ^( TYPED_LITERAL expression expression ) );
	public final SparqlifyConfigParser.typeCtorExpression_return typeCtorExpression() throws RecognitionException {
		SparqlifyConfigParser.typeCtorExpression_return retval = new SparqlifyConfigParser.typeCtorExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BNODE92=null;
		Token char_literal93=null;
		Token char_literal95=null;
		Token URI96=null;
		Token char_literal97=null;
		Token COMMA99=null;
		Token char_literal101=null;
		Token PLAIN_LITERAL102=null;
		Token char_literal103=null;
		Token char_literal105=null;
		Token char_literal107=null;
		Token TYPED_LITERAL108=null;
		Token char_literal109=null;
		Token char_literal111=null;
		Token char_literal113=null;
		ParserRuleReturnScope expression94 =null;
		ParserRuleReturnScope expression98 =null;
		ParserRuleReturnScope expression100 =null;
		ParserRuleReturnScope expression104 =null;
		ParserRuleReturnScope expression106 =null;
		ParserRuleReturnScope expression110 =null;
		ParserRuleReturnScope expression112 =null;

		CommonTree BNODE92_tree=null;
		CommonTree char_literal93_tree=null;
		CommonTree char_literal95_tree=null;
		CommonTree URI96_tree=null;
		CommonTree char_literal97_tree=null;
		CommonTree COMMA99_tree=null;
		CommonTree char_literal101_tree=null;
		CommonTree PLAIN_LITERAL102_tree=null;
		CommonTree char_literal103_tree=null;
		CommonTree char_literal105_tree=null;
		CommonTree char_literal107_tree=null;
		CommonTree TYPED_LITERAL108_tree=null;
		CommonTree char_literal109_tree=null;
		CommonTree char_literal111_tree=null;
		CommonTree char_literal113_tree=null;
		RewriteRuleTokenStream stream_BNODE=new RewriteRuleTokenStream(adaptor,"token BNODE");
		RewriteRuleTokenStream stream_TYPED_LITERAL=new RewriteRuleTokenStream(adaptor,"token TYPED_LITERAL");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_PLAIN_LITERAL=new RewriteRuleTokenStream(adaptor,"token PLAIN_LITERAL");
		RewriteRuleTokenStream stream_URI=new RewriteRuleTokenStream(adaptor,"token URI");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:371:5: ( BNODE '(' expression ')' -> ^( BNODE expression ) | URI '(' expression ( COMMA expression )* ')' -> ^( URI ^( EXPRESSION_LIST ( expression )* ) ) | PLAIN_LITERAL '(' expression ( ',' expression )? ')' -> ^( PLAIN_LITERAL expression ( expression )? ) | TYPED_LITERAL '(' expression ',' expression ')' -> ^( TYPED_LITERAL expression expression ) )
			int alt29=4;
			switch ( input.LA(1) ) {
			case BNODE:
				{
				alt29=1;
				}
				break;
			case URI:
				{
				alt29=2;
				}
				break;
			case PLAIN_LITERAL:
				{
				alt29=3;
				}
				break;
			case TYPED_LITERAL:
				{
				alt29=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 29, 0, input);
				throw nvae;
			}
			switch (alt29) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:371:7: BNODE '(' expression ')'
					{
					BNODE92=(Token)match(input,BNODE,FOLLOW_BNODE_in_typeCtorExpression1421);  
					stream_BNODE.add(BNODE92);

					char_literal93=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1423);  
					stream_OPEN_BRACE.add(char_literal93);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1425);
					expression94=expression();
					state._fsp--;

					stream_expression.add(expression94.getTree());
					char_literal95=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1427);  
					stream_CLOSE_BRACE.add(char_literal95);

					// AST REWRITE
					// elements: expression, BNODE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 371:32: -> ^( BNODE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:371:35: ^( BNODE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_BNODE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:372:7: URI '(' expression ( COMMA expression )* ')'
					{
					URI96=(Token)match(input,URI,FOLLOW_URI_in_typeCtorExpression1443);  
					stream_URI.add(URI96);

					char_literal97=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1445);  
					stream_OPEN_BRACE.add(char_literal97);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1447);
					expression98=expression();
					state._fsp--;

					stream_expression.add(expression98.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:372:26: ( COMMA expression )*
					loop27:
					while (true) {
						int alt27=2;
						int LA27_0 = input.LA(1);
						if ( (LA27_0==COMMA) ) {
							alt27=1;
						}

						switch (alt27) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:372:27: COMMA expression
							{
							COMMA99=(Token)match(input,COMMA,FOLLOW_COMMA_in_typeCtorExpression1450);  
							stream_COMMA.add(COMMA99);

							pushFollow(FOLLOW_expression_in_typeCtorExpression1452);
							expression100=expression();
							state._fsp--;

							stream_expression.add(expression100.getTree());
							}
							break;

						default :
							break loop27;
						}
					}

					char_literal101=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1456);  
					stream_CLOSE_BRACE.add(char_literal101);

					// AST REWRITE
					// elements: URI, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 372:50: -> ^( URI ^( EXPRESSION_LIST ( expression )* ) )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:372:53: ^( URI ^( EXPRESSION_LIST ( expression )* ) )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_URI.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:372:59: ^( EXPRESSION_LIST ( expression )* )
						{
						CommonTree root_2 = (CommonTree)adaptor.nil();
						root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(EXPRESSION_LIST, "EXPRESSION_LIST"), root_2);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:372:77: ( expression )*
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_2, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:373:7: PLAIN_LITERAL '(' expression ( ',' expression )? ')'
					{
					PLAIN_LITERAL102=(Token)match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_typeCtorExpression1477);  
					stream_PLAIN_LITERAL.add(PLAIN_LITERAL102);

					char_literal103=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1479);  
					stream_OPEN_BRACE.add(char_literal103);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1481);
					expression104=expression();
					state._fsp--;

					stream_expression.add(expression104.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:373:36: ( ',' expression )?
					int alt28=2;
					int LA28_0 = input.LA(1);
					if ( (LA28_0==COMMA) ) {
						alt28=1;
					}
					switch (alt28) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:373:37: ',' expression
							{
							char_literal105=(Token)match(input,COMMA,FOLLOW_COMMA_in_typeCtorExpression1484);  
							stream_COMMA.add(char_literal105);

							pushFollow(FOLLOW_expression_in_typeCtorExpression1486);
							expression106=expression();
							state._fsp--;

							stream_expression.add(expression106.getTree());
							}
							break;

					}

					char_literal107=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1490);  
					stream_CLOSE_BRACE.add(char_literal107);

					// AST REWRITE
					// elements: expression, expression, PLAIN_LITERAL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 373:58: -> ^( PLAIN_LITERAL expression ( expression )? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:373:61: ^( PLAIN_LITERAL expression ( expression )? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_PLAIN_LITERAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:373:88: ( expression )?
						if ( stream_expression.hasNext() ) {
							adaptor.addChild(root_1, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:374:7: TYPED_LITERAL '(' expression ',' expression ')'
					{
					TYPED_LITERAL108=(Token)match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_typeCtorExpression1509);  
					stream_TYPED_LITERAL.add(TYPED_LITERAL108);

					char_literal109=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1511);  
					stream_OPEN_BRACE.add(char_literal109);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1513);
					expression110=expression();
					state._fsp--;

					stream_expression.add(expression110.getTree());
					char_literal111=(Token)match(input,COMMA,FOLLOW_COMMA_in_typeCtorExpression1515);  
					stream_COMMA.add(char_literal111);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1517);
					expression112=expression();
					state._fsp--;

					stream_expression.add(expression112.getTree());
					char_literal113=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1519);  
					stream_CLOSE_BRACE.add(char_literal113);

					// AST REWRITE
					// elements: expression, expression, TYPED_LITERAL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 374:55: -> ^( TYPED_LITERAL expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:374:58: ^( TYPED_LITERAL expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_TYPED_LITERAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "typeCtorExpression"


	public static class query_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "query"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:381:1: query : ( prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | update ( SEMICOLON update )* EOF -> ^( UPDATE ( update )+ ) );
	public final SparqlifyConfigParser.query_return query() throws RecognitionException {
		SparqlifyConfigParser.query_return retval = new SparqlifyConfigParser.query_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF120=null;
		Token SEMICOLON122=null;
		Token EOF124=null;
		ParserRuleReturnScope prologue114 =null;
		ParserRuleReturnScope selectQuery115 =null;
		ParserRuleReturnScope constructQuery116 =null;
		ParserRuleReturnScope describeQuery117 =null;
		ParserRuleReturnScope askQuery118 =null;
		ParserRuleReturnScope bindingsClause119 =null;
		ParserRuleReturnScope update121 =null;
		ParserRuleReturnScope update123 =null;

		CommonTree EOF120_tree=null;
		CommonTree SEMICOLON122_tree=null;
		CommonTree EOF124_tree=null;
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_EOF=new RewriteRuleTokenStream(adaptor,"token EOF");
		RewriteRuleSubtreeStream stream_update=new RewriteRuleSubtreeStream(adaptor,"rule update");
		RewriteRuleSubtreeStream stream_describeQuery=new RewriteRuleSubtreeStream(adaptor,"rule describeQuery");
		RewriteRuleSubtreeStream stream_bindingsClause=new RewriteRuleSubtreeStream(adaptor,"rule bindingsClause");
		RewriteRuleSubtreeStream stream_constructQuery=new RewriteRuleSubtreeStream(adaptor,"rule constructQuery");
		RewriteRuleSubtreeStream stream_askQuery=new RewriteRuleSubtreeStream(adaptor,"rule askQuery");
		RewriteRuleSubtreeStream stream_prologue=new RewriteRuleSubtreeStream(adaptor,"rule prologue");
		RewriteRuleSubtreeStream stream_selectQuery=new RewriteRuleSubtreeStream(adaptor,"rule selectQuery");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:5: ( prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | update ( SEMICOLON update )* EOF -> ^( UPDATE ( update )+ ) )
			int alt32=2;
			alt32 = dfa32.predict(input);
			switch (alt32) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:7: prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF
					{
					pushFollow(FOLLOW_prologue_in_query1550);
					prologue114=prologue();
					state._fsp--;

					stream_prologue.add(prologue114.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:16: ( selectQuery | constructQuery | describeQuery | askQuery )
					int alt30=4;
					switch ( input.LA(1) ) {
					case SELECT:
						{
						alt30=1;
						}
						break;
					case CONSTRUCT:
						{
						alt30=2;
						}
						break;
					case DESCRIBE:
						{
						alt30=3;
						}
						break;
					case ASK:
						{
						alt30=4;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 30, 0, input);
						throw nvae;
					}
					switch (alt30) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:18: selectQuery
							{
							pushFollow(FOLLOW_selectQuery_in_query1554);
							selectQuery115=selectQuery();
							state._fsp--;

							stream_selectQuery.add(selectQuery115.getTree());
							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:32: constructQuery
							{
							pushFollow(FOLLOW_constructQuery_in_query1558);
							constructQuery116=constructQuery();
							state._fsp--;

							stream_constructQuery.add(constructQuery116.getTree());
							}
							break;
						case 3 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:49: describeQuery
							{
							pushFollow(FOLLOW_describeQuery_in_query1562);
							describeQuery117=describeQuery();
							state._fsp--;

							stream_describeQuery.add(describeQuery117.getTree());
							}
							break;
						case 4 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:65: askQuery
							{
							pushFollow(FOLLOW_askQuery_in_query1566);
							askQuery118=askQuery();
							state._fsp--;

							stream_askQuery.add(askQuery118.getTree());
							}
							break;

					}

					pushFollow(FOLLOW_bindingsClause_in_query1570);
					bindingsClause119=bindingsClause();
					state._fsp--;

					stream_bindingsClause.add(bindingsClause119.getTree());
					EOF120=(Token)match(input,EOF,FOLLOW_EOF_in_query1572);  
					stream_EOF.add(EOF120);

					// AST REWRITE
					// elements: askQuery, constructQuery, prologue, describeQuery, selectQuery, bindingsClause
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 382:95: -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )*
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:98: ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(QUERY, "QUERY"), root_1);
						adaptor.addChild(root_1, stream_prologue.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:115: ( selectQuery )*
						while ( stream_selectQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_selectQuery.nextTree());
						}
						stream_selectQuery.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:128: ( constructQuery )*
						while ( stream_constructQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_constructQuery.nextTree());
						}
						stream_constructQuery.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:144: ( describeQuery )*
						while ( stream_describeQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_describeQuery.nextTree());
						}
						stream_describeQuery.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:159: ( askQuery )*
						while ( stream_askQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_askQuery.nextTree());
						}
						stream_askQuery.reset();

						adaptor.addChild(root_0, root_1);
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:382:170: ( bindingsClause )*
						while ( stream_bindingsClause.hasNext() ) {
							adaptor.addChild(root_0, stream_bindingsClause.nextTree());
						}
						stream_bindingsClause.reset();

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:383:7: update ( SEMICOLON update )* EOF
					{
					pushFollow(FOLLOW_update_in_query1603);
					update121=update();
					state._fsp--;

					stream_update.add(update121.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:383:14: ( SEMICOLON update )*
					loop31:
					while (true) {
						int alt31=2;
						int LA31_0 = input.LA(1);
						if ( (LA31_0==SEMICOLON) ) {
							alt31=1;
						}

						switch (alt31) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:383:16: SEMICOLON update
							{
							SEMICOLON122=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_query1607);  
							stream_SEMICOLON.add(SEMICOLON122);

							pushFollow(FOLLOW_update_in_query1609);
							update123=update();
							state._fsp--;

							stream_update.add(update123.getTree());
							}
							break;

						default :
							break loop31;
						}
					}

					EOF124=(Token)match(input,EOF,FOLLOW_EOF_in_query1613);  
					stream_EOF.add(EOF124);

					// AST REWRITE
					// elements: update
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 383:39: -> ^( UPDATE ( update )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:383:42: ^( UPDATE ( update )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UPDATE, "UPDATE"), root_1);
						if ( !(stream_update.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_update.hasNext() ) {
							adaptor.addChild(root_1, stream_update.nextTree());
						}
						stream_update.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "query"


	public static class prologue_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prologue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:386:1: prologue : ( baseDecl | prefixDecl )* -> ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) ;
	public final SparqlifyConfigParser.prologue_return prologue() throws RecognitionException {
		SparqlifyConfigParser.prologue_return retval = new SparqlifyConfigParser.prologue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope baseDecl125 =null;
		ParserRuleReturnScope prefixDecl126 =null;

		RewriteRuleSubtreeStream stream_prefixDecl=new RewriteRuleSubtreeStream(adaptor,"rule prefixDecl");
		RewriteRuleSubtreeStream stream_baseDecl=new RewriteRuleSubtreeStream(adaptor,"rule baseDecl");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:5: ( ( baseDecl | prefixDecl )* -> ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:7: ( baseDecl | prefixDecl )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:7: ( baseDecl | prefixDecl )*
			loop33:
			while (true) {
				int alt33=3;
				int LA33_0 = input.LA(1);
				if ( (LA33_0==BASE) ) {
					alt33=1;
				}
				else if ( (LA33_0==PREFIX) ) {
					alt33=2;
				}

				switch (alt33) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:8: baseDecl
					{
					pushFollow(FOLLOW_baseDecl_in_prologue1640);
					baseDecl125=baseDecl();
					state._fsp--;

					stream_baseDecl.add(baseDecl125.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:19: prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_prologue1644);
					prefixDecl126=prefixDecl();
					state._fsp--;

					stream_prefixDecl.add(prefixDecl126.getTree());
					}
					break;

				default :
					break loop33;
				}
			}

			// AST REWRITE
			// elements: baseDecl, prefixDecl
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 387:32: -> ^( PROLOGUE ( baseDecl )* ( prefixDecl )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:35: ^( PROLOGUE ( baseDecl )* ( prefixDecl )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PROLOGUE, "PROLOGUE"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:46: ( baseDecl )*
				while ( stream_baseDecl.hasNext() ) {
					adaptor.addChild(root_1, stream_baseDecl.nextTree());
				}
				stream_baseDecl.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:387:56: ( prefixDecl )*
				while ( stream_prefixDecl.hasNext() ) {
					adaptor.addChild(root_1, stream_prefixDecl.nextTree());
				}
				stream_prefixDecl.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prologue"


	public static class baseDecl_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "baseDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:390:1: baseDecl : BASE IRI_REF -> ^( BASE IRI_REF ) ;
	public final SparqlifyConfigParser.baseDecl_return baseDecl() throws RecognitionException {
		SparqlifyConfigParser.baseDecl_return retval = new SparqlifyConfigParser.baseDecl_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BASE127=null;
		Token IRI_REF128=null;

		CommonTree BASE127_tree=null;
		CommonTree IRI_REF128_tree=null;
		RewriteRuleTokenStream stream_BASE=new RewriteRuleTokenStream(adaptor,"token BASE");
		RewriteRuleTokenStream stream_IRI_REF=new RewriteRuleTokenStream(adaptor,"token IRI_REF");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:391:5: ( BASE IRI_REF -> ^( BASE IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:391:7: BASE IRI_REF
			{
			BASE127=(Token)match(input,BASE,FOLLOW_BASE_in_baseDecl1675);  
			stream_BASE.add(BASE127);

			IRI_REF128=(Token)match(input,IRI_REF,FOLLOW_IRI_REF_in_baseDecl1677);  
			stream_IRI_REF.add(IRI_REF128);

			// AST REWRITE
			// elements: BASE, IRI_REF
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 391:20: -> ^( BASE IRI_REF )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:391:23: ^( BASE IRI_REF )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_BASE.nextNode(), root_1);
				adaptor.addChild(root_1, stream_IRI_REF.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "baseDecl"


	public static class prefixDecl_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:1: prefixDecl : PREFIX PNAME_NS IRI_REF -> ^( PREFIX PNAME_NS IRI_REF ) ;
	public final SparqlifyConfigParser.prefixDecl_return prefixDecl() throws RecognitionException {
		SparqlifyConfigParser.prefixDecl_return retval = new SparqlifyConfigParser.prefixDecl_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token PREFIX129=null;
		Token PNAME_NS130=null;
		Token IRI_REF131=null;

		CommonTree PREFIX129_tree=null;
		CommonTree PNAME_NS130_tree=null;
		CommonTree IRI_REF131_tree=null;
		RewriteRuleTokenStream stream_PREFIX=new RewriteRuleTokenStream(adaptor,"token PREFIX");
		RewriteRuleTokenStream stream_PNAME_NS=new RewriteRuleTokenStream(adaptor,"token PNAME_NS");
		RewriteRuleTokenStream stream_IRI_REF=new RewriteRuleTokenStream(adaptor,"token IRI_REF");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:395:5: ( PREFIX PNAME_NS IRI_REF -> ^( PREFIX PNAME_NS IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:395:7: PREFIX PNAME_NS IRI_REF
			{
			PREFIX129=(Token)match(input,PREFIX,FOLLOW_PREFIX_in_prefixDecl1702);  
			stream_PREFIX.add(PREFIX129);

			PNAME_NS130=(Token)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixDecl1704);  
			stream_PNAME_NS.add(PNAME_NS130);

			IRI_REF131=(Token)match(input,IRI_REF,FOLLOW_IRI_REF_in_prefixDecl1706);  
			stream_IRI_REF.add(IRI_REF131);

			// AST REWRITE
			// elements: IRI_REF, PREFIX, PNAME_NS
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 395:31: -> ^( PREFIX PNAME_NS IRI_REF )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:395:34: ^( PREFIX PNAME_NS IRI_REF )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_PREFIX.nextNode(), root_1);
				adaptor.addChild(root_1, stream_PNAME_NS.nextNode());
				adaptor.addChild(root_1, stream_IRI_REF.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixDecl"


	public static class selectQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "selectQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:398:1: selectQuery : selectClause ( datasetClause )* whereClause solutionModifier -> ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* ) ;
	public final SparqlifyConfigParser.selectQuery_return selectQuery() throws RecognitionException {
		SparqlifyConfigParser.selectQuery_return retval = new SparqlifyConfigParser.selectQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope selectClause132 =null;
		ParserRuleReturnScope datasetClause133 =null;
		ParserRuleReturnScope whereClause134 =null;
		ParserRuleReturnScope solutionModifier135 =null;

		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");
		RewriteRuleSubtreeStream stream_selectClause=new RewriteRuleSubtreeStream(adaptor,"rule selectClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:5: ( selectClause ( datasetClause )* whereClause solutionModifier -> ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:7: selectClause ( datasetClause )* whereClause solutionModifier
			{
			pushFollow(FOLLOW_selectClause_in_selectQuery1733);
			selectClause132=selectClause();
			state._fsp--;

			stream_selectClause.add(selectClause132.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:20: ( datasetClause )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==FROM) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:20: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_selectQuery1735);
					datasetClause133=datasetClause();
					state._fsp--;

					stream_datasetClause.add(datasetClause133.getTree());
					}
					break;

				default :
					break loop34;
				}
			}

			pushFollow(FOLLOW_whereClause_in_selectQuery1738);
			whereClause134=whereClause();
			state._fsp--;

			stream_whereClause.add(whereClause134.getTree());
			pushFollow(FOLLOW_solutionModifier_in_selectQuery1740);
			solutionModifier135=solutionModifier();
			state._fsp--;

			stream_solutionModifier.add(solutionModifier135.getTree());
			// AST REWRITE
			// elements: whereClause, selectClause, datasetClause, solutionModifier
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 399:64: -> ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:67: ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SELECT, "SELECT"), root_1);
				adaptor.addChild(root_1, stream_selectClause.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:89: ( datasetClause )*
				while ( stream_datasetClause.hasNext() ) {
					adaptor.addChild(root_1, stream_datasetClause.nextTree());
				}
				stream_datasetClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:104: ( whereClause )*
				while ( stream_whereClause.hasNext() ) {
					adaptor.addChild(root_1, stream_whereClause.nextTree());
				}
				stream_whereClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:399:117: ( solutionModifier )*
				while ( stream_solutionModifier.hasNext() ) {
					adaptor.addChild(root_1, stream_solutionModifier.nextTree());
				}
				stream_solutionModifier.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectQuery"


	public static class subSelect_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "subSelect"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:402:1: subSelect : selectClause whereClause solutionModifier -> ^( SUBSELECT ( whereClause )* solutionModifier ) ;
	public final SparqlifyConfigParser.subSelect_return subSelect() throws RecognitionException {
		SparqlifyConfigParser.subSelect_return retval = new SparqlifyConfigParser.subSelect_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope selectClause136 =null;
		ParserRuleReturnScope whereClause137 =null;
		ParserRuleReturnScope solutionModifier138 =null;

		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");
		RewriteRuleSubtreeStream stream_selectClause=new RewriteRuleSubtreeStream(adaptor,"rule selectClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:403:5: ( selectClause whereClause solutionModifier -> ^( SUBSELECT ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:403:7: selectClause whereClause solutionModifier
			{
			pushFollow(FOLLOW_selectClause_in_subSelect1774);
			selectClause136=selectClause();
			state._fsp--;

			stream_selectClause.add(selectClause136.getTree());
			pushFollow(FOLLOW_whereClause_in_subSelect1776);
			whereClause137=whereClause();
			state._fsp--;

			stream_whereClause.add(whereClause137.getTree());
			pushFollow(FOLLOW_solutionModifier_in_subSelect1778);
			solutionModifier138=solutionModifier();
			state._fsp--;

			stream_solutionModifier.add(solutionModifier138.getTree());
			// AST REWRITE
			// elements: solutionModifier, whereClause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 403:49: -> ^( SUBSELECT ( whereClause )* solutionModifier )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:403:52: ^( SUBSELECT ( whereClause )* solutionModifier )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SUBSELECT, "SUBSELECT"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:403:64: ( whereClause )*
				while ( stream_whereClause.hasNext() ) {
					adaptor.addChild(root_1, stream_whereClause.nextTree());
				}
				stream_whereClause.reset();

				adaptor.addChild(root_1, stream_solutionModifier.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "subSelect"


	public static class selectClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "selectClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:1: selectClause : ( SELECT ( DISTINCT | REDUCED )? ASTERISK -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK ) | SELECT ( DISTINCT | REDUCED )? (v+= selectVariables )+ -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* ) );
	public final SparqlifyConfigParser.selectClause_return selectClause() throws RecognitionException {
		SparqlifyConfigParser.selectClause_return retval = new SparqlifyConfigParser.selectClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SELECT139=null;
		Token DISTINCT140=null;
		Token REDUCED141=null;
		Token ASTERISK142=null;
		Token SELECT143=null;
		Token DISTINCT144=null;
		Token REDUCED145=null;
		List<Object> list_v=null;
		RuleReturnScope v = null;
		CommonTree SELECT139_tree=null;
		CommonTree DISTINCT140_tree=null;
		CommonTree REDUCED141_tree=null;
		CommonTree ASTERISK142_tree=null;
		CommonTree SELECT143_tree=null;
		CommonTree DISTINCT144_tree=null;
		CommonTree REDUCED145_tree=null;
		RewriteRuleTokenStream stream_SELECT=new RewriteRuleTokenStream(adaptor,"token SELECT");
		RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
		RewriteRuleTokenStream stream_REDUCED=new RewriteRuleTokenStream(adaptor,"token REDUCED");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleSubtreeStream stream_selectVariables=new RewriteRuleSubtreeStream(adaptor,"rule selectVariables");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:5: ( SELECT ( DISTINCT | REDUCED )? ASTERISK -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK ) | SELECT ( DISTINCT | REDUCED )? (v+= selectVariables )+ -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* ) )
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==SELECT) ) {
				switch ( input.LA(2) ) {
				case DISTINCT:
					{
					int LA38_2 = input.LA(3);
					if ( (LA38_2==ASTERISK) ) {
						alt38=1;
					}
					else if ( (LA38_2==OPEN_BRACE||(LA38_2 >= VAR1 && LA38_2 <= VAR3)) ) {
						alt38=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 38, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case REDUCED:
					{
					int LA38_3 = input.LA(3);
					if ( (LA38_3==ASTERISK) ) {
						alt38=1;
					}
					else if ( (LA38_3==OPEN_BRACE||(LA38_3 >= VAR1 && LA38_3 <= VAR3)) ) {
						alt38=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 38, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case ASTERISK:
					{
					alt38=1;
					}
					break;
				case OPEN_BRACE:
				case VAR1:
				case VAR2:
				case VAR3:
					{
					alt38=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 38, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 38, 0, input);
				throw nvae;
			}

			switch (alt38) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:7: SELECT ( DISTINCT | REDUCED )? ASTERISK
					{
					SELECT139=(Token)match(input,SELECT,FOLLOW_SELECT_in_selectClause1811);  
					stream_SELECT.add(SELECT139);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:14: ( DISTINCT | REDUCED )?
					int alt35=3;
					int LA35_0 = input.LA(1);
					if ( (LA35_0==DISTINCT) ) {
						alt35=1;
					}
					else if ( (LA35_0==REDUCED) ) {
						alt35=2;
					}
					switch (alt35) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:16: DISTINCT
							{
							DISTINCT140=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1815);  
							stream_DISTINCT.add(DISTINCT140);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:27: REDUCED
							{
							REDUCED141=(Token)match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1819);  
							stream_REDUCED.add(REDUCED141);

							}
							break;

					}

					ASTERISK142=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1824);  
					stream_ASTERISK.add(ASTERISK142);

					// AST REWRITE
					// elements: REDUCED, DISTINCT, ASTERISK
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 407:47: -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:50: ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SELECT_CLAUSE, "SELECT_CLAUSE"), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:66: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:407:76: ( REDUCED )*
						while ( stream_REDUCED.hasNext() ) {
							adaptor.addChild(root_1, stream_REDUCED.nextNode());
						}
						stream_REDUCED.reset();

						adaptor.addChild(root_1, stream_ASTERISK.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:7: SELECT ( DISTINCT | REDUCED )? (v+= selectVariables )+
					{
					SELECT143=(Token)match(input,SELECT,FOLLOW_SELECT_in_selectClause1846);  
					stream_SELECT.add(SELECT143);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:14: ( DISTINCT | REDUCED )?
					int alt36=3;
					int LA36_0 = input.LA(1);
					if ( (LA36_0==DISTINCT) ) {
						alt36=1;
					}
					else if ( (LA36_0==REDUCED) ) {
						alt36=2;
					}
					switch (alt36) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:16: DISTINCT
							{
							DISTINCT144=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1850);  
							stream_DISTINCT.add(DISTINCT144);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:27: REDUCED
							{
							REDUCED145=(Token)match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1854);  
							stream_REDUCED.add(REDUCED145);

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:38: (v+= selectVariables )+
					int cnt37=0;
					loop37:
					while (true) {
						int alt37=2;
						int LA37_0 = input.LA(1);
						if ( (LA37_0==OPEN_BRACE||(LA37_0 >= VAR1 && LA37_0 <= VAR3)) ) {
							alt37=1;
						}

						switch (alt37) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:39: v+= selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1862);
							v=selectVariables();
							state._fsp--;

							stream_selectVariables.add(v.getTree());
							if (list_v==null) list_v=new ArrayList<Object>();
							list_v.add(v.getTree());
							}
							break;

						default :
							if ( cnt37 >= 1 ) break loop37;
							EarlyExitException eee = new EarlyExitException(37, input);
							throw eee;
						}
						cnt37++;
					}

					// AST REWRITE
					// elements: DISTINCT, v, REDUCED
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: v
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"token v",list_v);
					root_0 = (CommonTree)adaptor.nil();
					// 408:60: -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:63: ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SELECT_CLAUSE, "SELECT_CLAUSE"), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:79: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:89: ( REDUCED )*
						while ( stream_REDUCED.hasNext() ) {
							adaptor.addChild(root_1, stream_REDUCED.nextNode());
						}
						stream_REDUCED.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:408:99: ( $v)*
						while ( stream_v.hasNext() ) {
							adaptor.addChild(root_1, stream_v.nextTree());
						}
						stream_v.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectClause"


	public static class selectVariables_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "selectVariables"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:411:1: selectVariables : (v= var -> ^( VAR $v) | OPEN_BRACE e= expression AS v= var CLOSE_BRACE -> ^( AS $e $v) );
	public final SparqlifyConfigParser.selectVariables_return selectVariables() throws RecognitionException {
		SparqlifyConfigParser.selectVariables_return retval = new SparqlifyConfigParser.selectVariables_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE146=null;
		Token AS147=null;
		Token CLOSE_BRACE148=null;
		ParserRuleReturnScope v =null;
		ParserRuleReturnScope e =null;

		CommonTree OPEN_BRACE146_tree=null;
		CommonTree AS147_tree=null;
		CommonTree CLOSE_BRACE148_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:412:5: (v= var -> ^( VAR $v) | OPEN_BRACE e= expression AS v= var CLOSE_BRACE -> ^( AS $e $v) )
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( ((LA39_0 >= VAR1 && LA39_0 <= VAR3)) ) {
				alt39=1;
			}
			else if ( (LA39_0==OPEN_BRACE) ) {
				alt39=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:412:7: v= var
					{
					pushFollow(FOLLOW_var_in_selectVariables1899);
					v=var();
					state._fsp--;

					stream_var.add(v.getTree());
					// AST REWRITE
					// elements: v
					// token labels: 
					// rule labels: v, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 412:13: -> ^( VAR $v)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:412:16: ^( VAR $v)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, "VAR"), root_1);
						adaptor.addChild(root_1, stream_v.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:413:7: OPEN_BRACE e= expression AS v= var CLOSE_BRACE
					{
					OPEN_BRACE146=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_selectVariables1917);  
					stream_OPEN_BRACE.add(OPEN_BRACE146);

					pushFollow(FOLLOW_expression_in_selectVariables1921);
					e=expression();
					state._fsp--;

					stream_expression.add(e.getTree());
					AS147=(Token)match(input,AS,FOLLOW_AS_in_selectVariables1923);  
					stream_AS.add(AS147);

					pushFollow(FOLLOW_var_in_selectVariables1927);
					v=var();
					state._fsp--;

					stream_var.add(v.getTree());
					CLOSE_BRACE148=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_selectVariables1929);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE148);

					// AST REWRITE
					// elements: AS, v, e
					// token labels: 
					// rule labels: v, retval, e
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_e=new RewriteRuleSubtreeStream(adaptor,"rule e",e!=null?e.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 413:52: -> ^( AS $e $v)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:413:55: ^( AS $e $v)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_e.nextTree());
						adaptor.addChild(root_1, stream_v.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectVariables"


	public static class constructQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:416:1: constructQuery : ( CONSTRUCT constructTemplate ( datasetClause )* whereClause solutionModifier -> ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* ) | CONSTRUCT ( datasetClause )* WHERE OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE solutionModifier -> ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* ) );
	public final SparqlifyConfigParser.constructQuery_return constructQuery() throws RecognitionException {
		SparqlifyConfigParser.constructQuery_return retval = new SparqlifyConfigParser.constructQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CONSTRUCT149=null;
		Token CONSTRUCT154=null;
		Token WHERE156=null;
		Token OPEN_CURLY_BRACE157=null;
		Token CLOSE_CURLY_BRACE159=null;
		ParserRuleReturnScope constructTemplate150 =null;
		ParserRuleReturnScope datasetClause151 =null;
		ParserRuleReturnScope whereClause152 =null;
		ParserRuleReturnScope solutionModifier153 =null;
		ParserRuleReturnScope datasetClause155 =null;
		ParserRuleReturnScope triplesTemplate158 =null;
		ParserRuleReturnScope solutionModifier160 =null;

		CommonTree CONSTRUCT149_tree=null;
		CommonTree CONSTRUCT154_tree=null;
		CommonTree WHERE156_tree=null;
		CommonTree OPEN_CURLY_BRACE157_tree=null;
		CommonTree CLOSE_CURLY_BRACE159_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_triplesTemplate=new RewriteRuleSubtreeStream(adaptor,"rule triplesTemplate");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");
		RewriteRuleSubtreeStream stream_constructTemplate=new RewriteRuleSubtreeStream(adaptor,"rule constructTemplate");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:5: ( CONSTRUCT constructTemplate ( datasetClause )* whereClause solutionModifier -> ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* ) | CONSTRUCT ( datasetClause )* WHERE OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE solutionModifier -> ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* ) )
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==CONSTRUCT) ) {
				int LA43_1 = input.LA(2);
				if ( (LA43_1==OPEN_CURLY_BRACE) ) {
					alt43=1;
				}
				else if ( (LA43_1==FROM||LA43_1==WHERE) ) {
					alt43=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 43, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 43, 0, input);
				throw nvae;
			}

			switch (alt43) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:7: CONSTRUCT constructTemplate ( datasetClause )* whereClause solutionModifier
					{
					CONSTRUCT149=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1960);  
					stream_CONSTRUCT.add(CONSTRUCT149);

					pushFollow(FOLLOW_constructTemplate_in_constructQuery1962);
					constructTemplate150=constructTemplate();
					state._fsp--;

					stream_constructTemplate.add(constructTemplate150.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:35: ( datasetClause )*
					loop40:
					while (true) {
						int alt40=2;
						int LA40_0 = input.LA(1);
						if ( (LA40_0==FROM) ) {
							alt40=1;
						}

						switch (alt40) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:35: datasetClause
							{
							pushFollow(FOLLOW_datasetClause_in_constructQuery1964);
							datasetClause151=datasetClause();
							state._fsp--;

							stream_datasetClause.add(datasetClause151.getTree());
							}
							break;

						default :
							break loop40;
						}
					}

					pushFollow(FOLLOW_whereClause_in_constructQuery1967);
					whereClause152=whereClause();
					state._fsp--;

					stream_whereClause.add(whereClause152.getTree());
					pushFollow(FOLLOW_solutionModifier_in_constructQuery1969);
					solutionModifier153=solutionModifier();
					state._fsp--;

					stream_solutionModifier.add(solutionModifier153.getTree());
					// AST REWRITE
					// elements: datasetClause, constructTemplate, whereClause, solutionModifier, CONSTRUCT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 417:79: -> ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:82: ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONSTRUCT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:94: ( constructTemplate )*
						while ( stream_constructTemplate.hasNext() ) {
							adaptor.addChild(root_1, stream_constructTemplate.nextTree());
						}
						stream_constructTemplate.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:113: ( datasetClause )*
						while ( stream_datasetClause.hasNext() ) {
							adaptor.addChild(root_1, stream_datasetClause.nextTree());
						}
						stream_datasetClause.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:128: ( whereClause )*
						while ( stream_whereClause.hasNext() ) {
							adaptor.addChild(root_1, stream_whereClause.nextTree());
						}
						stream_whereClause.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:417:141: ( solutionModifier )*
						while ( stream_solutionModifier.hasNext() ) {
							adaptor.addChild(root_1, stream_solutionModifier.nextTree());
						}
						stream_solutionModifier.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:7: CONSTRUCT ( datasetClause )* WHERE OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE solutionModifier
					{
					CONSTRUCT154=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1995);  
					stream_CONSTRUCT.add(CONSTRUCT154);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:17: ( datasetClause )*
					loop41:
					while (true) {
						int alt41=2;
						int LA41_0 = input.LA(1);
						if ( (LA41_0==FROM) ) {
							alt41=1;
						}

						switch (alt41) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:17: datasetClause
							{
							pushFollow(FOLLOW_datasetClause_in_constructQuery1997);
							datasetClause155=datasetClause();
							state._fsp--;

							stream_datasetClause.add(datasetClause155.getTree());
							}
							break;

						default :
							break loop41;
						}
					}

					WHERE156=(Token)match(input,WHERE,FOLLOW_WHERE_in_constructQuery2000);  
					stream_WHERE.add(WHERE156);

					OPEN_CURLY_BRACE157=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_constructQuery2002);  
					stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE157);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:55: ( triplesTemplate )?
					int alt42=2;
					int LA42_0 = input.LA(1);
					if ( (LA42_0==BLANK_NODE_LABEL||(LA42_0 >= DECIMAL && LA42_0 <= DECIMAL_POSITIVE)||(LA42_0 >= DOUBLE && LA42_0 <= DOUBLE_POSITIVE)||LA42_0==FALSE||(LA42_0 >= INTEGER && LA42_0 <= INTEGER_POSITIVE)||LA42_0==IRI_REF||LA42_0==OPEN_BRACE||LA42_0==OPEN_SQUARE_BRACKET||(LA42_0 >= PNAME_LN && LA42_0 <= PNAME_NS)||(LA42_0 >= STRING_LITERAL1 && LA42_0 <= STRING_LITERAL_LONG2)||LA42_0==TRUE||(LA42_0 >= VAR1 && LA42_0 <= VAR3)) ) {
						alt42=1;
					}
					switch (alt42) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:55: triplesTemplate
							{
							pushFollow(FOLLOW_triplesTemplate_in_constructQuery2004);
							triplesTemplate158=triplesTemplate();
							state._fsp--;

							stream_triplesTemplate.add(triplesTemplate158.getTree());
							}
							break;

					}

					CLOSE_CURLY_BRACE159=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_constructQuery2007);  
					stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE159);

					pushFollow(FOLLOW_solutionModifier_in_constructQuery2009);
					solutionModifier160=solutionModifier();
					state._fsp--;

					stream_solutionModifier.add(solutionModifier160.getTree());
					// AST REWRITE
					// elements: triplesTemplate, solutionModifier, CONSTRUCT, datasetClause, WHERE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 418:107: -> ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:110: ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONSTRUCT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:122: ( datasetClause )*
						while ( stream_datasetClause.hasNext() ) {
							adaptor.addChild(root_1, stream_datasetClause.nextTree());
						}
						stream_datasetClause.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:137: ^( WHERE ( triplesTemplate )* )
						{
						CommonTree root_2 = (CommonTree)adaptor.nil();
						root_2 = (CommonTree)adaptor.becomeRoot(stream_WHERE.nextNode(), root_2);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:145: ( triplesTemplate )*
						while ( stream_triplesTemplate.hasNext() ) {
							adaptor.addChild(root_2, stream_triplesTemplate.nextTree());
						}
						stream_triplesTemplate.reset();

						adaptor.addChild(root_1, root_2);
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:163: ( solutionModifier )*
						while ( stream_solutionModifier.hasNext() ) {
							adaptor.addChild(root_1, stream_solutionModifier.nextTree());
						}
						stream_solutionModifier.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructQuery"


	public static class describeQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "describeQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:421:1: describeQuery : DESCRIBE ( (v+= varOrIRIref )+ | ASTERISK ) ( datasetClause )* ( whereClause )? solutionModifier -> ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* ) ;
	public final SparqlifyConfigParser.describeQuery_return describeQuery() throws RecognitionException {
		SparqlifyConfigParser.describeQuery_return retval = new SparqlifyConfigParser.describeQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DESCRIBE161=null;
		Token ASTERISK162=null;
		List<Object> list_v=null;
		ParserRuleReturnScope datasetClause163 =null;
		ParserRuleReturnScope whereClause164 =null;
		ParserRuleReturnScope solutionModifier165 =null;
		RuleReturnScope v = null;
		CommonTree DESCRIBE161_tree=null;
		CommonTree ASTERISK162_tree=null;
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleTokenStream stream_DESCRIBE=new RewriteRuleTokenStream(adaptor,"token DESCRIBE");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:5: ( DESCRIBE ( (v+= varOrIRIref )+ | ASTERISK ) ( datasetClause )* ( whereClause )? solutionModifier -> ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:7: DESCRIBE ( (v+= varOrIRIref )+ | ASTERISK ) ( datasetClause )* ( whereClause )? solutionModifier
			{
			DESCRIBE161=(Token)match(input,DESCRIBE,FOLLOW_DESCRIBE_in_describeQuery2045);  
			stream_DESCRIBE.add(DESCRIBE161);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:16: ( (v+= varOrIRIref )+ | ASTERISK )
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==IRI_REF||(LA45_0 >= PNAME_LN && LA45_0 <= PNAME_NS)||(LA45_0 >= VAR1 && LA45_0 <= VAR3)) ) {
				alt45=1;
			}
			else if ( (LA45_0==ASTERISK) ) {
				alt45=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 45, 0, input);
				throw nvae;
			}

			switch (alt45) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:18: (v+= varOrIRIref )+
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:18: (v+= varOrIRIref )+
					int cnt44=0;
					loop44:
					while (true) {
						int alt44=2;
						int LA44_0 = input.LA(1);
						if ( (LA44_0==IRI_REF||(LA44_0 >= PNAME_LN && LA44_0 <= PNAME_NS)||(LA44_0 >= VAR1 && LA44_0 <= VAR3)) ) {
							alt44=1;
						}

						switch (alt44) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:19: v+= varOrIRIref
							{
							pushFollow(FOLLOW_varOrIRIref_in_describeQuery2052);
							v=varOrIRIref();
							state._fsp--;

							stream_varOrIRIref.add(v.getTree());
							if (list_v==null) list_v=new ArrayList<Object>();
							list_v.add(v.getTree());
							}
							break;

						default :
							if ( cnt44 >= 1 ) break loop44;
							EarlyExitException eee = new EarlyExitException(44, input);
							throw eee;
						}
						cnt44++;
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:38: ASTERISK
					{
					ASTERISK162=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_describeQuery2058);  
					stream_ASTERISK.add(ASTERISK162);

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:49: ( datasetClause )*
			loop46:
			while (true) {
				int alt46=2;
				int LA46_0 = input.LA(1);
				if ( (LA46_0==FROM) ) {
					alt46=1;
				}

				switch (alt46) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:49: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_describeQuery2062);
					datasetClause163=datasetClause();
					state._fsp--;

					stream_datasetClause.add(datasetClause163.getTree());
					}
					break;

				default :
					break loop46;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:64: ( whereClause )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==OPEN_CURLY_BRACE||LA47_0==WHERE) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:64: whereClause
					{
					pushFollow(FOLLOW_whereClause_in_describeQuery2065);
					whereClause164=whereClause();
					state._fsp--;

					stream_whereClause.add(whereClause164.getTree());
					}
					break;

			}

			pushFollow(FOLLOW_solutionModifier_in_describeQuery2068);
			solutionModifier165=solutionModifier();
			state._fsp--;

			stream_solutionModifier.add(solutionModifier165.getTree());
			// AST REWRITE
			// elements: v, solutionModifier, ASTERISK, datasetClause, whereClause, DESCRIBE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: v
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"token v",list_v);
			root_0 = (CommonTree)adaptor.nil();
			// 422:94: -> ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:97: ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_DESCRIBE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:109: ( $v)*
				while ( stream_v.hasNext() ) {
					adaptor.addChild(root_1, stream_v.nextTree());
				}
				stream_v.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:112: ( ASTERISK )*
				while ( stream_ASTERISK.hasNext() ) {
					adaptor.addChild(root_1, stream_ASTERISK.nextNode());
				}
				stream_ASTERISK.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:122: ( datasetClause )*
				while ( stream_datasetClause.hasNext() ) {
					adaptor.addChild(root_1, stream_datasetClause.nextTree());
				}
				stream_datasetClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:137: ( whereClause )?
				if ( stream_whereClause.hasNext() ) {
					adaptor.addChild(root_1, stream_whereClause.nextTree());
				}
				stream_whereClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:422:150: ( solutionModifier )*
				while ( stream_solutionModifier.hasNext() ) {
					adaptor.addChild(root_1, stream_solutionModifier.nextTree());
				}
				stream_solutionModifier.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "describeQuery"


	public static class askQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "askQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:1: askQuery : ASK ( datasetClause )* whereClause -> ^( ASK ( datasetClause )* whereClause ) ;
	public final SparqlifyConfigParser.askQuery_return askQuery() throws RecognitionException {
		SparqlifyConfigParser.askQuery_return retval = new SparqlifyConfigParser.askQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASK166=null;
		ParserRuleReturnScope datasetClause167 =null;
		ParserRuleReturnScope whereClause168 =null;

		CommonTree ASK166_tree=null;
		RewriteRuleTokenStream stream_ASK=new RewriteRuleTokenStream(adaptor,"token ASK");
		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:426:5: ( ASK ( datasetClause )* whereClause -> ^( ASK ( datasetClause )* whereClause ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:426:7: ASK ( datasetClause )* whereClause
			{
			ASK166=(Token)match(input,ASK,FOLLOW_ASK_in_askQuery2107);  
			stream_ASK.add(ASK166);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:426:11: ( datasetClause )*
			loop48:
			while (true) {
				int alt48=2;
				int LA48_0 = input.LA(1);
				if ( (LA48_0==FROM) ) {
					alt48=1;
				}

				switch (alt48) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:426:11: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_askQuery2109);
					datasetClause167=datasetClause();
					state._fsp--;

					stream_datasetClause.add(datasetClause167.getTree());
					}
					break;

				default :
					break loop48;
				}
			}

			pushFollow(FOLLOW_whereClause_in_askQuery2112);
			whereClause168=whereClause();
			state._fsp--;

			stream_whereClause.add(whereClause168.getTree());
			// AST REWRITE
			// elements: datasetClause, ASK, whereClause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 426:38: -> ^( ASK ( datasetClause )* whereClause )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:426:41: ^( ASK ( datasetClause )* whereClause )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_ASK.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:426:47: ( datasetClause )*
				while ( stream_datasetClause.hasNext() ) {
					adaptor.addChild(root_1, stream_datasetClause.nextTree());
				}
				stream_datasetClause.reset();

				adaptor.addChild(root_1, stream_whereClause.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "askQuery"


	public static class datasetClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "datasetClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:1: datasetClause : FROM ( NAMED )? iriRef -> ^( FROM ( NAMED )? iriRef ) ;
	public final SparqlifyConfigParser.datasetClause_return datasetClause() throws RecognitionException {
		SparqlifyConfigParser.datasetClause_return retval = new SparqlifyConfigParser.datasetClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token FROM169=null;
		Token NAMED170=null;
		ParserRuleReturnScope iriRef171 =null;

		CommonTree FROM169_tree=null;
		CommonTree NAMED170_tree=null;
		RewriteRuleTokenStream stream_FROM=new RewriteRuleTokenStream(adaptor,"token FROM");
		RewriteRuleTokenStream stream_NAMED=new RewriteRuleTokenStream(adaptor,"token NAMED");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:430:5: ( FROM ( NAMED )? iriRef -> ^( FROM ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:430:7: FROM ( NAMED )? iriRef
			{
			FROM169=(Token)match(input,FROM,FOLLOW_FROM_in_datasetClause2140);  
			stream_FROM.add(FROM169);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:430:12: ( NAMED )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==NAMED) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:430:12: NAMED
					{
					NAMED170=(Token)match(input,NAMED,FOLLOW_NAMED_in_datasetClause2142);  
					stream_NAMED.add(NAMED170);

					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_datasetClause2145);
			iriRef171=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef171.getTree());
			// AST REWRITE
			// elements: NAMED, iriRef, FROM
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 430:26: -> ^( FROM ( NAMED )? iriRef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:430:29: ^( FROM ( NAMED )? iriRef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_FROM.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:430:36: ( NAMED )?
				if ( stream_NAMED.hasNext() ) {
					adaptor.addChild(root_1, stream_NAMED.nextNode());
				}
				stream_NAMED.reset();

				adaptor.addChild(root_1, stream_iriRef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "datasetClause"


	public static class whereClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "whereClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:433:1: whereClause : ( WHERE )? groupGraphPattern -> ^( WHERE_CLAUSE groupGraphPattern ) ;
	public final SparqlifyConfigParser.whereClause_return whereClause() throws RecognitionException {
		SparqlifyConfigParser.whereClause_return retval = new SparqlifyConfigParser.whereClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WHERE172=null;
		ParserRuleReturnScope groupGraphPattern173 =null;

		CommonTree WHERE172_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:434:5: ( ( WHERE )? groupGraphPattern -> ^( WHERE_CLAUSE groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:434:7: ( WHERE )? groupGraphPattern
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:434:7: ( WHERE )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==WHERE) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:434:7: WHERE
					{
					WHERE172=(Token)match(input,WHERE,FOLLOW_WHERE_in_whereClause2173);  
					stream_WHERE.add(WHERE172);

					}
					break;

			}

			pushFollow(FOLLOW_groupGraphPattern_in_whereClause2176);
			groupGraphPattern173=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern173.getTree());
			// AST REWRITE
			// elements: groupGraphPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 434:32: -> ^( WHERE_CLAUSE groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:434:35: ^( WHERE_CLAUSE groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(WHERE_CLAUSE, "WHERE_CLAUSE"), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "whereClause"


	public static class solutionModifier_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "solutionModifier"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:437:1: solutionModifier : ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? -> ( groupClause )* ( havingClause )* ( orderClause )* ( limitOffsetClauses )* ;
	public final SparqlifyConfigParser.solutionModifier_return solutionModifier() throws RecognitionException {
		SparqlifyConfigParser.solutionModifier_return retval = new SparqlifyConfigParser.solutionModifier_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope groupClause174 =null;
		ParserRuleReturnScope havingClause175 =null;
		ParserRuleReturnScope orderClause176 =null;
		ParserRuleReturnScope limitOffsetClauses177 =null;

		RewriteRuleSubtreeStream stream_limitOffsetClauses=new RewriteRuleSubtreeStream(adaptor,"rule limitOffsetClauses");
		RewriteRuleSubtreeStream stream_orderClause=new RewriteRuleSubtreeStream(adaptor,"rule orderClause");
		RewriteRuleSubtreeStream stream_groupClause=new RewriteRuleSubtreeStream(adaptor,"rule groupClause");
		RewriteRuleSubtreeStream stream_havingClause=new RewriteRuleSubtreeStream(adaptor,"rule havingClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:5: ( ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? -> ( groupClause )* ( havingClause )* ( orderClause )* ( limitOffsetClauses )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:7: ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:7: ( groupClause )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==GROUP) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:7: groupClause
					{
					pushFollow(FOLLOW_groupClause_in_solutionModifier2201);
					groupClause174=groupClause();
					state._fsp--;

					stream_groupClause.add(groupClause174.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:20: ( havingClause )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==HAVING) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:20: havingClause
					{
					pushFollow(FOLLOW_havingClause_in_solutionModifier2204);
					havingClause175=havingClause();
					state._fsp--;

					stream_havingClause.add(havingClause175.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:34: ( orderClause )?
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==ORDER) ) {
				alt53=1;
			}
			switch (alt53) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:34: orderClause
					{
					pushFollow(FOLLOW_orderClause_in_solutionModifier2207);
					orderClause176=orderClause();
					state._fsp--;

					stream_orderClause.add(orderClause176.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:47: ( limitOffsetClauses )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==LIMIT||LA54_0==OFFSET) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:47: limitOffsetClauses
					{
					pushFollow(FOLLOW_limitOffsetClauses_in_solutionModifier2210);
					limitOffsetClauses177=limitOffsetClauses();
					state._fsp--;

					stream_limitOffsetClauses.add(limitOffsetClauses177.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: limitOffsetClauses, groupClause, havingClause, orderClause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 438:67: -> ( groupClause )* ( havingClause )* ( orderClause )* ( limitOffsetClauses )*
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:70: ( groupClause )*
				while ( stream_groupClause.hasNext() ) {
					adaptor.addChild(root_0, stream_groupClause.nextTree());
				}
				stream_groupClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:83: ( havingClause )*
				while ( stream_havingClause.hasNext() ) {
					adaptor.addChild(root_0, stream_havingClause.nextTree());
				}
				stream_havingClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:97: ( orderClause )*
				while ( stream_orderClause.hasNext() ) {
					adaptor.addChild(root_0, stream_orderClause.nextTree());
				}
				stream_orderClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:438:110: ( limitOffsetClauses )*
				while ( stream_limitOffsetClauses.hasNext() ) {
					adaptor.addChild(root_0, stream_limitOffsetClauses.nextTree());
				}
				stream_limitOffsetClauses.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "solutionModifier"


	public static class groupClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:441:1: groupClause : GROUP BY ( groupCondition )+ -> ^( GROUP_BY ( groupCondition )+ ) ;
	public final SparqlifyConfigParser.groupClause_return groupClause() throws RecognitionException {
		SparqlifyConfigParser.groupClause_return retval = new SparqlifyConfigParser.groupClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GROUP178=null;
		Token BY179=null;
		ParserRuleReturnScope groupCondition180 =null;

		CommonTree GROUP178_tree=null;
		CommonTree BY179_tree=null;
		RewriteRuleTokenStream stream_GROUP=new RewriteRuleTokenStream(adaptor,"token GROUP");
		RewriteRuleTokenStream stream_BY=new RewriteRuleTokenStream(adaptor,"token BY");
		RewriteRuleSubtreeStream stream_groupCondition=new RewriteRuleSubtreeStream(adaptor,"rule groupCondition");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:442:5: ( GROUP BY ( groupCondition )+ -> ^( GROUP_BY ( groupCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:442:7: GROUP BY ( groupCondition )+
			{
			GROUP178=(Token)match(input,GROUP,FOLLOW_GROUP_in_groupClause2242);  
			stream_GROUP.add(GROUP178);

			BY179=(Token)match(input,BY,FOLLOW_BY_in_groupClause2244);  
			stream_BY.add(BY179);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:442:16: ( groupCondition )+
			int cnt55=0;
			loop55:
			while (true) {
				int alt55=2;
				int LA55_0 = input.LA(1);
				if ( (LA55_0==ABS||(LA55_0 >= BNODE && LA55_0 <= BOUND)||LA55_0==CEIL||LA55_0==COALESCE||LA55_0==CONCAT||LA55_0==CONTAINS||(LA55_0 >= DATATYPE && LA55_0 <= DAY)||LA55_0==ENCODE_FOR_URI||LA55_0==EXISTS||LA55_0==FLOOR||(LA55_0 >= HOURS && LA55_0 <= IF)||(LA55_0 >= IRI && LA55_0 <= IRI_REF)||(LA55_0 >= ISBLANK && LA55_0 <= ISURI)||(LA55_0 >= LANG && LA55_0 <= LANGMATCHES)||LA55_0==LCASE||LA55_0==MD5||LA55_0==MINUTES||LA55_0==MONTH||LA55_0==NOT||LA55_0==NOW||LA55_0==OPEN_BRACE||(LA55_0 >= PNAME_LN && LA55_0 <= PNAME_NS)||LA55_0==RAND||LA55_0==REGEX||(LA55_0 >= ROUND && LA55_0 <= SAMETERM)||LA55_0==SECONDS||(LA55_0 >= SHA1 && LA55_0 <= SHA512)||(LA55_0 >= STR && LA55_0 <= STRENDS)||(LA55_0 >= STRLANG && LA55_0 <= STRSTARTS)||LA55_0==SUBSTR||LA55_0==TIMEZONE||(LA55_0 >= TZ && LA55_0 <= UCASE)||LA55_0==URI||(LA55_0 >= VAR1 && LA55_0 <= VAR3)||LA55_0==YEAR) ) {
					alt55=1;
				}

				switch (alt55) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:442:16: groupCondition
					{
					pushFollow(FOLLOW_groupCondition_in_groupClause2246);
					groupCondition180=groupCondition();
					state._fsp--;

					stream_groupCondition.add(groupCondition180.getTree());
					}
					break;

				default :
					if ( cnt55 >= 1 ) break loop55;
					EarlyExitException eee = new EarlyExitException(55, input);
					throw eee;
				}
				cnt55++;
			}

			// AST REWRITE
			// elements: groupCondition
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 442:32: -> ^( GROUP_BY ( groupCondition )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:442:35: ^( GROUP_BY ( groupCondition )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(GROUP_BY, "GROUP_BY"), root_1);
				if ( !(stream_groupCondition.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_groupCondition.hasNext() ) {
					adaptor.addChild(root_1, stream_groupCondition.nextTree());
				}
				stream_groupCondition.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupClause"


	public static class groupCondition_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:1: groupCondition : ( builtInCall | functionCall | OPEN_BRACE expression ( AS var )? CLOSE_BRACE -> ^( AS expression ( var )* ) | var );
	public final SparqlifyConfigParser.groupCondition_return groupCondition() throws RecognitionException {
		SparqlifyConfigParser.groupCondition_return retval = new SparqlifyConfigParser.groupCondition_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE183=null;
		Token AS185=null;
		Token CLOSE_BRACE187=null;
		ParserRuleReturnScope builtInCall181 =null;
		ParserRuleReturnScope functionCall182 =null;
		ParserRuleReturnScope expression184 =null;
		ParserRuleReturnScope var186 =null;
		ParserRuleReturnScope var188 =null;

		CommonTree OPEN_BRACE183_tree=null;
		CommonTree AS185_tree=null;
		CommonTree CLOSE_BRACE187_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:446:5: ( builtInCall | functionCall | OPEN_BRACE expression ( AS var )? CLOSE_BRACE -> ^( AS expression ( var )* ) | var )
			int alt57=4;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt57=1;
				}
				break;
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt57=2;
				}
				break;
			case OPEN_BRACE:
				{
				alt57=3;
				}
				break;
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt57=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 57, 0, input);
				throw nvae;
			}
			switch (alt57) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:446:7: builtInCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_builtInCall_in_groupCondition2280);
					builtInCall181=builtInCall();
					state._fsp--;

					adaptor.addChild(root_0, builtInCall181.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:447:7: functionCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_functionCall_in_groupCondition2288);
					functionCall182=functionCall();
					state._fsp--;

					adaptor.addChild(root_0, functionCall182.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:448:7: OPEN_BRACE expression ( AS var )? CLOSE_BRACE
					{
					OPEN_BRACE183=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_groupCondition2296);  
					stream_OPEN_BRACE.add(OPEN_BRACE183);

					pushFollow(FOLLOW_expression_in_groupCondition2298);
					expression184=expression();
					state._fsp--;

					stream_expression.add(expression184.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:448:29: ( AS var )?
					int alt56=2;
					int LA56_0 = input.LA(1);
					if ( (LA56_0==AS) ) {
						alt56=1;
					}
					switch (alt56) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:448:30: AS var
							{
							AS185=(Token)match(input,AS,FOLLOW_AS_in_groupCondition2301);  
							stream_AS.add(AS185);

							pushFollow(FOLLOW_var_in_groupCondition2303);
							var186=var();
							state._fsp--;

							stream_var.add(var186.getTree());
							}
							break;

					}

					CLOSE_BRACE187=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_groupCondition2307);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE187);

					// AST REWRITE
					// elements: expression, AS, var
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 448:51: -> ^( AS expression ( var )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:448:54: ^( AS expression ( var )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:448:70: ( var )*
						while ( stream_var.hasNext() ) {
							adaptor.addChild(root_1, stream_var.nextTree());
						}
						stream_var.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:449:7: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_groupCondition2326);
					var188=var();
					state._fsp--;

					adaptor.addChild(root_0, var188.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupCondition"


	public static class havingClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "havingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:452:1: havingClause : HAVING ( constraint )+ -> ^( HAVING ( constraint )+ ) ;
	public final SparqlifyConfigParser.havingClause_return havingClause() throws RecognitionException {
		SparqlifyConfigParser.havingClause_return retval = new SparqlifyConfigParser.havingClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token HAVING189=null;
		ParserRuleReturnScope constraint190 =null;

		CommonTree HAVING189_tree=null;
		RewriteRuleTokenStream stream_HAVING=new RewriteRuleTokenStream(adaptor,"token HAVING");
		RewriteRuleSubtreeStream stream_constraint=new RewriteRuleSubtreeStream(adaptor,"rule constraint");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:453:5: ( HAVING ( constraint )+ -> ^( HAVING ( constraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:453:7: HAVING ( constraint )+
			{
			HAVING189=(Token)match(input,HAVING,FOLLOW_HAVING_in_havingClause2347);  
			stream_HAVING.add(HAVING189);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:453:14: ( constraint )+
			int cnt58=0;
			loop58:
			while (true) {
				int alt58=2;
				int LA58_0 = input.LA(1);
				if ( (LA58_0==ABS||(LA58_0 >= BNODE && LA58_0 <= BOUND)||LA58_0==CEIL||LA58_0==COALESCE||LA58_0==CONCAT||LA58_0==CONTAINS||(LA58_0 >= DATATYPE && LA58_0 <= DAY)||LA58_0==ENCODE_FOR_URI||LA58_0==EXISTS||LA58_0==FLOOR||(LA58_0 >= HOURS && LA58_0 <= IF)||(LA58_0 >= IRI && LA58_0 <= IRI_REF)||(LA58_0 >= ISBLANK && LA58_0 <= ISURI)||(LA58_0 >= LANG && LA58_0 <= LANGMATCHES)||LA58_0==LCASE||LA58_0==MD5||LA58_0==MINUTES||LA58_0==MONTH||LA58_0==NOT||LA58_0==NOW||LA58_0==OPEN_BRACE||(LA58_0 >= PNAME_LN && LA58_0 <= PNAME_NS)||LA58_0==RAND||LA58_0==REGEX||(LA58_0 >= ROUND && LA58_0 <= SAMETERM)||LA58_0==SECONDS||(LA58_0 >= SHA1 && LA58_0 <= SHA512)||(LA58_0 >= STR && LA58_0 <= STRENDS)||(LA58_0 >= STRLANG && LA58_0 <= STRSTARTS)||LA58_0==SUBSTR||LA58_0==TIMEZONE||(LA58_0 >= TZ && LA58_0 <= UCASE)||LA58_0==URI||LA58_0==YEAR) ) {
					alt58=1;
				}

				switch (alt58) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:453:14: constraint
					{
					pushFollow(FOLLOW_constraint_in_havingClause2349);
					constraint190=constraint();
					state._fsp--;

					stream_constraint.add(constraint190.getTree());
					}
					break;

				default :
					if ( cnt58 >= 1 ) break loop58;
					EarlyExitException eee = new EarlyExitException(58, input);
					throw eee;
				}
				cnt58++;
			}

			// AST REWRITE
			// elements: constraint, HAVING
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 453:26: -> ^( HAVING ( constraint )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:453:29: ^( HAVING ( constraint )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_HAVING.nextNode(), root_1);
				if ( !(stream_constraint.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_constraint.hasNext() ) {
					adaptor.addChild(root_1, stream_constraint.nextTree());
				}
				stream_constraint.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "havingClause"


	public static class orderClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "orderClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:456:1: orderClause : ORDER BY ( orderCondition )+ -> ^( ORDER_BY ( orderCondition )+ ) ;
	public final SparqlifyConfigParser.orderClause_return orderClause() throws RecognitionException {
		SparqlifyConfigParser.orderClause_return retval = new SparqlifyConfigParser.orderClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ORDER191=null;
		Token BY192=null;
		ParserRuleReturnScope orderCondition193 =null;

		CommonTree ORDER191_tree=null;
		CommonTree BY192_tree=null;
		RewriteRuleTokenStream stream_BY=new RewriteRuleTokenStream(adaptor,"token BY");
		RewriteRuleTokenStream stream_ORDER=new RewriteRuleTokenStream(adaptor,"token ORDER");
		RewriteRuleSubtreeStream stream_orderCondition=new RewriteRuleSubtreeStream(adaptor,"rule orderCondition");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:457:5: ( ORDER BY ( orderCondition )+ -> ^( ORDER_BY ( orderCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:457:7: ORDER BY ( orderCondition )+
			{
			ORDER191=(Token)match(input,ORDER,FOLLOW_ORDER_in_orderClause2381);  
			stream_ORDER.add(ORDER191);

			BY192=(Token)match(input,BY,FOLLOW_BY_in_orderClause2383);  
			stream_BY.add(BY192);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:457:16: ( orderCondition )+
			int cnt59=0;
			loop59:
			while (true) {
				int alt59=2;
				int LA59_0 = input.LA(1);
				if ( (LA59_0==ABS||LA59_0==ASC||(LA59_0 >= BNODE && LA59_0 <= BOUND)||LA59_0==CEIL||LA59_0==COALESCE||LA59_0==CONCAT||LA59_0==CONTAINS||(LA59_0 >= DATATYPE && LA59_0 <= DAY)||LA59_0==DESC||LA59_0==ENCODE_FOR_URI||LA59_0==EXISTS||LA59_0==FLOOR||(LA59_0 >= HOURS && LA59_0 <= IF)||(LA59_0 >= IRI && LA59_0 <= IRI_REF)||(LA59_0 >= ISBLANK && LA59_0 <= ISURI)||(LA59_0 >= LANG && LA59_0 <= LANGMATCHES)||LA59_0==LCASE||LA59_0==MD5||LA59_0==MINUTES||LA59_0==MONTH||LA59_0==NOT||LA59_0==NOW||LA59_0==OPEN_BRACE||(LA59_0 >= PNAME_LN && LA59_0 <= PNAME_NS)||LA59_0==RAND||LA59_0==REGEX||(LA59_0 >= ROUND && LA59_0 <= SAMETERM)||LA59_0==SECONDS||(LA59_0 >= SHA1 && LA59_0 <= SHA512)||(LA59_0 >= STR && LA59_0 <= STRENDS)||(LA59_0 >= STRLANG && LA59_0 <= STRSTARTS)||LA59_0==SUBSTR||LA59_0==TIMEZONE||(LA59_0 >= TZ && LA59_0 <= UCASE)||LA59_0==URI||(LA59_0 >= VAR1 && LA59_0 <= VAR3)||LA59_0==YEAR) ) {
					alt59=1;
				}

				switch (alt59) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:457:16: orderCondition
					{
					pushFollow(FOLLOW_orderCondition_in_orderClause2385);
					orderCondition193=orderCondition();
					state._fsp--;

					stream_orderCondition.add(orderCondition193.getTree());
					}
					break;

				default :
					if ( cnt59 >= 1 ) break loop59;
					EarlyExitException eee = new EarlyExitException(59, input);
					throw eee;
				}
				cnt59++;
			}

			// AST REWRITE
			// elements: orderCondition
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 457:32: -> ^( ORDER_BY ( orderCondition )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:457:35: ^( ORDER_BY ( orderCondition )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_BY, "ORDER_BY"), root_1);
				if ( !(stream_orderCondition.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_orderCondition.hasNext() ) {
					adaptor.addChild(root_1, stream_orderCondition.nextTree());
				}
				stream_orderCondition.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "orderClause"


	public static class orderCondition_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "orderCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:460:1: orderCondition : ( ASC brackettedExpression -> ^( ORDER_CONDITION ASC brackettedExpression ) | DESC brackettedExpression -> ^( ORDER_CONDITION DESC brackettedExpression ) | constraint -> ^( ORDER_CONDITION constraint ) | var -> ^( ORDER_CONDITION var ) );
	public final SparqlifyConfigParser.orderCondition_return orderCondition() throws RecognitionException {
		SparqlifyConfigParser.orderCondition_return retval = new SparqlifyConfigParser.orderCondition_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASC194=null;
		Token DESC196=null;
		ParserRuleReturnScope brackettedExpression195 =null;
		ParserRuleReturnScope brackettedExpression197 =null;
		ParserRuleReturnScope constraint198 =null;
		ParserRuleReturnScope var199 =null;

		CommonTree ASC194_tree=null;
		CommonTree DESC196_tree=null;
		RewriteRuleTokenStream stream_DESC=new RewriteRuleTokenStream(adaptor,"token DESC");
		RewriteRuleTokenStream stream_ASC=new RewriteRuleTokenStream(adaptor,"token ASC");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_constraint=new RewriteRuleSubtreeStream(adaptor,"rule constraint");
		RewriteRuleSubtreeStream stream_brackettedExpression=new RewriteRuleSubtreeStream(adaptor,"rule brackettedExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:461:5: ( ASC brackettedExpression -> ^( ORDER_CONDITION ASC brackettedExpression ) | DESC brackettedExpression -> ^( ORDER_CONDITION DESC brackettedExpression ) | constraint -> ^( ORDER_CONDITION constraint ) | var -> ^( ORDER_CONDITION var ) )
			int alt60=4;
			switch ( input.LA(1) ) {
			case ASC:
				{
				alt60=1;
				}
				break;
			case DESC:
				{
				alt60=2;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case IRI_REF:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case OPEN_BRACE:
			case PNAME_LN:
			case PNAME_NS:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt60=3;
				}
				break;
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt60=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 60, 0, input);
				throw nvae;
			}
			switch (alt60) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:461:7: ASC brackettedExpression
					{
					ASC194=(Token)match(input,ASC,FOLLOW_ASC_in_orderCondition2412);  
					stream_ASC.add(ASC194);

					pushFollow(FOLLOW_brackettedExpression_in_orderCondition2414);
					brackettedExpression195=brackettedExpression();
					state._fsp--;

					stream_brackettedExpression.add(brackettedExpression195.getTree());
					// AST REWRITE
					// elements: brackettedExpression, ASC
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 461:32: -> ^( ORDER_CONDITION ASC brackettedExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:461:35: ^( ORDER_CONDITION ASC brackettedExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_ASC.nextNode());
						adaptor.addChild(root_1, stream_brackettedExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:462:7: DESC brackettedExpression
					{
					DESC196=(Token)match(input,DESC,FOLLOW_DESC_in_orderCondition2432);  
					stream_DESC.add(DESC196);

					pushFollow(FOLLOW_brackettedExpression_in_orderCondition2434);
					brackettedExpression197=brackettedExpression();
					state._fsp--;

					stream_brackettedExpression.add(brackettedExpression197.getTree());
					// AST REWRITE
					// elements: brackettedExpression, DESC
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 462:33: -> ^( ORDER_CONDITION DESC brackettedExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:462:36: ^( ORDER_CONDITION DESC brackettedExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_DESC.nextNode());
						adaptor.addChild(root_1, stream_brackettedExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:463:7: constraint
					{
					pushFollow(FOLLOW_constraint_in_orderCondition2452);
					constraint198=constraint();
					state._fsp--;

					stream_constraint.add(constraint198.getTree());
					// AST REWRITE
					// elements: constraint
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 463:18: -> ^( ORDER_CONDITION constraint )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:463:21: ^( ORDER_CONDITION constraint )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_constraint.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:464:7: var
					{
					pushFollow(FOLLOW_var_in_orderCondition2468);
					var199=var();
					state._fsp--;

					stream_var.add(var199.getTree());
					// AST REWRITE
					// elements: var
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 464:11: -> ^( ORDER_CONDITION var )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:464:14: ^( ORDER_CONDITION var )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_var.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "orderCondition"


	public static class limitOffsetClauses_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "limitOffsetClauses"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:467:1: limitOffsetClauses : ( limitClause ( offsetClause )? -> limitClause ( offsetClause )* | offsetClause ( limitClause )? -> offsetClause ( limitClause )* );
	public final SparqlifyConfigParser.limitOffsetClauses_return limitOffsetClauses() throws RecognitionException {
		SparqlifyConfigParser.limitOffsetClauses_return retval = new SparqlifyConfigParser.limitOffsetClauses_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope limitClause200 =null;
		ParserRuleReturnScope offsetClause201 =null;
		ParserRuleReturnScope offsetClause202 =null;
		ParserRuleReturnScope limitClause203 =null;

		RewriteRuleSubtreeStream stream_offsetClause=new RewriteRuleSubtreeStream(adaptor,"rule offsetClause");
		RewriteRuleSubtreeStream stream_limitClause=new RewriteRuleSubtreeStream(adaptor,"rule limitClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:5: ( limitClause ( offsetClause )? -> limitClause ( offsetClause )* | offsetClause ( limitClause )? -> offsetClause ( limitClause )* )
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==LIMIT) ) {
				alt63=1;
			}
			else if ( (LA63_0==OFFSET) ) {
				alt63=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 63, 0, input);
				throw nvae;
			}

			switch (alt63) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:7: limitClause ( offsetClause )?
					{
					pushFollow(FOLLOW_limitClause_in_limitOffsetClauses2498);
					limitClause200=limitClause();
					state._fsp--;

					stream_limitClause.add(limitClause200.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:19: ( offsetClause )?
					int alt61=2;
					int LA61_0 = input.LA(1);
					if ( (LA61_0==OFFSET) ) {
						alt61=1;
					}
					switch (alt61) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:19: offsetClause
							{
							pushFollow(FOLLOW_offsetClause_in_limitOffsetClauses2500);
							offsetClause201=offsetClause();
							state._fsp--;

							stream_offsetClause.add(offsetClause201.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: limitClause, offsetClause
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 468:33: -> limitClause ( offsetClause )*
					{
						adaptor.addChild(root_0, stream_limitClause.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:48: ( offsetClause )*
						while ( stream_offsetClause.hasNext() ) {
							adaptor.addChild(root_0, stream_offsetClause.nextTree());
						}
						stream_offsetClause.reset();

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:469:7: offsetClause ( limitClause )?
					{
					pushFollow(FOLLOW_offsetClause_in_limitOffsetClauses2516);
					offsetClause202=offsetClause();
					state._fsp--;

					stream_offsetClause.add(offsetClause202.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:469:20: ( limitClause )?
					int alt62=2;
					int LA62_0 = input.LA(1);
					if ( (LA62_0==LIMIT) ) {
						alt62=1;
					}
					switch (alt62) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:469:20: limitClause
							{
							pushFollow(FOLLOW_limitClause_in_limitOffsetClauses2518);
							limitClause203=limitClause();
							state._fsp--;

							stream_limitClause.add(limitClause203.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: offsetClause, limitClause
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 469:33: -> offsetClause ( limitClause )*
					{
						adaptor.addChild(root_0, stream_offsetClause.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:469:49: ( limitClause )*
						while ( stream_limitClause.hasNext() ) {
							adaptor.addChild(root_0, stream_limitClause.nextTree());
						}
						stream_limitClause.reset();

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "limitOffsetClauses"


	public static class limitClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "limitClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:472:1: limitClause : LIMIT INTEGER -> ^( LIMIT INTEGER ) ;
	public final SparqlifyConfigParser.limitClause_return limitClause() throws RecognitionException {
		SparqlifyConfigParser.limitClause_return retval = new SparqlifyConfigParser.limitClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token LIMIT204=null;
		Token INTEGER205=null;

		CommonTree LIMIT204_tree=null;
		CommonTree INTEGER205_tree=null;
		RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");
		RewriteRuleTokenStream stream_LIMIT=new RewriteRuleTokenStream(adaptor,"token LIMIT");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:473:5: ( LIMIT INTEGER -> ^( LIMIT INTEGER ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:473:7: LIMIT INTEGER
			{
			LIMIT204=(Token)match(input,LIMIT,FOLLOW_LIMIT_in_limitClause2543);  
			stream_LIMIT.add(LIMIT204);

			INTEGER205=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_limitClause2545);  
			stream_INTEGER.add(INTEGER205);

			// AST REWRITE
			// elements: INTEGER, LIMIT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 473:21: -> ^( LIMIT INTEGER )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:473:24: ^( LIMIT INTEGER )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_LIMIT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_INTEGER.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "limitClause"


	public static class offsetClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "offsetClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:476:1: offsetClause : OFFSET INTEGER -> ^( OFFSET INTEGER ) ;
	public final SparqlifyConfigParser.offsetClause_return offsetClause() throws RecognitionException {
		SparqlifyConfigParser.offsetClause_return retval = new SparqlifyConfigParser.offsetClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OFFSET206=null;
		Token INTEGER207=null;

		CommonTree OFFSET206_tree=null;
		CommonTree INTEGER207_tree=null;
		RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");
		RewriteRuleTokenStream stream_OFFSET=new RewriteRuleTokenStream(adaptor,"token OFFSET");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:477:5: ( OFFSET INTEGER -> ^( OFFSET INTEGER ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:477:7: OFFSET INTEGER
			{
			OFFSET206=(Token)match(input,OFFSET,FOLLOW_OFFSET_in_offsetClause2570);  
			stream_OFFSET.add(OFFSET206);

			INTEGER207=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_offsetClause2572);  
			stream_INTEGER.add(INTEGER207);

			// AST REWRITE
			// elements: OFFSET, INTEGER
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 477:22: -> ^( OFFSET INTEGER )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:477:25: ^( OFFSET INTEGER )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_OFFSET.nextNode(), root_1);
				adaptor.addChild(root_1, stream_INTEGER.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "offsetClause"


	public static class bindingsClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bindingsClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:480:1: bindingsClause : ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )? -> ( ^( BINDINGS ( var )* ( bindingValueList )* ) )? ;
	public final SparqlifyConfigParser.bindingsClause_return bindingsClause() throws RecognitionException {
		SparqlifyConfigParser.bindingsClause_return retval = new SparqlifyConfigParser.bindingsClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BINDINGS208=null;
		Token OPEN_CURLY_BRACE210=null;
		Token CLOSE_CURLY_BRACE212=null;
		ParserRuleReturnScope var209 =null;
		ParserRuleReturnScope bindingValueList211 =null;

		CommonTree BINDINGS208_tree=null;
		CommonTree OPEN_CURLY_BRACE210_tree=null;
		CommonTree CLOSE_CURLY_BRACE212_tree=null;
		RewriteRuleTokenStream stream_BINDINGS=new RewriteRuleTokenStream(adaptor,"token BINDINGS");
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_bindingValueList=new RewriteRuleSubtreeStream(adaptor,"rule bindingValueList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:5: ( ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )? -> ( ^( BINDINGS ( var )* ( bindingValueList )* ) )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:7: ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:7: ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )?
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==BINDINGS) ) {
				alt66=1;
			}
			switch (alt66) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:8: BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE
					{
					BINDINGS208=(Token)match(input,BINDINGS,FOLLOW_BINDINGS_in_bindingsClause2598);  
					stream_BINDINGS.add(BINDINGS208);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:17: ( var )*
					loop64:
					while (true) {
						int alt64=2;
						int LA64_0 = input.LA(1);
						if ( ((LA64_0 >= VAR1 && LA64_0 <= VAR3)) ) {
							alt64=1;
						}

						switch (alt64) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:17: var
							{
							pushFollow(FOLLOW_var_in_bindingsClause2600);
							var209=var();
							state._fsp--;

							stream_var.add(var209.getTree());
							}
							break;

						default :
							break loop64;
						}
					}

					OPEN_CURLY_BRACE210=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_bindingsClause2603);  
					stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE210);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:39: ( bindingValueList )*
					loop65:
					while (true) {
						int alt65=2;
						int LA65_0 = input.LA(1);
						if ( (LA65_0==OPEN_BRACE) ) {
							alt65=1;
						}

						switch (alt65) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:39: bindingValueList
							{
							pushFollow(FOLLOW_bindingValueList_in_bindingsClause2605);
							bindingValueList211=bindingValueList();
							state._fsp--;

							stream_bindingValueList.add(bindingValueList211.getTree());
							}
							break;

						default :
							break loop65;
						}
					}

					CLOSE_CURLY_BRACE212=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_bindingsClause2608);  
					stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE212);

					}
					break;

			}

			// AST REWRITE
			// elements: BINDINGS, bindingValueList, var
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 481:77: -> ( ^( BINDINGS ( var )* ( bindingValueList )* ) )?
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:80: ( ^( BINDINGS ( var )* ( bindingValueList )* ) )?
				if ( stream_BINDINGS.hasNext()||stream_bindingValueList.hasNext()||stream_var.hasNext() ) {
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:80: ^( BINDINGS ( var )* ( bindingValueList )* )
					{
					CommonTree root_1 = (CommonTree)adaptor.nil();
					root_1 = (CommonTree)adaptor.becomeRoot(stream_BINDINGS.nextNode(), root_1);
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:91: ( var )*
					while ( stream_var.hasNext() ) {
						adaptor.addChild(root_1, stream_var.nextTree());
					}
					stream_var.reset();

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:481:96: ( bindingValueList )*
					while ( stream_bindingValueList.hasNext() ) {
						adaptor.addChild(root_1, stream_bindingValueList.nextTree());
					}
					stream_bindingValueList.reset();

					adaptor.addChild(root_0, root_1);
					}

				}
				stream_BINDINGS.reset();
				stream_bindingValueList.reset();
				stream_var.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bindingsClause"


	public static class bindingValueList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bindingValueList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:484:1: bindingValueList : OPEN_BRACE ( bindingValue )* CLOSE_BRACE -> ^( BINDING_VALUE ( bindingValue )* ) ;
	public final SparqlifyConfigParser.bindingValueList_return bindingValueList() throws RecognitionException {
		SparqlifyConfigParser.bindingValueList_return retval = new SparqlifyConfigParser.bindingValueList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE213=null;
		Token CLOSE_BRACE215=null;
		ParserRuleReturnScope bindingValue214 =null;

		CommonTree OPEN_BRACE213_tree=null;
		CommonTree CLOSE_BRACE215_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_bindingValue=new RewriteRuleSubtreeStream(adaptor,"rule bindingValue");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:485:5: ( OPEN_BRACE ( bindingValue )* CLOSE_BRACE -> ^( BINDING_VALUE ( bindingValue )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:485:7: OPEN_BRACE ( bindingValue )* CLOSE_BRACE
			{
			OPEN_BRACE213=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_bindingValueList2644);  
			stream_OPEN_BRACE.add(OPEN_BRACE213);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:485:18: ( bindingValue )*
			loop67:
			while (true) {
				int alt67=2;
				int LA67_0 = input.LA(1);
				if ( ((LA67_0 >= DECIMAL && LA67_0 <= DECIMAL_POSITIVE)||(LA67_0 >= DOUBLE && LA67_0 <= DOUBLE_POSITIVE)||LA67_0==FALSE||(LA67_0 >= INTEGER && LA67_0 <= INTEGER_POSITIVE)||LA67_0==IRI_REF||(LA67_0 >= PNAME_LN && LA67_0 <= PNAME_NS)||(LA67_0 >= STRING_LITERAL1 && LA67_0 <= STRING_LITERAL_LONG2)||LA67_0==TRUE||LA67_0==UNDEF) ) {
					alt67=1;
				}

				switch (alt67) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:485:18: bindingValue
					{
					pushFollow(FOLLOW_bindingValue_in_bindingValueList2646);
					bindingValue214=bindingValue();
					state._fsp--;

					stream_bindingValue.add(bindingValue214.getTree());
					}
					break;

				default :
					break loop67;
				}
			}

			CLOSE_BRACE215=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_bindingValueList2649);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE215);

			// AST REWRITE
			// elements: bindingValue
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 485:44: -> ^( BINDING_VALUE ( bindingValue )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:485:47: ^( BINDING_VALUE ( bindingValue )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(BINDING_VALUE, "BINDING_VALUE"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:485:63: ( bindingValue )*
				while ( stream_bindingValue.hasNext() ) {
					adaptor.addChild(root_1, stream_bindingValue.nextTree());
				}
				stream_bindingValue.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bindingValueList"


	public static class bindingValue_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bindingValue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:1: bindingValue : ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | UNDEF );
	public final SparqlifyConfigParser.bindingValue_return bindingValue() throws RecognitionException {
		SparqlifyConfigParser.bindingValue_return retval = new SparqlifyConfigParser.bindingValue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token UNDEF220=null;
		ParserRuleReturnScope iriRef216 =null;
		ParserRuleReturnScope rdfLiteral217 =null;
		ParserRuleReturnScope numericLiteral218 =null;
		ParserRuleReturnScope booleanLiteral219 =null;

		CommonTree UNDEF220_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:489:5: ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | UNDEF )
			int alt68=5;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt68=1;
				}
				break;
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
				{
				alt68=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt68=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt68=4;
				}
				break;
			case UNDEF:
				{
				alt68=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 68, 0, input);
				throw nvae;
			}
			switch (alt68) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:489:7: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_bindingValue2680);
					iriRef216=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef216.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:489:16: rdfLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_rdfLiteral_in_bindingValue2684);
					rdfLiteral217=rdfLiteral();
					state._fsp--;

					adaptor.addChild(root_0, rdfLiteral217.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:489:29: numericLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteral_in_bindingValue2688);
					numericLiteral218=numericLiteral();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteral218.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:489:46: booleanLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_booleanLiteral_in_bindingValue2692);
					booleanLiteral219=booleanLiteral();
					state._fsp--;

					adaptor.addChild(root_0, booleanLiteral219.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:489:63: UNDEF
					{
					root_0 = (CommonTree)adaptor.nil();


					UNDEF220=(Token)match(input,UNDEF,FOLLOW_UNDEF_in_bindingValue2696); 
					UNDEF220_tree = (CommonTree)adaptor.create(UNDEF220);
					adaptor.addChild(root_0, UNDEF220_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bindingValue"


	public static class update_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "update"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:492:1: update : prologue ( load | clear | drop | add | move | copy | create | insert | delete | modify ) -> prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* ;
	public final SparqlifyConfigParser.update_return update() throws RecognitionException {
		SparqlifyConfigParser.update_return retval = new SparqlifyConfigParser.update_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope prologue221 =null;
		ParserRuleReturnScope load222 =null;
		ParserRuleReturnScope clear223 =null;
		ParserRuleReturnScope drop224 =null;
		ParserRuleReturnScope add225 =null;
		ParserRuleReturnScope move226 =null;
		ParserRuleReturnScope copy227 =null;
		ParserRuleReturnScope create228 =null;
		ParserRuleReturnScope insert229 =null;
		ParserRuleReturnScope delete230 =null;
		ParserRuleReturnScope modify231 =null;

		RewriteRuleSubtreeStream stream_clear=new RewriteRuleSubtreeStream(adaptor,"rule clear");
		RewriteRuleSubtreeStream stream_prologue=new RewriteRuleSubtreeStream(adaptor,"rule prologue");
		RewriteRuleSubtreeStream stream_drop=new RewriteRuleSubtreeStream(adaptor,"rule drop");
		RewriteRuleSubtreeStream stream_delete=new RewriteRuleSubtreeStream(adaptor,"rule delete");
		RewriteRuleSubtreeStream stream_modify=new RewriteRuleSubtreeStream(adaptor,"rule modify");
		RewriteRuleSubtreeStream stream_load=new RewriteRuleSubtreeStream(adaptor,"rule load");
		RewriteRuleSubtreeStream stream_add=new RewriteRuleSubtreeStream(adaptor,"rule add");
		RewriteRuleSubtreeStream stream_insert=new RewriteRuleSubtreeStream(adaptor,"rule insert");
		RewriteRuleSubtreeStream stream_create=new RewriteRuleSubtreeStream(adaptor,"rule create");
		RewriteRuleSubtreeStream stream_move=new RewriteRuleSubtreeStream(adaptor,"rule move");
		RewriteRuleSubtreeStream stream_copy=new RewriteRuleSubtreeStream(adaptor,"rule copy");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:5: ( prologue ( load | clear | drop | add | move | copy | create | insert | delete | modify ) -> prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:7: prologue ( load | clear | drop | add | move | copy | create | insert | delete | modify )
			{
			pushFollow(FOLLOW_prologue_in_update2717);
			prologue221=prologue();
			state._fsp--;

			stream_prologue.add(prologue221.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:16: ( load | clear | drop | add | move | copy | create | insert | delete | modify )
			int alt69=10;
			switch ( input.LA(1) ) {
			case LOAD:
				{
				alt69=1;
				}
				break;
			case CLEAR:
				{
				alt69=2;
				}
				break;
			case DROP:
				{
				alt69=3;
				}
				break;
			case ADD:
				{
				alt69=4;
				}
				break;
			case MOVE:
				{
				alt69=5;
				}
				break;
			case COPY:
				{
				alt69=6;
				}
				break;
			case CREATE:
				{
				alt69=7;
				}
				break;
			case INSERT:
				{
				int LA69_8 = input.LA(2);
				if ( (LA69_8==DATA) ) {
					alt69=8;
				}
				else if ( (LA69_8==OPEN_CURLY_BRACE) ) {
					alt69=10;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 69, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DELETE:
				{
				int LA69_9 = input.LA(2);
				if ( (LA69_9==DATA||LA69_9==WHERE) ) {
					alt69=9;
				}
				else if ( (LA69_9==OPEN_CURLY_BRACE) ) {
					alt69=10;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 69, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case WITH:
				{
				alt69=10;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 69, 0, input);
				throw nvae;
			}
			switch (alt69) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:17: load
					{
					pushFollow(FOLLOW_load_in_update2720);
					load222=load();
					state._fsp--;

					stream_load.add(load222.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:24: clear
					{
					pushFollow(FOLLOW_clear_in_update2724);
					clear223=clear();
					state._fsp--;

					stream_clear.add(clear223.getTree());
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:32: drop
					{
					pushFollow(FOLLOW_drop_in_update2728);
					drop224=drop();
					state._fsp--;

					stream_drop.add(drop224.getTree());
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:39: add
					{
					pushFollow(FOLLOW_add_in_update2732);
					add225=add();
					state._fsp--;

					stream_add.add(add225.getTree());
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:45: move
					{
					pushFollow(FOLLOW_move_in_update2736);
					move226=move();
					state._fsp--;

					stream_move.add(move226.getTree());
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:52: copy
					{
					pushFollow(FOLLOW_copy_in_update2740);
					copy227=copy();
					state._fsp--;

					stream_copy.add(copy227.getTree());
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:59: create
					{
					pushFollow(FOLLOW_create_in_update2744);
					create228=create();
					state._fsp--;

					stream_create.add(create228.getTree());
					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:68: insert
					{
					pushFollow(FOLLOW_insert_in_update2748);
					insert229=insert();
					state._fsp--;

					stream_insert.add(insert229.getTree());
					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:77: delete
					{
					pushFollow(FOLLOW_delete_in_update2752);
					delete230=delete();
					state._fsp--;

					stream_delete.add(delete230.getTree());
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:86: modify
					{
					pushFollow(FOLLOW_modify_in_update2756);
					modify231=modify();
					state._fsp--;

					stream_modify.add(modify231.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: insert, clear, prologue, move, add, drop, load, create, copy, modify, delete
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 493:94: -> prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )*
			{
				adaptor.addChild(root_0, stream_prologue.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:106: ( load )*
				while ( stream_load.hasNext() ) {
					adaptor.addChild(root_0, stream_load.nextTree());
				}
				stream_load.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:112: ( clear )*
				while ( stream_clear.hasNext() ) {
					adaptor.addChild(root_0, stream_clear.nextTree());
				}
				stream_clear.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:119: ( drop )*
				while ( stream_drop.hasNext() ) {
					adaptor.addChild(root_0, stream_drop.nextTree());
				}
				stream_drop.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:125: ( add )*
				while ( stream_add.hasNext() ) {
					adaptor.addChild(root_0, stream_add.nextTree());
				}
				stream_add.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:130: ( move )*
				while ( stream_move.hasNext() ) {
					adaptor.addChild(root_0, stream_move.nextTree());
				}
				stream_move.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:136: ( copy )*
				while ( stream_copy.hasNext() ) {
					adaptor.addChild(root_0, stream_copy.nextTree());
				}
				stream_copy.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:142: ( create )*
				while ( stream_create.hasNext() ) {
					adaptor.addChild(root_0, stream_create.nextTree());
				}
				stream_create.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:150: ( insert )*
				while ( stream_insert.hasNext() ) {
					adaptor.addChild(root_0, stream_insert.nextTree());
				}
				stream_insert.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:158: ( delete )*
				while ( stream_delete.hasNext() ) {
					adaptor.addChild(root_0, stream_delete.nextTree());
				}
				stream_delete.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:493:166: ( modify )*
				while ( stream_modify.hasNext() ) {
					adaptor.addChild(root_0, stream_modify.nextTree());
				}
				stream_modify.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "update"


	public static class load_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "load"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:496:1: load : LOAD ( SILENT )? iriRef ( INTO graphRef )? -> ^( LOAD ( SILENT )* iriRef ( graphRef )* ) ;
	public final SparqlifyConfigParser.load_return load() throws RecognitionException {
		SparqlifyConfigParser.load_return retval = new SparqlifyConfigParser.load_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token LOAD232=null;
		Token SILENT233=null;
		Token INTO235=null;
		ParserRuleReturnScope iriRef234 =null;
		ParserRuleReturnScope graphRef236 =null;

		CommonTree LOAD232_tree=null;
		CommonTree SILENT233_tree=null;
		CommonTree INTO235_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_INTO=new RewriteRuleTokenStream(adaptor,"token INTO");
		RewriteRuleTokenStream stream_LOAD=new RewriteRuleTokenStream(adaptor,"token LOAD");
		RewriteRuleSubtreeStream stream_graphRef=new RewriteRuleSubtreeStream(adaptor,"rule graphRef");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:5: ( LOAD ( SILENT )? iriRef ( INTO graphRef )? -> ^( LOAD ( SILENT )* iriRef ( graphRef )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:7: LOAD ( SILENT )? iriRef ( INTO graphRef )?
			{
			LOAD232=(Token)match(input,LOAD,FOLLOW_LOAD_in_load2819);  
			stream_LOAD.add(LOAD232);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:12: ( SILENT )?
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==SILENT) ) {
				alt70=1;
			}
			switch (alt70) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:12: SILENT
					{
					SILENT233=(Token)match(input,SILENT,FOLLOW_SILENT_in_load2821);  
					stream_SILENT.add(SILENT233);

					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_load2824);
			iriRef234=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef234.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:27: ( INTO graphRef )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==INTO) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:29: INTO graphRef
					{
					INTO235=(Token)match(input,INTO,FOLLOW_INTO_in_load2828);  
					stream_INTO.add(INTO235);

					pushFollow(FOLLOW_graphRef_in_load2830);
					graphRef236=graphRef();
					state._fsp--;

					stream_graphRef.add(graphRef236.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: iriRef, SILENT, LOAD, graphRef
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 497:46: -> ^( LOAD ( SILENT )* iriRef ( graphRef )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:49: ^( LOAD ( SILENT )* iriRef ( graphRef )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_LOAD.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:56: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_iriRef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:497:71: ( graphRef )*
				while ( stream_graphRef.hasNext() ) {
					adaptor.addChild(root_1, stream_graphRef.nextTree());
				}
				stream_graphRef.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "load"


	public static class clear_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "clear"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:1: clear : CLEAR ( SILENT )? graphRefAll -> ^( CLEAR ( SILENT )* graphRefAll ) ;
	public final SparqlifyConfigParser.clear_return clear() throws RecognitionException {
		SparqlifyConfigParser.clear_return retval = new SparqlifyConfigParser.clear_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CLEAR237=null;
		Token SILENT238=null;
		ParserRuleReturnScope graphRefAll239 =null;

		CommonTree CLEAR237_tree=null;
		CommonTree SILENT238_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_CLEAR=new RewriteRuleTokenStream(adaptor,"token CLEAR");
		RewriteRuleSubtreeStream stream_graphRefAll=new RewriteRuleSubtreeStream(adaptor,"rule graphRefAll");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:501:5: ( CLEAR ( SILENT )? graphRefAll -> ^( CLEAR ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:501:7: CLEAR ( SILENT )? graphRefAll
			{
			CLEAR237=(Token)match(input,CLEAR,FOLLOW_CLEAR_in_clear2868);  
			stream_CLEAR.add(CLEAR237);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:501:14: ( SILENT )?
			int alt72=2;
			int LA72_0 = input.LA(1);
			if ( (LA72_0==SILENT) ) {
				alt72=1;
			}
			switch (alt72) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:501:14: SILENT
					{
					SILENT238=(Token)match(input,SILENT,FOLLOW_SILENT_in_clear2871);  
					stream_SILENT.add(SILENT238);

					}
					break;

			}

			pushFollow(FOLLOW_graphRefAll_in_clear2874);
			graphRefAll239=graphRefAll();
			state._fsp--;

			stream_graphRefAll.add(graphRefAll239.getTree());
			// AST REWRITE
			// elements: graphRefAll, SILENT, CLEAR
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 501:34: -> ^( CLEAR ( SILENT )* graphRefAll )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:501:37: ^( CLEAR ( SILENT )* graphRefAll )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_CLEAR.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:501:45: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_graphRefAll.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "clear"


	public static class drop_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "drop"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:1: drop : DROP ( SILENT )? graphRefAll -> ^( DROP ( SILENT )* graphRefAll ) ;
	public final SparqlifyConfigParser.drop_return drop() throws RecognitionException {
		SparqlifyConfigParser.drop_return retval = new SparqlifyConfigParser.drop_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DROP240=null;
		Token SILENT241=null;
		ParserRuleReturnScope graphRefAll242 =null;

		CommonTree DROP240_tree=null;
		CommonTree SILENT241_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_DROP=new RewriteRuleTokenStream(adaptor,"token DROP");
		RewriteRuleSubtreeStream stream_graphRefAll=new RewriteRuleSubtreeStream(adaptor,"rule graphRefAll");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:505:5: ( DROP ( SILENT )? graphRefAll -> ^( DROP ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:505:7: DROP ( SILENT )? graphRefAll
			{
			DROP240=(Token)match(input,DROP,FOLLOW_DROP_in_drop2906);  
			stream_DROP.add(DROP240);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:505:12: ( SILENT )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==SILENT) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:505:12: SILENT
					{
					SILENT241=(Token)match(input,SILENT,FOLLOW_SILENT_in_drop2908);  
					stream_SILENT.add(SILENT241);

					}
					break;

			}

			pushFollow(FOLLOW_graphRefAll_in_drop2911);
			graphRefAll242=graphRefAll();
			state._fsp--;

			stream_graphRefAll.add(graphRefAll242.getTree());
			// AST REWRITE
			// elements: SILENT, graphRefAll, DROP
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 505:32: -> ^( DROP ( SILENT )* graphRefAll )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:505:35: ^( DROP ( SILENT )* graphRefAll )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_DROP.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:505:42: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_graphRefAll.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "drop"


	public static class create_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "create"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:508:1: create : CREATE ( SILENT )? graphRef -> ^( CREATE ( SILENT )* graphRef ) ;
	public final SparqlifyConfigParser.create_return create() throws RecognitionException {
		SparqlifyConfigParser.create_return retval = new SparqlifyConfigParser.create_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE243=null;
		Token SILENT244=null;
		ParserRuleReturnScope graphRef245 =null;

		CommonTree CREATE243_tree=null;
		CommonTree SILENT244_tree=null;
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleSubtreeStream stream_graphRef=new RewriteRuleSubtreeStream(adaptor,"rule graphRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:509:5: ( CREATE ( SILENT )? graphRef -> ^( CREATE ( SILENT )* graphRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:509:7: CREATE ( SILENT )? graphRef
			{
			CREATE243=(Token)match(input,CREATE,FOLLOW_CREATE_in_create2940);  
			stream_CREATE.add(CREATE243);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:509:14: ( SILENT )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==SILENT) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:509:14: SILENT
					{
					SILENT244=(Token)match(input,SILENT,FOLLOW_SILENT_in_create2942);  
					stream_SILENT.add(SILENT244);

					}
					break;

			}

			pushFollow(FOLLOW_graphRef_in_create2945);
			graphRef245=graphRef();
			state._fsp--;

			stream_graphRef.add(graphRef245.getTree());
			// AST REWRITE
			// elements: SILENT, graphRef, CREATE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 509:31: -> ^( CREATE ( SILENT )* graphRef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:509:34: ^( CREATE ( SILENT )* graphRef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_CREATE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:509:43: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_graphRef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "create"


	public static class add_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "add"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:512:1: add : ADD ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( ADD ( SILENT )* $from $to) ;
	public final SparqlifyConfigParser.add_return add() throws RecognitionException {
		SparqlifyConfigParser.add_return retval = new SparqlifyConfigParser.add_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ADD246=null;
		Token SILENT247=null;
		Token TO248=null;
		ParserRuleReturnScope from =null;
		ParserRuleReturnScope to =null;

		CommonTree ADD246_tree=null;
		CommonTree SILENT247_tree=null;
		CommonTree TO248_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_TO=new RewriteRuleTokenStream(adaptor,"token TO");
		RewriteRuleTokenStream stream_ADD=new RewriteRuleTokenStream(adaptor,"token ADD");
		RewriteRuleSubtreeStream stream_graphOrDefault=new RewriteRuleSubtreeStream(adaptor,"rule graphOrDefault");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:513:5: ( ADD ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( ADD ( SILENT )* $from $to) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:513:7: ADD ( SILENT )? from= graphOrDefault TO to= graphOrDefault
			{
			ADD246=(Token)match(input,ADD,FOLLOW_ADD_in_add2977);  
			stream_ADD.add(ADD246);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:513:11: ( SILENT )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==SILENT) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:513:11: SILENT
					{
					SILENT247=(Token)match(input,SILENT,FOLLOW_SILENT_in_add2979);  
					stream_SILENT.add(SILENT247);

					}
					break;

			}

			pushFollow(FOLLOW_graphOrDefault_in_add2984);
			from=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(from.getTree());
			TO248=(Token)match(input,TO,FOLLOW_TO_in_add2986);  
			stream_TO.add(TO248);

			pushFollow(FOLLOW_graphOrDefault_in_add2990);
			to=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(to.getTree());
			// AST REWRITE
			// elements: SILENT, ADD, to, from
			// token labels: 
			// rule labels: to, retval, from
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_to=new RewriteRuleSubtreeStream(adaptor,"rule to",to!=null?to.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_from=new RewriteRuleSubtreeStream(adaptor,"rule from",from!=null?from.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 513:60: -> ^( ADD ( SILENT )* $from $to)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:513:63: ^( ADD ( SILENT )* $from $to)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_ADD.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:513:69: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_from.nextTree());
				adaptor.addChild(root_1, stream_to.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "add"


	public static class move_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "move"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:516:1: move : MOVE ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( MOVE ( SILENT )* $from $to) ;
	public final SparqlifyConfigParser.move_return move() throws RecognitionException {
		SparqlifyConfigParser.move_return retval = new SparqlifyConfigParser.move_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token MOVE249=null;
		Token SILENT250=null;
		Token TO251=null;
		ParserRuleReturnScope from =null;
		ParserRuleReturnScope to =null;

		CommonTree MOVE249_tree=null;
		CommonTree SILENT250_tree=null;
		CommonTree TO251_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_TO=new RewriteRuleTokenStream(adaptor,"token TO");
		RewriteRuleTokenStream stream_MOVE=new RewriteRuleTokenStream(adaptor,"token MOVE");
		RewriteRuleSubtreeStream stream_graphOrDefault=new RewriteRuleSubtreeStream(adaptor,"rule graphOrDefault");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:517:5: ( MOVE ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( MOVE ( SILENT )* $from $to) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:517:7: MOVE ( SILENT )? from= graphOrDefault TO to= graphOrDefault
			{
			MOVE249=(Token)match(input,MOVE,FOLLOW_MOVE_in_move3026);  
			stream_MOVE.add(MOVE249);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:517:12: ( SILENT )?
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==SILENT) ) {
				alt76=1;
			}
			switch (alt76) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:517:12: SILENT
					{
					SILENT250=(Token)match(input,SILENT,FOLLOW_SILENT_in_move3028);  
					stream_SILENT.add(SILENT250);

					}
					break;

			}

			pushFollow(FOLLOW_graphOrDefault_in_move3033);
			from=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(from.getTree());
			TO251=(Token)match(input,TO,FOLLOW_TO_in_move3035);  
			stream_TO.add(TO251);

			pushFollow(FOLLOW_graphOrDefault_in_move3039);
			to=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(to.getTree());
			// AST REWRITE
			// elements: from, SILENT, MOVE, to
			// token labels: 
			// rule labels: to, retval, from
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_to=new RewriteRuleSubtreeStream(adaptor,"rule to",to!=null?to.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_from=new RewriteRuleSubtreeStream(adaptor,"rule from",from!=null?from.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 517:61: -> ^( MOVE ( SILENT )* $from $to)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:517:64: ^( MOVE ( SILENT )* $from $to)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_MOVE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:517:71: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_from.nextTree());
				adaptor.addChild(root_1, stream_to.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "move"


	public static class copy_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "copy"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:520:1: copy : COPY ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( COPY ( SILENT )* $from $to) ;
	public final SparqlifyConfigParser.copy_return copy() throws RecognitionException {
		SparqlifyConfigParser.copy_return retval = new SparqlifyConfigParser.copy_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COPY252=null;
		Token SILENT253=null;
		Token TO254=null;
		ParserRuleReturnScope from =null;
		ParserRuleReturnScope to =null;

		CommonTree COPY252_tree=null;
		CommonTree SILENT253_tree=null;
		CommonTree TO254_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_TO=new RewriteRuleTokenStream(adaptor,"token TO");
		RewriteRuleTokenStream stream_COPY=new RewriteRuleTokenStream(adaptor,"token COPY");
		RewriteRuleSubtreeStream stream_graphOrDefault=new RewriteRuleSubtreeStream(adaptor,"rule graphOrDefault");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:521:5: ( COPY ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( COPY ( SILENT )* $from $to) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:521:7: COPY ( SILENT )? from= graphOrDefault TO to= graphOrDefault
			{
			COPY252=(Token)match(input,COPY,FOLLOW_COPY_in_copy3075);  
			stream_COPY.add(COPY252);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:521:12: ( SILENT )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==SILENT) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:521:12: SILENT
					{
					SILENT253=(Token)match(input,SILENT,FOLLOW_SILENT_in_copy3077);  
					stream_SILENT.add(SILENT253);

					}
					break;

			}

			pushFollow(FOLLOW_graphOrDefault_in_copy3082);
			from=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(from.getTree());
			TO254=(Token)match(input,TO,FOLLOW_TO_in_copy3084);  
			stream_TO.add(TO254);

			pushFollow(FOLLOW_graphOrDefault_in_copy3088);
			to=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(to.getTree());
			// AST REWRITE
			// elements: to, from, SILENT, COPY
			// token labels: 
			// rule labels: to, retval, from
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_to=new RewriteRuleSubtreeStream(adaptor,"rule to",to!=null?to.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_from=new RewriteRuleSubtreeStream(adaptor,"rule from",from!=null?from.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 521:61: -> ^( COPY ( SILENT )* $from $to)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:521:64: ^( COPY ( SILENT )* $from $to)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_COPY.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:521:71: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_from.nextTree());
				adaptor.addChild(root_1, stream_to.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "copy"


	public static class insert_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "insert"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:524:1: insert : INSERT DATA quadPattern -> ^( INSERT DATA quadPattern ) ;
	public final SparqlifyConfigParser.insert_return insert() throws RecognitionException {
		SparqlifyConfigParser.insert_return retval = new SparqlifyConfigParser.insert_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INSERT255=null;
		Token DATA256=null;
		ParserRuleReturnScope quadPattern257 =null;

		CommonTree INSERT255_tree=null;
		CommonTree DATA256_tree=null;
		RewriteRuleTokenStream stream_INSERT=new RewriteRuleTokenStream(adaptor,"token INSERT");
		RewriteRuleTokenStream stream_DATA=new RewriteRuleTokenStream(adaptor,"token DATA");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:525:5: ( INSERT DATA quadPattern -> ^( INSERT DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:525:7: INSERT DATA quadPattern
			{
			INSERT255=(Token)match(input,INSERT,FOLLOW_INSERT_in_insert3120);  
			stream_INSERT.add(INSERT255);

			DATA256=(Token)match(input,DATA,FOLLOW_DATA_in_insert3122);  
			stream_DATA.add(DATA256);

			pushFollow(FOLLOW_quadPattern_in_insert3124);
			quadPattern257=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern257.getTree());
			// AST REWRITE
			// elements: INSERT, DATA, quadPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 525:31: -> ^( INSERT DATA quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:525:34: ^( INSERT DATA quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_INSERT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_DATA.nextNode());
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "insert"


	public static class delete_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "delete"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:528:1: delete : DELETE ( deleteData | deleteWhere ) ;
	public final SparqlifyConfigParser.delete_return delete() throws RecognitionException {
		SparqlifyConfigParser.delete_return retval = new SparqlifyConfigParser.delete_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DELETE258=null;
		ParserRuleReturnScope deleteData259 =null;
		ParserRuleReturnScope deleteWhere260 =null;

		CommonTree DELETE258_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:529:5: ( DELETE ( deleteData | deleteWhere ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:529:7: DELETE ( deleteData | deleteWhere )
			{
			root_0 = (CommonTree)adaptor.nil();


			DELETE258=(Token)match(input,DELETE,FOLLOW_DELETE_in_delete3158); 
			DELETE258_tree = (CommonTree)adaptor.create(DELETE258);
			adaptor.addChild(root_0, DELETE258_tree);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:529:14: ( deleteData | deleteWhere )
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==DATA) ) {
				alt78=1;
			}
			else if ( (LA78_0==WHERE) ) {
				alt78=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 78, 0, input);
				throw nvae;
			}

			switch (alt78) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:529:16: deleteData
					{
					pushFollow(FOLLOW_deleteData_in_delete3162);
					deleteData259=deleteData();
					state._fsp--;

					adaptor.addChild(root_0, deleteData259.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:529:29: deleteWhere
					{
					pushFollow(FOLLOW_deleteWhere_in_delete3166);
					deleteWhere260=deleteWhere();
					state._fsp--;

					adaptor.addChild(root_0, deleteWhere260.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delete"


	public static class deleteData_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "deleteData"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:532:1: deleteData : DATA quadPattern -> ^( DELETE DATA quadPattern ) ;
	public final SparqlifyConfigParser.deleteData_return deleteData() throws RecognitionException {
		SparqlifyConfigParser.deleteData_return retval = new SparqlifyConfigParser.deleteData_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DATA261=null;
		ParserRuleReturnScope quadPattern262 =null;

		CommonTree DATA261_tree=null;
		RewriteRuleTokenStream stream_DATA=new RewriteRuleTokenStream(adaptor,"token DATA");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:533:5: ( DATA quadPattern -> ^( DELETE DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:533:7: DATA quadPattern
			{
			DATA261=(Token)match(input,DATA,FOLLOW_DATA_in_deleteData3185);  
			stream_DATA.add(DATA261);

			pushFollow(FOLLOW_quadPattern_in_deleteData3187);
			quadPattern262=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern262.getTree());
			// AST REWRITE
			// elements: DATA, quadPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 533:24: -> ^( DELETE DATA quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:533:27: ^( DELETE DATA quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(DELETE, "DELETE"), root_1);
				adaptor.addChild(root_1, stream_DATA.nextNode());
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteData"


	public static class deleteWhere_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "deleteWhere"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:536:1: deleteWhere : WHERE quadPattern -> ^( DELETE WHERE quadPattern ) ;
	public final SparqlifyConfigParser.deleteWhere_return deleteWhere() throws RecognitionException {
		SparqlifyConfigParser.deleteWhere_return retval = new SparqlifyConfigParser.deleteWhere_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WHERE263=null;
		ParserRuleReturnScope quadPattern264 =null;

		CommonTree WHERE263_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:537:5: ( WHERE quadPattern -> ^( DELETE WHERE quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:537:7: WHERE quadPattern
			{
			WHERE263=(Token)match(input,WHERE,FOLLOW_WHERE_in_deleteWhere3214);  
			stream_WHERE.add(WHERE263);

			pushFollow(FOLLOW_quadPattern_in_deleteWhere3216);
			quadPattern264=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern264.getTree());
			// AST REWRITE
			// elements: quadPattern, WHERE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 537:25: -> ^( DELETE WHERE quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:537:28: ^( DELETE WHERE quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(DELETE, "DELETE"), root_1);
				adaptor.addChild(root_1, stream_WHERE.nextNode());
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteWhere"


	public static class modify_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "modify"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:540:1: modify : ( WITH i= iriRef )? ( deleteClause ( insertClause )? | insertClause ) ( usingClause )* WHERE groupGraphPattern -> ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) ;
	public final SparqlifyConfigParser.modify_return modify() throws RecognitionException {
		SparqlifyConfigParser.modify_return retval = new SparqlifyConfigParser.modify_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WITH265=null;
		Token WHERE270=null;
		ParserRuleReturnScope i =null;
		ParserRuleReturnScope deleteClause266 =null;
		ParserRuleReturnScope insertClause267 =null;
		ParserRuleReturnScope insertClause268 =null;
		ParserRuleReturnScope usingClause269 =null;
		ParserRuleReturnScope groupGraphPattern271 =null;

		CommonTree WITH265_tree=null;
		CommonTree WHERE270_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleTokenStream stream_WITH=new RewriteRuleTokenStream(adaptor,"token WITH");
		RewriteRuleSubtreeStream stream_deleteClause=new RewriteRuleSubtreeStream(adaptor,"rule deleteClause");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");
		RewriteRuleSubtreeStream stream_insertClause=new RewriteRuleSubtreeStream(adaptor,"rule insertClause");
		RewriteRuleSubtreeStream stream_usingClause=new RewriteRuleSubtreeStream(adaptor,"rule usingClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:5: ( ( WITH i= iriRef )? ( deleteClause ( insertClause )? | insertClause ) ( usingClause )* WHERE groupGraphPattern -> ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:7: ( WITH i= iriRef )? ( deleteClause ( insertClause )? | insertClause ) ( usingClause )* WHERE groupGraphPattern
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:7: ( WITH i= iriRef )?
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==WITH) ) {
				alt79=1;
			}
			switch (alt79) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:9: WITH i= iriRef
					{
					WITH265=(Token)match(input,WITH,FOLLOW_WITH_in_modify3249);  
					stream_WITH.add(WITH265);

					pushFollow(FOLLOW_iriRef_in_modify3253);
					i=iriRef();
					state._fsp--;

					stream_iriRef.add(i.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:26: ( deleteClause ( insertClause )? | insertClause )
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==DELETE) ) {
				alt81=1;
			}
			else if ( (LA81_0==INSERT) ) {
				alt81=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 81, 0, input);
				throw nvae;
			}

			switch (alt81) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:27: deleteClause ( insertClause )?
					{
					pushFollow(FOLLOW_deleteClause_in_modify3259);
					deleteClause266=deleteClause();
					state._fsp--;

					stream_deleteClause.add(deleteClause266.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:40: ( insertClause )?
					int alt80=2;
					int LA80_0 = input.LA(1);
					if ( (LA80_0==INSERT) ) {
						alt80=1;
					}
					switch (alt80) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:40: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify3261);
							insertClause267=insertClause();
							state._fsp--;

							stream_insertClause.add(insertClause267.getTree());
							}
							break;

					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:56: insertClause
					{
					pushFollow(FOLLOW_insertClause_in_modify3266);
					insertClause268=insertClause();
					state._fsp--;

					stream_insertClause.add(insertClause268.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:70: ( usingClause )*
			loop82:
			while (true) {
				int alt82=2;
				int LA82_0 = input.LA(1);
				if ( (LA82_0==USING) ) {
					alt82=1;
				}

				switch (alt82) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:70: usingClause
					{
					pushFollow(FOLLOW_usingClause_in_modify3269);
					usingClause269=usingClause();
					state._fsp--;

					stream_usingClause.add(usingClause269.getTree());
					}
					break;

				default :
					break loop82;
				}
			}

			WHERE270=(Token)match(input,WHERE,FOLLOW_WHERE_in_modify3272);  
			stream_WHERE.add(WHERE270);

			pushFollow(FOLLOW_groupGraphPattern_in_modify3274);
			groupGraphPattern271=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern271.getTree());
			// AST REWRITE
			// elements: groupGraphPattern, WHERE, deleteClause, insertClause, i, WITH, usingClause
			// token labels: 
			// rule labels: retval, i
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_i=new RewriteRuleSubtreeStream(adaptor,"rule i",i!=null?i.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 541:107: -> ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:110: ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(MODIFY, "MODIFY"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:119: ( ^( WITH $i) )?
				if ( stream_i.hasNext()||stream_WITH.hasNext() ) {
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:119: ^( WITH $i)
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot(stream_WITH.nextNode(), root_2);
					adaptor.addChild(root_2, stream_i.nextTree());
					adaptor.addChild(root_1, root_2);
					}

				}
				stream_i.reset();
				stream_WITH.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:131: ( deleteClause )*
				while ( stream_deleteClause.hasNext() ) {
					adaptor.addChild(root_1, stream_deleteClause.nextTree());
				}
				stream_deleteClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:145: ( insertClause )*
				while ( stream_insertClause.hasNext() ) {
					adaptor.addChild(root_1, stream_insertClause.nextTree());
				}
				stream_insertClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:159: ( usingClause )*
				while ( stream_usingClause.hasNext() ) {
					adaptor.addChild(root_1, stream_usingClause.nextTree());
				}
				stream_usingClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:541:172: ^( WHERE groupGraphPattern )
				{
				CommonTree root_2 = (CommonTree)adaptor.nil();
				root_2 = (CommonTree)adaptor.becomeRoot(stream_WHERE.nextNode(), root_2);
				adaptor.addChild(root_2, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "modify"


	public static class deleteClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "deleteClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:544:1: deleteClause : DELETE quadPattern -> DELETE quadPattern ;
	public final SparqlifyConfigParser.deleteClause_return deleteClause() throws RecognitionException {
		SparqlifyConfigParser.deleteClause_return retval = new SparqlifyConfigParser.deleteClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DELETE272=null;
		ParserRuleReturnScope quadPattern273 =null;

		CommonTree DELETE272_tree=null;
		RewriteRuleTokenStream stream_DELETE=new RewriteRuleTokenStream(adaptor,"token DELETE");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:545:5: ( DELETE quadPattern -> DELETE quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:545:7: DELETE quadPattern
			{
			DELETE272=(Token)match(input,DELETE,FOLLOW_DELETE_in_deleteClause3322);  
			stream_DELETE.add(DELETE272);

			pushFollow(FOLLOW_quadPattern_in_deleteClause3324);
			quadPattern273=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern273.getTree());
			// AST REWRITE
			// elements: quadPattern, DELETE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 545:26: -> DELETE quadPattern
			{
				adaptor.addChild(root_0, stream_DELETE.nextNode());
				adaptor.addChild(root_0, stream_quadPattern.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteClause"


	public static class insertClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "insertClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:1: insertClause : INSERT quadPattern -> INSERT quadPattern ;
	public final SparqlifyConfigParser.insertClause_return insertClause() throws RecognitionException {
		SparqlifyConfigParser.insertClause_return retval = new SparqlifyConfigParser.insertClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INSERT274=null;
		ParserRuleReturnScope quadPattern275 =null;

		CommonTree INSERT274_tree=null;
		RewriteRuleTokenStream stream_INSERT=new RewriteRuleTokenStream(adaptor,"token INSERT");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:549:5: ( INSERT quadPattern -> INSERT quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:549:7: INSERT quadPattern
			{
			INSERT274=(Token)match(input,INSERT,FOLLOW_INSERT_in_insertClause3353);  
			stream_INSERT.add(INSERT274);

			pushFollow(FOLLOW_quadPattern_in_insertClause3355);
			quadPattern275=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern275.getTree());
			// AST REWRITE
			// elements: quadPattern, INSERT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 549:26: -> INSERT quadPattern
			{
				adaptor.addChild(root_0, stream_INSERT.nextNode());
				adaptor.addChild(root_0, stream_quadPattern.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "insertClause"


	public static class usingClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "usingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:552:1: usingClause : USING ( NAMED )? iriRef -> ^( USING ( NAMED )? iriRef ) ;
	public final SparqlifyConfigParser.usingClause_return usingClause() throws RecognitionException {
		SparqlifyConfigParser.usingClause_return retval = new SparqlifyConfigParser.usingClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token USING276=null;
		Token NAMED277=null;
		ParserRuleReturnScope iriRef278 =null;

		CommonTree USING276_tree=null;
		CommonTree NAMED277_tree=null;
		RewriteRuleTokenStream stream_USING=new RewriteRuleTokenStream(adaptor,"token USING");
		RewriteRuleTokenStream stream_NAMED=new RewriteRuleTokenStream(adaptor,"token NAMED");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:553:5: ( USING ( NAMED )? iriRef -> ^( USING ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:553:7: USING ( NAMED )? iriRef
			{
			USING276=(Token)match(input,USING,FOLLOW_USING_in_usingClause3378);  
			stream_USING.add(USING276);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:553:13: ( NAMED )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==NAMED) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:553:13: NAMED
					{
					NAMED277=(Token)match(input,NAMED,FOLLOW_NAMED_in_usingClause3380);  
					stream_NAMED.add(NAMED277);

					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_usingClause3383);
			iriRef278=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef278.getTree());
			// AST REWRITE
			// elements: NAMED, USING, iriRef
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 553:27: -> ^( USING ( NAMED )? iriRef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:553:30: ^( USING ( NAMED )? iriRef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_USING.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:553:38: ( NAMED )?
				if ( stream_NAMED.hasNext() ) {
					adaptor.addChild(root_1, stream_NAMED.nextNode());
				}
				stream_NAMED.reset();

				adaptor.addChild(root_1, stream_iriRef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "usingClause"


	public static class graphOrDefault_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphOrDefault"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:556:1: graphOrDefault : ( DEFAULT | ( GRAPH )? iriRef );
	public final SparqlifyConfigParser.graphOrDefault_return graphOrDefault() throws RecognitionException {
		SparqlifyConfigParser.graphOrDefault_return retval = new SparqlifyConfigParser.graphOrDefault_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DEFAULT279=null;
		Token GRAPH280=null;
		ParserRuleReturnScope iriRef281 =null;

		CommonTree DEFAULT279_tree=null;
		CommonTree GRAPH280_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:557:5: ( DEFAULT | ( GRAPH )? iriRef )
			int alt85=2;
			int LA85_0 = input.LA(1);
			if ( (LA85_0==DEFAULT) ) {
				alt85=1;
			}
			else if ( (LA85_0==GRAPH||LA85_0==IRI_REF||(LA85_0 >= PNAME_LN && LA85_0 <= PNAME_NS)) ) {
				alt85=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 85, 0, input);
				throw nvae;
			}

			switch (alt85) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:557:7: DEFAULT
					{
					root_0 = (CommonTree)adaptor.nil();


					DEFAULT279=(Token)match(input,DEFAULT,FOLLOW_DEFAULT_in_graphOrDefault3414); 
					DEFAULT279_tree = (CommonTree)adaptor.create(DEFAULT279);
					adaptor.addChild(root_0, DEFAULT279_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:558:7: ( GRAPH )? iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:558:7: ( GRAPH )?
					int alt84=2;
					int LA84_0 = input.LA(1);
					if ( (LA84_0==GRAPH) ) {
						alt84=1;
					}
					switch (alt84) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:558:7: GRAPH
							{
							GRAPH280=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_graphOrDefault3423); 
							GRAPH280_tree = (CommonTree)adaptor.create(GRAPH280);
							adaptor.addChild(root_0, GRAPH280_tree);

							}
							break;

					}

					pushFollow(FOLLOW_iriRef_in_graphOrDefault3426);
					iriRef281=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef281.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphOrDefault"


	public static class graphRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:561:1: graphRef : GRAPH iriRef ;
	public final SparqlifyConfigParser.graphRef_return graphRef() throws RecognitionException {
		SparqlifyConfigParser.graphRef_return retval = new SparqlifyConfigParser.graphRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GRAPH282=null;
		ParserRuleReturnScope iriRef283 =null;

		CommonTree GRAPH282_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:562:5: ( GRAPH iriRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:562:7: GRAPH iriRef
			{
			root_0 = (CommonTree)adaptor.nil();


			GRAPH282=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_graphRef3453); 
			GRAPH282_tree = (CommonTree)adaptor.create(GRAPH282);
			adaptor.addChild(root_0, GRAPH282_tree);

			pushFollow(FOLLOW_iriRef_in_graphRef3455);
			iriRef283=iriRef();
			state._fsp--;

			adaptor.addChild(root_0, iriRef283.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphRef"


	public static class graphRefAll_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphRefAll"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:565:1: graphRefAll : ( graphRef | DEFAULT | NAMED | ALL );
	public final SparqlifyConfigParser.graphRefAll_return graphRefAll() throws RecognitionException {
		SparqlifyConfigParser.graphRefAll_return retval = new SparqlifyConfigParser.graphRefAll_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DEFAULT285=null;
		Token NAMED286=null;
		Token ALL287=null;
		ParserRuleReturnScope graphRef284 =null;

		CommonTree DEFAULT285_tree=null;
		CommonTree NAMED286_tree=null;
		CommonTree ALL287_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:566:5: ( graphRef | DEFAULT | NAMED | ALL )
			int alt86=4;
			switch ( input.LA(1) ) {
			case GRAPH:
				{
				alt86=1;
				}
				break;
			case DEFAULT:
				{
				alt86=2;
				}
				break;
			case NAMED:
				{
				alt86=3;
				}
				break;
			case ALL:
				{
				alt86=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 86, 0, input);
				throw nvae;
			}
			switch (alt86) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:566:7: graphRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_graphRef_in_graphRefAll3472);
					graphRef284=graphRef();
					state._fsp--;

					adaptor.addChild(root_0, graphRef284.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:566:18: DEFAULT
					{
					root_0 = (CommonTree)adaptor.nil();


					DEFAULT285=(Token)match(input,DEFAULT,FOLLOW_DEFAULT_in_graphRefAll3476); 
					DEFAULT285_tree = (CommonTree)adaptor.create(DEFAULT285);
					adaptor.addChild(root_0, DEFAULT285_tree);

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:566:28: NAMED
					{
					root_0 = (CommonTree)adaptor.nil();


					NAMED286=(Token)match(input,NAMED,FOLLOW_NAMED_in_graphRefAll3480); 
					NAMED286_tree = (CommonTree)adaptor.create(NAMED286);
					adaptor.addChild(root_0, NAMED286_tree);

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:566:36: ALL
					{
					root_0 = (CommonTree)adaptor.nil();


					ALL287=(Token)match(input,ALL,FOLLOW_ALL_in_graphRefAll3484); 
					ALL287_tree = (CommonTree)adaptor.create(ALL287);
					adaptor.addChild(root_0, ALL287_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphRefAll"


	public static class quadPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "quadPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:569:1: quadPattern : OPEN_CURLY_BRACE quads CLOSE_CURLY_BRACE -> quads ;
	public final SparqlifyConfigParser.quadPattern_return quadPattern() throws RecognitionException {
		SparqlifyConfigParser.quadPattern_return retval = new SparqlifyConfigParser.quadPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_CURLY_BRACE288=null;
		Token CLOSE_CURLY_BRACE290=null;
		ParserRuleReturnScope quads289 =null;

		CommonTree OPEN_CURLY_BRACE288_tree=null;
		CommonTree CLOSE_CURLY_BRACE290_tree=null;
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_quads=new RewriteRuleSubtreeStream(adaptor,"rule quads");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:570:5: ( OPEN_CURLY_BRACE quads CLOSE_CURLY_BRACE -> quads )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:570:7: OPEN_CURLY_BRACE quads CLOSE_CURLY_BRACE
			{
			OPEN_CURLY_BRACE288=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_quadPattern3501);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE288);

			pushFollow(FOLLOW_quads_in_quadPattern3503);
			quads289=quads();
			state._fsp--;

			stream_quads.add(quads289.getTree());
			CLOSE_CURLY_BRACE290=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_quadPattern3505);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE290);

			// AST REWRITE
			// elements: quads
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 570:48: -> quads
			{
				adaptor.addChild(root_0, stream_quads.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "quadPattern"


	public static class quads_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "quads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:573:1: quads : ( triplesTemplate )? ( quadsNotTriples ( DOT )? ( triplesTemplate )? )* -> ( triplesTemplate )? ( quadsNotTriples ( triplesTemplate )? )* ;
	public final SparqlifyConfigParser.quads_return quads() throws RecognitionException {
		SparqlifyConfigParser.quads_return retval = new SparqlifyConfigParser.quads_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT293=null;
		ParserRuleReturnScope triplesTemplate291 =null;
		ParserRuleReturnScope quadsNotTriples292 =null;
		ParserRuleReturnScope triplesTemplate294 =null;

		CommonTree DOT293_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesTemplate=new RewriteRuleSubtreeStream(adaptor,"rule triplesTemplate");
		RewriteRuleSubtreeStream stream_quadsNotTriples=new RewriteRuleSubtreeStream(adaptor,"rule quadsNotTriples");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:5: ( ( triplesTemplate )? ( quadsNotTriples ( DOT )? ( triplesTemplate )? )* -> ( triplesTemplate )? ( quadsNotTriples ( triplesTemplate )? )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:7: ( triplesTemplate )? ( quadsNotTriples ( DOT )? ( triplesTemplate )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:7: ( triplesTemplate )?
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==BLANK_NODE_LABEL||(LA87_0 >= DECIMAL && LA87_0 <= DECIMAL_POSITIVE)||(LA87_0 >= DOUBLE && LA87_0 <= DOUBLE_POSITIVE)||LA87_0==FALSE||(LA87_0 >= INTEGER && LA87_0 <= INTEGER_POSITIVE)||LA87_0==IRI_REF||LA87_0==OPEN_BRACE||LA87_0==OPEN_SQUARE_BRACKET||(LA87_0 >= PNAME_LN && LA87_0 <= PNAME_NS)||(LA87_0 >= STRING_LITERAL1 && LA87_0 <= STRING_LITERAL_LONG2)||LA87_0==TRUE||(LA87_0 >= VAR1 && LA87_0 <= VAR3)) ) {
				alt87=1;
			}
			switch (alt87) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:7: triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quads3530);
					triplesTemplate291=triplesTemplate();
					state._fsp--;

					stream_triplesTemplate.add(triplesTemplate291.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:24: ( quadsNotTriples ( DOT )? ( triplesTemplate )? )*
			loop90:
			while (true) {
				int alt90=2;
				int LA90_0 = input.LA(1);
				if ( (LA90_0==GRAPH) ) {
					alt90=1;
				}

				switch (alt90) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:26: quadsNotTriples ( DOT )? ( triplesTemplate )?
					{
					pushFollow(FOLLOW_quadsNotTriples_in_quads3535);
					quadsNotTriples292=quadsNotTriples();
					state._fsp--;

					stream_quadsNotTriples.add(quadsNotTriples292.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:42: ( DOT )?
					int alt88=2;
					int LA88_0 = input.LA(1);
					if ( (LA88_0==DOT) ) {
						alt88=1;
					}
					switch (alt88) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:42: DOT
							{
							DOT293=(Token)match(input,DOT,FOLLOW_DOT_in_quads3537);  
							stream_DOT.add(DOT293);

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:47: ( triplesTemplate )?
					int alt89=2;
					int LA89_0 = input.LA(1);
					if ( (LA89_0==BLANK_NODE_LABEL||(LA89_0 >= DECIMAL && LA89_0 <= DECIMAL_POSITIVE)||(LA89_0 >= DOUBLE && LA89_0 <= DOUBLE_POSITIVE)||LA89_0==FALSE||(LA89_0 >= INTEGER && LA89_0 <= INTEGER_POSITIVE)||LA89_0==IRI_REF||LA89_0==OPEN_BRACE||LA89_0==OPEN_SQUARE_BRACKET||(LA89_0 >= PNAME_LN && LA89_0 <= PNAME_NS)||(LA89_0 >= STRING_LITERAL1 && LA89_0 <= STRING_LITERAL_LONG2)||LA89_0==TRUE||(LA89_0 >= VAR1 && LA89_0 <= VAR3)) ) {
						alt89=1;
					}
					switch (alt89) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:47: triplesTemplate
							{
							pushFollow(FOLLOW_triplesTemplate_in_quads3540);
							triplesTemplate294=triplesTemplate();
							state._fsp--;

							stream_triplesTemplate.add(triplesTemplate294.getTree());
							}
							break;

					}

					}
					break;

				default :
					break loop90;
				}
			}

			// AST REWRITE
			// elements: quadsNotTriples, triplesTemplate, triplesTemplate
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 574:67: -> ( triplesTemplate )? ( quadsNotTriples ( triplesTemplate )? )*
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:71: ( triplesTemplate )?
				if ( stream_triplesTemplate.hasNext() ) {
					adaptor.addChild(root_0, stream_triplesTemplate.nextTree());
				}
				stream_triplesTemplate.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:88: ( quadsNotTriples ( triplesTemplate )? )*
				while ( stream_quadsNotTriples.hasNext() ) {
					adaptor.addChild(root_0, stream_quadsNotTriples.nextTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:574:106: ( triplesTemplate )?
					if ( stream_triplesTemplate.hasNext() ) {
						adaptor.addChild(root_0, stream_triplesTemplate.nextTree());
					}
					stream_triplesTemplate.reset();

				}
				stream_quadsNotTriples.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "quads"


	public static class quadsNotTriples_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "quadsNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:577:1: quadsNotTriples : GRAPH varOrIRIref OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE -> ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? ) ;
	public final SparqlifyConfigParser.quadsNotTriples_return quadsNotTriples() throws RecognitionException {
		SparqlifyConfigParser.quadsNotTriples_return retval = new SparqlifyConfigParser.quadsNotTriples_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GRAPH295=null;
		Token OPEN_CURLY_BRACE297=null;
		Token CLOSE_CURLY_BRACE299=null;
		ParserRuleReturnScope varOrIRIref296 =null;
		ParserRuleReturnScope triplesTemplate298 =null;

		CommonTree GRAPH295_tree=null;
		CommonTree OPEN_CURLY_BRACE297_tree=null;
		CommonTree CLOSE_CURLY_BRACE299_tree=null;
		RewriteRuleTokenStream stream_GRAPH=new RewriteRuleTokenStream(adaptor,"token GRAPH");
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_triplesTemplate=new RewriteRuleSubtreeStream(adaptor,"rule triplesTemplate");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:578:5: ( GRAPH varOrIRIref OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE -> ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:578:7: GRAPH varOrIRIref OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE
			{
			GRAPH295=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_quadsNotTriples3582);  
			stream_GRAPH.add(GRAPH295);

			pushFollow(FOLLOW_varOrIRIref_in_quadsNotTriples3584);
			varOrIRIref296=varOrIRIref();
			state._fsp--;

			stream_varOrIRIref.add(varOrIRIref296.getTree());
			OPEN_CURLY_BRACE297=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_quadsNotTriples3586);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE297);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:578:42: ( triplesTemplate )?
			int alt91=2;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==BLANK_NODE_LABEL||(LA91_0 >= DECIMAL && LA91_0 <= DECIMAL_POSITIVE)||(LA91_0 >= DOUBLE && LA91_0 <= DOUBLE_POSITIVE)||LA91_0==FALSE||(LA91_0 >= INTEGER && LA91_0 <= INTEGER_POSITIVE)||LA91_0==IRI_REF||LA91_0==OPEN_BRACE||LA91_0==OPEN_SQUARE_BRACKET||(LA91_0 >= PNAME_LN && LA91_0 <= PNAME_NS)||(LA91_0 >= STRING_LITERAL1 && LA91_0 <= STRING_LITERAL_LONG2)||LA91_0==TRUE||(LA91_0 >= VAR1 && LA91_0 <= VAR3)) ) {
				alt91=1;
			}
			switch (alt91) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:578:42: triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quadsNotTriples3588);
					triplesTemplate298=triplesTemplate();
					state._fsp--;

					stream_triplesTemplate.add(triplesTemplate298.getTree());
					}
					break;

			}

			CLOSE_CURLY_BRACE299=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_quadsNotTriples3591);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE299);

			// AST REWRITE
			// elements: varOrIRIref, triplesTemplate
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 578:77: -> ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:578:80: ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(GRAPH_TOKEN, "GRAPH_TOKEN"), root_1);
				adaptor.addChild(root_1, stream_varOrIRIref.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:578:106: ( triplesTemplate )?
				if ( stream_triplesTemplate.hasNext() ) {
					adaptor.addChild(root_1, stream_triplesTemplate.nextTree());
				}
				stream_triplesTemplate.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "quadsNotTriples"


	public static class triplesTemplate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:1: triplesTemplate : triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ^( TRIPLES_TEMPLATE ( triplesSameSubject )* ) ;
	public final SparqlifyConfigParser.triplesTemplate_return triplesTemplate() throws RecognitionException {
		SparqlifyConfigParser.triplesTemplate_return retval = new SparqlifyConfigParser.triplesTemplate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT301=null;
		Token DOT303=null;
		ParserRuleReturnScope triplesSameSubject300 =null;
		ParserRuleReturnScope triplesSameSubject302 =null;

		CommonTree DOT301_tree=null;
		CommonTree DOT303_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesSameSubject=new RewriteRuleSubtreeStream(adaptor,"rule triplesSameSubject");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:5: ( triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ^( TRIPLES_TEMPLATE ( triplesSameSubject )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:7: triplesSameSubject ( DOT triplesSameSubject )* ( DOT )?
			{
			pushFollow(FOLLOW_triplesSameSubject_in_triplesTemplate3623);
			triplesSameSubject300=triplesSameSubject();
			state._fsp--;

			stream_triplesSameSubject.add(triplesSameSubject300.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:26: ( DOT triplesSameSubject )*
			loop92:
			while (true) {
				int alt92=2;
				int LA92_0 = input.LA(1);
				if ( (LA92_0==DOT) ) {
					int LA92_1 = input.LA(2);
					if ( (LA92_1==BLANK_NODE_LABEL||(LA92_1 >= DECIMAL && LA92_1 <= DECIMAL_POSITIVE)||(LA92_1 >= DOUBLE && LA92_1 <= DOUBLE_POSITIVE)||LA92_1==FALSE||(LA92_1 >= INTEGER && LA92_1 <= INTEGER_POSITIVE)||LA92_1==IRI_REF||LA92_1==OPEN_BRACE||LA92_1==OPEN_SQUARE_BRACKET||(LA92_1 >= PNAME_LN && LA92_1 <= PNAME_NS)||(LA92_1 >= STRING_LITERAL1 && LA92_1 <= STRING_LITERAL_LONG2)||LA92_1==TRUE||(LA92_1 >= VAR1 && LA92_1 <= VAR3)) ) {
						alt92=1;
					}

				}

				switch (alt92) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:28: DOT triplesSameSubject
					{
					DOT301=(Token)match(input,DOT,FOLLOW_DOT_in_triplesTemplate3627);  
					stream_DOT.add(DOT301);

					pushFollow(FOLLOW_triplesSameSubject_in_triplesTemplate3629);
					triplesSameSubject302=triplesSameSubject();
					state._fsp--;

					stream_triplesSameSubject.add(triplesSameSubject302.getTree());
					}
					break;

				default :
					break loop92;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:54: ( DOT )?
			int alt93=2;
			int LA93_0 = input.LA(1);
			if ( (LA93_0==DOT) ) {
				alt93=1;
			}
			switch (alt93) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:54: DOT
					{
					DOT303=(Token)match(input,DOT,FOLLOW_DOT_in_triplesTemplate3634);  
					stream_DOT.add(DOT303);

					}
					break;

			}

			// AST REWRITE
			// elements: triplesSameSubject
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 582:59: -> ^( TRIPLES_TEMPLATE ( triplesSameSubject )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:62: ^( TRIPLES_TEMPLATE ( triplesSameSubject )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLES_TEMPLATE, "TRIPLES_TEMPLATE"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:582:81: ( triplesSameSubject )*
				while ( stream_triplesSameSubject.hasNext() ) {
					adaptor.addChild(root_1, stream_triplesSameSubject.nextTree());
				}
				stream_triplesSameSubject.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesTemplate"


	public static class groupGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:585:1: groupGraphPattern : OPEN_CURLY_BRACE ( subSelect | groupGraphPatternSub ) CLOSE_CURLY_BRACE -> ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* ) ;
	public final SparqlifyConfigParser.groupGraphPattern_return groupGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.groupGraphPattern_return retval = new SparqlifyConfigParser.groupGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_CURLY_BRACE304=null;
		Token CLOSE_CURLY_BRACE307=null;
		ParserRuleReturnScope subSelect305 =null;
		ParserRuleReturnScope groupGraphPatternSub306 =null;

		CommonTree OPEN_CURLY_BRACE304_tree=null;
		CommonTree CLOSE_CURLY_BRACE307_tree=null;
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_groupGraphPatternSub=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPatternSub");
		RewriteRuleSubtreeStream stream_subSelect=new RewriteRuleSubtreeStream(adaptor,"rule subSelect");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:5: ( OPEN_CURLY_BRACE ( subSelect | groupGraphPatternSub ) CLOSE_CURLY_BRACE -> ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:7: OPEN_CURLY_BRACE ( subSelect | groupGraphPatternSub ) CLOSE_CURLY_BRACE
			{
			OPEN_CURLY_BRACE304=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_groupGraphPattern3666);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE304);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:24: ( subSelect | groupGraphPatternSub )
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==SELECT) ) {
				alt94=1;
			}
			else if ( (LA94_0==BIND||LA94_0==BLANK_NODE_LABEL||LA94_0==CLOSE_CURLY_BRACE||(LA94_0 >= DECIMAL && LA94_0 <= DECIMAL_POSITIVE)||(LA94_0 >= DOUBLE && LA94_0 <= DOUBLE_POSITIVE)||(LA94_0 >= FALSE && LA94_0 <= FILTER)||LA94_0==GRAPH||(LA94_0 >= INTEGER && LA94_0 <= INTEGER_POSITIVE)||LA94_0==IRI_REF||LA94_0==MINUS_KEYWORD||(LA94_0 >= OPEN_BRACE && LA94_0 <= OPTIONAL)||(LA94_0 >= PNAME_LN && LA94_0 <= PNAME_NS)||LA94_0==SERVICE||(LA94_0 >= STRING_LITERAL1 && LA94_0 <= STRING_LITERAL_LONG2)||LA94_0==TRUE||(LA94_0 >= VAR1 && LA94_0 <= VAR3)) ) {
				alt94=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}

			switch (alt94) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:26: subSelect
					{
					pushFollow(FOLLOW_subSelect_in_groupGraphPattern3670);
					subSelect305=subSelect();
					state._fsp--;

					stream_subSelect.add(subSelect305.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:38: groupGraphPatternSub
					{
					pushFollow(FOLLOW_groupGraphPatternSub_in_groupGraphPattern3674);
					groupGraphPatternSub306=groupGraphPatternSub();
					state._fsp--;

					stream_groupGraphPatternSub.add(groupGraphPatternSub306.getTree());
					}
					break;

			}

			CLOSE_CURLY_BRACE307=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_groupGraphPattern3678);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE307);

			// AST REWRITE
			// elements: subSelect, groupGraphPatternSub
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 586:79: -> ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:82: ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(GROUP_GRAPH_PATTERN, "GROUP_GRAPH_PATTERN"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:104: ( subSelect )*
				while ( stream_subSelect.hasNext() ) {
					adaptor.addChild(root_1, stream_subSelect.nextTree());
				}
				stream_subSelect.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:586:115: ( groupGraphPatternSub )*
				while ( stream_groupGraphPatternSub.hasNext() ) {
					adaptor.addChild(root_1, stream_groupGraphPatternSub.nextTree());
				}
				stream_groupGraphPatternSub.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupGraphPattern"


	public static class groupGraphPatternSub_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupGraphPatternSub"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:1: groupGraphPatternSub : ( triplesBlock )? ( groupGraphPatternSubCache )* -> ( triplesBlock )? ( groupGraphPatternSubCache )* ;
	public final SparqlifyConfigParser.groupGraphPatternSub_return groupGraphPatternSub() throws RecognitionException {
		SparqlifyConfigParser.groupGraphPatternSub_return retval = new SparqlifyConfigParser.groupGraphPatternSub_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope triplesBlock308 =null;
		ParserRuleReturnScope groupGraphPatternSubCache309 =null;

		RewriteRuleSubtreeStream stream_triplesBlock=new RewriteRuleSubtreeStream(adaptor,"rule triplesBlock");
		RewriteRuleSubtreeStream stream_groupGraphPatternSubCache=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPatternSubCache");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:5: ( ( triplesBlock )? ( groupGraphPatternSubCache )* -> ( triplesBlock )? ( groupGraphPatternSubCache )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:7: ( triplesBlock )? ( groupGraphPatternSubCache )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:7: ( triplesBlock )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==BLANK_NODE_LABEL||(LA95_0 >= DECIMAL && LA95_0 <= DECIMAL_POSITIVE)||(LA95_0 >= DOUBLE && LA95_0 <= DOUBLE_POSITIVE)||LA95_0==FALSE||(LA95_0 >= INTEGER && LA95_0 <= INTEGER_POSITIVE)||LA95_0==IRI_REF||LA95_0==OPEN_BRACE||LA95_0==OPEN_SQUARE_BRACKET||(LA95_0 >= PNAME_LN && LA95_0 <= PNAME_NS)||(LA95_0 >= STRING_LITERAL1 && LA95_0 <= STRING_LITERAL_LONG2)||LA95_0==TRUE||(LA95_0 >= VAR1 && LA95_0 <= VAR3)) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:7: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSub3711);
					triplesBlock308=triplesBlock();
					state._fsp--;

					stream_triplesBlock.add(triplesBlock308.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:21: ( groupGraphPatternSubCache )*
			loop96:
			while (true) {
				int alt96=2;
				int LA96_0 = input.LA(1);
				if ( (LA96_0==BIND||LA96_0==FILTER||LA96_0==GRAPH||LA96_0==MINUS_KEYWORD||LA96_0==OPEN_CURLY_BRACE||LA96_0==OPTIONAL||LA96_0==SERVICE) ) {
					alt96=1;
				}

				switch (alt96) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:23: groupGraphPatternSubCache
					{
					pushFollow(FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub3716);
					groupGraphPatternSubCache309=groupGraphPatternSubCache();
					state._fsp--;

					stream_groupGraphPatternSubCache.add(groupGraphPatternSubCache309.getTree());
					}
					break;

				default :
					break loop96;
				}
			}

			// AST REWRITE
			// elements: triplesBlock, groupGraphPatternSubCache
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 590:52: -> ( triplesBlock )? ( groupGraphPatternSubCache )*
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:55: ( triplesBlock )?
				if ( stream_triplesBlock.hasNext() ) {
					adaptor.addChild(root_0, stream_triplesBlock.nextTree());
				}
				stream_triplesBlock.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:590:69: ( groupGraphPatternSubCache )*
				while ( stream_groupGraphPatternSubCache.hasNext() ) {
					adaptor.addChild(root_0, stream_groupGraphPatternSubCache.nextTree());
				}
				stream_groupGraphPatternSubCache.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupGraphPatternSub"


	public static class groupGraphPatternSubCache_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupGraphPatternSubCache"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:1: groupGraphPatternSubCache : graphPatternNotTriples ( DOT )? ( triplesBlock )? -> graphPatternNotTriples ( triplesBlock )? ;
	public final SparqlifyConfigParser.groupGraphPatternSubCache_return groupGraphPatternSubCache() throws RecognitionException {
		SparqlifyConfigParser.groupGraphPatternSubCache_return retval = new SparqlifyConfigParser.groupGraphPatternSubCache_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT311=null;
		ParserRuleReturnScope graphPatternNotTriples310 =null;
		ParserRuleReturnScope triplesBlock312 =null;

		CommonTree DOT311_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesBlock=new RewriteRuleSubtreeStream(adaptor,"rule triplesBlock");
		RewriteRuleSubtreeStream stream_graphPatternNotTriples=new RewriteRuleSubtreeStream(adaptor,"rule graphPatternNotTriples");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:594:5: ( graphPatternNotTriples ( DOT )? ( triplesBlock )? -> graphPatternNotTriples ( triplesBlock )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:594:8: graphPatternNotTriples ( DOT )? ( triplesBlock )?
			{
			pushFollow(FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache3745);
			graphPatternNotTriples310=graphPatternNotTriples();
			state._fsp--;

			stream_graphPatternNotTriples.add(graphPatternNotTriples310.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:594:31: ( DOT )?
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==DOT) ) {
				alt97=1;
			}
			switch (alt97) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:594:31: DOT
					{
					DOT311=(Token)match(input,DOT,FOLLOW_DOT_in_groupGraphPatternSubCache3747);  
					stream_DOT.add(DOT311);

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:594:36: ( triplesBlock )?
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==BLANK_NODE_LABEL||(LA98_0 >= DECIMAL && LA98_0 <= DECIMAL_POSITIVE)||(LA98_0 >= DOUBLE && LA98_0 <= DOUBLE_POSITIVE)||LA98_0==FALSE||(LA98_0 >= INTEGER && LA98_0 <= INTEGER_POSITIVE)||LA98_0==IRI_REF||LA98_0==OPEN_BRACE||LA98_0==OPEN_SQUARE_BRACKET||(LA98_0 >= PNAME_LN && LA98_0 <= PNAME_NS)||(LA98_0 >= STRING_LITERAL1 && LA98_0 <= STRING_LITERAL_LONG2)||LA98_0==TRUE||(LA98_0 >= VAR1 && LA98_0 <= VAR3)) ) {
				alt98=1;
			}
			switch (alt98) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:594:36: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSubCache3750);
					triplesBlock312=triplesBlock();
					state._fsp--;

					stream_triplesBlock.add(triplesBlock312.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: graphPatternNotTriples, triplesBlock
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 594:50: -> graphPatternNotTriples ( triplesBlock )?
			{
				adaptor.addChild(root_0, stream_graphPatternNotTriples.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:594:76: ( triplesBlock )?
				if ( stream_triplesBlock.hasNext() ) {
					adaptor.addChild(root_0, stream_triplesBlock.nextTree());
				}
				stream_triplesBlock.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupGraphPatternSubCache"


	public static class triplesBlock_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesBlock"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:1: triplesBlock : triplesSameSubjectPath ( DOT triplesSameSubjectPath )* ( DOT )? -> ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ ) ;
	public final SparqlifyConfigParser.triplesBlock_return triplesBlock() throws RecognitionException {
		SparqlifyConfigParser.triplesBlock_return retval = new SparqlifyConfigParser.triplesBlock_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT314=null;
		Token DOT316=null;
		ParserRuleReturnScope triplesSameSubjectPath313 =null;
		ParserRuleReturnScope triplesSameSubjectPath315 =null;

		CommonTree DOT314_tree=null;
		CommonTree DOT316_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesSameSubjectPath=new RewriteRuleSubtreeStream(adaptor,"rule triplesSameSubjectPath");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:598:5: ( triplesSameSubjectPath ( DOT triplesSameSubjectPath )* ( DOT )? -> ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:598:7: triplesSameSubjectPath ( DOT triplesSameSubjectPath )* ( DOT )?
			{
			pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesBlock3777);
			triplesSameSubjectPath313=triplesSameSubjectPath();
			state._fsp--;

			stream_triplesSameSubjectPath.add(triplesSameSubjectPath313.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:598:30: ( DOT triplesSameSubjectPath )*
			loop99:
			while (true) {
				int alt99=2;
				int LA99_0 = input.LA(1);
				if ( (LA99_0==DOT) ) {
					int LA99_1 = input.LA(2);
					if ( (LA99_1==BLANK_NODE_LABEL||(LA99_1 >= DECIMAL && LA99_1 <= DECIMAL_POSITIVE)||(LA99_1 >= DOUBLE && LA99_1 <= DOUBLE_POSITIVE)||LA99_1==FALSE||(LA99_1 >= INTEGER && LA99_1 <= INTEGER_POSITIVE)||LA99_1==IRI_REF||LA99_1==OPEN_BRACE||LA99_1==OPEN_SQUARE_BRACKET||(LA99_1 >= PNAME_LN && LA99_1 <= PNAME_NS)||(LA99_1 >= STRING_LITERAL1 && LA99_1 <= STRING_LITERAL_LONG2)||LA99_1==TRUE||(LA99_1 >= VAR1 && LA99_1 <= VAR3)) ) {
						alt99=1;
					}

				}

				switch (alt99) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:598:32: DOT triplesSameSubjectPath
					{
					DOT314=(Token)match(input,DOT,FOLLOW_DOT_in_triplesBlock3781);  
					stream_DOT.add(DOT314);

					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesBlock3783);
					triplesSameSubjectPath315=triplesSameSubjectPath();
					state._fsp--;

					stream_triplesSameSubjectPath.add(triplesSameSubjectPath315.getTree());
					}
					break;

				default :
					break loop99;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:598:61: ( DOT )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==DOT) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:598:61: DOT
					{
					DOT316=(Token)match(input,DOT,FOLLOW_DOT_in_triplesBlock3787);  
					stream_DOT.add(DOT316);

					}
					break;

			}

			// AST REWRITE
			// elements: triplesSameSubjectPath
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 598:66: -> ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:598:69: ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLES_BLOCK, "TRIPLES_BLOCK"), root_1);
				if ( !(stream_triplesSameSubjectPath.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_triplesSameSubjectPath.hasNext() ) {
					adaptor.addChild(root_1, stream_triplesSameSubjectPath.nextTree());
				}
				stream_triplesSameSubjectPath.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesBlock"


	public static class graphPatternNotTriples_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphPatternNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:1: graphPatternNotTriples : ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind );
	public final SparqlifyConfigParser.graphPatternNotTriples_return graphPatternNotTriples() throws RecognitionException {
		SparqlifyConfigParser.graphPatternNotTriples_return retval = new SparqlifyConfigParser.graphPatternNotTriples_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope groupOrUnionGraphPattern317 =null;
		ParserRuleReturnScope optionalGraphPattern318 =null;
		ParserRuleReturnScope minusGraphPattern319 =null;
		ParserRuleReturnScope graphGraphPattern320 =null;
		ParserRuleReturnScope serviceGraphPattern321 =null;
		ParserRuleReturnScope filter322 =null;
		ParserRuleReturnScope bind323 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:5: ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind )
			int alt101=7;
			switch ( input.LA(1) ) {
			case OPEN_CURLY_BRACE:
				{
				alt101=1;
				}
				break;
			case OPTIONAL:
				{
				alt101=2;
				}
				break;
			case MINUS_KEYWORD:
				{
				alt101=3;
				}
				break;
			case GRAPH:
				{
				alt101=4;
				}
				break;
			case SERVICE:
				{
				alt101=5;
				}
				break;
			case FILTER:
				{
				alt101=6;
				}
				break;
			case BIND:
				{
				alt101=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 101, 0, input);
				throw nvae;
			}
			switch (alt101) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:7: groupOrUnionGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples3814);
					groupOrUnionGraphPattern317=groupOrUnionGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, groupOrUnionGraphPattern317.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:34: optionalGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_optionalGraphPattern_in_graphPatternNotTriples3818);
					optionalGraphPattern318=optionalGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, optionalGraphPattern318.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:57: minusGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_minusGraphPattern_in_graphPatternNotTriples3822);
					minusGraphPattern319=minusGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, minusGraphPattern319.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:77: graphGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_graphGraphPattern_in_graphPatternNotTriples3826);
					graphGraphPattern320=graphGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, graphGraphPattern320.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:97: serviceGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_serviceGraphPattern_in_graphPatternNotTriples3830);
					serviceGraphPattern321=serviceGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, serviceGraphPattern321.getTree());

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:119: filter
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_filter_in_graphPatternNotTriples3834);
					filter322=filter();
					state._fsp--;

					adaptor.addChild(root_0, filter322.getTree());

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:602:128: bind
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_bind_in_graphPatternNotTriples3838);
					bind323=bind();
					state._fsp--;

					adaptor.addChild(root_0, bind323.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphPatternNotTriples"


	public static class optionalGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "optionalGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:1: optionalGraphPattern : OPTIONAL groupGraphPattern -> ^( OPTIONAL groupGraphPattern ) ;
	public final SparqlifyConfigParser.optionalGraphPattern_return optionalGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.optionalGraphPattern_return retval = new SparqlifyConfigParser.optionalGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPTIONAL324=null;
		ParserRuleReturnScope groupGraphPattern325 =null;

		CommonTree OPTIONAL324_tree=null;
		RewriteRuleTokenStream stream_OPTIONAL=new RewriteRuleTokenStream(adaptor,"token OPTIONAL");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:606:5: ( OPTIONAL groupGraphPattern -> ^( OPTIONAL groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:606:7: OPTIONAL groupGraphPattern
			{
			OPTIONAL324=(Token)match(input,OPTIONAL,FOLLOW_OPTIONAL_in_optionalGraphPattern3855);  
			stream_OPTIONAL.add(OPTIONAL324);

			pushFollow(FOLLOW_groupGraphPattern_in_optionalGraphPattern3857);
			groupGraphPattern325=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern325.getTree());
			// AST REWRITE
			// elements: groupGraphPattern, OPTIONAL
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 606:34: -> ^( OPTIONAL groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:606:37: ^( OPTIONAL groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_OPTIONAL.nextNode(), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionalGraphPattern"


	public static class graphGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:1: graphGraphPattern : GRAPH varOrIRIref groupGraphPattern -> ^( GRAPH varOrIRIref groupGraphPattern ) ;
	public final SparqlifyConfigParser.graphGraphPattern_return graphGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.graphGraphPattern_return retval = new SparqlifyConfigParser.graphGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GRAPH326=null;
		ParserRuleReturnScope varOrIRIref327 =null;
		ParserRuleReturnScope groupGraphPattern328 =null;

		CommonTree GRAPH326_tree=null;
		RewriteRuleTokenStream stream_GRAPH=new RewriteRuleTokenStream(adaptor,"token GRAPH");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:610:5: ( GRAPH varOrIRIref groupGraphPattern -> ^( GRAPH varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:610:7: GRAPH varOrIRIref groupGraphPattern
			{
			GRAPH326=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_graphGraphPattern3882);  
			stream_GRAPH.add(GRAPH326);

			pushFollow(FOLLOW_varOrIRIref_in_graphGraphPattern3884);
			varOrIRIref327=varOrIRIref();
			state._fsp--;

			stream_varOrIRIref.add(varOrIRIref327.getTree());
			pushFollow(FOLLOW_groupGraphPattern_in_graphGraphPattern3886);
			groupGraphPattern328=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern328.getTree());
			// AST REWRITE
			// elements: groupGraphPattern, varOrIRIref, GRAPH
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 610:43: -> ^( GRAPH varOrIRIref groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:610:46: ^( GRAPH varOrIRIref groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_GRAPH.nextNode(), root_1);
				adaptor.addChild(root_1, stream_varOrIRIref.nextTree());
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphGraphPattern"


	public static class serviceGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "serviceGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:613:1: serviceGraphPattern : SERVICE ( SILENT )? varOrIRIref groupGraphPattern -> ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) ;
	public final SparqlifyConfigParser.serviceGraphPattern_return serviceGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.serviceGraphPattern_return retval = new SparqlifyConfigParser.serviceGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SERVICE329=null;
		Token SILENT330=null;
		ParserRuleReturnScope varOrIRIref331 =null;
		ParserRuleReturnScope groupGraphPattern332 =null;

		CommonTree SERVICE329_tree=null;
		CommonTree SILENT330_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_SERVICE=new RewriteRuleTokenStream(adaptor,"token SERVICE");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:614:5: ( SERVICE ( SILENT )? varOrIRIref groupGraphPattern -> ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:614:7: SERVICE ( SILENT )? varOrIRIref groupGraphPattern
			{
			SERVICE329=(Token)match(input,SERVICE,FOLLOW_SERVICE_in_serviceGraphPattern3913);  
			stream_SERVICE.add(SERVICE329);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:614:15: ( SILENT )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==SILENT) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:614:15: SILENT
					{
					SILENT330=(Token)match(input,SILENT,FOLLOW_SILENT_in_serviceGraphPattern3915);  
					stream_SILENT.add(SILENT330);

					}
					break;

			}

			pushFollow(FOLLOW_varOrIRIref_in_serviceGraphPattern3918);
			varOrIRIref331=varOrIRIref();
			state._fsp--;

			stream_varOrIRIref.add(varOrIRIref331.getTree());
			pushFollow(FOLLOW_groupGraphPattern_in_serviceGraphPattern3920);
			groupGraphPattern332=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern332.getTree());
			// AST REWRITE
			// elements: SERVICE, groupGraphPattern, varOrIRIref, SILENT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 614:53: -> ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:614:56: ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_SERVICE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:614:66: ( SILENT )?
				if ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_varOrIRIref.nextTree());
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "serviceGraphPattern"


	public static class bind_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bind"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:617:1: bind : BIND OPEN_BRACE expression AS var CLOSE_BRACE -> ^( BIND expression ^( AS var ) ) ;
	public final SparqlifyConfigParser.bind_return bind() throws RecognitionException {
		SparqlifyConfigParser.bind_return retval = new SparqlifyConfigParser.bind_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BIND333=null;
		Token OPEN_BRACE334=null;
		Token AS336=null;
		Token CLOSE_BRACE338=null;
		ParserRuleReturnScope expression335 =null;
		ParserRuleReturnScope var337 =null;

		CommonTree BIND333_tree=null;
		CommonTree OPEN_BRACE334_tree=null;
		CommonTree AS336_tree=null;
		CommonTree CLOSE_BRACE338_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_BIND=new RewriteRuleTokenStream(adaptor,"token BIND");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:618:5: ( BIND OPEN_BRACE expression AS var CLOSE_BRACE -> ^( BIND expression ^( AS var ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:618:7: BIND OPEN_BRACE expression AS var CLOSE_BRACE
			{
			BIND333=(Token)match(input,BIND,FOLLOW_BIND_in_bind3954);  
			stream_BIND.add(BIND333);

			OPEN_BRACE334=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_bind3956);  
			stream_OPEN_BRACE.add(OPEN_BRACE334);

			pushFollow(FOLLOW_expression_in_bind3958);
			expression335=expression();
			state._fsp--;

			stream_expression.add(expression335.getTree());
			AS336=(Token)match(input,AS,FOLLOW_AS_in_bind3960);  
			stream_AS.add(AS336);

			pushFollow(FOLLOW_var_in_bind3962);
			var337=var();
			state._fsp--;

			stream_var.add(var337.getTree());
			CLOSE_BRACE338=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_bind3964);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE338);

			// AST REWRITE
			// elements: expression, var, BIND, AS
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 618:53: -> ^( BIND expression ^( AS var ) )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:618:56: ^( BIND expression ^( AS var ) )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_BIND.nextNode(), root_1);
				adaptor.addChild(root_1, stream_expression.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:618:74: ^( AS var )
				{
				CommonTree root_2 = (CommonTree)adaptor.nil();
				root_2 = (CommonTree)adaptor.becomeRoot(stream_AS.nextNode(), root_2);
				adaptor.addChild(root_2, stream_var.nextTree());
				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bind"


	public static class minusGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "minusGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:621:1: minusGraphPattern : MINUS_KEYWORD groupGraphPattern -> ^( MINUS_KEYWORD groupGraphPattern ) ;
	public final SparqlifyConfigParser.minusGraphPattern_return minusGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.minusGraphPattern_return retval = new SparqlifyConfigParser.minusGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token MINUS_KEYWORD339=null;
		ParserRuleReturnScope groupGraphPattern340 =null;

		CommonTree MINUS_KEYWORD339_tree=null;
		RewriteRuleTokenStream stream_MINUS_KEYWORD=new RewriteRuleTokenStream(adaptor,"token MINUS_KEYWORD");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:622:5: ( MINUS_KEYWORD groupGraphPattern -> ^( MINUS_KEYWORD groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:622:7: MINUS_KEYWORD groupGraphPattern
			{
			MINUS_KEYWORD339=(Token)match(input,MINUS_KEYWORD,FOLLOW_MINUS_KEYWORD_in_minusGraphPattern4001);  
			stream_MINUS_KEYWORD.add(MINUS_KEYWORD339);

			pushFollow(FOLLOW_groupGraphPattern_in_minusGraphPattern4003);
			groupGraphPattern340=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern340.getTree());
			// AST REWRITE
			// elements: groupGraphPattern, MINUS_KEYWORD
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 622:39: -> ^( MINUS_KEYWORD groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:622:42: ^( MINUS_KEYWORD groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_MINUS_KEYWORD.nextNode(), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "minusGraphPattern"


	public static class groupOrUnionGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupOrUnionGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:625:1: groupOrUnionGraphPattern : (g1= groupGraphPattern -> $g1) ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )* ;
	public final SparqlifyConfigParser.groupOrUnionGraphPattern_return groupOrUnionGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.groupOrUnionGraphPattern_return retval = new SparqlifyConfigParser.groupOrUnionGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token UNION341=null;
		ParserRuleReturnScope g1 =null;
		ParserRuleReturnScope g2 =null;

		CommonTree UNION341_tree=null;
		RewriteRuleTokenStream stream_UNION=new RewriteRuleTokenStream(adaptor,"token UNION");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:5: ( (g1= groupGraphPattern -> $g1) ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:7: (g1= groupGraphPattern -> $g1) ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:7: (g1= groupGraphPattern -> $g1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:8: g1= groupGraphPattern
			{
			pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4031);
			g1=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(g1.getTree());
			// AST REWRITE
			// elements: g1
			// token labels: 
			// rule labels: retval, g1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_g1=new RewriteRuleSubtreeStream(adaptor,"rule g1",g1!=null?g1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 626:28: -> $g1
			{
				adaptor.addChild(root_0, stream_g1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:35: ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )*
			loop103:
			while (true) {
				int alt103=2;
				int LA103_0 = input.LA(1);
				if ( (LA103_0==UNION) ) {
					alt103=1;
				}

				switch (alt103) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:36: ( UNION g2= groupGraphPattern )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:36: ( UNION g2= groupGraphPattern )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:37: UNION g2= groupGraphPattern
					{
					UNION341=(Token)match(input,UNION,FOLLOW_UNION_in_groupOrUnionGraphPattern4039);  
					stream_UNION.add(UNION341);

					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4043);
					g2=groupGraphPattern();
					state._fsp--;

					stream_groupGraphPattern.add(g2.getTree());
					}

					// AST REWRITE
					// elements: g2, groupOrUnionGraphPattern, UNION
					// token labels: 
					// rule labels: retval, g2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_g2=new RewriteRuleSubtreeStream(adaptor,"rule g2",g2!=null?g2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 626:65: -> ^( UNION $groupOrUnionGraphPattern $g2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:626:68: ^( UNION $groupOrUnionGraphPattern $g2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_UNION.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_g2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop103;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupOrUnionGraphPattern"


	public static class filter_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "filter"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:629:1: filter : FILTER constraint -> ^( FILTER constraint ) ;
	public final SparqlifyConfigParser.filter_return filter() throws RecognitionException {
		SparqlifyConfigParser.filter_return retval = new SparqlifyConfigParser.filter_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token FILTER342=null;
		ParserRuleReturnScope constraint343 =null;

		CommonTree FILTER342_tree=null;
		RewriteRuleTokenStream stream_FILTER=new RewriteRuleTokenStream(adaptor,"token FILTER");
		RewriteRuleSubtreeStream stream_constraint=new RewriteRuleSubtreeStream(adaptor,"rule constraint");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:630:5: ( FILTER constraint -> ^( FILTER constraint ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:630:7: FILTER constraint
			{
			FILTER342=(Token)match(input,FILTER,FOLLOW_FILTER_in_filter4075);  
			stream_FILTER.add(FILTER342);

			pushFollow(FOLLOW_constraint_in_filter4077);
			constraint343=constraint();
			state._fsp--;

			stream_constraint.add(constraint343.getTree());
			// AST REWRITE
			// elements: FILTER, constraint
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 630:25: -> ^( FILTER constraint )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:630:28: ^( FILTER constraint )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_FILTER.nextNode(), root_1);
				adaptor.addChild(root_1, stream_constraint.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "filter"


	public static class constraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:1: constraint : ( brackettedExpression | builtInCall | functionCall );
	public final SparqlifyConfigParser.constraint_return constraint() throws RecognitionException {
		SparqlifyConfigParser.constraint_return retval = new SparqlifyConfigParser.constraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope brackettedExpression344 =null;
		ParserRuleReturnScope builtInCall345 =null;
		ParserRuleReturnScope functionCall346 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:634:5: ( brackettedExpression | builtInCall | functionCall )
			int alt104=3;
			switch ( input.LA(1) ) {
			case OPEN_BRACE:
				{
				alt104=1;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt104=2;
				}
				break;
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt104=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}
			switch (alt104) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:634:7: brackettedExpression
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_brackettedExpression_in_constraint4102);
					brackettedExpression344=brackettedExpression();
					state._fsp--;

					adaptor.addChild(root_0, brackettedExpression344.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:635:7: builtInCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_builtInCall_in_constraint4110);
					builtInCall345=builtInCall();
					state._fsp--;

					adaptor.addChild(root_0, builtInCall345.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:636:7: functionCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_functionCall_in_constraint4118);
					functionCall346=functionCall();
					state._fsp--;

					adaptor.addChild(root_0, functionCall346.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constraint"


	public static class functionCall_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:639:1: functionCall : iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) ;
	public final SparqlifyConfigParser.functionCall_return functionCall() throws RecognitionException {
		SparqlifyConfigParser.functionCall_return retval = new SparqlifyConfigParser.functionCall_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef347 =null;
		ParserRuleReturnScope argList348 =null;

		RewriteRuleSubtreeStream stream_argList=new RewriteRuleSubtreeStream(adaptor,"rule argList");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:640:5: ( iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:640:7: iriRef argList
			{
			pushFollow(FOLLOW_iriRef_in_functionCall4135);
			iriRef347=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef347.getTree());
			pushFollow(FOLLOW_argList_in_functionCall4137);
			argList348=argList();
			state._fsp--;

			stream_argList.add(argList348.getTree());
			// AST REWRITE
			// elements: iriRef, argList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 640:22: -> ^( FUNCTION iriRef ^( ARG_LIST argList ) )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:640:25: ^( FUNCTION iriRef ^( ARG_LIST argList ) )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION, "FUNCTION"), root_1);
				adaptor.addChild(root_1, stream_iriRef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:640:43: ^( ARG_LIST argList )
				{
				CommonTree root_2 = (CommonTree)adaptor.nil();
				root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ARG_LIST, "ARG_LIST"), root_2);
				adaptor.addChild(root_2, stream_argList.nextTree());
				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionCall"


	public static class argList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "argList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:643:1: argList : ( nil -> nil | OPEN_BRACE ( DISTINCT )? expression ( COMMA expression )* CLOSE_BRACE -> ( DISTINCT )? ( expression )* );
	public final SparqlifyConfigParser.argList_return argList() throws RecognitionException {
		SparqlifyConfigParser.argList_return retval = new SparqlifyConfigParser.argList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE350=null;
		Token DISTINCT351=null;
		Token COMMA353=null;
		Token CLOSE_BRACE355=null;
		ParserRuleReturnScope nil349 =null;
		ParserRuleReturnScope expression352 =null;
		ParserRuleReturnScope expression354 =null;

		CommonTree OPEN_BRACE350_tree=null;
		CommonTree DISTINCT351_tree=null;
		CommonTree COMMA353_tree=null;
		CommonTree CLOSE_BRACE355_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:644:5: ( nil -> nil | OPEN_BRACE ( DISTINCT )? expression ( COMMA expression )* CLOSE_BRACE -> ( DISTINCT )? ( expression )* )
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==OPEN_BRACE) ) {
				int LA107_1 = input.LA(2);
				if ( (LA107_1==CLOSE_BRACE) ) {
					alt107=1;
				}
				else if ( (LA107_1==ABS||LA107_1==AVG||(LA107_1 >= BNODE && LA107_1 <= BOUND)||LA107_1==CEIL||LA107_1==COALESCE||LA107_1==CONCAT||LA107_1==CONTAINS||LA107_1==COUNT||(LA107_1 >= DATATYPE && LA107_1 <= DECIMAL_POSITIVE)||LA107_1==DISTINCT||(LA107_1 >= DOUBLE && LA107_1 <= DOUBLE_POSITIVE)||LA107_1==ENCODE_FOR_URI||LA107_1==EXISTS||LA107_1==FALSE||LA107_1==FLOOR||LA107_1==GROUP_CONCAT||(LA107_1 >= HOURS && LA107_1 <= IF)||(LA107_1 >= INTEGER && LA107_1 <= INTEGER_POSITIVE)||(LA107_1 >= IRI && LA107_1 <= IRI_REF)||(LA107_1 >= ISBLANK && LA107_1 <= ISURI)||(LA107_1 >= LANG && LA107_1 <= LANGMATCHES)||LA107_1==LCASE||(LA107_1 >= MAX && LA107_1 <= MINUS)||LA107_1==MINUTES||LA107_1==MONTH||LA107_1==NAME||LA107_1==NEGATION||LA107_1==NOT||LA107_1==NOW||LA107_1==OPEN_BRACE||(LA107_1 >= PLUS && LA107_1 <= PNAME_NS)||LA107_1==RAND||LA107_1==REGEX||(LA107_1 >= ROUND && LA107_1 <= SECONDS)||(LA107_1 >= SHA1 && LA107_1 <= SHA512)||(LA107_1 >= STR && LA107_1 <= STRENDS)||(LA107_1 >= STRING_LITERAL1 && LA107_1 <= STRSTARTS)||(LA107_1 >= SUBSTR && LA107_1 <= SUM)||LA107_1==TIMEZONE||LA107_1==TRUE||(LA107_1 >= TZ && LA107_1 <= UCASE)||LA107_1==URI||(LA107_1 >= VAR1 && LA107_1 <= VAR3)||LA107_1==YEAR) ) {
					alt107=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 107, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 107, 0, input);
				throw nvae;
			}

			switch (alt107) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:644:7: nil
					{
					pushFollow(FOLLOW_nil_in_argList4168);
					nil349=nil();
					state._fsp--;

					stream_nil.add(nil349.getTree());
					// AST REWRITE
					// elements: nil
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 644:11: -> nil
					{
						adaptor.addChild(root_0, stream_nil.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:645:7: OPEN_BRACE ( DISTINCT )? expression ( COMMA expression )* CLOSE_BRACE
					{
					OPEN_BRACE350=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_argList4180);  
					stream_OPEN_BRACE.add(OPEN_BRACE350);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:645:18: ( DISTINCT )?
					int alt105=2;
					int LA105_0 = input.LA(1);
					if ( (LA105_0==DISTINCT) ) {
						alt105=1;
					}
					switch (alt105) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:645:18: DISTINCT
							{
							DISTINCT351=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_argList4182);  
							stream_DISTINCT.add(DISTINCT351);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_argList4185);
					expression352=expression();
					state._fsp--;

					stream_expression.add(expression352.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:645:39: ( COMMA expression )*
					loop106:
					while (true) {
						int alt106=2;
						int LA106_0 = input.LA(1);
						if ( (LA106_0==COMMA) ) {
							alt106=1;
						}

						switch (alt106) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:645:41: COMMA expression
							{
							COMMA353=(Token)match(input,COMMA,FOLLOW_COMMA_in_argList4189);  
							stream_COMMA.add(COMMA353);

							pushFollow(FOLLOW_expression_in_argList4191);
							expression354=expression();
							state._fsp--;

							stream_expression.add(expression354.getTree());
							}
							break;

						default :
							break loop106;
						}
					}

					CLOSE_BRACE355=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_argList4196);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE355);

					// AST REWRITE
					// elements: DISTINCT, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 645:73: -> ( DISTINCT )? ( expression )*
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:645:76: ( DISTINCT )?
						if ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_0, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:645:86: ( expression )*
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_0, stream_expression.nextTree());
						}
						stream_expression.reset();

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "argList"


	public static class expressionList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "expressionList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:649:1: expressionList : ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE ) -> ^( EXPRESSION_LIST ( nil )* ( expression )* ) ;
	public final SparqlifyConfigParser.expressionList_return expressionList() throws RecognitionException {
		SparqlifyConfigParser.expressionList_return retval = new SparqlifyConfigParser.expressionList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE357=null;
		Token COMMA359=null;
		Token CLOSE_BRACE361=null;
		ParserRuleReturnScope nil356 =null;
		ParserRuleReturnScope expression358 =null;
		ParserRuleReturnScope expression360 =null;

		CommonTree OPEN_BRACE357_tree=null;
		CommonTree COMMA359_tree=null;
		CommonTree CLOSE_BRACE361_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:5: ( ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE ) -> ^( EXPRESSION_LIST ( nil )* ( expression )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:7: ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:7: ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE )
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==OPEN_BRACE) ) {
				int LA109_1 = input.LA(2);
				if ( (LA109_1==CLOSE_BRACE) ) {
					alt109=1;
				}
				else if ( (LA109_1==ABS||LA109_1==AVG||(LA109_1 >= BNODE && LA109_1 <= BOUND)||LA109_1==CEIL||LA109_1==COALESCE||LA109_1==CONCAT||LA109_1==CONTAINS||LA109_1==COUNT||(LA109_1 >= DATATYPE && LA109_1 <= DECIMAL_POSITIVE)||(LA109_1 >= DOUBLE && LA109_1 <= DOUBLE_POSITIVE)||LA109_1==ENCODE_FOR_URI||LA109_1==EXISTS||LA109_1==FALSE||LA109_1==FLOOR||LA109_1==GROUP_CONCAT||(LA109_1 >= HOURS && LA109_1 <= IF)||(LA109_1 >= INTEGER && LA109_1 <= INTEGER_POSITIVE)||(LA109_1 >= IRI && LA109_1 <= IRI_REF)||(LA109_1 >= ISBLANK && LA109_1 <= ISURI)||(LA109_1 >= LANG && LA109_1 <= LANGMATCHES)||LA109_1==LCASE||(LA109_1 >= MAX && LA109_1 <= MINUS)||LA109_1==MINUTES||LA109_1==MONTH||LA109_1==NAME||LA109_1==NEGATION||LA109_1==NOT||LA109_1==NOW||LA109_1==OPEN_BRACE||(LA109_1 >= PLUS && LA109_1 <= PNAME_NS)||LA109_1==RAND||LA109_1==REGEX||(LA109_1 >= ROUND && LA109_1 <= SECONDS)||(LA109_1 >= SHA1 && LA109_1 <= SHA512)||(LA109_1 >= STR && LA109_1 <= STRENDS)||(LA109_1 >= STRING_LITERAL1 && LA109_1 <= STRSTARTS)||(LA109_1 >= SUBSTR && LA109_1 <= SUM)||LA109_1==TIMEZONE||LA109_1==TRUE||(LA109_1 >= TZ && LA109_1 <= UCASE)||LA109_1==URI||(LA109_1 >= VAR1 && LA109_1 <= VAR3)||LA109_1==YEAR) ) {
					alt109=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 109, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 109, 0, input);
				throw nvae;
			}

			switch (alt109) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:9: nil
					{
					pushFollow(FOLLOW_nil_in_expressionList4224);
					nil356=nil();
					state._fsp--;

					stream_nil.add(nil356.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:15: OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE
					{
					OPEN_BRACE357=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_expressionList4228);  
					stream_OPEN_BRACE.add(OPEN_BRACE357);

					pushFollow(FOLLOW_expression_in_expressionList4230);
					expression358=expression();
					state._fsp--;

					stream_expression.add(expression358.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:37: ( COMMA expression )*
					loop108:
					while (true) {
						int alt108=2;
						int LA108_0 = input.LA(1);
						if ( (LA108_0==COMMA) ) {
							alt108=1;
						}

						switch (alt108) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:39: COMMA expression
							{
							COMMA359=(Token)match(input,COMMA,FOLLOW_COMMA_in_expressionList4234);  
							stream_COMMA.add(COMMA359);

							pushFollow(FOLLOW_expression_in_expressionList4236);
							expression360=expression();
							state._fsp--;

							stream_expression.add(expression360.getTree());
							}
							break;

						default :
							break loop108;
						}
					}

					CLOSE_BRACE361=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_expressionList4241);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE361);

					}
					break;

			}

			// AST REWRITE
			// elements: nil, expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 650:73: -> ^( EXPRESSION_LIST ( nil )* ( expression )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:76: ^( EXPRESSION_LIST ( nil )* ( expression )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(EXPRESSION_LIST, "EXPRESSION_LIST"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:94: ( nil )*
				while ( stream_nil.hasNext() ) {
					adaptor.addChild(root_1, stream_nil.nextTree());
				}
				stream_nil.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:99: ( expression )*
				while ( stream_expression.hasNext() ) {
					adaptor.addChild(root_1, stream_expression.nextTree());
				}
				stream_expression.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "expressionList"


	public static class constructTemplateQuads_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructTemplateQuads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:660:1: constructTemplateQuads : quadPattern -> ^( CONSTRUCT_QUADS quadPattern ) ;
	public final SparqlifyConfigParser.constructTemplateQuads_return constructTemplateQuads() throws RecognitionException {
		SparqlifyConfigParser.constructTemplateQuads_return retval = new SparqlifyConfigParser.constructTemplateQuads_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope quadPattern362 =null;

		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:661:5: ( quadPattern -> ^( CONSTRUCT_QUADS quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:661:7: quadPattern
			{
			pushFollow(FOLLOW_quadPattern_in_constructTemplateQuads4277);
			quadPattern362=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern362.getTree());
			// AST REWRITE
			// elements: quadPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 661:19: -> ^( CONSTRUCT_QUADS quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:661:22: ^( CONSTRUCT_QUADS quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRUCT_QUADS, "CONSTRUCT_QUADS"), root_1);
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructTemplateQuads"


	public static class constructTemplate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:665:1: constructTemplate : OPEN_CURLY_BRACE ( constructTriples )? CLOSE_CURLY_BRACE -> ^( CONSTRUCT_TRIPLES ( constructTriples )? ) ;
	public final SparqlifyConfigParser.constructTemplate_return constructTemplate() throws RecognitionException {
		SparqlifyConfigParser.constructTemplate_return retval = new SparqlifyConfigParser.constructTemplate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_CURLY_BRACE363=null;
		Token CLOSE_CURLY_BRACE365=null;
		ParserRuleReturnScope constructTriples364 =null;

		CommonTree OPEN_CURLY_BRACE363_tree=null;
		CommonTree CLOSE_CURLY_BRACE365_tree=null;
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_constructTriples=new RewriteRuleSubtreeStream(adaptor,"rule constructTriples");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:666:5: ( OPEN_CURLY_BRACE ( constructTriples )? CLOSE_CURLY_BRACE -> ^( CONSTRUCT_TRIPLES ( constructTriples )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:666:7: OPEN_CURLY_BRACE ( constructTriples )? CLOSE_CURLY_BRACE
			{
			OPEN_CURLY_BRACE363=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_constructTemplate4303);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE363);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:666:24: ( constructTriples )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==BLANK_NODE_LABEL||(LA110_0 >= DECIMAL && LA110_0 <= DECIMAL_POSITIVE)||(LA110_0 >= DOUBLE && LA110_0 <= DOUBLE_POSITIVE)||LA110_0==FALSE||(LA110_0 >= INTEGER && LA110_0 <= INTEGER_POSITIVE)||LA110_0==IRI_REF||LA110_0==OPEN_BRACE||LA110_0==OPEN_SQUARE_BRACKET||(LA110_0 >= PNAME_LN && LA110_0 <= PNAME_NS)||(LA110_0 >= STRING_LITERAL1 && LA110_0 <= STRING_LITERAL_LONG2)||LA110_0==TRUE||(LA110_0 >= VAR1 && LA110_0 <= VAR3)) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:666:24: constructTriples
					{
					pushFollow(FOLLOW_constructTriples_in_constructTemplate4305);
					constructTriples364=constructTriples();
					state._fsp--;

					stream_constructTriples.add(constructTriples364.getTree());
					}
					break;

			}

			CLOSE_CURLY_BRACE365=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_constructTemplate4308);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE365);

			// AST REWRITE
			// elements: constructTriples
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 666:60: -> ^( CONSTRUCT_TRIPLES ( constructTriples )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:666:63: ^( CONSTRUCT_TRIPLES ( constructTriples )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRUCT_TRIPLES, "CONSTRUCT_TRIPLES"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:666:83: ( constructTriples )?
				if ( stream_constructTriples.hasNext() ) {
					adaptor.addChild(root_1, stream_constructTriples.nextTree());
				}
				stream_constructTriples.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructTemplate"


	public static class constructTriples_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:669:1: constructTriples : triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ( triplesSameSubject )+ ;
	public final SparqlifyConfigParser.constructTriples_return constructTriples() throws RecognitionException {
		SparqlifyConfigParser.constructTriples_return retval = new SparqlifyConfigParser.constructTriples_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT367=null;
		Token DOT369=null;
		ParserRuleReturnScope triplesSameSubject366 =null;
		ParserRuleReturnScope triplesSameSubject368 =null;

		CommonTree DOT367_tree=null;
		CommonTree DOT369_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesSameSubject=new RewriteRuleSubtreeStream(adaptor,"rule triplesSameSubject");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:670:5: ( triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ( triplesSameSubject )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:670:7: triplesSameSubject ( DOT triplesSameSubject )* ( DOT )?
			{
			pushFollow(FOLLOW_triplesSameSubject_in_constructTriples4334);
			triplesSameSubject366=triplesSameSubject();
			state._fsp--;

			stream_triplesSameSubject.add(triplesSameSubject366.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:670:26: ( DOT triplesSameSubject )*
			loop111:
			while (true) {
				int alt111=2;
				int LA111_0 = input.LA(1);
				if ( (LA111_0==DOT) ) {
					int LA111_1 = input.LA(2);
					if ( (LA111_1==BLANK_NODE_LABEL||(LA111_1 >= DECIMAL && LA111_1 <= DECIMAL_POSITIVE)||(LA111_1 >= DOUBLE && LA111_1 <= DOUBLE_POSITIVE)||LA111_1==FALSE||(LA111_1 >= INTEGER && LA111_1 <= INTEGER_POSITIVE)||LA111_1==IRI_REF||LA111_1==OPEN_BRACE||LA111_1==OPEN_SQUARE_BRACKET||(LA111_1 >= PNAME_LN && LA111_1 <= PNAME_NS)||(LA111_1 >= STRING_LITERAL1 && LA111_1 <= STRING_LITERAL_LONG2)||LA111_1==TRUE||(LA111_1 >= VAR1 && LA111_1 <= VAR3)) ) {
						alt111=1;
					}

				}

				switch (alt111) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:670:28: DOT triplesSameSubject
					{
					DOT367=(Token)match(input,DOT,FOLLOW_DOT_in_constructTriples4338);  
					stream_DOT.add(DOT367);

					pushFollow(FOLLOW_triplesSameSubject_in_constructTriples4340);
					triplesSameSubject368=triplesSameSubject();
					state._fsp--;

					stream_triplesSameSubject.add(triplesSameSubject368.getTree());
					}
					break;

				default :
					break loop111;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:670:54: ( DOT )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==DOT) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:670:54: DOT
					{
					DOT369=(Token)match(input,DOT,FOLLOW_DOT_in_constructTriples4345);  
					stream_DOT.add(DOT369);

					}
					break;

			}

			// AST REWRITE
			// elements: triplesSameSubject
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 670:59: -> ( triplesSameSubject )+
			{
				if ( !(stream_triplesSameSubject.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_triplesSameSubject.hasNext() ) {
					adaptor.addChild(root_0, stream_triplesSameSubject.nextTree());
				}
				stream_triplesSameSubject.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructTriples"


	public static class triplesSameSubject_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesSameSubject"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:677:1: triplesSameSubject : ( varOrTerm propertyListNotEmpty[(CommonTree) $varOrTerm.tree] -> propertyListNotEmpty | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) ) );
	public final SparqlifyConfigParser.triplesSameSubject_return triplesSameSubject() throws RecognitionException {
		SparqlifyConfigParser.triplesSameSubject_return retval = new SparqlifyConfigParser.triplesSameSubject_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope t =null;
		ParserRuleReturnScope p =null;
		ParserRuleReturnScope varOrTerm370 =null;
		ParserRuleReturnScope propertyListNotEmpty371 =null;

		RewriteRuleSubtreeStream stream_varOrTerm=new RewriteRuleSubtreeStream(adaptor,"rule varOrTerm");
		RewriteRuleSubtreeStream stream_propertyListNotEmpty=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmpty");
		RewriteRuleSubtreeStream stream_triplesNode=new RewriteRuleSubtreeStream(adaptor,"rule triplesNode");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:678:5: ( varOrTerm propertyListNotEmpty[(CommonTree) $varOrTerm.tree] -> propertyListNotEmpty | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) ) )
			int alt114=2;
			switch ( input.LA(1) ) {
			case BLANK_NODE_LABEL:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case FALSE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case TRUE:
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt114=1;
				}
				break;
			case OPEN_SQUARE_BRACKET:
				{
				int LA114_2 = input.LA(2);
				if ( (LA114_2==CLOSE_SQUARE_BRACKET) ) {
					alt114=1;
				}
				else if ( (LA114_2==A||LA114_2==IRI_REF||(LA114_2 >= PNAME_LN && LA114_2 <= PNAME_NS)||(LA114_2 >= VAR1 && LA114_2 <= VAR3)) ) {
					alt114=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 114, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case OPEN_BRACE:
				{
				int LA114_3 = input.LA(2);
				if ( (LA114_3==CLOSE_BRACE) ) {
					alt114=1;
				}
				else if ( (LA114_3==BLANK_NODE_LABEL||(LA114_3 >= DECIMAL && LA114_3 <= DECIMAL_POSITIVE)||(LA114_3 >= DOUBLE && LA114_3 <= DOUBLE_POSITIVE)||LA114_3==FALSE||(LA114_3 >= INTEGER && LA114_3 <= INTEGER_POSITIVE)||LA114_3==IRI_REF||LA114_3==OPEN_BRACE||LA114_3==OPEN_SQUARE_BRACKET||(LA114_3 >= PNAME_LN && LA114_3 <= PNAME_NS)||(LA114_3 >= STRING_LITERAL1 && LA114_3 <= STRING_LITERAL_LONG2)||LA114_3==TRUE||(LA114_3 >= VAR1 && LA114_3 <= VAR3)) ) {
					alt114=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 114, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 114, 0, input);
				throw nvae;
			}
			switch (alt114) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:678:7: varOrTerm propertyListNotEmpty[(CommonTree) $varOrTerm.tree]
					{
					pushFollow(FOLLOW_varOrTerm_in_triplesSameSubject4370);
					varOrTerm370=varOrTerm();
					state._fsp--;

					stream_varOrTerm.add(varOrTerm370.getTree());
					pushFollow(FOLLOW_propertyListNotEmpty_in_triplesSameSubject4372);
					propertyListNotEmpty371=propertyListNotEmpty((CommonTree) (varOrTerm370!=null?((CommonTree)varOrTerm370.getTree()):null));
					state._fsp--;

					stream_propertyListNotEmpty.add(propertyListNotEmpty371.getTree());
					// AST REWRITE
					// elements: propertyListNotEmpty
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 678:68: -> propertyListNotEmpty
					{
						adaptor.addChild(root_0, stream_propertyListNotEmpty.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:7: (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:7: (t= triplesNode -> $t)
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:8: t= triplesNode
					{
					pushFollow(FOLLOW_triplesNode_in_triplesSameSubject4388);
					t=triplesNode();
					state._fsp--;

					stream_triplesNode.add(t.getTree());
					// AST REWRITE
					// elements: t
					// token labels: 
					// rule labels: retval, t
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_t=new RewriteRuleSubtreeStream(adaptor,"rule t",t!=null?t.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 679:22: -> $t
					{
						adaptor.addChild(root_0, stream_t.nextTree());
					}


					retval.tree = root_0;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:29: ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:30: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:31: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					int alt113=2;
					int LA113_0 = input.LA(1);
					if ( (LA113_0==A||LA113_0==IRI_REF||(LA113_0 >= PNAME_LN && LA113_0 <= PNAME_NS)||(LA113_0 >= VAR1 && LA113_0 <= VAR3)) ) {
						alt113=1;
					}
					switch (alt113) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:31: p= propertyListNotEmpty[(CommonTree) $t.tree]
							{
							pushFollow(FOLLOW_propertyListNotEmpty_in_triplesSameSubject4399);
							p=propertyListNotEmpty((CommonTree) (t!=null?((CommonTree)t.getTree()):null));
							state._fsp--;

							stream_propertyListNotEmpty.add(p.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: triplesSameSubject, p
					// token labels: 
					// rule labels: retval, p
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_p=new RewriteRuleSubtreeStream(adaptor,"rule p",p!=null?p.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 679:76: -> ^( TRIPLE $triplesSameSubject ( $p)? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:79: ^( TRIPLE $triplesSameSubject ( $p)? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:679:109: ( $p)?
						if ( stream_p.hasNext() ) {
							adaptor.addChild(root_1, stream_p.nextTree());
						}
						stream_p.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesSameSubject"


	public static class propertyListNotEmpty_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "propertyListNotEmpty"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:682:1: propertyListNotEmpty[CommonTree subject] : v= verb objectList[subject, (CommonTree) $v.tree] ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ ;
	public final SparqlifyConfigParser.propertyListNotEmpty_return propertyListNotEmpty(CommonTree subject) throws RecognitionException {
		SparqlifyConfigParser.propertyListNotEmpty_return retval = new SparqlifyConfigParser.propertyListNotEmpty_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SEMICOLON373=null;
		ParserRuleReturnScope v =null;
		ParserRuleReturnScope objectList372 =null;
		ParserRuleReturnScope objectList374 =null;

		CommonTree SEMICOLON373_tree=null;
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleSubtreeStream stream_verb=new RewriteRuleSubtreeStream(adaptor,"rule verb");
		RewriteRuleSubtreeStream stream_objectList=new RewriteRuleSubtreeStream(adaptor,"rule objectList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:683:5: (v= verb objectList[subject, (CommonTree) $v.tree] ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:683:7: v= verb objectList[subject, (CommonTree) $v.tree] ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )*
			{
			pushFollow(FOLLOW_verb_in_propertyListNotEmpty4435);
			v=verb();
			state._fsp--;

			stream_verb.add(v.getTree());
			pushFollow(FOLLOW_objectList_in_propertyListNotEmpty4437);
			objectList372=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
			state._fsp--;

			stream_objectList.add(objectList372.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:683:56: ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )*
			loop116:
			while (true) {
				int alt116=2;
				int LA116_0 = input.LA(1);
				if ( (LA116_0==SEMICOLON) ) {
					alt116=1;
				}

				switch (alt116) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:683:57: SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )?
					{
					SEMICOLON373=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_propertyListNotEmpty4441);  
					stream_SEMICOLON.add(SEMICOLON373);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:683:67: (v= verb objectList[subject, (CommonTree) $v.tree] )?
					int alt115=2;
					int LA115_0 = input.LA(1);
					if ( (LA115_0==A||LA115_0==IRI_REF||(LA115_0 >= PNAME_LN && LA115_0 <= PNAME_NS)||(LA115_0 >= VAR1 && LA115_0 <= VAR3)) ) {
						alt115=1;
					}
					switch (alt115) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:683:68: v= verb objectList[subject, (CommonTree) $v.tree]
							{
							pushFollow(FOLLOW_verb_in_propertyListNotEmpty4446);
							v=verb();
							state._fsp--;

							stream_verb.add(v.getTree());
							pushFollow(FOLLOW_objectList_in_propertyListNotEmpty4448);
							objectList374=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
							state._fsp--;

							stream_objectList.add(objectList374.getTree());
							}
							break;

					}

					}
					break;

				default :
					break loop116;
				}
			}

			// AST REWRITE
			// elements: objectList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 683:121: -> ( objectList )+
			{
				if ( !(stream_objectList.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_objectList.hasNext() ) {
					adaptor.addChild(root_0, stream_objectList.nextTree());
				}
				stream_objectList.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "propertyListNotEmpty"


	public static class objectList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "objectList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:1: objectList[CommonTree subject, CommonTree predicate] : graphNode ( COMMA graphNode )* -> ( ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) ) )+ ;
	public final SparqlifyConfigParser.objectList_return objectList(CommonTree subject, CommonTree predicate) throws RecognitionException {
		SparqlifyConfigParser.objectList_return retval = new SparqlifyConfigParser.objectList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COMMA376=null;
		ParserRuleReturnScope graphNode375 =null;
		ParserRuleReturnScope graphNode377 =null;

		CommonTree COMMA376_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_graphNode=new RewriteRuleSubtreeStream(adaptor,"rule graphNode");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:5: ( graphNode ( COMMA graphNode )* -> ( ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) ) )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:7: graphNode ( COMMA graphNode )*
			{
			pushFollow(FOLLOW_graphNode_in_objectList4477);
			graphNode375=graphNode();
			state._fsp--;

			stream_graphNode.add(graphNode375.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:17: ( COMMA graphNode )*
			loop117:
			while (true) {
				int alt117=2;
				int LA117_0 = input.LA(1);
				if ( (LA117_0==COMMA) ) {
					alt117=1;
				}

				switch (alt117) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:19: COMMA graphNode
					{
					COMMA376=(Token)match(input,COMMA,FOLLOW_COMMA_in_objectList4481);  
					stream_COMMA.add(COMMA376);

					pushFollow(FOLLOW_graphNode_in_objectList4483);
					graphNode377=graphNode();
					state._fsp--;

					stream_graphNode.add(graphNode377.getTree());
					}
					break;

				default :
					break loop117;
				}
			}

			// AST REWRITE
			// elements: graphNode
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 687:38: -> ( ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) ) )+
			{
				if ( !(stream_graphNode.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_graphNode.hasNext() ) {
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:41: ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) )
					{
					CommonTree root_1 = (CommonTree)adaptor.nil();
					root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:50: ^( SUBJECT )
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SUBJECT, "SUBJECT"), root_2);
					adaptor.addChild(root_2, subject.dupNode());
					adaptor.addChild(root_1, root_2);
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:81: ^( PREDICATE )
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PREDICATE, "PREDICATE"), root_2);
					adaptor.addChild(root_2, predicate.dupNode());
					adaptor.addChild(root_1, root_2);
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:687:116: ^( OBJECT graphNode )
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(OBJECT, "OBJECT"), root_2);
					adaptor.addChild(root_2, stream_graphNode.nextTree());
					adaptor.addChild(root_1, root_2);
					}

					adaptor.addChild(root_0, root_1);
					}

				}
				stream_graphNode.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "objectList"


	public static class verb_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "verb"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:701:1: verb : ( varOrIRIref | A );
	public final SparqlifyConfigParser.verb_return verb() throws RecognitionException {
		SparqlifyConfigParser.verb_return retval = new SparqlifyConfigParser.verb_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token A379=null;
		ParserRuleReturnScope varOrIRIref378 =null;

		CommonTree A379_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:702:5: ( varOrIRIref | A )
			int alt118=2;
			int LA118_0 = input.LA(1);
			if ( (LA118_0==IRI_REF||(LA118_0 >= PNAME_LN && LA118_0 <= PNAME_NS)||(LA118_0 >= VAR1 && LA118_0 <= VAR3)) ) {
				alt118=1;
			}
			else if ( (LA118_0==A) ) {
				alt118=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}

			switch (alt118) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:702:7: varOrIRIref
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_varOrIRIref_in_verb4533);
					varOrIRIref378=varOrIRIref();
					state._fsp--;

					adaptor.addChild(root_0, varOrIRIref378.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:703:7: A
					{
					root_0 = (CommonTree)adaptor.nil();


					A379=(Token)match(input,A,FOLLOW_A_in_verb4541); 
					A379_tree = (CommonTree)adaptor.create(A379);
					adaptor.addChild(root_0, A379_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "verb"


	public static class triplesSameSubjectPath_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesSameSubjectPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:706:1: triplesSameSubjectPath : ( varOrTerm propertyListNotEmptyPath[(CommonTree) $varOrTerm.tree] -> ^( TRIPLE propertyListNotEmptyPath ) | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) ) );
	public final SparqlifyConfigParser.triplesSameSubjectPath_return triplesSameSubjectPath() throws RecognitionException {
		SparqlifyConfigParser.triplesSameSubjectPath_return retval = new SparqlifyConfigParser.triplesSameSubjectPath_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope t =null;
		ParserRuleReturnScope p =null;
		ParserRuleReturnScope varOrTerm380 =null;
		ParserRuleReturnScope propertyListNotEmptyPath381 =null;

		RewriteRuleSubtreeStream stream_propertyListNotEmpty=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmpty");
		RewriteRuleSubtreeStream stream_varOrTerm=new RewriteRuleSubtreeStream(adaptor,"rule varOrTerm");
		RewriteRuleSubtreeStream stream_triplesNode=new RewriteRuleSubtreeStream(adaptor,"rule triplesNode");
		RewriteRuleSubtreeStream stream_propertyListNotEmptyPath=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmptyPath");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:707:5: ( varOrTerm propertyListNotEmptyPath[(CommonTree) $varOrTerm.tree] -> ^( TRIPLE propertyListNotEmptyPath ) | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) ) )
			int alt120=2;
			switch ( input.LA(1) ) {
			case BLANK_NODE_LABEL:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case FALSE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case TRUE:
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt120=1;
				}
				break;
			case OPEN_SQUARE_BRACKET:
				{
				int LA120_2 = input.LA(2);
				if ( (LA120_2==CLOSE_SQUARE_BRACKET) ) {
					alt120=1;
				}
				else if ( (LA120_2==A||LA120_2==IRI_REF||(LA120_2 >= PNAME_LN && LA120_2 <= PNAME_NS)||(LA120_2 >= VAR1 && LA120_2 <= VAR3)) ) {
					alt120=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 120, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case OPEN_BRACE:
				{
				int LA120_3 = input.LA(2);
				if ( (LA120_3==CLOSE_BRACE) ) {
					alt120=1;
				}
				else if ( (LA120_3==BLANK_NODE_LABEL||(LA120_3 >= DECIMAL && LA120_3 <= DECIMAL_POSITIVE)||(LA120_3 >= DOUBLE && LA120_3 <= DOUBLE_POSITIVE)||LA120_3==FALSE||(LA120_3 >= INTEGER && LA120_3 <= INTEGER_POSITIVE)||LA120_3==IRI_REF||LA120_3==OPEN_BRACE||LA120_3==OPEN_SQUARE_BRACKET||(LA120_3 >= PNAME_LN && LA120_3 <= PNAME_NS)||(LA120_3 >= STRING_LITERAL1 && LA120_3 <= STRING_LITERAL_LONG2)||LA120_3==TRUE||(LA120_3 >= VAR1 && LA120_3 <= VAR3)) ) {
					alt120=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 120, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 120, 0, input);
				throw nvae;
			}
			switch (alt120) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:707:7: varOrTerm propertyListNotEmptyPath[(CommonTree) $varOrTerm.tree]
					{
					pushFollow(FOLLOW_varOrTerm_in_triplesSameSubjectPath4558);
					varOrTerm380=varOrTerm();
					state._fsp--;

					stream_varOrTerm.add(varOrTerm380.getTree());
					pushFollow(FOLLOW_propertyListNotEmptyPath_in_triplesSameSubjectPath4560);
					propertyListNotEmptyPath381=propertyListNotEmptyPath((CommonTree) (varOrTerm380!=null?((CommonTree)varOrTerm380.getTree()):null));
					state._fsp--;

					stream_propertyListNotEmptyPath.add(propertyListNotEmptyPath381.getTree());
					// AST REWRITE
					// elements: propertyListNotEmptyPath
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 707:72: -> ^( TRIPLE propertyListNotEmptyPath )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:707:75: ^( TRIPLE propertyListNotEmptyPath )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_propertyListNotEmptyPath.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:7: (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:7: (t= triplesNode -> $t)
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:8: t= triplesNode
					{
					pushFollow(FOLLOW_triplesNode_in_triplesSameSubjectPath4580);
					t=triplesNode();
					state._fsp--;

					stream_triplesNode.add(t.getTree());
					// AST REWRITE
					// elements: t
					// token labels: 
					// rule labels: retval, t
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_t=new RewriteRuleSubtreeStream(adaptor,"rule t",t!=null?t.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 708:22: -> $t
					{
						adaptor.addChild(root_0, stream_t.nextTree());
					}


					retval.tree = root_0;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:29: ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:30: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:31: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					int alt119=2;
					int LA119_0 = input.LA(1);
					if ( (LA119_0==A||LA119_0==IRI_REF||(LA119_0 >= PNAME_LN && LA119_0 <= PNAME_NS)||(LA119_0 >= VAR1 && LA119_0 <= VAR3)) ) {
						alt119=1;
					}
					switch (alt119) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:31: p= propertyListNotEmpty[(CommonTree) $t.tree]
							{
							pushFollow(FOLLOW_propertyListNotEmpty_in_triplesSameSubjectPath4591);
							p=propertyListNotEmpty((CommonTree) (t!=null?((CommonTree)t.getTree()):null));
							state._fsp--;

							stream_propertyListNotEmpty.add(p.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: triplesSameSubjectPath, p
					// token labels: 
					// rule labels: retval, p
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_p=new RewriteRuleSubtreeStream(adaptor,"rule p",p!=null?p.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 708:76: -> ^( TRIPLE $triplesSameSubjectPath ( $p)? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:79: ^( TRIPLE $triplesSameSubjectPath ( $p)? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:113: ( $p)?
						if ( stream_p.hasNext() ) {
							adaptor.addChild(root_1, stream_p.nextTree());
						}
						stream_p.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesSameSubjectPath"


	public static class propertyListNotEmptyPath_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "propertyListNotEmptyPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:711:1: propertyListNotEmptyPath[CommonTree subject] : (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] ) ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ ;
	public final SparqlifyConfigParser.propertyListNotEmptyPath_return propertyListNotEmptyPath(CommonTree subject) throws RecognitionException {
		SparqlifyConfigParser.propertyListNotEmptyPath_return retval = new SparqlifyConfigParser.propertyListNotEmptyPath_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SEMICOLON384=null;
		ParserRuleReturnScope p =null;
		ParserRuleReturnScope v =null;
		ParserRuleReturnScope objectList382 =null;
		ParserRuleReturnScope objectList383 =null;
		ParserRuleReturnScope objectList385 =null;
		ParserRuleReturnScope objectList386 =null;

		CommonTree SEMICOLON384_tree=null;
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleSubtreeStream stream_verbPath=new RewriteRuleSubtreeStream(adaptor,"rule verbPath");
		RewriteRuleSubtreeStream stream_objectList=new RewriteRuleSubtreeStream(adaptor,"rule objectList");
		RewriteRuleSubtreeStream stream_verbSimple=new RewriteRuleSubtreeStream(adaptor,"rule verbSimple");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:5: ( (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] ) ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:7: (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] ) ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:7: (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )
			int alt121=2;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==A||LA121_0==INVERSE||LA121_0==IRI_REF||LA121_0==NEGATION||LA121_0==OPEN_BRACE||(LA121_0 >= PNAME_LN && LA121_0 <= PNAME_NS)) ) {
				alt121=1;
			}
			else if ( ((LA121_0 >= VAR1 && LA121_0 <= VAR3)) ) {
				alt121=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}

			switch (alt121) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:8: p= verbPath objectList[subject, (CommonTree) $p.tree]
					{
					pushFollow(FOLLOW_verbPath_in_propertyListNotEmptyPath4630);
					p=verbPath();
					state._fsp--;

					stream_verbPath.add(p.getTree());
					pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4633);
					objectList382=objectList(subject, (CommonTree) (p!=null?((CommonTree)p.getTree()):null));
					state._fsp--;

					stream_objectList.add(objectList382.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:63: v= verbSimple objectList[subject, (CommonTree) $v.tree]
					{
					pushFollow(FOLLOW_verbSimple_in_propertyListNotEmptyPath4639);
					v=verbSimple();
					state._fsp--;

					stream_verbSimple.add(v.getTree());
					pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4641);
					objectList383=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
					state._fsp--;

					stream_objectList.add(objectList383.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:119: ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )*
			loop123:
			while (true) {
				int alt123=2;
				int LA123_0 = input.LA(1);
				if ( (LA123_0==SEMICOLON) ) {
					alt123=1;
				}

				switch (alt123) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:120: SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )?
					{
					SEMICOLON384=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_propertyListNotEmptyPath4646);  
					stream_SEMICOLON.add(SEMICOLON384);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:130: (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )?
					int alt122=3;
					int LA122_0 = input.LA(1);
					if ( (LA122_0==A||LA122_0==INVERSE||LA122_0==IRI_REF||LA122_0==NEGATION||LA122_0==OPEN_BRACE||(LA122_0 >= PNAME_LN && LA122_0 <= PNAME_NS)) ) {
						alt122=1;
					}
					else if ( ((LA122_0 >= VAR1 && LA122_0 <= VAR3)) ) {
						alt122=2;
					}
					switch (alt122) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:131: p= verbPath objectList[subject, (CommonTree) $p.tree]
							{
							pushFollow(FOLLOW_verbPath_in_propertyListNotEmptyPath4651);
							p=verbPath();
							state._fsp--;

							stream_verbPath.add(p.getTree());
							pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4653);
							objectList385=objectList(subject, (CommonTree) (p!=null?((CommonTree)p.getTree()):null));
							state._fsp--;

							stream_objectList.add(objectList385.getTree());
							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:712:187: v= verbSimple objectList[subject, (CommonTree) $v.tree]
							{
							pushFollow(FOLLOW_verbSimple_in_propertyListNotEmptyPath4661);
							v=verbSimple();
							state._fsp--;

							stream_verbSimple.add(v.getTree());
							pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4664);
							objectList386=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
							state._fsp--;

							stream_objectList.add(objectList386.getTree());
							}
							break;

					}

					}
					break;

				default :
					break loop123;
				}
			}

			// AST REWRITE
			// elements: objectList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 712:248: -> ( objectList )+
			{
				if ( !(stream_objectList.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_objectList.hasNext() ) {
					adaptor.addChild(root_0, stream_objectList.nextTree());
				}
				stream_objectList.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "propertyListNotEmptyPath"


	public static class verbPath_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "verbPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:1: verbPath : path ;
	public final SparqlifyConfigParser.verbPath_return verbPath() throws RecognitionException {
		SparqlifyConfigParser.verbPath_return retval = new SparqlifyConfigParser.verbPath_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope path387 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:716:5: ( path )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:716:7: path
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_path_in_verbPath4696);
			path387=path();
			state._fsp--;

			adaptor.addChild(root_0, path387.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "verbPath"


	public static class verbSimple_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "verbSimple"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:1: verbSimple : var ;
	public final SparqlifyConfigParser.verbSimple_return verbSimple() throws RecognitionException {
		SparqlifyConfigParser.verbSimple_return retval = new SparqlifyConfigParser.verbSimple_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope var388 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:720:5: ( var )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:720:7: var
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_var_in_verbSimple4717);
			var388=var();
			state._fsp--;

			adaptor.addChild(root_0, var388.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "verbSimple"


	public static class path_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "path"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:723:1: path : pathSequence ( PIPE pathSequence )* -> PATH pathSequence ( PIPE pathSequence )* ;
	public final SparqlifyConfigParser.path_return path() throws RecognitionException {
		SparqlifyConfigParser.path_return retval = new SparqlifyConfigParser.path_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token PIPE390=null;
		ParserRuleReturnScope pathSequence389 =null;
		ParserRuleReturnScope pathSequence391 =null;

		CommonTree PIPE390_tree=null;
		RewriteRuleTokenStream stream_PIPE=new RewriteRuleTokenStream(adaptor,"token PIPE");
		RewriteRuleSubtreeStream stream_pathSequence=new RewriteRuleSubtreeStream(adaptor,"rule pathSequence");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:724:5: ( pathSequence ( PIPE pathSequence )* -> PATH pathSequence ( PIPE pathSequence )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:724:7: pathSequence ( PIPE pathSequence )*
			{
			pushFollow(FOLLOW_pathSequence_in_path4739);
			pathSequence389=pathSequence();
			state._fsp--;

			stream_pathSequence.add(pathSequence389.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:724:20: ( PIPE pathSequence )*
			loop124:
			while (true) {
				int alt124=2;
				int LA124_0 = input.LA(1);
				if ( (LA124_0==PIPE) ) {
					alt124=1;
				}

				switch (alt124) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:724:22: PIPE pathSequence
					{
					PIPE390=(Token)match(input,PIPE,FOLLOW_PIPE_in_path4743);  
					stream_PIPE.add(PIPE390);

					pushFollow(FOLLOW_pathSequence_in_path4745);
					pathSequence391=pathSequence();
					state._fsp--;

					stream_pathSequence.add(pathSequence391.getTree());
					}
					break;

				default :
					break loop124;
				}
			}

			// AST REWRITE
			// elements: pathSequence, pathSequence, PIPE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 724:43: -> PATH pathSequence ( PIPE pathSequence )*
			{
				adaptor.addChild(root_0, (CommonTree)adaptor.create(PATH, "PATH"));
				adaptor.addChild(root_0, stream_pathSequence.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:724:64: ( PIPE pathSequence )*
				while ( stream_pathSequence.hasNext()||stream_PIPE.hasNext() ) {
					adaptor.addChild(root_0, stream_PIPE.nextNode());
					adaptor.addChild(root_0, stream_pathSequence.nextTree());
				}
				stream_pathSequence.reset();
				stream_PIPE.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "path"


	public static class pathSequence_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathSequence"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:727:1: pathSequence : pathEltOrInverse ( DIVIDE pathEltOrInverse )* ;
	public final SparqlifyConfigParser.pathSequence_return pathSequence() throws RecognitionException {
		SparqlifyConfigParser.pathSequence_return retval = new SparqlifyConfigParser.pathSequence_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DIVIDE393=null;
		ParserRuleReturnScope pathEltOrInverse392 =null;
		ParserRuleReturnScope pathEltOrInverse394 =null;

		CommonTree DIVIDE393_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:728:5: ( pathEltOrInverse ( DIVIDE pathEltOrInverse )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:728:7: pathEltOrInverse ( DIVIDE pathEltOrInverse )*
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence4781);
			pathEltOrInverse392=pathEltOrInverse();
			state._fsp--;

			adaptor.addChild(root_0, pathEltOrInverse392.getTree());

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:728:24: ( DIVIDE pathEltOrInverse )*
			loop125:
			while (true) {
				int alt125=2;
				int LA125_0 = input.LA(1);
				if ( (LA125_0==DIVIDE) ) {
					alt125=1;
				}

				switch (alt125) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:728:26: DIVIDE pathEltOrInverse
					{
					DIVIDE393=(Token)match(input,DIVIDE,FOLLOW_DIVIDE_in_pathSequence4785); 
					DIVIDE393_tree = (CommonTree)adaptor.create(DIVIDE393);
					adaptor.addChild(root_0, DIVIDE393_tree);

					pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence4787);
					pathEltOrInverse394=pathEltOrInverse();
					state._fsp--;

					adaptor.addChild(root_0, pathEltOrInverse394.getTree());

					}
					break;

				default :
					break loop125;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathSequence"


	public static class pathElt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathElt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:731:1: pathElt : pathPrimary ( pathMod )? ;
	public final SparqlifyConfigParser.pathElt_return pathElt() throws RecognitionException {
		SparqlifyConfigParser.pathElt_return retval = new SparqlifyConfigParser.pathElt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope pathPrimary395 =null;
		ParserRuleReturnScope pathMod396 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:732:5: ( pathPrimary ( pathMod )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:732:7: pathPrimary ( pathMod )?
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_pathPrimary_in_pathElt4815);
			pathPrimary395=pathPrimary();
			state._fsp--;

			adaptor.addChild(root_0, pathPrimary395.getTree());

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:732:19: ( pathMod )?
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==ASTERISK||LA126_0==OPEN_CURLY_BRACE||LA126_0==PLUS||LA126_0==QUESTION_MARK) ) {
				alt126=1;
			}
			switch (alt126) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:732:19: pathMod
					{
					pushFollow(FOLLOW_pathMod_in_pathElt4817);
					pathMod396=pathMod();
					state._fsp--;

					adaptor.addChild(root_0, pathMod396.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathElt"


	public static class pathEltOrInverse_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathEltOrInverse"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:735:1: pathEltOrInverse : ( pathElt | INVERSE pathElt );
	public final SparqlifyConfigParser.pathEltOrInverse_return pathEltOrInverse() throws RecognitionException {
		SparqlifyConfigParser.pathEltOrInverse_return retval = new SparqlifyConfigParser.pathEltOrInverse_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INVERSE398=null;
		ParserRuleReturnScope pathElt397 =null;
		ParserRuleReturnScope pathElt399 =null;

		CommonTree INVERSE398_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:736:5: ( pathElt | INVERSE pathElt )
			int alt127=2;
			int LA127_0 = input.LA(1);
			if ( (LA127_0==A||LA127_0==IRI_REF||LA127_0==NEGATION||LA127_0==OPEN_BRACE||(LA127_0 >= PNAME_LN && LA127_0 <= PNAME_NS)) ) {
				alt127=1;
			}
			else if ( (LA127_0==INVERSE) ) {
				alt127=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 127, 0, input);
				throw nvae;
			}

			switch (alt127) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:736:7: pathElt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse4839);
					pathElt397=pathElt();
					state._fsp--;

					adaptor.addChild(root_0, pathElt397.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:736:17: INVERSE pathElt
					{
					root_0 = (CommonTree)adaptor.nil();


					INVERSE398=(Token)match(input,INVERSE,FOLLOW_INVERSE_in_pathEltOrInverse4843); 
					INVERSE398_tree = (CommonTree)adaptor.create(INVERSE398);
					adaptor.addChild(root_0, INVERSE398_tree);

					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse4845);
					pathElt399=pathElt();
					state._fsp--;

					adaptor.addChild(root_0, pathElt399.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathEltOrInverse"


	public static class pathMod_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathMod"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:739:1: pathMod : ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) ;
	public final SparqlifyConfigParser.pathMod_return pathMod() throws RecognitionException {
		SparqlifyConfigParser.pathMod_return retval = new SparqlifyConfigParser.pathMod_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASTERISK400=null;
		Token QUESTION_MARK401=null;
		Token PLUS402=null;
		Token OPEN_CURLY_BRACE403=null;
		Token INTEGER404=null;
		Token COMMA405=null;
		Token CLOSE_CURLY_BRACE406=null;
		Token INTEGER407=null;
		Token CLOSE_CURLY_BRACE408=null;
		Token CLOSE_CURLY_BRACE409=null;
		Token COMMA410=null;
		Token INTEGER411=null;
		Token CLOSE_CURLY_BRACE412=null;

		CommonTree ASTERISK400_tree=null;
		CommonTree QUESTION_MARK401_tree=null;
		CommonTree PLUS402_tree=null;
		CommonTree OPEN_CURLY_BRACE403_tree=null;
		CommonTree INTEGER404_tree=null;
		CommonTree COMMA405_tree=null;
		CommonTree CLOSE_CURLY_BRACE406_tree=null;
		CommonTree INTEGER407_tree=null;
		CommonTree CLOSE_CURLY_BRACE408_tree=null;
		CommonTree CLOSE_CURLY_BRACE409_tree=null;
		CommonTree COMMA410_tree=null;
		CommonTree INTEGER411_tree=null;
		CommonTree CLOSE_CURLY_BRACE412_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:5: ( ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			int alt131=4;
			switch ( input.LA(1) ) {
			case ASTERISK:
				{
				alt131=1;
				}
				break;
			case QUESTION_MARK:
				{
				alt131=2;
				}
				break;
			case PLUS:
				{
				alt131=3;
				}
				break;
			case OPEN_CURLY_BRACE:
				{
				alt131=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 131, 0, input);
				throw nvae;
			}
			switch (alt131) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:9: ASTERISK
					{
					ASTERISK400=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_pathMod4868); 
					ASTERISK400_tree = (CommonTree)adaptor.create(ASTERISK400);
					adaptor.addChild(root_0, ASTERISK400_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:20: QUESTION_MARK
					{
					QUESTION_MARK401=(Token)match(input,QUESTION_MARK,FOLLOW_QUESTION_MARK_in_pathMod4872); 
					QUESTION_MARK401_tree = (CommonTree)adaptor.create(QUESTION_MARK401);
					adaptor.addChild(root_0, QUESTION_MARK401_tree);

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:36: PLUS
					{
					PLUS402=(Token)match(input,PLUS,FOLLOW_PLUS_in_pathMod4876); 
					PLUS402_tree = (CommonTree)adaptor.create(PLUS402);
					adaptor.addChild(root_0, PLUS402_tree);

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:43: OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					{
					OPEN_CURLY_BRACE403=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_pathMod4880); 
					OPEN_CURLY_BRACE403_tree = (CommonTree)adaptor.create(OPEN_CURLY_BRACE403);
					adaptor.addChild(root_0, OPEN_CURLY_BRACE403_tree);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:60: ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					int alt130=2;
					int LA130_0 = input.LA(1);
					if ( (LA130_0==INTEGER) ) {
						alt130=1;
					}
					else if ( (LA130_0==COMMA) ) {
						alt130=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 130, 0, input);
						throw nvae;
					}

					switch (alt130) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:62: INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							{
							INTEGER404=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_pathMod4884); 
							INTEGER404_tree = (CommonTree)adaptor.create(INTEGER404);
							adaptor.addChild(root_0, INTEGER404_tree);

							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:70: ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							int alt129=2;
							int LA129_0 = input.LA(1);
							if ( (LA129_0==COMMA) ) {
								alt129=1;
							}
							else if ( (LA129_0==CLOSE_CURLY_BRACE) ) {
								alt129=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 129, 0, input);
								throw nvae;
							}

							switch (alt129) {
								case 1 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:72: COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									{
									COMMA405=(Token)match(input,COMMA,FOLLOW_COMMA_in_pathMod4888); 
									COMMA405_tree = (CommonTree)adaptor.create(COMMA405);
									adaptor.addChild(root_0, COMMA405_tree);

									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:78: ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									int alt128=2;
									int LA128_0 = input.LA(1);
									if ( (LA128_0==CLOSE_CURLY_BRACE) ) {
										alt128=1;
									}
									else if ( (LA128_0==INTEGER) ) {
										alt128=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 128, 0, input);
										throw nvae;
									}

									switch (alt128) {
										case 1 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:80: CLOSE_CURLY_BRACE
											{
											CLOSE_CURLY_BRACE406=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4892); 
											CLOSE_CURLY_BRACE406_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE406);
											adaptor.addChild(root_0, CLOSE_CURLY_BRACE406_tree);

											}
											break;
										case 2 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:100: INTEGER CLOSE_CURLY_BRACE
											{
											INTEGER407=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_pathMod4896); 
											INTEGER407_tree = (CommonTree)adaptor.create(INTEGER407);
											adaptor.addChild(root_0, INTEGER407_tree);

											CLOSE_CURLY_BRACE408=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4898); 
											CLOSE_CURLY_BRACE408_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE408);
											adaptor.addChild(root_0, CLOSE_CURLY_BRACE408_tree);

											}
											break;

									}

									}
									break;
								case 2 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:130: CLOSE_CURLY_BRACE
									{
									CLOSE_CURLY_BRACE409=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4904); 
									CLOSE_CURLY_BRACE409_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE409);
									adaptor.addChild(root_0, CLOSE_CURLY_BRACE409_tree);

									}
									break;

							}

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:740:152: COMMA INTEGER CLOSE_CURLY_BRACE
							{
							COMMA410=(Token)match(input,COMMA,FOLLOW_COMMA_in_pathMod4910); 
							COMMA410_tree = (CommonTree)adaptor.create(COMMA410);
							adaptor.addChild(root_0, COMMA410_tree);

							INTEGER411=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_pathMod4912); 
							INTEGER411_tree = (CommonTree)adaptor.create(INTEGER411);
							adaptor.addChild(root_0, INTEGER411_tree);

							CLOSE_CURLY_BRACE412=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4914); 
							CLOSE_CURLY_BRACE412_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE412);
							adaptor.addChild(root_0, CLOSE_CURLY_BRACE412_tree);

							}
							break;

					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathMod"


	public static class pathPrimary_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathPrimary"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:743:1: pathPrimary : ( iriRef -> ^( PATH_PRIMARY iriRef ) | A -> ^( PATH_PRIMARY A ) | NEGATION pathNegatedPropertySet -> ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | OPEN_BRACE path CLOSE_BRACE -> ^( PATH_PRIMARY path ) );
	public final SparqlifyConfigParser.pathPrimary_return pathPrimary() throws RecognitionException {
		SparqlifyConfigParser.pathPrimary_return retval = new SparqlifyConfigParser.pathPrimary_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token A414=null;
		Token NEGATION415=null;
		Token OPEN_BRACE417=null;
		Token CLOSE_BRACE419=null;
		ParserRuleReturnScope iriRef413 =null;
		ParserRuleReturnScope pathNegatedPropertySet416 =null;
		ParserRuleReturnScope path418 =null;

		CommonTree A414_tree=null;
		CommonTree NEGATION415_tree=null;
		CommonTree OPEN_BRACE417_tree=null;
		CommonTree CLOSE_BRACE419_tree=null;
		RewriteRuleTokenStream stream_A=new RewriteRuleTokenStream(adaptor,"token A");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_NEGATION=new RewriteRuleTokenStream(adaptor,"token NEGATION");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_path=new RewriteRuleSubtreeStream(adaptor,"rule path");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");
		RewriteRuleSubtreeStream stream_pathNegatedPropertySet=new RewriteRuleSubtreeStream(adaptor,"rule pathNegatedPropertySet");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:744:5: ( iriRef -> ^( PATH_PRIMARY iriRef ) | A -> ^( PATH_PRIMARY A ) | NEGATION pathNegatedPropertySet -> ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | OPEN_BRACE path CLOSE_BRACE -> ^( PATH_PRIMARY path ) )
			int alt132=4;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt132=1;
				}
				break;
			case A:
				{
				alt132=2;
				}
				break;
			case NEGATION:
				{
				alt132=3;
				}
				break;
			case OPEN_BRACE:
				{
				alt132=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 132, 0, input);
				throw nvae;
			}
			switch (alt132) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:744:7: iriRef
					{
					pushFollow(FOLLOW_iriRef_in_pathPrimary4935);
					iriRef413=iriRef();
					state._fsp--;

					stream_iriRef.add(iriRef413.getTree());
					// AST REWRITE
					// elements: iriRef
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 744:14: -> ^( PATH_PRIMARY iriRef )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:744:17: ^( PATH_PRIMARY iriRef )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_iriRef.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:745:7: A
					{
					A414=(Token)match(input,A,FOLLOW_A_in_pathPrimary4951);  
					stream_A.add(A414);

					// AST REWRITE
					// elements: A
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 745:9: -> ^( PATH_PRIMARY A )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:745:12: ^( PATH_PRIMARY A )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_A.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:746:7: NEGATION pathNegatedPropertySet
					{
					NEGATION415=(Token)match(input,NEGATION,FOLLOW_NEGATION_in_pathPrimary4967);  
					stream_NEGATION.add(NEGATION415);

					pushFollow(FOLLOW_pathNegatedPropertySet_in_pathPrimary4969);
					pathNegatedPropertySet416=pathNegatedPropertySet();
					state._fsp--;

					stream_pathNegatedPropertySet.add(pathNegatedPropertySet416.getTree());
					// AST REWRITE
					// elements: pathNegatedPropertySet, NEGATION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 746:39: -> ^( PATH_PRIMARY NEGATION pathNegatedPropertySet )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:746:42: ^( PATH_PRIMARY NEGATION pathNegatedPropertySet )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_NEGATION.nextNode());
						adaptor.addChild(root_1, stream_pathNegatedPropertySet.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:7: OPEN_BRACE path CLOSE_BRACE
					{
					OPEN_BRACE417=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_pathPrimary4987);  
					stream_OPEN_BRACE.add(OPEN_BRACE417);

					pushFollow(FOLLOW_path_in_pathPrimary4989);
					path418=path();
					state._fsp--;

					stream_path.add(path418.getTree());
					CLOSE_BRACE419=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_pathPrimary4991);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE419);

					// AST REWRITE
					// elements: path
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 747:35: -> ^( PATH_PRIMARY path )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:38: ^( PATH_PRIMARY path )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_path.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathPrimary"


	public static class pathNegatedPropertySet_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathNegatedPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:750:1: pathNegatedPropertySet : ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE ) -> ^( PATH_NEGATED ( pathOneInPropertySet )+ ) ;
	public final SparqlifyConfigParser.pathNegatedPropertySet_return pathNegatedPropertySet() throws RecognitionException {
		SparqlifyConfigParser.pathNegatedPropertySet_return retval = new SparqlifyConfigParser.pathNegatedPropertySet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE421=null;
		Token PIPE423=null;
		Token CLOSE_BRACE425=null;
		ParserRuleReturnScope pathOneInPropertySet420 =null;
		ParserRuleReturnScope pathOneInPropertySet422 =null;
		ParserRuleReturnScope pathOneInPropertySet424 =null;

		CommonTree OPEN_BRACE421_tree=null;
		CommonTree PIPE423_tree=null;
		CommonTree CLOSE_BRACE425_tree=null;
		RewriteRuleTokenStream stream_PIPE=new RewriteRuleTokenStream(adaptor,"token PIPE");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_pathOneInPropertySet=new RewriteRuleSubtreeStream(adaptor,"rule pathOneInPropertySet");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:5: ( ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE ) -> ^( PATH_NEGATED ( pathOneInPropertySet )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:7: ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:7: ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE )
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==A||LA135_0==INVERSE||LA135_0==IRI_REF||(LA135_0 >= PNAME_LN && LA135_0 <= PNAME_NS)) ) {
				alt135=1;
			}
			else if ( (LA135_0==OPEN_BRACE) ) {
				alt135=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 135, 0, input);
				throw nvae;
			}

			switch (alt135) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:8: pathOneInPropertySet
					{
					pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5017);
					pathOneInPropertySet420=pathOneInPropertySet();
					state._fsp--;

					stream_pathOneInPropertySet.add(pathOneInPropertySet420.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:31: OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE
					{
					OPEN_BRACE421=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_pathNegatedPropertySet5021);  
					stream_OPEN_BRACE.add(OPEN_BRACE421);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:42: ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )?
					int alt134=2;
					int LA134_0 = input.LA(1);
					if ( (LA134_0==A||LA134_0==INVERSE||LA134_0==IRI_REF||(LA134_0 >= PNAME_LN && LA134_0 <= PNAME_NS)) ) {
						alt134=1;
					}
					switch (alt134) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:44: pathOneInPropertySet ( PIPE pathOneInPropertySet )*
							{
							pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5025);
							pathOneInPropertySet422=pathOneInPropertySet();
							state._fsp--;

							stream_pathOneInPropertySet.add(pathOneInPropertySet422.getTree());
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:65: ( PIPE pathOneInPropertySet )*
							loop133:
							while (true) {
								int alt133=2;
								int LA133_0 = input.LA(1);
								if ( (LA133_0==PIPE) ) {
									alt133=1;
								}

								switch (alt133) {
								case 1 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:67: PIPE pathOneInPropertySet
									{
									PIPE423=(Token)match(input,PIPE,FOLLOW_PIPE_in_pathNegatedPropertySet5029);  
									stream_PIPE.add(PIPE423);

									pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5031);
									pathOneInPropertySet424=pathOneInPropertySet();
									state._fsp--;

									stream_pathOneInPropertySet.add(pathOneInPropertySet424.getTree());
									}
									break;

								default :
									break loop133;
								}
							}

							}
							break;

					}

					CLOSE_BRACE425=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_pathNegatedPropertySet5039);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE425);

					}
					break;

			}

			// AST REWRITE
			// elements: pathOneInPropertySet
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 751:112: -> ^( PATH_NEGATED ( pathOneInPropertySet )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:115: ^( PATH_NEGATED ( pathOneInPropertySet )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_NEGATED, "PATH_NEGATED"), root_1);
				if ( !(stream_pathOneInPropertySet.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_pathOneInPropertySet.hasNext() ) {
					adaptor.addChild(root_1, stream_pathOneInPropertySet.nextTree());
				}
				stream_pathOneInPropertySet.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathNegatedPropertySet"


	public static class pathOneInPropertySet_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathOneInPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:754:1: pathOneInPropertySet : ( INVERSE )? ( iriRef | A ) ;
	public final SparqlifyConfigParser.pathOneInPropertySet_return pathOneInPropertySet() throws RecognitionException {
		SparqlifyConfigParser.pathOneInPropertySet_return retval = new SparqlifyConfigParser.pathOneInPropertySet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INVERSE426=null;
		Token A428=null;
		ParserRuleReturnScope iriRef427 =null;

		CommonTree INVERSE426_tree=null;
		CommonTree A428_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:755:5: ( ( INVERSE )? ( iriRef | A ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:755:7: ( INVERSE )? ( iriRef | A )
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:755:7: ( INVERSE )?
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( (LA136_0==INVERSE) ) {
				alt136=1;
			}
			switch (alt136) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:755:7: INVERSE
					{
					INVERSE426=(Token)match(input,INVERSE,FOLLOW_INVERSE_in_pathOneInPropertySet5069); 
					INVERSE426_tree = (CommonTree)adaptor.create(INVERSE426);
					adaptor.addChild(root_0, INVERSE426_tree);

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:755:16: ( iriRef | A )
			int alt137=2;
			int LA137_0 = input.LA(1);
			if ( (LA137_0==IRI_REF||(LA137_0 >= PNAME_LN && LA137_0 <= PNAME_NS)) ) {
				alt137=1;
			}
			else if ( (LA137_0==A) ) {
				alt137=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}

			switch (alt137) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:755:18: iriRef
					{
					pushFollow(FOLLOW_iriRef_in_pathOneInPropertySet5074);
					iriRef427=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef427.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:755:27: A
					{
					A428=(Token)match(input,A,FOLLOW_A_in_pathOneInPropertySet5078); 
					A428_tree = (CommonTree)adaptor.create(A428);
					adaptor.addChild(root_0, A428_tree);

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathOneInPropertySet"


	public static class triplesNode_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:1: triplesNode : ( OPEN_BRACE ( graphNode )+ CLOSE_BRACE -> ^( COLLECTION ( graphNode )+ ) |lsb= OPEN_SQUARE_BRACKET propertyListNotEmpty[new CommonTree(new CommonToken(VAR,\"[]\"))] CLOSE_SQUARE_BRACKET -> ^( TRIPLE propertyListNotEmpty ) );
	public final SparqlifyConfigParser.triplesNode_return triplesNode() throws RecognitionException {
		SparqlifyConfigParser.triplesNode_return retval = new SparqlifyConfigParser.triplesNode_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token lsb=null;
		Token OPEN_BRACE429=null;
		Token CLOSE_BRACE431=null;
		Token CLOSE_SQUARE_BRACKET433=null;
		ParserRuleReturnScope graphNode430 =null;
		ParserRuleReturnScope propertyListNotEmpty432 =null;

		CommonTree lsb_tree=null;
		CommonTree OPEN_BRACE429_tree=null;
		CommonTree CLOSE_BRACE431_tree=null;
		CommonTree CLOSE_SQUARE_BRACKET433_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_SQUARE_BRACKET=new RewriteRuleTokenStream(adaptor,"token OPEN_SQUARE_BRACKET");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_CLOSE_SQUARE_BRACKET=new RewriteRuleTokenStream(adaptor,"token CLOSE_SQUARE_BRACKET");
		RewriteRuleSubtreeStream stream_graphNode=new RewriteRuleSubtreeStream(adaptor,"rule graphNode");
		RewriteRuleSubtreeStream stream_propertyListNotEmpty=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmpty");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:759:5: ( OPEN_BRACE ( graphNode )+ CLOSE_BRACE -> ^( COLLECTION ( graphNode )+ ) |lsb= OPEN_SQUARE_BRACKET propertyListNotEmpty[new CommonTree(new CommonToken(VAR,\"[]\"))] CLOSE_SQUARE_BRACKET -> ^( TRIPLE propertyListNotEmpty ) )
			int alt139=2;
			int LA139_0 = input.LA(1);
			if ( (LA139_0==OPEN_BRACE) ) {
				alt139=1;
			}
			else if ( (LA139_0==OPEN_SQUARE_BRACKET) ) {
				alt139=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}

			switch (alt139) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:759:7: OPEN_BRACE ( graphNode )+ CLOSE_BRACE
					{
					OPEN_BRACE429=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_triplesNode5098);  
					stream_OPEN_BRACE.add(OPEN_BRACE429);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:759:18: ( graphNode )+
					int cnt138=0;
					loop138:
					while (true) {
						int alt138=2;
						int LA138_0 = input.LA(1);
						if ( (LA138_0==BLANK_NODE_LABEL||(LA138_0 >= DECIMAL && LA138_0 <= DECIMAL_POSITIVE)||(LA138_0 >= DOUBLE && LA138_0 <= DOUBLE_POSITIVE)||LA138_0==FALSE||(LA138_0 >= INTEGER && LA138_0 <= INTEGER_POSITIVE)||LA138_0==IRI_REF||LA138_0==OPEN_BRACE||LA138_0==OPEN_SQUARE_BRACKET||(LA138_0 >= PNAME_LN && LA138_0 <= PNAME_NS)||(LA138_0 >= STRING_LITERAL1 && LA138_0 <= STRING_LITERAL_LONG2)||LA138_0==TRUE||(LA138_0 >= VAR1 && LA138_0 <= VAR3)) ) {
							alt138=1;
						}

						switch (alt138) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:759:18: graphNode
							{
							pushFollow(FOLLOW_graphNode_in_triplesNode5100);
							graphNode430=graphNode();
							state._fsp--;

							stream_graphNode.add(graphNode430.getTree());
							}
							break;

						default :
							if ( cnt138 >= 1 ) break loop138;
							EarlyExitException eee = new EarlyExitException(138, input);
							throw eee;
						}
						cnt138++;
					}

					CLOSE_BRACE431=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_triplesNode5103);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE431);

					// AST REWRITE
					// elements: graphNode
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 759:41: -> ^( COLLECTION ( graphNode )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:759:44: ^( COLLECTION ( graphNode )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(COLLECTION, "COLLECTION"), root_1);
						if ( !(stream_graphNode.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_graphNode.hasNext() ) {
							adaptor.addChild(root_1, stream_graphNode.nextTree());
						}
						stream_graphNode.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:760:7: lsb= OPEN_SQUARE_BRACKET propertyListNotEmpty[new CommonTree(new CommonToken(VAR,\"[]\"))] CLOSE_SQUARE_BRACKET
					{
					lsb=(Token)match(input,OPEN_SQUARE_BRACKET,FOLLOW_OPEN_SQUARE_BRACKET_in_triplesNode5122);  
					stream_OPEN_SQUARE_BRACKET.add(lsb);

					pushFollow(FOLLOW_propertyListNotEmpty_in_triplesNode5124);
					propertyListNotEmpty432=propertyListNotEmpty(new CommonTree(new CommonToken(VAR,"[]")));
					state._fsp--;

					stream_propertyListNotEmpty.add(propertyListNotEmpty432.getTree());
					CLOSE_SQUARE_BRACKET433=(Token)match(input,CLOSE_SQUARE_BRACKET,FOLLOW_CLOSE_SQUARE_BRACKET_in_triplesNode5127);  
					stream_CLOSE_SQUARE_BRACKET.add(CLOSE_SQUARE_BRACKET433);

					// AST REWRITE
					// elements: propertyListNotEmpty
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 760:116: -> ^( TRIPLE propertyListNotEmpty )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:760:119: ^( TRIPLE propertyListNotEmpty )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_propertyListNotEmpty.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesNode"


	public static class graphNode_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:763:1: graphNode : ( varOrTerm | triplesNode );
	public final SparqlifyConfigParser.graphNode_return graphNode() throws RecognitionException {
		SparqlifyConfigParser.graphNode_return retval = new SparqlifyConfigParser.graphNode_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope varOrTerm434 =null;
		ParserRuleReturnScope triplesNode435 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:764:5: ( varOrTerm | triplesNode )
			int alt140=2;
			switch ( input.LA(1) ) {
			case BLANK_NODE_LABEL:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case FALSE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case TRUE:
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt140=1;
				}
				break;
			case OPEN_SQUARE_BRACKET:
				{
				int LA140_2 = input.LA(2);
				if ( (LA140_2==CLOSE_SQUARE_BRACKET) ) {
					alt140=1;
				}
				else if ( (LA140_2==A||LA140_2==IRI_REF||(LA140_2 >= PNAME_LN && LA140_2 <= PNAME_NS)||(LA140_2 >= VAR1 && LA140_2 <= VAR3)) ) {
					alt140=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 140, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case OPEN_BRACE:
				{
				int LA140_3 = input.LA(2);
				if ( (LA140_3==CLOSE_BRACE) ) {
					alt140=1;
				}
				else if ( (LA140_3==BLANK_NODE_LABEL||(LA140_3 >= DECIMAL && LA140_3 <= DECIMAL_POSITIVE)||(LA140_3 >= DOUBLE && LA140_3 <= DOUBLE_POSITIVE)||LA140_3==FALSE||(LA140_3 >= INTEGER && LA140_3 <= INTEGER_POSITIVE)||LA140_3==IRI_REF||LA140_3==OPEN_BRACE||LA140_3==OPEN_SQUARE_BRACKET||(LA140_3 >= PNAME_LN && LA140_3 <= PNAME_NS)||(LA140_3 >= STRING_LITERAL1 && LA140_3 <= STRING_LITERAL_LONG2)||LA140_3==TRUE||(LA140_3 >= VAR1 && LA140_3 <= VAR3)) ) {
					alt140=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 140, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}
			switch (alt140) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:764:7: varOrTerm
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_varOrTerm_in_graphNode5152);
					varOrTerm434=varOrTerm();
					state._fsp--;

					adaptor.addChild(root_0, varOrTerm434.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:764:19: triplesNode
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_triplesNode_in_graphNode5156);
					triplesNode435=triplesNode();
					state._fsp--;

					adaptor.addChild(root_0, triplesNode435.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphNode"


	public static class varOrTerm_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varOrTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:767:1: varOrTerm : ( var | graphTerm );
	public final SparqlifyConfigParser.varOrTerm_return varOrTerm() throws RecognitionException {
		SparqlifyConfigParser.varOrTerm_return retval = new SparqlifyConfigParser.varOrTerm_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope var436 =null;
		ParserRuleReturnScope graphTerm437 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:768:5: ( var | graphTerm )
			int alt141=2;
			int LA141_0 = input.LA(1);
			if ( ((LA141_0 >= VAR1 && LA141_0 <= VAR3)) ) {
				alt141=1;
			}
			else if ( (LA141_0==BLANK_NODE_LABEL||(LA141_0 >= DECIMAL && LA141_0 <= DECIMAL_POSITIVE)||(LA141_0 >= DOUBLE && LA141_0 <= DOUBLE_POSITIVE)||LA141_0==FALSE||(LA141_0 >= INTEGER && LA141_0 <= INTEGER_POSITIVE)||LA141_0==IRI_REF||LA141_0==OPEN_BRACE||LA141_0==OPEN_SQUARE_BRACKET||(LA141_0 >= PNAME_LN && LA141_0 <= PNAME_NS)||(LA141_0 >= STRING_LITERAL1 && LA141_0 <= STRING_LITERAL_LONG2)||LA141_0==TRUE) ) {
				alt141=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}

			switch (alt141) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:768:7: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_varOrTerm5173);
					var436=var();
					state._fsp--;

					adaptor.addChild(root_0, var436.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:768:13: graphTerm
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_graphTerm_in_varOrTerm5177);
					graphTerm437=graphTerm();
					state._fsp--;

					adaptor.addChild(root_0, graphTerm437.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varOrTerm"


	public static class varOrIRIref_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varOrIRIref"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:771:1: varOrIRIref : ( var | iriRef );
	public final SparqlifyConfigParser.varOrIRIref_return varOrIRIref() throws RecognitionException {
		SparqlifyConfigParser.varOrIRIref_return retval = new SparqlifyConfigParser.varOrIRIref_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope var438 =null;
		ParserRuleReturnScope iriRef439 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:772:5: ( var | iriRef )
			int alt142=2;
			int LA142_0 = input.LA(1);
			if ( ((LA142_0 >= VAR1 && LA142_0 <= VAR3)) ) {
				alt142=1;
			}
			else if ( (LA142_0==IRI_REF||(LA142_0 >= PNAME_LN && LA142_0 <= PNAME_NS)) ) {
				alt142=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 142, 0, input);
				throw nvae;
			}

			switch (alt142) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:772:7: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_varOrIRIref5194);
					var438=var();
					state._fsp--;

					adaptor.addChild(root_0, var438.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:772:13: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_varOrIRIref5198);
					iriRef439=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef439.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varOrIRIref"


	public static class var_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "var"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:775:1: var : (v= VAR1 -> ^( VAR[$v] ) |v= VAR2 -> ^( VAR[$v] ) |v= VAR3 -> ^( VAR[$v] ) );
	public final SparqlifyConfigParser.var_return var() throws RecognitionException {
		SparqlifyConfigParser.var_return retval = new SparqlifyConfigParser.var_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token v=null;

		CommonTree v_tree=null;
		RewriteRuleTokenStream stream_VAR1=new RewriteRuleTokenStream(adaptor,"token VAR1");
		RewriteRuleTokenStream stream_VAR2=new RewriteRuleTokenStream(adaptor,"token VAR2");
		RewriteRuleTokenStream stream_VAR3=new RewriteRuleTokenStream(adaptor,"token VAR3");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:776:5: (v= VAR1 -> ^( VAR[$v] ) |v= VAR2 -> ^( VAR[$v] ) |v= VAR3 -> ^( VAR[$v] ) )
			int alt143=3;
			switch ( input.LA(1) ) {
			case VAR1:
				{
				alt143=1;
				}
				break;
			case VAR2:
				{
				alt143=2;
				}
				break;
			case VAR3:
				{
				alt143=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 143, 0, input);
				throw nvae;
			}
			switch (alt143) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:776:7: v= VAR1
					{
					v=(Token)match(input,VAR1,FOLLOW_VAR1_in_var5217);  
					stream_VAR1.add(v);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 776:14: -> ^( VAR[$v] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:776:17: ^( VAR[$v] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, v), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:777:7: v= VAR2
					{
					v=(Token)match(input,VAR2,FOLLOW_VAR2_in_var5234);  
					stream_VAR2.add(v);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 777:14: -> ^( VAR[$v] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:777:17: ^( VAR[$v] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, v), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:778:7: v= VAR3
					{
					v=(Token)match(input,VAR3,FOLLOW_VAR3_in_var5251);  
					stream_VAR3.add(v);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 778:14: -> ^( VAR[$v] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:778:17: ^( VAR[$v] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, v), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "var"


	public static class graphTerm_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:782:1: graphTerm : ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | blankNode | nil );
	public final SparqlifyConfigParser.graphTerm_return graphTerm() throws RecognitionException {
		SparqlifyConfigParser.graphTerm_return retval = new SparqlifyConfigParser.graphTerm_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef440 =null;
		ParserRuleReturnScope rdfLiteral441 =null;
		ParserRuleReturnScope numericLiteral442 =null;
		ParserRuleReturnScope booleanLiteral443 =null;
		ParserRuleReturnScope blankNode444 =null;
		ParserRuleReturnScope nil445 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:783:5: ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | blankNode | nil )
			int alt144=6;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt144=1;
				}
				break;
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
				{
				alt144=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt144=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt144=4;
				}
				break;
			case BLANK_NODE_LABEL:
			case OPEN_SQUARE_BRACKET:
				{
				alt144=5;
				}
				break;
			case OPEN_BRACE:
				{
				alt144=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}
			switch (alt144) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:783:7: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_graphTerm5276);
					iriRef440=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef440.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:784:7: rdfLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_rdfLiteral_in_graphTerm5284);
					rdfLiteral441=rdfLiteral();
					state._fsp--;

					adaptor.addChild(root_0, rdfLiteral441.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:785:7: numericLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteral_in_graphTerm5292);
					numericLiteral442=numericLiteral();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteral442.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:786:7: booleanLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_booleanLiteral_in_graphTerm5300);
					booleanLiteral443=booleanLiteral();
					state._fsp--;

					adaptor.addChild(root_0, booleanLiteral443.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:787:7: blankNode
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_blankNode_in_graphTerm5308);
					blankNode444=blankNode();
					state._fsp--;

					adaptor.addChild(root_0, blankNode444.getTree());

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:788:7: nil
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_nil_in_graphTerm5316);
					nil445=nil();
					state._fsp--;

					adaptor.addChild(root_0, nil445.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphTerm"


	public static class nil_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "nil"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:791:1: nil : OPEN_BRACE CLOSE_BRACE ;
	public final SparqlifyConfigParser.nil_return nil() throws RecognitionException {
		SparqlifyConfigParser.nil_return retval = new SparqlifyConfigParser.nil_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE446=null;
		Token CLOSE_BRACE447=null;

		CommonTree OPEN_BRACE446_tree=null;
		CommonTree CLOSE_BRACE447_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:792:5: ( OPEN_BRACE CLOSE_BRACE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:792:7: OPEN_BRACE CLOSE_BRACE
			{
			root_0 = (CommonTree)adaptor.nil();


			OPEN_BRACE446=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_nil5337); 
			OPEN_BRACE446_tree = (CommonTree)adaptor.create(OPEN_BRACE446);
			adaptor.addChild(root_0, OPEN_BRACE446_tree);

			CLOSE_BRACE447=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_nil5339); 
			CLOSE_BRACE447_tree = (CommonTree)adaptor.create(CLOSE_BRACE447);
			adaptor.addChild(root_0, CLOSE_BRACE447_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "nil"


	public static class expression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "expression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:795:1: expression : conditionalOrExpression ;
	public final SparqlifyConfigParser.expression_return expression() throws RecognitionException {
		SparqlifyConfigParser.expression_return retval = new SparqlifyConfigParser.expression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope conditionalOrExpression448 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:796:5: ( conditionalOrExpression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:796:7: conditionalOrExpression
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_conditionalOrExpression_in_expression5356);
			conditionalOrExpression448=conditionalOrExpression();
			state._fsp--;

			adaptor.addChild(root_0, conditionalOrExpression448.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "expression"


	public static class conditionalOrExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "conditionalOrExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:799:1: conditionalOrExpression : (c1= conditionalAndExpression -> $c1) ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )* ;
	public final SparqlifyConfigParser.conditionalOrExpression_return conditionalOrExpression() throws RecognitionException {
		SparqlifyConfigParser.conditionalOrExpression_return retval = new SparqlifyConfigParser.conditionalOrExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OR449=null;
		ParserRuleReturnScope c1 =null;
		ParserRuleReturnScope c2 =null;

		CommonTree OR449_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_conditionalAndExpression=new RewriteRuleSubtreeStream(adaptor,"rule conditionalAndExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:800:5: ( (c1= conditionalAndExpression -> $c1) ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:800:7: (c1= conditionalAndExpression -> $c1) ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:800:7: (c1= conditionalAndExpression -> $c1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:800:8: c1= conditionalAndExpression
			{
			pushFollow(FOLLOW_conditionalAndExpression_in_conditionalOrExpression5376);
			c1=conditionalAndExpression();
			state._fsp--;

			stream_conditionalAndExpression.add(c1.getTree());
			// AST REWRITE
			// elements: c1
			// token labels: 
			// rule labels: retval, c1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_c1=new RewriteRuleSubtreeStream(adaptor,"rule c1",c1!=null?c1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 800:36: -> $c1
			{
				adaptor.addChild(root_0, stream_c1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:800:44: ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )*
			loop145:
			while (true) {
				int alt145=2;
				int LA145_0 = input.LA(1);
				if ( (LA145_0==OR) ) {
					alt145=1;
				}

				switch (alt145) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:800:45: OR c2= conditionalAndExpression
					{
					OR449=(Token)match(input,OR,FOLLOW_OR_in_conditionalOrExpression5385);  
					stream_OR.add(OR449);

					pushFollow(FOLLOW_conditionalAndExpression_in_conditionalOrExpression5389);
					c2=conditionalAndExpression();
					state._fsp--;

					stream_conditionalAndExpression.add(c2.getTree());
					// AST REWRITE
					// elements: c2, conditionalOrExpression, OR
					// token labels: 
					// rule labels: retval, c2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_c2=new RewriteRuleSubtreeStream(adaptor,"rule c2",c2!=null?c2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 800:76: -> ^( OR $conditionalOrExpression $c2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:800:79: ^( OR $conditionalOrExpression $c2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_OR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_c2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop145;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "conditionalOrExpression"


	public static class conditionalAndExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "conditionalAndExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:803:1: conditionalAndExpression : (v1= valueLogical -> $v1) ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )* ;
	public final SparqlifyConfigParser.conditionalAndExpression_return conditionalAndExpression() throws RecognitionException {
		SparqlifyConfigParser.conditionalAndExpression_return retval = new SparqlifyConfigParser.conditionalAndExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token AND450=null;
		ParserRuleReturnScope v1 =null;
		ParserRuleReturnScope v2 =null;

		CommonTree AND450_tree=null;
		RewriteRuleTokenStream stream_AND=new RewriteRuleTokenStream(adaptor,"token AND");
		RewriteRuleSubtreeStream stream_valueLogical=new RewriteRuleSubtreeStream(adaptor,"rule valueLogical");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:804:5: ( (v1= valueLogical -> $v1) ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:804:7: (v1= valueLogical -> $v1) ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:804:7: (v1= valueLogical -> $v1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:804:8: v1= valueLogical
			{
			pushFollow(FOLLOW_valueLogical_in_conditionalAndExpression5423);
			v1=valueLogical();
			state._fsp--;

			stream_valueLogical.add(v1.getTree());
			// AST REWRITE
			// elements: v1
			// token labels: 
			// rule labels: v1, retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_v1=new RewriteRuleSubtreeStream(adaptor,"rule v1",v1!=null?v1.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 804:24: -> $v1
			{
				adaptor.addChild(root_0, stream_v1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:804:32: ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )*
			loop146:
			while (true) {
				int alt146=2;
				int LA146_0 = input.LA(1);
				if ( (LA146_0==AND) ) {
					alt146=1;
				}

				switch (alt146) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:804:33: AND v2= valueLogical
					{
					AND450=(Token)match(input,AND,FOLLOW_AND_in_conditionalAndExpression5432);  
					stream_AND.add(AND450);

					pushFollow(FOLLOW_valueLogical_in_conditionalAndExpression5436);
					v2=valueLogical();
					state._fsp--;

					stream_valueLogical.add(v2.getTree());
					// AST REWRITE
					// elements: conditionalAndExpression, v2, AND
					// token labels: 
					// rule labels: retval, v2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_v2=new RewriteRuleSubtreeStream(adaptor,"rule v2",v2!=null?v2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 804:53: -> ^( AND $conditionalAndExpression $v2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:804:56: ^( AND $conditionalAndExpression $v2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AND.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_v2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop146;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "conditionalAndExpression"


	public static class valueLogical_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "valueLogical"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:1: valueLogical : relationalExpression ;
	public final SparqlifyConfigParser.valueLogical_return valueLogical() throws RecognitionException {
		SparqlifyConfigParser.valueLogical_return retval = new SparqlifyConfigParser.valueLogical_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope relationalExpression451 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:808:5: ( relationalExpression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:808:7: relationalExpression
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_relationalExpression_in_valueLogical5467);
			relationalExpression451=relationalExpression();
			state._fsp--;

			adaptor.addChild(root_0, relationalExpression451.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "valueLogical"


	public static class relationalExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "relationalExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:1: relationalExpression : (n1= numericExpression -> $n1) ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )? ;
	public final SparqlifyConfigParser.relationalExpression_return relationalExpression() throws RecognitionException {
		SparqlifyConfigParser.relationalExpression_return retval = new SparqlifyConfigParser.relationalExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EQUAL452=null;
		Token NOT_EQUAL453=null;
		Token LESS454=null;
		Token GREATER455=null;
		Token LESS_EQUAL456=null;
		Token GREATER_EQUAL457=null;
		Token IN458=null;
		Token NOT459=null;
		Token IN460=null;
		ParserRuleReturnScope n1 =null;
		ParserRuleReturnScope n2 =null;
		ParserRuleReturnScope n3 =null;
		ParserRuleReturnScope n4 =null;
		ParserRuleReturnScope n5 =null;
		ParserRuleReturnScope n6 =null;
		ParserRuleReturnScope n7 =null;
		ParserRuleReturnScope l2 =null;
		ParserRuleReturnScope l3 =null;

		CommonTree EQUAL452_tree=null;
		CommonTree NOT_EQUAL453_tree=null;
		CommonTree LESS454_tree=null;
		CommonTree GREATER455_tree=null;
		CommonTree LESS_EQUAL456_tree=null;
		CommonTree GREATER_EQUAL457_tree=null;
		CommonTree IN458_tree=null;
		CommonTree NOT459_tree=null;
		CommonTree IN460_tree=null;
		RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
		RewriteRuleTokenStream stream_LESS_EQUAL=new RewriteRuleTokenStream(adaptor,"token LESS_EQUAL");
		RewriteRuleTokenStream stream_IN=new RewriteRuleTokenStream(adaptor,"token IN");
		RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
		RewriteRuleTokenStream stream_NOT_EQUAL=new RewriteRuleTokenStream(adaptor,"token NOT_EQUAL");
		RewriteRuleTokenStream stream_GREATER_EQUAL=new RewriteRuleTokenStream(adaptor,"token GREATER_EQUAL");
		RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
		RewriteRuleTokenStream stream_LESS=new RewriteRuleTokenStream(adaptor,"token LESS");
		RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");
		RewriteRuleSubtreeStream stream_numericExpression=new RewriteRuleSubtreeStream(adaptor,"rule numericExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:5: ( (n1= numericExpression -> $n1) ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:7: (n1= numericExpression -> $n1) ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:7: (n1= numericExpression -> $n1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:8: n1= numericExpression
			{
			pushFollow(FOLLOW_numericExpression_in_relationalExpression5487);
			n1=numericExpression();
			state._fsp--;

			stream_numericExpression.add(n1.getTree());
			// AST REWRITE
			// elements: n1
			// token labels: 
			// rule labels: n1, retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_n1=new RewriteRuleSubtreeStream(adaptor,"rule n1",n1!=null?n1.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 812:29: -> $n1
			{
				adaptor.addChild(root_0, stream_n1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:37: ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )?
			int alt147=9;
			switch ( input.LA(1) ) {
				case EQUAL:
					{
					alt147=1;
					}
					break;
				case NOT_EQUAL:
					{
					alt147=2;
					}
					break;
				case LESS:
					{
					alt147=3;
					}
					break;
				case GREATER:
					{
					alt147=4;
					}
					break;
				case LESS_EQUAL:
					{
					alt147=5;
					}
					break;
				case GREATER_EQUAL:
					{
					alt147=6;
					}
					break;
				case IN:
					{
					alt147=7;
					}
					break;
				case NOT:
					{
					alt147=8;
					}
					break;
			}
			switch (alt147) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:39: ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:39: ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:40: EQUAL n2= numericExpression
					{
					EQUAL452=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_relationalExpression5498);  
					stream_EQUAL.add(EQUAL452);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5502);
					n2=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n2.getTree());
					// AST REWRITE
					// elements: EQUAL, n2, relationalExpression
					// token labels: 
					// rule labels: retval, n2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n2=new RewriteRuleSubtreeStream(adaptor,"rule n2",n2!=null?n2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 812:67: -> ^( EQUAL $relationalExpression $n2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:812:70: ^( EQUAL $relationalExpression $n2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:813:39: ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:813:39: ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:813:40: NOT_EQUAL n3= numericExpression
					{
					NOT_EQUAL453=(Token)match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_relationalExpression5559);  
					stream_NOT_EQUAL.add(NOT_EQUAL453);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5563);
					n3=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n3.getTree());
					// AST REWRITE
					// elements: relationalExpression, n3, NOT_EQUAL
					// token labels: 
					// rule labels: retval, n3
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n3=new RewriteRuleSubtreeStream(adaptor,"rule n3",n3!=null?n3.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 813:71: -> ^( NOT_EQUAL $relationalExpression $n3)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:813:74: ^( NOT_EQUAL $relationalExpression $n3)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_NOT_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n3.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:814:39: ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:814:39: ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:814:40: LESS n4= numericExpression
					{
					LESS454=(Token)match(input,LESS,FOLLOW_LESS_in_relationalExpression5618);  
					stream_LESS.add(LESS454);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5622);
					n4=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n4.getTree());
					// AST REWRITE
					// elements: relationalExpression, LESS, n4
					// token labels: 
					// rule labels: retval, n4
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n4=new RewriteRuleSubtreeStream(adaptor,"rule n4",n4!=null?n4.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 814:66: -> ^( LESS $relationalExpression $n4)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:814:69: ^( LESS $relationalExpression $n4)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LESS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n4.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:815:39: ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:815:39: ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:815:40: GREATER n5= numericExpression
					{
					GREATER455=(Token)match(input,GREATER,FOLLOW_GREATER_in_relationalExpression5677);  
					stream_GREATER.add(GREATER455);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5681);
					n5=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n5.getTree());
					// AST REWRITE
					// elements: relationalExpression, n5, GREATER
					// token labels: 
					// rule labels: retval, n5
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n5=new RewriteRuleSubtreeStream(adaptor,"rule n5",n5!=null?n5.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 815:69: -> ^( GREATER $relationalExpression $n5)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:815:72: ^( GREATER $relationalExpression $n5)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_GREATER.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n5.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:816:39: ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:816:39: ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:816:40: LESS_EQUAL n6= numericExpression
					{
					LESS_EQUAL456=(Token)match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_relationalExpression5735);  
					stream_LESS_EQUAL.add(LESS_EQUAL456);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5739);
					n6=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n6.getTree());
					// AST REWRITE
					// elements: relationalExpression, LESS_EQUAL, n6
					// token labels: 
					// rule labels: retval, n6
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n6=new RewriteRuleSubtreeStream(adaptor,"rule n6",n6!=null?n6.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 816:72: -> ^( LESS_EQUAL $relationalExpression $n6)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:816:75: ^( LESS_EQUAL $relationalExpression $n6)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LESS_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n6.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:817:39: ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:817:39: ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:817:40: GREATER_EQUAL n7= numericExpression
					{
					GREATER_EQUAL457=(Token)match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_relationalExpression5793);  
					stream_GREATER_EQUAL.add(GREATER_EQUAL457);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5797);
					n7=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n7.getTree());
					// AST REWRITE
					// elements: GREATER_EQUAL, relationalExpression, n7
					// token labels: 
					// rule labels: retval, n7
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n7=new RewriteRuleSubtreeStream(adaptor,"rule n7",n7!=null?n7.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 817:75: -> ^( GREATER_EQUAL $relationalExpression $n7)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:817:78: ^( GREATER_EQUAL $relationalExpression $n7)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_GREATER_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n7.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:818:39: ( IN l2= expressionList -> ^( IN $relationalExpression $l2) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:818:39: ( IN l2= expressionList -> ^( IN $relationalExpression $l2) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:818:40: IN l2= expressionList
					{
					IN458=(Token)match(input,IN,FOLLOW_IN_in_relationalExpression5853);  
					stream_IN.add(IN458);

					pushFollow(FOLLOW_expressionList_in_relationalExpression5857);
					l2=expressionList();
					state._fsp--;

					stream_expressionList.add(l2.getTree());
					// AST REWRITE
					// elements: IN, l2, relationalExpression
					// token labels: 
					// rule labels: retval, l2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_l2=new RewriteRuleSubtreeStream(adaptor,"rule l2",l2!=null?l2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 818:61: -> ^( IN $relationalExpression $l2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:818:64: ^( IN $relationalExpression $l2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_IN.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_l2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:39: ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:39: ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:40: NOT IN l3= expressionList
					{
					NOT459=(Token)match(input,NOT,FOLLOW_NOT_in_relationalExpression5911);  
					stream_NOT.add(NOT459);

					IN460=(Token)match(input,IN,FOLLOW_IN_in_relationalExpression5913);  
					stream_IN.add(IN460);

					pushFollow(FOLLOW_expressionList_in_relationalExpression5917);
					l3=expressionList();
					state._fsp--;

					stream_expressionList.add(l3.getTree());
					// AST REWRITE
					// elements: NOT, l3, relationalExpression, IN
					// token labels: 
					// rule labels: retval, l3
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_l3=new RewriteRuleSubtreeStream(adaptor,"rule l3",l3!=null?l3.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 819:65: -> ^( NOT IN $relationalExpression $l3)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:68: ^( NOT IN $relationalExpression $l3)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_NOT.nextNode(), root_1);
						adaptor.addChild(root_1, stream_IN.nextNode());
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_l3.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "relationalExpression"


	public static class numericExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:822:1: numericExpression : additiveExpression ;
	public final SparqlifyConfigParser.numericExpression_return numericExpression() throws RecognitionException {
		SparqlifyConfigParser.numericExpression_return retval = new SparqlifyConfigParser.numericExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope additiveExpression461 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:823:5: ( additiveExpression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:823:7: additiveExpression
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_additiveExpression_in_numericExpression5952);
			additiveExpression461=additiveExpression();
			state._fsp--;

			adaptor.addChild(root_0, additiveExpression461.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericExpression"


	public static class additiveExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "additiveExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:826:1: additiveExpression : (m1= multiplicativeExpression -> $m1) ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )* ;
	public final SparqlifyConfigParser.additiveExpression_return additiveExpression() throws RecognitionException {
		SparqlifyConfigParser.additiveExpression_return retval = new SparqlifyConfigParser.additiveExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASTERISK463=null;
		Token DIVIDE464=null;
		ParserRuleReturnScope m1 =null;
		ParserRuleReturnScope m2 =null;
		ParserRuleReturnScope n1 =null;
		ParserRuleReturnScope n2 =null;
		ParserRuleReturnScope u2 =null;
		ParserRuleReturnScope additiveOperator462 =null;

		CommonTree ASTERISK463_tree=null;
		CommonTree DIVIDE464_tree=null;
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleTokenStream stream_DIVIDE=new RewriteRuleTokenStream(adaptor,"token DIVIDE");
		RewriteRuleSubtreeStream stream_unaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule unaryExpression");
		RewriteRuleSubtreeStream stream_numericLiteralNegative=new RewriteRuleSubtreeStream(adaptor,"rule numericLiteralNegative");
		RewriteRuleSubtreeStream stream_numericLiteralPositive=new RewriteRuleSubtreeStream(adaptor,"rule numericLiteralPositive");
		RewriteRuleSubtreeStream stream_additiveOperator=new RewriteRuleSubtreeStream(adaptor,"rule additiveOperator");
		RewriteRuleSubtreeStream stream_multiplicativeExpression=new RewriteRuleSubtreeStream(adaptor,"rule multiplicativeExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:5: ( (m1= multiplicativeExpression -> $m1) ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:7: (m1= multiplicativeExpression -> $m1) ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:7: (m1= multiplicativeExpression -> $m1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:8: m1= multiplicativeExpression
			{
			pushFollow(FOLLOW_multiplicativeExpression_in_additiveExpression5972);
			m1=multiplicativeExpression();
			state._fsp--;

			stream_multiplicativeExpression.add(m1.getTree());
			// AST REWRITE
			// elements: m1
			// token labels: 
			// rule labels: retval, m1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_m1=new RewriteRuleSubtreeStream(adaptor,"rule m1",m1!=null?m1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 827:36: -> $m1
			{
				adaptor.addChild(root_0, stream_m1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:44: ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )*
			loop150:
			while (true) {
				int alt150=3;
				int LA150_0 = input.LA(1);
				if ( (LA150_0==MINUS||LA150_0==PLUS) ) {
					alt150=1;
				}
				else if ( ((LA150_0 >= DECIMAL_NEGATIVE && LA150_0 <= DECIMAL_POSITIVE)||(LA150_0 >= DOUBLE_NEGATIVE && LA150_0 <= DOUBLE_POSITIVE)||(LA150_0 >= INTEGER_NEGATIVE && LA150_0 <= INTEGER_POSITIVE)) ) {
					alt150=2;
				}

				switch (alt150) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:46: ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:46: ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:47: additiveOperator m2= multiplicativeExpression
					{
					pushFollow(FOLLOW_additiveOperator_in_additiveExpression5983);
					additiveOperator462=additiveOperator();
					state._fsp--;

					stream_additiveOperator.add(additiveOperator462.getTree());
					pushFollow(FOLLOW_multiplicativeExpression_in_additiveExpression5987);
					m2=multiplicativeExpression();
					state._fsp--;

					stream_multiplicativeExpression.add(m2.getTree());
					// AST REWRITE
					// elements: additiveExpression, additiveOperator, m2
					// token labels: 
					// rule labels: retval, m2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_m2=new RewriteRuleSubtreeStream(adaptor,"rule m2",m2!=null?m2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 827:92: -> ^( additiveOperator $additiveExpression $m2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:827:95: ^( additiveOperator $additiveExpression $m2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_additiveOperator.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_m2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:828:48: (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )?
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:828:48: (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) )
					int alt148=2;
					int LA148_0 = input.LA(1);
					if ( (LA148_0==DECIMAL_POSITIVE||LA148_0==DOUBLE_POSITIVE||LA148_0==INTEGER_POSITIVE) ) {
						alt148=1;
					}
					else if ( (LA148_0==DECIMAL_NEGATIVE||LA148_0==DOUBLE_NEGATIVE||LA148_0==INTEGER_NEGATIVE) ) {
						alt148=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 148, 0, input);
						throw nvae;
					}

					switch (alt148) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:828:49: n1= numericLiteralPositive
							{
							pushFollow(FOLLOW_numericLiteralPositive_in_additiveExpression6054);
							n1=numericLiteralPositive();
							state._fsp--;

							stream_numericLiteralPositive.add(n1.getTree());
							// AST REWRITE
							// elements: additiveExpression, n1
							// token labels: 
							// rule labels: n1, retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_n1=new RewriteRuleSubtreeStream(adaptor,"rule n1",n1!=null?n1.getTree():null);
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 828:75: -> ^( PLUS $additiveExpression $n1)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:828:78: ^( PLUS $additiveExpression $n1)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PLUS, "PLUS"), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_n1.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:828:112: n2= numericLiteralNegative
							{
							pushFollow(FOLLOW_numericLiteralNegative_in_additiveExpression6072);
							n2=numericLiteralNegative();
							state._fsp--;

							stream_numericLiteralNegative.add(n2.getTree());
							// AST REWRITE
							// elements: additiveExpression, n2
							// token labels: 
							// rule labels: retval, n2
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
							RewriteRuleSubtreeStream stream_n2=new RewriteRuleSubtreeStream(adaptor,"rule n2",n2!=null?n2.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 828:138: -> ^( PLUS $additiveExpression $n2)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:828:141: ^( PLUS $additiveExpression $n2)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PLUS, "PLUS"), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_n2.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:46: ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )?
					int alt149=3;
					int LA149_0 = input.LA(1);
					if ( (LA149_0==ASTERISK) ) {
						alt149=1;
					}
					else if ( (LA149_0==DIVIDE) ) {
						alt149=2;
					}
					switch (alt149) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:48: ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:48: ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:50: ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:50: ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:51: ASTERISK u2= unaryExpression
							{
							ASTERISK463=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_additiveExpression6139);  
							stream_ASTERISK.add(ASTERISK463);

							pushFollow(FOLLOW_unaryExpression_in_additiveExpression6143);
							u2=unaryExpression();
							state._fsp--;

							stream_unaryExpression.add(u2.getTree());
							// AST REWRITE
							// elements: ASTERISK, u2, additiveExpression
							// token labels: 
							// rule labels: retval, u2
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
							RewriteRuleSubtreeStream stream_u2=new RewriteRuleSubtreeStream(adaptor,"rule u2",u2!=null?u2.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 829:79: -> ^( ASTERISK $additiveExpression $u2)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:82: ^( ASTERISK $additiveExpression $u2)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot(stream_ASTERISK.nextNode(), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_u2.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}

							}

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:48: ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:48: ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:50: ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:50: ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:51: DIVIDE u2= unaryExpression
							{
							DIVIDE464=(Token)match(input,DIVIDE,FOLLOW_DIVIDE_in_additiveExpression6211);  
							stream_DIVIDE.add(DIVIDE464);

							pushFollow(FOLLOW_unaryExpression_in_additiveExpression6215);
							u2=unaryExpression();
							state._fsp--;

							stream_unaryExpression.add(u2.getTree());
							// AST REWRITE
							// elements: additiveExpression, u2, DIVIDE
							// token labels: 
							// rule labels: retval, u2
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
							RewriteRuleSubtreeStream stream_u2=new RewriteRuleSubtreeStream(adaptor,"rule u2",u2!=null?u2.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 830:77: -> ^( DIVIDE $additiveExpression $u2)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:80: ^( DIVIDE $additiveExpression $u2)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot(stream_DIVIDE.nextNode(), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_u2.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}

							}

							}
							break;

					}

					}
					break;

				default :
					break loop150;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "additiveExpression"


	public static class additiveOperator_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "additiveOperator"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:833:1: additiveOperator : ( PLUS | MINUS );
	public final SparqlifyConfigParser.additiveOperator_return additiveOperator() throws RecognitionException {
		SparqlifyConfigParser.additiveOperator_return retval = new SparqlifyConfigParser.additiveOperator_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set465=null;

		CommonTree set465_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:5: ( PLUS | MINUS )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set465=input.LT(1);
			if ( input.LA(1)==MINUS||input.LA(1)==PLUS ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set465));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "additiveOperator"


	public static class multiplicativeExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "multiplicativeExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:837:1: multiplicativeExpression : (u1= unaryExpression -> $u1) ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )* ;
	public final SparqlifyConfigParser.multiplicativeExpression_return multiplicativeExpression() throws RecognitionException {
		SparqlifyConfigParser.multiplicativeExpression_return retval = new SparqlifyConfigParser.multiplicativeExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope u1 =null;
		ParserRuleReturnScope u2 =null;
		ParserRuleReturnScope multiplicativeOperator466 =null;

		RewriteRuleSubtreeStream stream_multiplicativeOperator=new RewriteRuleSubtreeStream(adaptor,"rule multiplicativeOperator");
		RewriteRuleSubtreeStream stream_unaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule unaryExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:838:5: ( (u1= unaryExpression -> $u1) ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:838:7: (u1= unaryExpression -> $u1) ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:838:7: (u1= unaryExpression -> $u1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:838:8: u1= unaryExpression
			{
			pushFollow(FOLLOW_unaryExpression_in_multiplicativeExpression6283);
			u1=unaryExpression();
			state._fsp--;

			stream_unaryExpression.add(u1.getTree());
			// AST REWRITE
			// elements: u1
			// token labels: 
			// rule labels: retval, u1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_u1=new RewriteRuleSubtreeStream(adaptor,"rule u1",u1!=null?u1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 838:27: -> $u1
			{
				adaptor.addChild(root_0, stream_u1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:838:35: ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )*
			loop151:
			while (true) {
				int alt151=2;
				int LA151_0 = input.LA(1);
				if ( (LA151_0==ASTERISK||LA151_0==DIVIDE) ) {
					alt151=1;
				}

				switch (alt151) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:838:36: multiplicativeOperator u2= unaryExpression
					{
					pushFollow(FOLLOW_multiplicativeOperator_in_multiplicativeExpression6292);
					multiplicativeOperator466=multiplicativeOperator();
					state._fsp--;

					stream_multiplicativeOperator.add(multiplicativeOperator466.getTree());
					pushFollow(FOLLOW_unaryExpression_in_multiplicativeExpression6296);
					u2=unaryExpression();
					state._fsp--;

					stream_unaryExpression.add(u2.getTree());
					// AST REWRITE
					// elements: multiplicativeExpression, u2, multiplicativeOperator
					// token labels: 
					// rule labels: retval, u2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_u2=new RewriteRuleSubtreeStream(adaptor,"rule u2",u2!=null?u2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 838:78: -> ^( multiplicativeOperator $multiplicativeExpression $u2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:838:81: ^( multiplicativeOperator $multiplicativeExpression $u2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_multiplicativeOperator.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_u2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop151;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "multiplicativeExpression"


	public static class multiplicativeOperator_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "multiplicativeOperator"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:841:1: multiplicativeOperator : ( ASTERISK | DIVIDE );
	public final SparqlifyConfigParser.multiplicativeOperator_return multiplicativeOperator() throws RecognitionException {
		SparqlifyConfigParser.multiplicativeOperator_return retval = new SparqlifyConfigParser.multiplicativeOperator_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set467=null;

		CommonTree set467_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:842:5: ( ASTERISK | DIVIDE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set467=input.LT(1);
			if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set467));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "multiplicativeOperator"


	public static class unaryExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "unaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:1: unaryExpression : (op= NEGATION primaryExpression -> ^( UNARY_NOT[$op] primaryExpression ) |op= PLUS primaryExpression -> ^( UNARY_PLUS[$op] primaryExpression ) |op= MINUS primaryExpression -> ^( UNARY_MINUS[$op] primaryExpression ) | primaryExpression -> ^( UNARY primaryExpression ) );
	public final SparqlifyConfigParser.unaryExpression_return unaryExpression() throws RecognitionException {
		SparqlifyConfigParser.unaryExpression_return retval = new SparqlifyConfigParser.unaryExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token op=null;
		ParserRuleReturnScope primaryExpression468 =null;
		ParserRuleReturnScope primaryExpression469 =null;
		ParserRuleReturnScope primaryExpression470 =null;
		ParserRuleReturnScope primaryExpression471 =null;

		CommonTree op_tree=null;
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_NEGATION=new RewriteRuleTokenStream(adaptor,"token NEGATION");
		RewriteRuleTokenStream stream_MINUS=new RewriteRuleTokenStream(adaptor,"token MINUS");
		RewriteRuleSubtreeStream stream_primaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule primaryExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:846:5: (op= NEGATION primaryExpression -> ^( UNARY_NOT[$op] primaryExpression ) |op= PLUS primaryExpression -> ^( UNARY_PLUS[$op] primaryExpression ) |op= MINUS primaryExpression -> ^( UNARY_MINUS[$op] primaryExpression ) | primaryExpression -> ^( UNARY primaryExpression ) )
			int alt152=4;
			switch ( input.LA(1) ) {
			case NEGATION:
				{
				alt152=1;
				}
				break;
			case PLUS:
				{
				alt152=2;
				}
				break;
			case MINUS:
				{
				alt152=3;
				}
				break;
			case ABS:
			case AVG:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case COUNT:
			case DATATYPE:
			case DAY:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FALSE:
			case FLOOR:
			case GROUP_CONCAT:
			case HOURS:
			case IF:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI:
			case IRI_REF:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MAX:
			case MD5:
			case MIN:
			case MINUTES:
			case MONTH:
			case NAME:
			case NOT:
			case NOW:
			case OPEN_BRACE:
			case PNAME_LN:
			case PNAME_NS:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SAMPLE:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case SUM:
			case TIMEZONE:
			case TRUE:
			case TZ:
			case UCASE:
			case URI:
			case VAR1:
			case VAR2:
			case VAR3:
			case YEAR:
				{
				alt152=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 152, 0, input);
				throw nvae;
			}
			switch (alt152) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:846:7: op= NEGATION primaryExpression
					{
					op=(Token)match(input,NEGATION,FOLLOW_NEGATION_in_unaryExpression6354);  
					stream_NEGATION.add(op);

					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6356);
					primaryExpression468=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression468.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 846:37: -> ^( UNARY_NOT[$op] primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:846:40: ^( UNARY_NOT[$op] primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY_NOT, op), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:847:7: op= PLUS primaryExpression
					{
					op=(Token)match(input,PLUS,FOLLOW_PLUS_in_unaryExpression6375);  
					stream_PLUS.add(op);

					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6377);
					primaryExpression469=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression469.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 847:33: -> ^( UNARY_PLUS[$op] primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:847:36: ^( UNARY_PLUS[$op] primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY_PLUS, op), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:848:7: op= MINUS primaryExpression
					{
					op=(Token)match(input,MINUS,FOLLOW_MINUS_in_unaryExpression6396);  
					stream_MINUS.add(op);

					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6398);
					primaryExpression470=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression470.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 848:34: -> ^( UNARY_MINUS[$op] primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:848:37: ^( UNARY_MINUS[$op] primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY_MINUS, op), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:850:7: primaryExpression
					{
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6416);
					primaryExpression471=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression471.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 850:25: -> ^( UNARY primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:850:28: ^( UNARY primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY, "UNARY"), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "unaryExpression"


	public static class primaryExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "primaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:853:1: primaryExpression : ( brackettedExpression | builtInCall | iriRefOrFunction | rdfLiteral | numericLiteral | booleanLiteral | var | aggregate | aliasedVar );
	public final SparqlifyConfigParser.primaryExpression_return primaryExpression() throws RecognitionException {
		SparqlifyConfigParser.primaryExpression_return retval = new SparqlifyConfigParser.primaryExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope brackettedExpression472 =null;
		ParserRuleReturnScope builtInCall473 =null;
		ParserRuleReturnScope iriRefOrFunction474 =null;
		ParserRuleReturnScope rdfLiteral475 =null;
		ParserRuleReturnScope numericLiteral476 =null;
		ParserRuleReturnScope booleanLiteral477 =null;
		ParserRuleReturnScope var478 =null;
		ParserRuleReturnScope aggregate479 =null;
		ParserRuleReturnScope aliasedVar480 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:5: ( brackettedExpression | builtInCall | iriRefOrFunction | rdfLiteral | numericLiteral | booleanLiteral | var | aggregate | aliasedVar )
			int alt153=9;
			switch ( input.LA(1) ) {
			case OPEN_BRACE:
				{
				alt153=1;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt153=2;
				}
				break;
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt153=3;
				}
				break;
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
				{
				alt153=4;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt153=5;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt153=6;
				}
				break;
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt153=7;
				}
				break;
			case AVG:
			case COUNT:
			case GROUP_CONCAT:
			case MAX:
			case MIN:
			case SAMPLE:
			case SUM:
				{
				alt153=8;
				}
				break;
			case NAME:
				{
				alt153=9;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 153, 0, input);
				throw nvae;
			}
			switch (alt153) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:7: brackettedExpression
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_brackettedExpression_in_primaryExpression6441);
					brackettedExpression472=brackettedExpression();
					state._fsp--;

					adaptor.addChild(root_0, brackettedExpression472.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:30: builtInCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_builtInCall_in_primaryExpression6445);
					builtInCall473=builtInCall();
					state._fsp--;

					adaptor.addChild(root_0, builtInCall473.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:44: iriRefOrFunction
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRefOrFunction_in_primaryExpression6449);
					iriRefOrFunction474=iriRefOrFunction();
					state._fsp--;

					adaptor.addChild(root_0, iriRefOrFunction474.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:63: rdfLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_rdfLiteral_in_primaryExpression6453);
					rdfLiteral475=rdfLiteral();
					state._fsp--;

					adaptor.addChild(root_0, rdfLiteral475.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:76: numericLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteral_in_primaryExpression6457);
					numericLiteral476=numericLiteral();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteral476.getTree());

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:93: booleanLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_booleanLiteral_in_primaryExpression6461);
					booleanLiteral477=booleanLiteral();
					state._fsp--;

					adaptor.addChild(root_0, booleanLiteral477.getTree());

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:110: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_primaryExpression6465);
					var478=var();
					state._fsp--;

					adaptor.addChild(root_0, var478.getTree());

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:116: aggregate
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_aggregate_in_primaryExpression6469);
					aggregate479=aggregate();
					state._fsp--;

					adaptor.addChild(root_0, aggregate479.getTree());

					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:855:4: aliasedVar
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_aliasedVar_in_primaryExpression6474);
					aliasedVar480=aliasedVar();
					state._fsp--;

					adaptor.addChild(root_0, aliasedVar480.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "primaryExpression"


	public static class aliasedVar_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "aliasedVar"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:859:1: aliasedVar : a= NAME DOT b= NAME -> ^( ALIASED_VAR $a $b) ;
	public final SparqlifyConfigParser.aliasedVar_return aliasedVar() throws RecognitionException {
		SparqlifyConfigParser.aliasedVar_return retval = new SparqlifyConfigParser.aliasedVar_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token a=null;
		Token b=null;
		Token DOT481=null;

		CommonTree a_tree=null;
		CommonTree b_tree=null;
		CommonTree DOT481_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:860:5: (a= NAME DOT b= NAME -> ^( ALIASED_VAR $a $b) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:860:7: a= NAME DOT b= NAME
			{
			a=(Token)match(input,NAME,FOLLOW_NAME_in_aliasedVar6494);  
			stream_NAME.add(a);

			DOT481=(Token)match(input,DOT,FOLLOW_DOT_in_aliasedVar6496);  
			stream_DOT.add(DOT481);

			b=(Token)match(input,NAME,FOLLOW_NAME_in_aliasedVar6500);  
			stream_NAME.add(b);

			// AST REWRITE
			// elements: a, b
			// token labels: b, a
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleTokenStream stream_b=new RewriteRuleTokenStream(adaptor,"token b",b);
			RewriteRuleTokenStream stream_a=new RewriteRuleTokenStream(adaptor,"token a",a);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 860:25: -> ^( ALIASED_VAR $a $b)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:860:28: ^( ALIASED_VAR $a $b)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ALIASED_VAR, "ALIASED_VAR"), root_1);
				adaptor.addChild(root_1, stream_a.nextNode());
				adaptor.addChild(root_1, stream_b.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "aliasedVar"


	public static class brackettedExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "brackettedExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:863:1: brackettedExpression : OPEN_BRACE expression CLOSE_BRACE -> expression ;
	public final SparqlifyConfigParser.brackettedExpression_return brackettedExpression() throws RecognitionException {
		SparqlifyConfigParser.brackettedExpression_return retval = new SparqlifyConfigParser.brackettedExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE482=null;
		Token CLOSE_BRACE484=null;
		ParserRuleReturnScope expression483 =null;

		CommonTree OPEN_BRACE482_tree=null;
		CommonTree CLOSE_BRACE484_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:864:5: ( OPEN_BRACE expression CLOSE_BRACE -> expression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:864:7: OPEN_BRACE expression CLOSE_BRACE
			{
			OPEN_BRACE482=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_brackettedExpression6529);  
			stream_OPEN_BRACE.add(OPEN_BRACE482);

			pushFollow(FOLLOW_expression_in_brackettedExpression6531);
			expression483=expression();
			state._fsp--;

			stream_expression.add(expression483.getTree());
			CLOSE_BRACE484=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_brackettedExpression6533);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE484);

			// AST REWRITE
			// elements: expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 864:41: -> expression
			{
				adaptor.addChild(root_0, stream_expression.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "brackettedExpression"


	public static class builtInCall_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "builtInCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:867:1: builtInCall : ( STR OPEN_BRACE expression CLOSE_BRACE -> ^( STR expression ) | LANG OPEN_BRACE expression CLOSE_BRACE -> ^( LANG expression ) | LANGMATCHES OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( LANGMATCHES ( expression )+ ) | DATATYPE OPEN_BRACE expression CLOSE_BRACE -> ^( DATATYPE expression ) | BOUND OPEN_BRACE var CLOSE_BRACE -> ^( BOUND var ) | IRI OPEN_BRACE expression CLOSE_BRACE -> ^( IRI expression ) | URI OPEN_BRACE expression CLOSE_BRACE -> ^( URI expression ) | BNODE ( OPEN_BRACE expression CLOSE_BRACE | nil ) -> ^( BNODE expression ) | RAND nil -> RAND | ABS OPEN_BRACE expression CLOSE_BRACE -> ^( ABS expression ) | CEIL OPEN_BRACE expression CLOSE_BRACE -> ^( CEIL expression ) | FLOOR OPEN_BRACE expression CLOSE_BRACE -> ^( FLOOR expression ) | ROUND OPEN_BRACE expression CLOSE_BRACE -> ^( ROUND expression ) | CONCAT expressionList -> ^( CONCAT expressionList ) | subStringExpression -> subStringExpression | STRLEN OPEN_BRACE expression CLOSE_BRACE -> ^( STRLEN expression ) | UCASE OPEN_BRACE expression CLOSE_BRACE -> ^( UCASE expression ) | LCASE OPEN_BRACE expression CLOSE_BRACE -> ^( LCASE expression ) | ENCODE_FOR_URI OPEN_BRACE expression CLOSE_BRACE -> ^( ENCODE_FOR_URI expression ) | CONTAINS OPEN_BRACE expression CLOSE_BRACE -> ^( CONTAINS expression ) | STRSTARTS OPEN_BRACE expression CLOSE_BRACE -> ^( STRSTARTS expression ) | STRENDS OPEN_BRACE expression CLOSE_BRACE -> ^( STRENDS expression ) | YEAR OPEN_BRACE expression CLOSE_BRACE -> ^( YEAR expression ) | MONTH OPEN_BRACE expression CLOSE_BRACE -> ^( MONTH expression ) | DAY OPEN_BRACE expression CLOSE_BRACE -> ^( DAY expression ) | HOURS OPEN_BRACE expression CLOSE_BRACE -> ^( HOURS expression ) | MINUTES OPEN_BRACE expression CLOSE_BRACE -> ^( MINUTES expression ) | SECONDS OPEN_BRACE expression CLOSE_BRACE -> ^( SECONDS expression ) | TIMEZONE OPEN_BRACE expression CLOSE_BRACE -> ^( TIMEZONE expression ) | TZ OPEN_BRACE expression CLOSE_BRACE -> ^( TZ expression ) | NOW nil -> NOW | MD5 OPEN_BRACE expression CLOSE_BRACE -> ^( MD5 expression ) | SHA1 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA1 expression ) | SHA224 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA224 expression ) | SHA256 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA256 expression ) | SHA384 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA384 expression ) | SHA512 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA512 expression ) | COALESCE expressionList -> ^( COALESCE expressionList ) | IF OPEN_BRACE e1= expression COMMA e2= expression COMMA e3= expression CLOSE_BRACE -> ^( IF $e1 $e2 $e3) | STRLANG OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRLANG expression expression ) | STRDT OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRDT expression expression ) | SAMETERM OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( SAMETERM expression expression ) | ISIRI OPEN_BRACE expression CLOSE_BRACE -> ^( ISIRI expression ) | ISURI OPEN_BRACE expression CLOSE_BRACE -> ^( ISURI expression ) | ISBLANK OPEN_BRACE expression CLOSE_BRACE -> ^( ISBLANK expression ) | ISLITERAL OPEN_BRACE expression CLOSE_BRACE -> ^( ISLITERAL expression ) | ISNUMERIC OPEN_BRACE expression CLOSE_BRACE -> ^( ISNUMERIC expression ) | regexExpression -> regexExpression | existsFunction -> existsFunction | notExistsFunction -> notExistsFunction );
	public final SparqlifyConfigParser.builtInCall_return builtInCall() throws RecognitionException {
		SparqlifyConfigParser.builtInCall_return retval = new SparqlifyConfigParser.builtInCall_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token STR485=null;
		Token OPEN_BRACE486=null;
		Token CLOSE_BRACE488=null;
		Token LANG489=null;
		Token OPEN_BRACE490=null;
		Token CLOSE_BRACE492=null;
		Token LANGMATCHES493=null;
		Token OPEN_BRACE494=null;
		Token COMMA496=null;
		Token CLOSE_BRACE498=null;
		Token DATATYPE499=null;
		Token OPEN_BRACE500=null;
		Token CLOSE_BRACE502=null;
		Token BOUND503=null;
		Token OPEN_BRACE504=null;
		Token CLOSE_BRACE506=null;
		Token IRI507=null;
		Token OPEN_BRACE508=null;
		Token CLOSE_BRACE510=null;
		Token URI511=null;
		Token OPEN_BRACE512=null;
		Token CLOSE_BRACE514=null;
		Token BNODE515=null;
		Token OPEN_BRACE516=null;
		Token CLOSE_BRACE518=null;
		Token RAND520=null;
		Token ABS522=null;
		Token OPEN_BRACE523=null;
		Token CLOSE_BRACE525=null;
		Token CEIL526=null;
		Token OPEN_BRACE527=null;
		Token CLOSE_BRACE529=null;
		Token FLOOR530=null;
		Token OPEN_BRACE531=null;
		Token CLOSE_BRACE533=null;
		Token ROUND534=null;
		Token OPEN_BRACE535=null;
		Token CLOSE_BRACE537=null;
		Token CONCAT538=null;
		Token STRLEN541=null;
		Token OPEN_BRACE542=null;
		Token CLOSE_BRACE544=null;
		Token UCASE545=null;
		Token OPEN_BRACE546=null;
		Token CLOSE_BRACE548=null;
		Token LCASE549=null;
		Token OPEN_BRACE550=null;
		Token CLOSE_BRACE552=null;
		Token ENCODE_FOR_URI553=null;
		Token OPEN_BRACE554=null;
		Token CLOSE_BRACE556=null;
		Token CONTAINS557=null;
		Token OPEN_BRACE558=null;
		Token CLOSE_BRACE560=null;
		Token STRSTARTS561=null;
		Token OPEN_BRACE562=null;
		Token CLOSE_BRACE564=null;
		Token STRENDS565=null;
		Token OPEN_BRACE566=null;
		Token CLOSE_BRACE568=null;
		Token YEAR569=null;
		Token OPEN_BRACE570=null;
		Token CLOSE_BRACE572=null;
		Token MONTH573=null;
		Token OPEN_BRACE574=null;
		Token CLOSE_BRACE576=null;
		Token DAY577=null;
		Token OPEN_BRACE578=null;
		Token CLOSE_BRACE580=null;
		Token HOURS581=null;
		Token OPEN_BRACE582=null;
		Token CLOSE_BRACE584=null;
		Token MINUTES585=null;
		Token OPEN_BRACE586=null;
		Token CLOSE_BRACE588=null;
		Token SECONDS589=null;
		Token OPEN_BRACE590=null;
		Token CLOSE_BRACE592=null;
		Token TIMEZONE593=null;
		Token OPEN_BRACE594=null;
		Token CLOSE_BRACE596=null;
		Token TZ597=null;
		Token OPEN_BRACE598=null;
		Token CLOSE_BRACE600=null;
		Token NOW601=null;
		Token MD5603=null;
		Token OPEN_BRACE604=null;
		Token CLOSE_BRACE606=null;
		Token SHA1607=null;
		Token OPEN_BRACE608=null;
		Token CLOSE_BRACE610=null;
		Token SHA224611=null;
		Token OPEN_BRACE612=null;
		Token CLOSE_BRACE614=null;
		Token SHA256615=null;
		Token OPEN_BRACE616=null;
		Token CLOSE_BRACE618=null;
		Token SHA384619=null;
		Token OPEN_BRACE620=null;
		Token CLOSE_BRACE622=null;
		Token SHA512623=null;
		Token OPEN_BRACE624=null;
		Token CLOSE_BRACE626=null;
		Token COALESCE627=null;
		Token IF629=null;
		Token OPEN_BRACE630=null;
		Token COMMA631=null;
		Token COMMA632=null;
		Token CLOSE_BRACE633=null;
		Token STRLANG634=null;
		Token OPEN_BRACE635=null;
		Token COMMA637=null;
		Token CLOSE_BRACE639=null;
		Token STRDT640=null;
		Token OPEN_BRACE641=null;
		Token COMMA643=null;
		Token CLOSE_BRACE645=null;
		Token SAMETERM646=null;
		Token OPEN_BRACE647=null;
		Token COMMA649=null;
		Token CLOSE_BRACE651=null;
		Token ISIRI652=null;
		Token OPEN_BRACE653=null;
		Token CLOSE_BRACE655=null;
		Token ISURI656=null;
		Token OPEN_BRACE657=null;
		Token CLOSE_BRACE659=null;
		Token ISBLANK660=null;
		Token OPEN_BRACE661=null;
		Token CLOSE_BRACE663=null;
		Token ISLITERAL664=null;
		Token OPEN_BRACE665=null;
		Token CLOSE_BRACE667=null;
		Token ISNUMERIC668=null;
		Token OPEN_BRACE669=null;
		Token CLOSE_BRACE671=null;
		ParserRuleReturnScope e1 =null;
		ParserRuleReturnScope e2 =null;
		ParserRuleReturnScope e3 =null;
		ParserRuleReturnScope expression487 =null;
		ParserRuleReturnScope expression491 =null;
		ParserRuleReturnScope expression495 =null;
		ParserRuleReturnScope expression497 =null;
		ParserRuleReturnScope expression501 =null;
		ParserRuleReturnScope var505 =null;
		ParserRuleReturnScope expression509 =null;
		ParserRuleReturnScope expression513 =null;
		ParserRuleReturnScope expression517 =null;
		ParserRuleReturnScope nil519 =null;
		ParserRuleReturnScope nil521 =null;
		ParserRuleReturnScope expression524 =null;
		ParserRuleReturnScope expression528 =null;
		ParserRuleReturnScope expression532 =null;
		ParserRuleReturnScope expression536 =null;
		ParserRuleReturnScope expressionList539 =null;
		ParserRuleReturnScope subStringExpression540 =null;
		ParserRuleReturnScope expression543 =null;
		ParserRuleReturnScope expression547 =null;
		ParserRuleReturnScope expression551 =null;
		ParserRuleReturnScope expression555 =null;
		ParserRuleReturnScope expression559 =null;
		ParserRuleReturnScope expression563 =null;
		ParserRuleReturnScope expression567 =null;
		ParserRuleReturnScope expression571 =null;
		ParserRuleReturnScope expression575 =null;
		ParserRuleReturnScope expression579 =null;
		ParserRuleReturnScope expression583 =null;
		ParserRuleReturnScope expression587 =null;
		ParserRuleReturnScope expression591 =null;
		ParserRuleReturnScope expression595 =null;
		ParserRuleReturnScope expression599 =null;
		ParserRuleReturnScope nil602 =null;
		ParserRuleReturnScope expression605 =null;
		ParserRuleReturnScope expression609 =null;
		ParserRuleReturnScope expression613 =null;
		ParserRuleReturnScope expression617 =null;
		ParserRuleReturnScope expression621 =null;
		ParserRuleReturnScope expression625 =null;
		ParserRuleReturnScope expressionList628 =null;
		ParserRuleReturnScope expression636 =null;
		ParserRuleReturnScope expression638 =null;
		ParserRuleReturnScope expression642 =null;
		ParserRuleReturnScope expression644 =null;
		ParserRuleReturnScope expression648 =null;
		ParserRuleReturnScope expression650 =null;
		ParserRuleReturnScope expression654 =null;
		ParserRuleReturnScope expression658 =null;
		ParserRuleReturnScope expression662 =null;
		ParserRuleReturnScope expression666 =null;
		ParserRuleReturnScope expression670 =null;
		ParserRuleReturnScope regexExpression672 =null;
		ParserRuleReturnScope existsFunction673 =null;
		ParserRuleReturnScope notExistsFunction674 =null;

		CommonTree STR485_tree=null;
		CommonTree OPEN_BRACE486_tree=null;
		CommonTree CLOSE_BRACE488_tree=null;
		CommonTree LANG489_tree=null;
		CommonTree OPEN_BRACE490_tree=null;
		CommonTree CLOSE_BRACE492_tree=null;
		CommonTree LANGMATCHES493_tree=null;
		CommonTree OPEN_BRACE494_tree=null;
		CommonTree COMMA496_tree=null;
		CommonTree CLOSE_BRACE498_tree=null;
		CommonTree DATATYPE499_tree=null;
		CommonTree OPEN_BRACE500_tree=null;
		CommonTree CLOSE_BRACE502_tree=null;
		CommonTree BOUND503_tree=null;
		CommonTree OPEN_BRACE504_tree=null;
		CommonTree CLOSE_BRACE506_tree=null;
		CommonTree IRI507_tree=null;
		CommonTree OPEN_BRACE508_tree=null;
		CommonTree CLOSE_BRACE510_tree=null;
		CommonTree URI511_tree=null;
		CommonTree OPEN_BRACE512_tree=null;
		CommonTree CLOSE_BRACE514_tree=null;
		CommonTree BNODE515_tree=null;
		CommonTree OPEN_BRACE516_tree=null;
		CommonTree CLOSE_BRACE518_tree=null;
		CommonTree RAND520_tree=null;
		CommonTree ABS522_tree=null;
		CommonTree OPEN_BRACE523_tree=null;
		CommonTree CLOSE_BRACE525_tree=null;
		CommonTree CEIL526_tree=null;
		CommonTree OPEN_BRACE527_tree=null;
		CommonTree CLOSE_BRACE529_tree=null;
		CommonTree FLOOR530_tree=null;
		CommonTree OPEN_BRACE531_tree=null;
		CommonTree CLOSE_BRACE533_tree=null;
		CommonTree ROUND534_tree=null;
		CommonTree OPEN_BRACE535_tree=null;
		CommonTree CLOSE_BRACE537_tree=null;
		CommonTree CONCAT538_tree=null;
		CommonTree STRLEN541_tree=null;
		CommonTree OPEN_BRACE542_tree=null;
		CommonTree CLOSE_BRACE544_tree=null;
		CommonTree UCASE545_tree=null;
		CommonTree OPEN_BRACE546_tree=null;
		CommonTree CLOSE_BRACE548_tree=null;
		CommonTree LCASE549_tree=null;
		CommonTree OPEN_BRACE550_tree=null;
		CommonTree CLOSE_BRACE552_tree=null;
		CommonTree ENCODE_FOR_URI553_tree=null;
		CommonTree OPEN_BRACE554_tree=null;
		CommonTree CLOSE_BRACE556_tree=null;
		CommonTree CONTAINS557_tree=null;
		CommonTree OPEN_BRACE558_tree=null;
		CommonTree CLOSE_BRACE560_tree=null;
		CommonTree STRSTARTS561_tree=null;
		CommonTree OPEN_BRACE562_tree=null;
		CommonTree CLOSE_BRACE564_tree=null;
		CommonTree STRENDS565_tree=null;
		CommonTree OPEN_BRACE566_tree=null;
		CommonTree CLOSE_BRACE568_tree=null;
		CommonTree YEAR569_tree=null;
		CommonTree OPEN_BRACE570_tree=null;
		CommonTree CLOSE_BRACE572_tree=null;
		CommonTree MONTH573_tree=null;
		CommonTree OPEN_BRACE574_tree=null;
		CommonTree CLOSE_BRACE576_tree=null;
		CommonTree DAY577_tree=null;
		CommonTree OPEN_BRACE578_tree=null;
		CommonTree CLOSE_BRACE580_tree=null;
		CommonTree HOURS581_tree=null;
		CommonTree OPEN_BRACE582_tree=null;
		CommonTree CLOSE_BRACE584_tree=null;
		CommonTree MINUTES585_tree=null;
		CommonTree OPEN_BRACE586_tree=null;
		CommonTree CLOSE_BRACE588_tree=null;
		CommonTree SECONDS589_tree=null;
		CommonTree OPEN_BRACE590_tree=null;
		CommonTree CLOSE_BRACE592_tree=null;
		CommonTree TIMEZONE593_tree=null;
		CommonTree OPEN_BRACE594_tree=null;
		CommonTree CLOSE_BRACE596_tree=null;
		CommonTree TZ597_tree=null;
		CommonTree OPEN_BRACE598_tree=null;
		CommonTree CLOSE_BRACE600_tree=null;
		CommonTree NOW601_tree=null;
		CommonTree MD5603_tree=null;
		CommonTree OPEN_BRACE604_tree=null;
		CommonTree CLOSE_BRACE606_tree=null;
		CommonTree SHA1607_tree=null;
		CommonTree OPEN_BRACE608_tree=null;
		CommonTree CLOSE_BRACE610_tree=null;
		CommonTree SHA224611_tree=null;
		CommonTree OPEN_BRACE612_tree=null;
		CommonTree CLOSE_BRACE614_tree=null;
		CommonTree SHA256615_tree=null;
		CommonTree OPEN_BRACE616_tree=null;
		CommonTree CLOSE_BRACE618_tree=null;
		CommonTree SHA384619_tree=null;
		CommonTree OPEN_BRACE620_tree=null;
		CommonTree CLOSE_BRACE622_tree=null;
		CommonTree SHA512623_tree=null;
		CommonTree OPEN_BRACE624_tree=null;
		CommonTree CLOSE_BRACE626_tree=null;
		CommonTree COALESCE627_tree=null;
		CommonTree IF629_tree=null;
		CommonTree OPEN_BRACE630_tree=null;
		CommonTree COMMA631_tree=null;
		CommonTree COMMA632_tree=null;
		CommonTree CLOSE_BRACE633_tree=null;
		CommonTree STRLANG634_tree=null;
		CommonTree OPEN_BRACE635_tree=null;
		CommonTree COMMA637_tree=null;
		CommonTree CLOSE_BRACE639_tree=null;
		CommonTree STRDT640_tree=null;
		CommonTree OPEN_BRACE641_tree=null;
		CommonTree COMMA643_tree=null;
		CommonTree CLOSE_BRACE645_tree=null;
		CommonTree SAMETERM646_tree=null;
		CommonTree OPEN_BRACE647_tree=null;
		CommonTree COMMA649_tree=null;
		CommonTree CLOSE_BRACE651_tree=null;
		CommonTree ISIRI652_tree=null;
		CommonTree OPEN_BRACE653_tree=null;
		CommonTree CLOSE_BRACE655_tree=null;
		CommonTree ISURI656_tree=null;
		CommonTree OPEN_BRACE657_tree=null;
		CommonTree CLOSE_BRACE659_tree=null;
		CommonTree ISBLANK660_tree=null;
		CommonTree OPEN_BRACE661_tree=null;
		CommonTree CLOSE_BRACE663_tree=null;
		CommonTree ISLITERAL664_tree=null;
		CommonTree OPEN_BRACE665_tree=null;
		CommonTree CLOSE_BRACE667_tree=null;
		CommonTree ISNUMERIC668_tree=null;
		CommonTree OPEN_BRACE669_tree=null;
		CommonTree CLOSE_BRACE671_tree=null;
		RewriteRuleTokenStream stream_SHA256=new RewriteRuleTokenStream(adaptor,"token SHA256");
		RewriteRuleTokenStream stream_YEAR=new RewriteRuleTokenStream(adaptor,"token YEAR");
		RewriteRuleTokenStream stream_TIMEZONE=new RewriteRuleTokenStream(adaptor,"token TIMEZONE");
		RewriteRuleTokenStream stream_CONTAINS=new RewriteRuleTokenStream(adaptor,"token CONTAINS");
		RewriteRuleTokenStream stream_STRENDS=new RewriteRuleTokenStream(adaptor,"token STRENDS");
		RewriteRuleTokenStream stream_LCASE=new RewriteRuleTokenStream(adaptor,"token LCASE");
		RewriteRuleTokenStream stream_BNODE=new RewriteRuleTokenStream(adaptor,"token BNODE");
		RewriteRuleTokenStream stream_SHA512=new RewriteRuleTokenStream(adaptor,"token SHA512");
		RewriteRuleTokenStream stream_SECONDS=new RewriteRuleTokenStream(adaptor,"token SECONDS");
		RewriteRuleTokenStream stream_NOW=new RewriteRuleTokenStream(adaptor,"token NOW");
		RewriteRuleTokenStream stream_DAY=new RewriteRuleTokenStream(adaptor,"token DAY");
		RewriteRuleTokenStream stream_SHA224=new RewriteRuleTokenStream(adaptor,"token SHA224");
		RewriteRuleTokenStream stream_STRLEN=new RewriteRuleTokenStream(adaptor,"token STRLEN");
		RewriteRuleTokenStream stream_MONTH=new RewriteRuleTokenStream(adaptor,"token MONTH");
		RewriteRuleTokenStream stream_ENCODE_FOR_URI=new RewriteRuleTokenStream(adaptor,"token ENCODE_FOR_URI");
		RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
		RewriteRuleTokenStream stream_ISURI=new RewriteRuleTokenStream(adaptor,"token ISURI");
		RewriteRuleTokenStream stream_STR=new RewriteRuleTokenStream(adaptor,"token STR");
		RewriteRuleTokenStream stream_STRDT=new RewriteRuleTokenStream(adaptor,"token STRDT");
		RewriteRuleTokenStream stream_ISLITERAL=new RewriteRuleTokenStream(adaptor,"token ISLITERAL");
		RewriteRuleTokenStream stream_SAMETERM=new RewriteRuleTokenStream(adaptor,"token SAMETERM");
		RewriteRuleTokenStream stream_MD5=new RewriteRuleTokenStream(adaptor,"token MD5");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_RAND=new RewriteRuleTokenStream(adaptor,"token RAND");
		RewriteRuleTokenStream stream_IRI=new RewriteRuleTokenStream(adaptor,"token IRI");
		RewriteRuleTokenStream stream_LANGMATCHES=new RewriteRuleTokenStream(adaptor,"token LANGMATCHES");
		RewriteRuleTokenStream stream_TZ=new RewriteRuleTokenStream(adaptor,"token TZ");
		RewriteRuleTokenStream stream_STRLANG=new RewriteRuleTokenStream(adaptor,"token STRLANG");
		RewriteRuleTokenStream stream_BOUND=new RewriteRuleTokenStream(adaptor,"token BOUND");
		RewriteRuleTokenStream stream_ISIRI=new RewriteRuleTokenStream(adaptor,"token ISIRI");
		RewriteRuleTokenStream stream_COALESCE=new RewriteRuleTokenStream(adaptor,"token COALESCE");
		RewriteRuleTokenStream stream_ISNUMERIC=new RewriteRuleTokenStream(adaptor,"token ISNUMERIC");
		RewriteRuleTokenStream stream_CONCAT=new RewriteRuleTokenStream(adaptor,"token CONCAT");
		RewriteRuleTokenStream stream_STRSTARTS=new RewriteRuleTokenStream(adaptor,"token STRSTARTS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_SHA1=new RewriteRuleTokenStream(adaptor,"token SHA1");
		RewriteRuleTokenStream stream_FLOOR=new RewriteRuleTokenStream(adaptor,"token FLOOR");
		RewriteRuleTokenStream stream_ISBLANK=new RewriteRuleTokenStream(adaptor,"token ISBLANK");
		RewriteRuleTokenStream stream_UCASE=new RewriteRuleTokenStream(adaptor,"token UCASE");
		RewriteRuleTokenStream stream_URI=new RewriteRuleTokenStream(adaptor,"token URI");
		RewriteRuleTokenStream stream_ABS=new RewriteRuleTokenStream(adaptor,"token ABS");
		RewriteRuleTokenStream stream_MINUTES=new RewriteRuleTokenStream(adaptor,"token MINUTES");
		RewriteRuleTokenStream stream_ROUND=new RewriteRuleTokenStream(adaptor,"token ROUND");
		RewriteRuleTokenStream stream_CEIL=new RewriteRuleTokenStream(adaptor,"token CEIL");
		RewriteRuleTokenStream stream_DATATYPE=new RewriteRuleTokenStream(adaptor,"token DATATYPE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_SHA384=new RewriteRuleTokenStream(adaptor,"token SHA384");
		RewriteRuleTokenStream stream_HOURS=new RewriteRuleTokenStream(adaptor,"token HOURS");
		RewriteRuleTokenStream stream_LANG=new RewriteRuleTokenStream(adaptor,"token LANG");
		RewriteRuleSubtreeStream stream_existsFunction=new RewriteRuleSubtreeStream(adaptor,"rule existsFunction");
		RewriteRuleSubtreeStream stream_subStringExpression=new RewriteRuleSubtreeStream(adaptor,"rule subStringExpression");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_notExistsFunction=new RewriteRuleSubtreeStream(adaptor,"rule notExistsFunction");
		RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_regexExpression=new RewriteRuleSubtreeStream(adaptor,"rule regexExpression");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:868:5: ( STR OPEN_BRACE expression CLOSE_BRACE -> ^( STR expression ) | LANG OPEN_BRACE expression CLOSE_BRACE -> ^( LANG expression ) | LANGMATCHES OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( LANGMATCHES ( expression )+ ) | DATATYPE OPEN_BRACE expression CLOSE_BRACE -> ^( DATATYPE expression ) | BOUND OPEN_BRACE var CLOSE_BRACE -> ^( BOUND var ) | IRI OPEN_BRACE expression CLOSE_BRACE -> ^( IRI expression ) | URI OPEN_BRACE expression CLOSE_BRACE -> ^( URI expression ) | BNODE ( OPEN_BRACE expression CLOSE_BRACE | nil ) -> ^( BNODE expression ) | RAND nil -> RAND | ABS OPEN_BRACE expression CLOSE_BRACE -> ^( ABS expression ) | CEIL OPEN_BRACE expression CLOSE_BRACE -> ^( CEIL expression ) | FLOOR OPEN_BRACE expression CLOSE_BRACE -> ^( FLOOR expression ) | ROUND OPEN_BRACE expression CLOSE_BRACE -> ^( ROUND expression ) | CONCAT expressionList -> ^( CONCAT expressionList ) | subStringExpression -> subStringExpression | STRLEN OPEN_BRACE expression CLOSE_BRACE -> ^( STRLEN expression ) | UCASE OPEN_BRACE expression CLOSE_BRACE -> ^( UCASE expression ) | LCASE OPEN_BRACE expression CLOSE_BRACE -> ^( LCASE expression ) | ENCODE_FOR_URI OPEN_BRACE expression CLOSE_BRACE -> ^( ENCODE_FOR_URI expression ) | CONTAINS OPEN_BRACE expression CLOSE_BRACE -> ^( CONTAINS expression ) | STRSTARTS OPEN_BRACE expression CLOSE_BRACE -> ^( STRSTARTS expression ) | STRENDS OPEN_BRACE expression CLOSE_BRACE -> ^( STRENDS expression ) | YEAR OPEN_BRACE expression CLOSE_BRACE -> ^( YEAR expression ) | MONTH OPEN_BRACE expression CLOSE_BRACE -> ^( MONTH expression ) | DAY OPEN_BRACE expression CLOSE_BRACE -> ^( DAY expression ) | HOURS OPEN_BRACE expression CLOSE_BRACE -> ^( HOURS expression ) | MINUTES OPEN_BRACE expression CLOSE_BRACE -> ^( MINUTES expression ) | SECONDS OPEN_BRACE expression CLOSE_BRACE -> ^( SECONDS expression ) | TIMEZONE OPEN_BRACE expression CLOSE_BRACE -> ^( TIMEZONE expression ) | TZ OPEN_BRACE expression CLOSE_BRACE -> ^( TZ expression ) | NOW nil -> NOW | MD5 OPEN_BRACE expression CLOSE_BRACE -> ^( MD5 expression ) | SHA1 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA1 expression ) | SHA224 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA224 expression ) | SHA256 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA256 expression ) | SHA384 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA384 expression ) | SHA512 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA512 expression ) | COALESCE expressionList -> ^( COALESCE expressionList ) | IF OPEN_BRACE e1= expression COMMA e2= expression COMMA e3= expression CLOSE_BRACE -> ^( IF $e1 $e2 $e3) | STRLANG OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRLANG expression expression ) | STRDT OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRDT expression expression ) | SAMETERM OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( SAMETERM expression expression ) | ISIRI OPEN_BRACE expression CLOSE_BRACE -> ^( ISIRI expression ) | ISURI OPEN_BRACE expression CLOSE_BRACE -> ^( ISURI expression ) | ISBLANK OPEN_BRACE expression CLOSE_BRACE -> ^( ISBLANK expression ) | ISLITERAL OPEN_BRACE expression CLOSE_BRACE -> ^( ISLITERAL expression ) | ISNUMERIC OPEN_BRACE expression CLOSE_BRACE -> ^( ISNUMERIC expression ) | regexExpression -> regexExpression | existsFunction -> existsFunction | notExistsFunction -> notExistsFunction )
			int alt155=50;
			switch ( input.LA(1) ) {
			case STR:
				{
				alt155=1;
				}
				break;
			case LANG:
				{
				alt155=2;
				}
				break;
			case LANGMATCHES:
				{
				alt155=3;
				}
				break;
			case DATATYPE:
				{
				alt155=4;
				}
				break;
			case BOUND:
				{
				alt155=5;
				}
				break;
			case IRI:
				{
				alt155=6;
				}
				break;
			case URI:
				{
				alt155=7;
				}
				break;
			case BNODE:
				{
				alt155=8;
				}
				break;
			case RAND:
				{
				alt155=9;
				}
				break;
			case ABS:
				{
				alt155=10;
				}
				break;
			case CEIL:
				{
				alt155=11;
				}
				break;
			case FLOOR:
				{
				alt155=12;
				}
				break;
			case ROUND:
				{
				alt155=13;
				}
				break;
			case CONCAT:
				{
				alt155=14;
				}
				break;
			case SUBSTR:
				{
				alt155=15;
				}
				break;
			case STRLEN:
				{
				alt155=16;
				}
				break;
			case UCASE:
				{
				alt155=17;
				}
				break;
			case LCASE:
				{
				alt155=18;
				}
				break;
			case ENCODE_FOR_URI:
				{
				alt155=19;
				}
				break;
			case CONTAINS:
				{
				alt155=20;
				}
				break;
			case STRSTARTS:
				{
				alt155=21;
				}
				break;
			case STRENDS:
				{
				alt155=22;
				}
				break;
			case YEAR:
				{
				alt155=23;
				}
				break;
			case MONTH:
				{
				alt155=24;
				}
				break;
			case DAY:
				{
				alt155=25;
				}
				break;
			case HOURS:
				{
				alt155=26;
				}
				break;
			case MINUTES:
				{
				alt155=27;
				}
				break;
			case SECONDS:
				{
				alt155=28;
				}
				break;
			case TIMEZONE:
				{
				alt155=29;
				}
				break;
			case TZ:
				{
				alt155=30;
				}
				break;
			case NOW:
				{
				alt155=31;
				}
				break;
			case MD5:
				{
				alt155=32;
				}
				break;
			case SHA1:
				{
				alt155=33;
				}
				break;
			case SHA224:
				{
				alt155=34;
				}
				break;
			case SHA256:
				{
				alt155=35;
				}
				break;
			case SHA384:
				{
				alt155=36;
				}
				break;
			case SHA512:
				{
				alt155=37;
				}
				break;
			case COALESCE:
				{
				alt155=38;
				}
				break;
			case IF:
				{
				alt155=39;
				}
				break;
			case STRLANG:
				{
				alt155=40;
				}
				break;
			case STRDT:
				{
				alt155=41;
				}
				break;
			case SAMETERM:
				{
				alt155=42;
				}
				break;
			case ISIRI:
				{
				alt155=43;
				}
				break;
			case ISURI:
				{
				alt155=44;
				}
				break;
			case ISBLANK:
				{
				alt155=45;
				}
				break;
			case ISLITERAL:
				{
				alt155=46;
				}
				break;
			case ISNUMERIC:
				{
				alt155=47;
				}
				break;
			case REGEX:
				{
				alt155=48;
				}
				break;
			case EXISTS:
				{
				alt155=49;
				}
				break;
			case NOT:
				{
				alt155=50;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 155, 0, input);
				throw nvae;
			}
			switch (alt155) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:868:7: STR OPEN_BRACE expression CLOSE_BRACE
					{
					STR485=(Token)match(input,STR,FOLLOW_STR_in_builtInCall6554);  
					stream_STR.add(STR485);

					OPEN_BRACE486=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6556);  
					stream_OPEN_BRACE.add(OPEN_BRACE486);

					pushFollow(FOLLOW_expression_in_builtInCall6558);
					expression487=expression();
					state._fsp--;

					stream_expression.add(expression487.getTree());
					CLOSE_BRACE488=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6560);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE488);

					// AST REWRITE
					// elements: STR, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 868:45: -> ^( STR expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:868:48: ^( STR expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:869:7: LANG OPEN_BRACE expression CLOSE_BRACE
					{
					LANG489=(Token)match(input,LANG,FOLLOW_LANG_in_builtInCall6576);  
					stream_LANG.add(LANG489);

					OPEN_BRACE490=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6578);  
					stream_OPEN_BRACE.add(OPEN_BRACE490);

					pushFollow(FOLLOW_expression_in_builtInCall6580);
					expression491=expression();
					state._fsp--;

					stream_expression.add(expression491.getTree());
					CLOSE_BRACE492=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6582);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE492);

					// AST REWRITE
					// elements: expression, LANG
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 869:46: -> ^( LANG expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:869:49: ^( LANG expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LANG.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:870:7: LANGMATCHES OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					LANGMATCHES493=(Token)match(input,LANGMATCHES,FOLLOW_LANGMATCHES_in_builtInCall6598);  
					stream_LANGMATCHES.add(LANGMATCHES493);

					OPEN_BRACE494=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6600);  
					stream_OPEN_BRACE.add(OPEN_BRACE494);

					pushFollow(FOLLOW_expression_in_builtInCall6602);
					expression495=expression();
					state._fsp--;

					stream_expression.add(expression495.getTree());
					COMMA496=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall6604);  
					stream_COMMA.add(COMMA496);

					pushFollow(FOLLOW_expression_in_builtInCall6606);
					expression497=expression();
					state._fsp--;

					stream_expression.add(expression497.getTree());
					CLOSE_BRACE498=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6608);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE498);

					// AST REWRITE
					// elements: expression, LANGMATCHES
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 870:70: -> ^( LANGMATCHES ( expression )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:870:73: ^( LANGMATCHES ( expression )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LANGMATCHES.nextNode(), root_1);
						if ( !(stream_expression.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_1, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:871:7: DATATYPE OPEN_BRACE expression CLOSE_BRACE
					{
					DATATYPE499=(Token)match(input,DATATYPE,FOLLOW_DATATYPE_in_builtInCall6625);  
					stream_DATATYPE.add(DATATYPE499);

					OPEN_BRACE500=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6627);  
					stream_OPEN_BRACE.add(OPEN_BRACE500);

					pushFollow(FOLLOW_expression_in_builtInCall6629);
					expression501=expression();
					state._fsp--;

					stream_expression.add(expression501.getTree());
					CLOSE_BRACE502=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6631);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE502);

					// AST REWRITE
					// elements: DATATYPE, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 871:50: -> ^( DATATYPE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:871:53: ^( DATATYPE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_DATATYPE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:872:7: BOUND OPEN_BRACE var CLOSE_BRACE
					{
					BOUND503=(Token)match(input,BOUND,FOLLOW_BOUND_in_builtInCall6647);  
					stream_BOUND.add(BOUND503);

					OPEN_BRACE504=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6649);  
					stream_OPEN_BRACE.add(OPEN_BRACE504);

					pushFollow(FOLLOW_var_in_builtInCall6651);
					var505=var();
					state._fsp--;

					stream_var.add(var505.getTree());
					CLOSE_BRACE506=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6653);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE506);

					// AST REWRITE
					// elements: BOUND, var
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 872:40: -> ^( BOUND var )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:872:43: ^( BOUND var )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_BOUND.nextNode(), root_1);
						adaptor.addChild(root_1, stream_var.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:873:7: IRI OPEN_BRACE expression CLOSE_BRACE
					{
					IRI507=(Token)match(input,IRI,FOLLOW_IRI_in_builtInCall6669);  
					stream_IRI.add(IRI507);

					OPEN_BRACE508=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6671);  
					stream_OPEN_BRACE.add(OPEN_BRACE508);

					pushFollow(FOLLOW_expression_in_builtInCall6673);
					expression509=expression();
					state._fsp--;

					stream_expression.add(expression509.getTree());
					CLOSE_BRACE510=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6675);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE510);

					// AST REWRITE
					// elements: IRI, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 873:45: -> ^( IRI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:873:48: ^( IRI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_IRI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:874:7: URI OPEN_BRACE expression CLOSE_BRACE
					{
					URI511=(Token)match(input,URI,FOLLOW_URI_in_builtInCall6691);  
					stream_URI.add(URI511);

					OPEN_BRACE512=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6693);  
					stream_OPEN_BRACE.add(OPEN_BRACE512);

					pushFollow(FOLLOW_expression_in_builtInCall6695);
					expression513=expression();
					state._fsp--;

					stream_expression.add(expression513.getTree());
					CLOSE_BRACE514=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6697);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE514);

					// AST REWRITE
					// elements: URI, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 874:45: -> ^( URI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:874:48: ^( URI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_URI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:7: BNODE ( OPEN_BRACE expression CLOSE_BRACE | nil )
					{
					BNODE515=(Token)match(input,BNODE,FOLLOW_BNODE_in_builtInCall6713);  
					stream_BNODE.add(BNODE515);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:13: ( OPEN_BRACE expression CLOSE_BRACE | nil )
					int alt154=2;
					int LA154_0 = input.LA(1);
					if ( (LA154_0==OPEN_BRACE) ) {
						int LA154_1 = input.LA(2);
						if ( (LA154_1==CLOSE_BRACE) ) {
							alt154=2;
						}
						else if ( (LA154_1==ABS||LA154_1==AVG||(LA154_1 >= BNODE && LA154_1 <= BOUND)||LA154_1==CEIL||LA154_1==COALESCE||LA154_1==CONCAT||LA154_1==CONTAINS||LA154_1==COUNT||(LA154_1 >= DATATYPE && LA154_1 <= DECIMAL_POSITIVE)||(LA154_1 >= DOUBLE && LA154_1 <= DOUBLE_POSITIVE)||LA154_1==ENCODE_FOR_URI||LA154_1==EXISTS||LA154_1==FALSE||LA154_1==FLOOR||LA154_1==GROUP_CONCAT||(LA154_1 >= HOURS && LA154_1 <= IF)||(LA154_1 >= INTEGER && LA154_1 <= INTEGER_POSITIVE)||(LA154_1 >= IRI && LA154_1 <= IRI_REF)||(LA154_1 >= ISBLANK && LA154_1 <= ISURI)||(LA154_1 >= LANG && LA154_1 <= LANGMATCHES)||LA154_1==LCASE||(LA154_1 >= MAX && LA154_1 <= MINUS)||LA154_1==MINUTES||LA154_1==MONTH||LA154_1==NAME||LA154_1==NEGATION||LA154_1==NOT||LA154_1==NOW||LA154_1==OPEN_BRACE||(LA154_1 >= PLUS && LA154_1 <= PNAME_NS)||LA154_1==RAND||LA154_1==REGEX||(LA154_1 >= ROUND && LA154_1 <= SECONDS)||(LA154_1 >= SHA1 && LA154_1 <= SHA512)||(LA154_1 >= STR && LA154_1 <= STRENDS)||(LA154_1 >= STRING_LITERAL1 && LA154_1 <= STRSTARTS)||(LA154_1 >= SUBSTR && LA154_1 <= SUM)||LA154_1==TIMEZONE||LA154_1==TRUE||(LA154_1 >= TZ && LA154_1 <= UCASE)||LA154_1==URI||(LA154_1 >= VAR1 && LA154_1 <= VAR3)||LA154_1==YEAR) ) {
							alt154=1;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 154, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 154, 0, input);
						throw nvae;
					}

					switch (alt154) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:14: OPEN_BRACE expression CLOSE_BRACE
							{
							OPEN_BRACE516=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6716);  
							stream_OPEN_BRACE.add(OPEN_BRACE516);

							pushFollow(FOLLOW_expression_in_builtInCall6718);
							expression517=expression();
							state._fsp--;

							stream_expression.add(expression517.getTree());
							CLOSE_BRACE518=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6720);  
							stream_CLOSE_BRACE.add(CLOSE_BRACE518);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:49: nil
							{
							pushFollow(FOLLOW_nil_in_builtInCall6723);
							nil519=nil();
							state._fsp--;

							stream_nil.add(nil519.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: expression, BNODE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 875:54: -> ^( BNODE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:57: ^( BNODE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_BNODE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:876:7: RAND nil
					{
					RAND520=(Token)match(input,RAND,FOLLOW_RAND_in_builtInCall6740);  
					stream_RAND.add(RAND520);

					pushFollow(FOLLOW_nil_in_builtInCall6742);
					nil521=nil();
					state._fsp--;

					stream_nil.add(nil521.getTree());
					// AST REWRITE
					// elements: RAND
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 876:16: -> RAND
					{
						adaptor.addChild(root_0, stream_RAND.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:877:7: ABS OPEN_BRACE expression CLOSE_BRACE
					{
					ABS522=(Token)match(input,ABS,FOLLOW_ABS_in_builtInCall6754);  
					stream_ABS.add(ABS522);

					OPEN_BRACE523=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6756);  
					stream_OPEN_BRACE.add(OPEN_BRACE523);

					pushFollow(FOLLOW_expression_in_builtInCall6758);
					expression524=expression();
					state._fsp--;

					stream_expression.add(expression524.getTree());
					CLOSE_BRACE525=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6760);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE525);

					// AST REWRITE
					// elements: ABS, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 877:45: -> ^( ABS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:877:48: ^( ABS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ABS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:878:7: CEIL OPEN_BRACE expression CLOSE_BRACE
					{
					CEIL526=(Token)match(input,CEIL,FOLLOW_CEIL_in_builtInCall6776);  
					stream_CEIL.add(CEIL526);

					OPEN_BRACE527=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6778);  
					stream_OPEN_BRACE.add(OPEN_BRACE527);

					pushFollow(FOLLOW_expression_in_builtInCall6780);
					expression528=expression();
					state._fsp--;

					stream_expression.add(expression528.getTree());
					CLOSE_BRACE529=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6782);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE529);

					// AST REWRITE
					// elements: CEIL, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 878:46: -> ^( CEIL expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:878:49: ^( CEIL expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CEIL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:879:7: FLOOR OPEN_BRACE expression CLOSE_BRACE
					{
					FLOOR530=(Token)match(input,FLOOR,FOLLOW_FLOOR_in_builtInCall6798);  
					stream_FLOOR.add(FLOOR530);

					OPEN_BRACE531=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6800);  
					stream_OPEN_BRACE.add(OPEN_BRACE531);

					pushFollow(FOLLOW_expression_in_builtInCall6802);
					expression532=expression();
					state._fsp--;

					stream_expression.add(expression532.getTree());
					CLOSE_BRACE533=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6804);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE533);

					// AST REWRITE
					// elements: FLOOR, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 879:47: -> ^( FLOOR expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:879:50: ^( FLOOR expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_FLOOR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:880:7: ROUND OPEN_BRACE expression CLOSE_BRACE
					{
					ROUND534=(Token)match(input,ROUND,FOLLOW_ROUND_in_builtInCall6820);  
					stream_ROUND.add(ROUND534);

					OPEN_BRACE535=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6822);  
					stream_OPEN_BRACE.add(OPEN_BRACE535);

					pushFollow(FOLLOW_expression_in_builtInCall6824);
					expression536=expression();
					state._fsp--;

					stream_expression.add(expression536.getTree());
					CLOSE_BRACE537=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6826);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE537);

					// AST REWRITE
					// elements: ROUND, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 880:47: -> ^( ROUND expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:880:50: ^( ROUND expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ROUND.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:881:7: CONCAT expressionList
					{
					CONCAT538=(Token)match(input,CONCAT,FOLLOW_CONCAT_in_builtInCall6842);  
					stream_CONCAT.add(CONCAT538);

					pushFollow(FOLLOW_expressionList_in_builtInCall6844);
					expressionList539=expressionList();
					state._fsp--;

					stream_expressionList.add(expressionList539.getTree());
					// AST REWRITE
					// elements: expressionList, CONCAT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 881:29: -> ^( CONCAT expressionList )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:881:32: ^( CONCAT expressionList )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONCAT.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expressionList.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:882:7: subStringExpression
					{
					pushFollow(FOLLOW_subStringExpression_in_builtInCall6860);
					subStringExpression540=subStringExpression();
					state._fsp--;

					stream_subStringExpression.add(subStringExpression540.getTree());
					// AST REWRITE
					// elements: subStringExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 882:27: -> subStringExpression
					{
						adaptor.addChild(root_0, stream_subStringExpression.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 16 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:883:7: STRLEN OPEN_BRACE expression CLOSE_BRACE
					{
					STRLEN541=(Token)match(input,STRLEN,FOLLOW_STRLEN_in_builtInCall6872);  
					stream_STRLEN.add(STRLEN541);

					OPEN_BRACE542=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6874);  
					stream_OPEN_BRACE.add(OPEN_BRACE542);

					pushFollow(FOLLOW_expression_in_builtInCall6876);
					expression543=expression();
					state._fsp--;

					stream_expression.add(expression543.getTree());
					CLOSE_BRACE544=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6878);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE544);

					// AST REWRITE
					// elements: expression, STRLEN
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 883:48: -> ^( STRLEN expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:883:51: ^( STRLEN expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRLEN.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 17 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:884:7: UCASE OPEN_BRACE expression CLOSE_BRACE
					{
					UCASE545=(Token)match(input,UCASE,FOLLOW_UCASE_in_builtInCall6894);  
					stream_UCASE.add(UCASE545);

					OPEN_BRACE546=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6896);  
					stream_OPEN_BRACE.add(OPEN_BRACE546);

					pushFollow(FOLLOW_expression_in_builtInCall6898);
					expression547=expression();
					state._fsp--;

					stream_expression.add(expression547.getTree());
					CLOSE_BRACE548=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6900);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE548);

					// AST REWRITE
					// elements: expression, UCASE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 884:47: -> ^( UCASE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:884:50: ^( UCASE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_UCASE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 18 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:885:7: LCASE OPEN_BRACE expression CLOSE_BRACE
					{
					LCASE549=(Token)match(input,LCASE,FOLLOW_LCASE_in_builtInCall6916);  
					stream_LCASE.add(LCASE549);

					OPEN_BRACE550=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6918);  
					stream_OPEN_BRACE.add(OPEN_BRACE550);

					pushFollow(FOLLOW_expression_in_builtInCall6920);
					expression551=expression();
					state._fsp--;

					stream_expression.add(expression551.getTree());
					CLOSE_BRACE552=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6922);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE552);

					// AST REWRITE
					// elements: expression, LCASE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 885:47: -> ^( LCASE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:885:50: ^( LCASE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LCASE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 19 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:886:7: ENCODE_FOR_URI OPEN_BRACE expression CLOSE_BRACE
					{
					ENCODE_FOR_URI553=(Token)match(input,ENCODE_FOR_URI,FOLLOW_ENCODE_FOR_URI_in_builtInCall6938);  
					stream_ENCODE_FOR_URI.add(ENCODE_FOR_URI553);

					OPEN_BRACE554=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6940);  
					stream_OPEN_BRACE.add(OPEN_BRACE554);

					pushFollow(FOLLOW_expression_in_builtInCall6942);
					expression555=expression();
					state._fsp--;

					stream_expression.add(expression555.getTree());
					CLOSE_BRACE556=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6944);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE556);

					// AST REWRITE
					// elements: expression, ENCODE_FOR_URI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 886:56: -> ^( ENCODE_FOR_URI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:886:59: ^( ENCODE_FOR_URI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ENCODE_FOR_URI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 20 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:887:7: CONTAINS OPEN_BRACE expression CLOSE_BRACE
					{
					CONTAINS557=(Token)match(input,CONTAINS,FOLLOW_CONTAINS_in_builtInCall6960);  
					stream_CONTAINS.add(CONTAINS557);

					OPEN_BRACE558=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6962);  
					stream_OPEN_BRACE.add(OPEN_BRACE558);

					pushFollow(FOLLOW_expression_in_builtInCall6964);
					expression559=expression();
					state._fsp--;

					stream_expression.add(expression559.getTree());
					CLOSE_BRACE560=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6966);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE560);

					// AST REWRITE
					// elements: expression, CONTAINS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 887:50: -> ^( CONTAINS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:887:53: ^( CONTAINS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONTAINS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 21 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:888:7: STRSTARTS OPEN_BRACE expression CLOSE_BRACE
					{
					STRSTARTS561=(Token)match(input,STRSTARTS,FOLLOW_STRSTARTS_in_builtInCall6982);  
					stream_STRSTARTS.add(STRSTARTS561);

					OPEN_BRACE562=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6984);  
					stream_OPEN_BRACE.add(OPEN_BRACE562);

					pushFollow(FOLLOW_expression_in_builtInCall6986);
					expression563=expression();
					state._fsp--;

					stream_expression.add(expression563.getTree());
					CLOSE_BRACE564=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6988);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE564);

					// AST REWRITE
					// elements: expression, STRSTARTS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 888:51: -> ^( STRSTARTS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:888:54: ^( STRSTARTS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRSTARTS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 22 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:889:7: STRENDS OPEN_BRACE expression CLOSE_BRACE
					{
					STRENDS565=(Token)match(input,STRENDS,FOLLOW_STRENDS_in_builtInCall7004);  
					stream_STRENDS.add(STRENDS565);

					OPEN_BRACE566=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7006);  
					stream_OPEN_BRACE.add(OPEN_BRACE566);

					pushFollow(FOLLOW_expression_in_builtInCall7008);
					expression567=expression();
					state._fsp--;

					stream_expression.add(expression567.getTree());
					CLOSE_BRACE568=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7010);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE568);

					// AST REWRITE
					// elements: expression, STRENDS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 889:49: -> ^( STRENDS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:889:52: ^( STRENDS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRENDS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 23 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:890:7: YEAR OPEN_BRACE expression CLOSE_BRACE
					{
					YEAR569=(Token)match(input,YEAR,FOLLOW_YEAR_in_builtInCall7026);  
					stream_YEAR.add(YEAR569);

					OPEN_BRACE570=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7028);  
					stream_OPEN_BRACE.add(OPEN_BRACE570);

					pushFollow(FOLLOW_expression_in_builtInCall7030);
					expression571=expression();
					state._fsp--;

					stream_expression.add(expression571.getTree());
					CLOSE_BRACE572=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7032);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE572);

					// AST REWRITE
					// elements: expression, YEAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 890:46: -> ^( YEAR expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:890:49: ^( YEAR expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_YEAR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 24 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:891:7: MONTH OPEN_BRACE expression CLOSE_BRACE
					{
					MONTH573=(Token)match(input,MONTH,FOLLOW_MONTH_in_builtInCall7048);  
					stream_MONTH.add(MONTH573);

					OPEN_BRACE574=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7050);  
					stream_OPEN_BRACE.add(OPEN_BRACE574);

					pushFollow(FOLLOW_expression_in_builtInCall7052);
					expression575=expression();
					state._fsp--;

					stream_expression.add(expression575.getTree());
					CLOSE_BRACE576=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7054);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE576);

					// AST REWRITE
					// elements: MONTH, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 891:47: -> ^( MONTH expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:891:50: ^( MONTH expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MONTH.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 25 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:892:7: DAY OPEN_BRACE expression CLOSE_BRACE
					{
					DAY577=(Token)match(input,DAY,FOLLOW_DAY_in_builtInCall7070);  
					stream_DAY.add(DAY577);

					OPEN_BRACE578=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7072);  
					stream_OPEN_BRACE.add(OPEN_BRACE578);

					pushFollow(FOLLOW_expression_in_builtInCall7074);
					expression579=expression();
					state._fsp--;

					stream_expression.add(expression579.getTree());
					CLOSE_BRACE580=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7076);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE580);

					// AST REWRITE
					// elements: expression, DAY
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 892:45: -> ^( DAY expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:892:48: ^( DAY expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_DAY.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 26 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:893:7: HOURS OPEN_BRACE expression CLOSE_BRACE
					{
					HOURS581=(Token)match(input,HOURS,FOLLOW_HOURS_in_builtInCall7092);  
					stream_HOURS.add(HOURS581);

					OPEN_BRACE582=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7094);  
					stream_OPEN_BRACE.add(OPEN_BRACE582);

					pushFollow(FOLLOW_expression_in_builtInCall7096);
					expression583=expression();
					state._fsp--;

					stream_expression.add(expression583.getTree());
					CLOSE_BRACE584=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7098);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE584);

					// AST REWRITE
					// elements: HOURS, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 893:47: -> ^( HOURS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:893:50: ^( HOURS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_HOURS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 27 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:894:7: MINUTES OPEN_BRACE expression CLOSE_BRACE
					{
					MINUTES585=(Token)match(input,MINUTES,FOLLOW_MINUTES_in_builtInCall7114);  
					stream_MINUTES.add(MINUTES585);

					OPEN_BRACE586=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7116);  
					stream_OPEN_BRACE.add(OPEN_BRACE586);

					pushFollow(FOLLOW_expression_in_builtInCall7118);
					expression587=expression();
					state._fsp--;

					stream_expression.add(expression587.getTree());
					CLOSE_BRACE588=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7120);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE588);

					// AST REWRITE
					// elements: MINUTES, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 894:49: -> ^( MINUTES expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:894:52: ^( MINUTES expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MINUTES.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 28 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:895:7: SECONDS OPEN_BRACE expression CLOSE_BRACE
					{
					SECONDS589=(Token)match(input,SECONDS,FOLLOW_SECONDS_in_builtInCall7136);  
					stream_SECONDS.add(SECONDS589);

					OPEN_BRACE590=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7138);  
					stream_OPEN_BRACE.add(OPEN_BRACE590);

					pushFollow(FOLLOW_expression_in_builtInCall7140);
					expression591=expression();
					state._fsp--;

					stream_expression.add(expression591.getTree());
					CLOSE_BRACE592=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7142);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE592);

					// AST REWRITE
					// elements: expression, SECONDS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 895:49: -> ^( SECONDS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:895:52: ^( SECONDS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SECONDS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 29 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:896:7: TIMEZONE OPEN_BRACE expression CLOSE_BRACE
					{
					TIMEZONE593=(Token)match(input,TIMEZONE,FOLLOW_TIMEZONE_in_builtInCall7158);  
					stream_TIMEZONE.add(TIMEZONE593);

					OPEN_BRACE594=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7160);  
					stream_OPEN_BRACE.add(OPEN_BRACE594);

					pushFollow(FOLLOW_expression_in_builtInCall7162);
					expression595=expression();
					state._fsp--;

					stream_expression.add(expression595.getTree());
					CLOSE_BRACE596=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7164);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE596);

					// AST REWRITE
					// elements: TIMEZONE, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 896:50: -> ^( TIMEZONE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:896:53: ^( TIMEZONE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_TIMEZONE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 30 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:897:7: TZ OPEN_BRACE expression CLOSE_BRACE
					{
					TZ597=(Token)match(input,TZ,FOLLOW_TZ_in_builtInCall7180);  
					stream_TZ.add(TZ597);

					OPEN_BRACE598=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7182);  
					stream_OPEN_BRACE.add(OPEN_BRACE598);

					pushFollow(FOLLOW_expression_in_builtInCall7184);
					expression599=expression();
					state._fsp--;

					stream_expression.add(expression599.getTree());
					CLOSE_BRACE600=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7186);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE600);

					// AST REWRITE
					// elements: expression, TZ
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 897:44: -> ^( TZ expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:897:47: ^( TZ expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_TZ.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 31 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:898:7: NOW nil
					{
					NOW601=(Token)match(input,NOW,FOLLOW_NOW_in_builtInCall7202);  
					stream_NOW.add(NOW601);

					pushFollow(FOLLOW_nil_in_builtInCall7204);
					nil602=nil();
					state._fsp--;

					stream_nil.add(nil602.getTree());
					// AST REWRITE
					// elements: NOW
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 898:15: -> NOW
					{
						adaptor.addChild(root_0, stream_NOW.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 32 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:899:7: MD5 OPEN_BRACE expression CLOSE_BRACE
					{
					MD5603=(Token)match(input,MD5,FOLLOW_MD5_in_builtInCall7216);  
					stream_MD5.add(MD5603);

					OPEN_BRACE604=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7218);  
					stream_OPEN_BRACE.add(OPEN_BRACE604);

					pushFollow(FOLLOW_expression_in_builtInCall7220);
					expression605=expression();
					state._fsp--;

					stream_expression.add(expression605.getTree());
					CLOSE_BRACE606=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7222);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE606);

					// AST REWRITE
					// elements: expression, MD5
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 899:45: -> ^( MD5 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:899:48: ^( MD5 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MD5.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 33 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:900:7: SHA1 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA1607=(Token)match(input,SHA1,FOLLOW_SHA1_in_builtInCall7238);  
					stream_SHA1.add(SHA1607);

					OPEN_BRACE608=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7240);  
					stream_OPEN_BRACE.add(OPEN_BRACE608);

					pushFollow(FOLLOW_expression_in_builtInCall7242);
					expression609=expression();
					state._fsp--;

					stream_expression.add(expression609.getTree());
					CLOSE_BRACE610=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7244);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE610);

					// AST REWRITE
					// elements: SHA1, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 900:46: -> ^( SHA1 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:900:49: ^( SHA1 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA1.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 34 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:901:7: SHA224 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA224611=(Token)match(input,SHA224,FOLLOW_SHA224_in_builtInCall7260);  
					stream_SHA224.add(SHA224611);

					OPEN_BRACE612=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7262);  
					stream_OPEN_BRACE.add(OPEN_BRACE612);

					pushFollow(FOLLOW_expression_in_builtInCall7264);
					expression613=expression();
					state._fsp--;

					stream_expression.add(expression613.getTree());
					CLOSE_BRACE614=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7266);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE614);

					// AST REWRITE
					// elements: expression, SHA224
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 901:48: -> ^( SHA224 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:901:51: ^( SHA224 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA224.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 35 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:902:7: SHA256 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA256615=(Token)match(input,SHA256,FOLLOW_SHA256_in_builtInCall7282);  
					stream_SHA256.add(SHA256615);

					OPEN_BRACE616=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7284);  
					stream_OPEN_BRACE.add(OPEN_BRACE616);

					pushFollow(FOLLOW_expression_in_builtInCall7286);
					expression617=expression();
					state._fsp--;

					stream_expression.add(expression617.getTree());
					CLOSE_BRACE618=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7288);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE618);

					// AST REWRITE
					// elements: expression, SHA256
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 902:48: -> ^( SHA256 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:902:51: ^( SHA256 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA256.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 36 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:903:7: SHA384 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA384619=(Token)match(input,SHA384,FOLLOW_SHA384_in_builtInCall7304);  
					stream_SHA384.add(SHA384619);

					OPEN_BRACE620=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7306);  
					stream_OPEN_BRACE.add(OPEN_BRACE620);

					pushFollow(FOLLOW_expression_in_builtInCall7308);
					expression621=expression();
					state._fsp--;

					stream_expression.add(expression621.getTree());
					CLOSE_BRACE622=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7310);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE622);

					// AST REWRITE
					// elements: SHA384, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 903:48: -> ^( SHA384 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:903:51: ^( SHA384 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA384.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 37 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:904:7: SHA512 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA512623=(Token)match(input,SHA512,FOLLOW_SHA512_in_builtInCall7326);  
					stream_SHA512.add(SHA512623);

					OPEN_BRACE624=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7328);  
					stream_OPEN_BRACE.add(OPEN_BRACE624);

					pushFollow(FOLLOW_expression_in_builtInCall7330);
					expression625=expression();
					state._fsp--;

					stream_expression.add(expression625.getTree());
					CLOSE_BRACE626=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7332);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE626);

					// AST REWRITE
					// elements: expression, SHA512
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 904:48: -> ^( SHA512 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:904:51: ^( SHA512 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA512.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 38 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:905:7: COALESCE expressionList
					{
					COALESCE627=(Token)match(input,COALESCE,FOLLOW_COALESCE_in_builtInCall7348);  
					stream_COALESCE.add(COALESCE627);

					pushFollow(FOLLOW_expressionList_in_builtInCall7350);
					expressionList628=expressionList();
					state._fsp--;

					stream_expressionList.add(expressionList628.getTree());
					// AST REWRITE
					// elements: COALESCE, expressionList
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 905:31: -> ^( COALESCE expressionList )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:905:34: ^( COALESCE expressionList )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_COALESCE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expressionList.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 39 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:906:7: IF OPEN_BRACE e1= expression COMMA e2= expression COMMA e3= expression CLOSE_BRACE
					{
					IF629=(Token)match(input,IF,FOLLOW_IF_in_builtInCall7366);  
					stream_IF.add(IF629);

					OPEN_BRACE630=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7368);  
					stream_OPEN_BRACE.add(OPEN_BRACE630);

					pushFollow(FOLLOW_expression_in_builtInCall7372);
					e1=expression();
					state._fsp--;

					stream_expression.add(e1.getTree());
					COMMA631=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7374);  
					stream_COMMA.add(COMMA631);

					pushFollow(FOLLOW_expression_in_builtInCall7378);
					e2=expression();
					state._fsp--;

					stream_expression.add(e2.getTree());
					COMMA632=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7380);  
					stream_COMMA.add(COMMA632);

					pushFollow(FOLLOW_expression_in_builtInCall7384);
					e3=expression();
					state._fsp--;

					stream_expression.add(e3.getTree());
					CLOSE_BRACE633=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7386);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE633);

					// AST REWRITE
					// elements: e3, IF, e2, e1
					// token labels: 
					// rule labels: e3, retval, e1, e2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_e3=new RewriteRuleSubtreeStream(adaptor,"rule e3",e3!=null?e3.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_e1=new RewriteRuleSubtreeStream(adaptor,"rule e1",e1!=null?e1.getTree():null);
					RewriteRuleSubtreeStream stream_e2=new RewriteRuleSubtreeStream(adaptor,"rule e2",e2!=null?e2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 906:87: -> ^( IF $e1 $e2 $e3)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:906:90: ^( IF $e1 $e2 $e3)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_IF.nextNode(), root_1);
						adaptor.addChild(root_1, stream_e1.nextTree());
						adaptor.addChild(root_1, stream_e2.nextTree());
						adaptor.addChild(root_1, stream_e3.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 40 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:907:7: STRLANG OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					STRLANG634=(Token)match(input,STRLANG,FOLLOW_STRLANG_in_builtInCall7409);  
					stream_STRLANG.add(STRLANG634);

					OPEN_BRACE635=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7411);  
					stream_OPEN_BRACE.add(OPEN_BRACE635);

					pushFollow(FOLLOW_expression_in_builtInCall7413);
					expression636=expression();
					state._fsp--;

					stream_expression.add(expression636.getTree());
					COMMA637=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7415);  
					stream_COMMA.add(COMMA637);

					pushFollow(FOLLOW_expression_in_builtInCall7417);
					expression638=expression();
					state._fsp--;

					stream_expression.add(expression638.getTree());
					CLOSE_BRACE639=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7419);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE639);

					// AST REWRITE
					// elements: STRLANG, expression, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 907:66: -> ^( STRLANG expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:907:69: ^( STRLANG expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRLANG.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 41 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:908:7: STRDT OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					STRDT640=(Token)match(input,STRDT,FOLLOW_STRDT_in_builtInCall7437);  
					stream_STRDT.add(STRDT640);

					OPEN_BRACE641=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7439);  
					stream_OPEN_BRACE.add(OPEN_BRACE641);

					pushFollow(FOLLOW_expression_in_builtInCall7441);
					expression642=expression();
					state._fsp--;

					stream_expression.add(expression642.getTree());
					COMMA643=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7443);  
					stream_COMMA.add(COMMA643);

					pushFollow(FOLLOW_expression_in_builtInCall7445);
					expression644=expression();
					state._fsp--;

					stream_expression.add(expression644.getTree());
					CLOSE_BRACE645=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7447);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE645);

					// AST REWRITE
					// elements: expression, STRDT, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 908:64: -> ^( STRDT expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:908:67: ^( STRDT expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRDT.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 42 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:909:7: SAMETERM OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					SAMETERM646=(Token)match(input,SAMETERM,FOLLOW_SAMETERM_in_builtInCall7465);  
					stream_SAMETERM.add(SAMETERM646);

					OPEN_BRACE647=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7467);  
					stream_OPEN_BRACE.add(OPEN_BRACE647);

					pushFollow(FOLLOW_expression_in_builtInCall7469);
					expression648=expression();
					state._fsp--;

					stream_expression.add(expression648.getTree());
					COMMA649=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7471);  
					stream_COMMA.add(COMMA649);

					pushFollow(FOLLOW_expression_in_builtInCall7473);
					expression650=expression();
					state._fsp--;

					stream_expression.add(expression650.getTree());
					CLOSE_BRACE651=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7475);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE651);

					// AST REWRITE
					// elements: expression, expression, SAMETERM
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 909:67: -> ^( SAMETERM expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:909:70: ^( SAMETERM expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SAMETERM.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 43 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:910:7: ISIRI OPEN_BRACE expression CLOSE_BRACE
					{
					ISIRI652=(Token)match(input,ISIRI,FOLLOW_ISIRI_in_builtInCall7493);  
					stream_ISIRI.add(ISIRI652);

					OPEN_BRACE653=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7495);  
					stream_OPEN_BRACE.add(OPEN_BRACE653);

					pushFollow(FOLLOW_expression_in_builtInCall7497);
					expression654=expression();
					state._fsp--;

					stream_expression.add(expression654.getTree());
					CLOSE_BRACE655=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7499);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE655);

					// AST REWRITE
					// elements: expression, ISIRI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 910:47: -> ^( ISIRI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:910:50: ^( ISIRI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISIRI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 44 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:911:7: ISURI OPEN_BRACE expression CLOSE_BRACE
					{
					ISURI656=(Token)match(input,ISURI,FOLLOW_ISURI_in_builtInCall7515);  
					stream_ISURI.add(ISURI656);

					OPEN_BRACE657=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7517);  
					stream_OPEN_BRACE.add(OPEN_BRACE657);

					pushFollow(FOLLOW_expression_in_builtInCall7519);
					expression658=expression();
					state._fsp--;

					stream_expression.add(expression658.getTree());
					CLOSE_BRACE659=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7521);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE659);

					// AST REWRITE
					// elements: expression, ISURI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 911:47: -> ^( ISURI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:911:50: ^( ISURI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISURI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 45 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:912:7: ISBLANK OPEN_BRACE expression CLOSE_BRACE
					{
					ISBLANK660=(Token)match(input,ISBLANK,FOLLOW_ISBLANK_in_builtInCall7537);  
					stream_ISBLANK.add(ISBLANK660);

					OPEN_BRACE661=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7539);  
					stream_OPEN_BRACE.add(OPEN_BRACE661);

					pushFollow(FOLLOW_expression_in_builtInCall7541);
					expression662=expression();
					state._fsp--;

					stream_expression.add(expression662.getTree());
					CLOSE_BRACE663=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7543);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE663);

					// AST REWRITE
					// elements: ISBLANK, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 912:49: -> ^( ISBLANK expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:912:52: ^( ISBLANK expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISBLANK.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 46 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:913:7: ISLITERAL OPEN_BRACE expression CLOSE_BRACE
					{
					ISLITERAL664=(Token)match(input,ISLITERAL,FOLLOW_ISLITERAL_in_builtInCall7560);  
					stream_ISLITERAL.add(ISLITERAL664);

					OPEN_BRACE665=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7562);  
					stream_OPEN_BRACE.add(OPEN_BRACE665);

					pushFollow(FOLLOW_expression_in_builtInCall7564);
					expression666=expression();
					state._fsp--;

					stream_expression.add(expression666.getTree());
					CLOSE_BRACE667=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7566);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE667);

					// AST REWRITE
					// elements: expression, ISLITERAL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 913:51: -> ^( ISLITERAL expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:913:54: ^( ISLITERAL expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISLITERAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 47 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:914:7: ISNUMERIC OPEN_BRACE expression CLOSE_BRACE
					{
					ISNUMERIC668=(Token)match(input,ISNUMERIC,FOLLOW_ISNUMERIC_in_builtInCall7582);  
					stream_ISNUMERIC.add(ISNUMERIC668);

					OPEN_BRACE669=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7584);  
					stream_OPEN_BRACE.add(OPEN_BRACE669);

					pushFollow(FOLLOW_expression_in_builtInCall7586);
					expression670=expression();
					state._fsp--;

					stream_expression.add(expression670.getTree());
					CLOSE_BRACE671=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7588);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE671);

					// AST REWRITE
					// elements: ISNUMERIC, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 914:51: -> ^( ISNUMERIC expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:914:54: ^( ISNUMERIC expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISNUMERIC.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 48 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:915:7: regexExpression
					{
					pushFollow(FOLLOW_regexExpression_in_builtInCall7604);
					regexExpression672=regexExpression();
					state._fsp--;

					stream_regexExpression.add(regexExpression672.getTree());
					// AST REWRITE
					// elements: regexExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 915:23: -> regexExpression
					{
						adaptor.addChild(root_0, stream_regexExpression.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 49 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:916:7: existsFunction
					{
					pushFollow(FOLLOW_existsFunction_in_builtInCall7616);
					existsFunction673=existsFunction();
					state._fsp--;

					stream_existsFunction.add(existsFunction673.getTree());
					// AST REWRITE
					// elements: existsFunction
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 916:22: -> existsFunction
					{
						adaptor.addChild(root_0, stream_existsFunction.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 50 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:917:7: notExistsFunction
					{
					pushFollow(FOLLOW_notExistsFunction_in_builtInCall7628);
					notExistsFunction674=notExistsFunction();
					state._fsp--;

					stream_notExistsFunction.add(notExistsFunction674.getTree());
					// AST REWRITE
					// elements: notExistsFunction
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 917:25: -> notExistsFunction
					{
						adaptor.addChild(root_0, stream_notExistsFunction.nextTree());
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "builtInCall"


	public static class regexExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "regexExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:920:1: regexExpression : REGEX OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( REGEX ( expression )* ) ;
	public final SparqlifyConfigParser.regexExpression_return regexExpression() throws RecognitionException {
		SparqlifyConfigParser.regexExpression_return retval = new SparqlifyConfigParser.regexExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token REGEX675=null;
		Token OPEN_BRACE676=null;
		Token COMMA678=null;
		Token COMMA680=null;
		Token CLOSE_BRACE682=null;
		ParserRuleReturnScope expression677 =null;
		ParserRuleReturnScope expression679 =null;
		ParserRuleReturnScope expression681 =null;

		CommonTree REGEX675_tree=null;
		CommonTree OPEN_BRACE676_tree=null;
		CommonTree COMMA678_tree=null;
		CommonTree COMMA680_tree=null;
		CommonTree CLOSE_BRACE682_tree=null;
		RewriteRuleTokenStream stream_REGEX=new RewriteRuleTokenStream(adaptor,"token REGEX");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:5: ( REGEX OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( REGEX ( expression )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:7: REGEX OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE
			{
			REGEX675=(Token)match(input,REGEX,FOLLOW_REGEX_in_regexExpression7649);  
			stream_REGEX.add(REGEX675);

			OPEN_BRACE676=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_regexExpression7651);  
			stream_OPEN_BRACE.add(OPEN_BRACE676);

			pushFollow(FOLLOW_expression_in_regexExpression7653);
			expression677=expression();
			state._fsp--;

			stream_expression.add(expression677.getTree());
			COMMA678=(Token)match(input,COMMA,FOLLOW_COMMA_in_regexExpression7655);  
			stream_COMMA.add(COMMA678);

			pushFollow(FOLLOW_expression_in_regexExpression7657);
			expression679=expression();
			state._fsp--;

			stream_expression.add(expression679.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:52: ( COMMA expression )?
			int alt156=2;
			int LA156_0 = input.LA(1);
			if ( (LA156_0==COMMA) ) {
				alt156=1;
			}
			switch (alt156) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:54: COMMA expression
					{
					COMMA680=(Token)match(input,COMMA,FOLLOW_COMMA_in_regexExpression7661);  
					stream_COMMA.add(COMMA680);

					pushFollow(FOLLOW_expression_in_regexExpression7663);
					expression681=expression();
					state._fsp--;

					stream_expression.add(expression681.getTree());
					}
					break;

			}

			CLOSE_BRACE682=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_regexExpression7668);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE682);

			// AST REWRITE
			// elements: REGEX, expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 921:86: -> ^( REGEX ( expression )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:89: ^( REGEX ( expression )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_REGEX.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:97: ( expression )*
				while ( stream_expression.hasNext() ) {
					adaptor.addChild(root_1, stream_expression.nextTree());
				}
				stream_expression.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "regexExpression"


	public static class subStringExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "subStringExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:924:1: subStringExpression : SUBSTR OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( SUBSTR ( expression )* ) ;
	public final SparqlifyConfigParser.subStringExpression_return subStringExpression() throws RecognitionException {
		SparqlifyConfigParser.subStringExpression_return retval = new SparqlifyConfigParser.subStringExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SUBSTR683=null;
		Token OPEN_BRACE684=null;
		Token COMMA686=null;
		Token COMMA688=null;
		Token CLOSE_BRACE690=null;
		ParserRuleReturnScope expression685 =null;
		ParserRuleReturnScope expression687 =null;
		ParserRuleReturnScope expression689 =null;

		CommonTree SUBSTR683_tree=null;
		CommonTree OPEN_BRACE684_tree=null;
		CommonTree COMMA686_tree=null;
		CommonTree COMMA688_tree=null;
		CommonTree CLOSE_BRACE690_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_SUBSTR=new RewriteRuleTokenStream(adaptor,"token SUBSTR");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:925:5: ( SUBSTR OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( SUBSTR ( expression )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:925:7: SUBSTR OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE
			{
			SUBSTR683=(Token)match(input,SUBSTR,FOLLOW_SUBSTR_in_subStringExpression7698);  
			stream_SUBSTR.add(SUBSTR683);

			OPEN_BRACE684=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_subStringExpression7700);  
			stream_OPEN_BRACE.add(OPEN_BRACE684);

			pushFollow(FOLLOW_expression_in_subStringExpression7702);
			expression685=expression();
			state._fsp--;

			stream_expression.add(expression685.getTree());
			COMMA686=(Token)match(input,COMMA,FOLLOW_COMMA_in_subStringExpression7704);  
			stream_COMMA.add(COMMA686);

			pushFollow(FOLLOW_expression_in_subStringExpression7706);
			expression687=expression();
			state._fsp--;

			stream_expression.add(expression687.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:925:53: ( COMMA expression )?
			int alt157=2;
			int LA157_0 = input.LA(1);
			if ( (LA157_0==COMMA) ) {
				alt157=1;
			}
			switch (alt157) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:925:55: COMMA expression
					{
					COMMA688=(Token)match(input,COMMA,FOLLOW_COMMA_in_subStringExpression7710);  
					stream_COMMA.add(COMMA688);

					pushFollow(FOLLOW_expression_in_subStringExpression7712);
					expression689=expression();
					state._fsp--;

					stream_expression.add(expression689.getTree());
					}
					break;

			}

			CLOSE_BRACE690=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_subStringExpression7717);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE690);

			// AST REWRITE
			// elements: SUBSTR, expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 925:87: -> ^( SUBSTR ( expression )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:925:90: ^( SUBSTR ( expression )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_SUBSTR.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:925:99: ( expression )*
				while ( stream_expression.hasNext() ) {
					adaptor.addChild(root_1, stream_expression.nextTree());
				}
				stream_expression.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "subStringExpression"


	public static class existsFunction_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "existsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:928:1: existsFunction : EXISTS groupGraphPattern -> ^( EXISTS groupGraphPattern ) ;
	public final SparqlifyConfigParser.existsFunction_return existsFunction() throws RecognitionException {
		SparqlifyConfigParser.existsFunction_return retval = new SparqlifyConfigParser.existsFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EXISTS691=null;
		ParserRuleReturnScope groupGraphPattern692 =null;

		CommonTree EXISTS691_tree=null;
		RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:929:5: ( EXISTS groupGraphPattern -> ^( EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:929:7: EXISTS groupGraphPattern
			{
			EXISTS691=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_existsFunction7747);  
			stream_EXISTS.add(EXISTS691);

			pushFollow(FOLLOW_groupGraphPattern_in_existsFunction7749);
			groupGraphPattern692=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern692.getTree());
			// AST REWRITE
			// elements: groupGraphPattern, EXISTS
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 929:32: -> ^( EXISTS groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:929:35: ^( EXISTS groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_EXISTS.nextNode(), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "existsFunction"


	public static class notExistsFunction_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "notExistsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:932:1: notExistsFunction : NOT EXISTS groupGraphPattern -> ^( NOT_EXISTS groupGraphPattern ) ;
	public final SparqlifyConfigParser.notExistsFunction_return notExistsFunction() throws RecognitionException {
		SparqlifyConfigParser.notExistsFunction_return retval = new SparqlifyConfigParser.notExistsFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NOT693=null;
		Token EXISTS694=null;
		ParserRuleReturnScope groupGraphPattern695 =null;

		CommonTree NOT693_tree=null;
		CommonTree EXISTS694_tree=null;
		RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
		RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:933:5: ( NOT EXISTS groupGraphPattern -> ^( NOT_EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:933:7: NOT EXISTS groupGraphPattern
			{
			NOT693=(Token)match(input,NOT,FOLLOW_NOT_in_notExistsFunction7774);  
			stream_NOT.add(NOT693);

			EXISTS694=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_notExistsFunction7776);  
			stream_EXISTS.add(EXISTS694);

			pushFollow(FOLLOW_groupGraphPattern_in_notExistsFunction7778);
			groupGraphPattern695=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern695.getTree());
			// AST REWRITE
			// elements: groupGraphPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 933:36: -> ^( NOT_EXISTS groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:933:39: ^( NOT_EXISTS groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NOT_EXISTS, "NOT_EXISTS"), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "notExistsFunction"


	public static class aggregate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "aggregate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:936:1: aggregate : ( COUNT OPEN_BRACE ( DISTINCT )? ( ASTERISK | expression ) CLOSE_BRACE -> ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | SUM OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SUM ( DISTINCT )* expression ) | MIN OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MIN ( DISTINCT )* expression ) | MAX OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MAX ( DISTINCT )* expression ) | AVG OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( AVG ( DISTINCT )* expression ) | SAMPLE OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SAMPLE ( DISTINCT )? expression ) | GROUP_CONCAT OPEN_BRACE ( DISTINCT )? expression ( SEMICOLON SEPARATOR EQUAL string )? CLOSE_BRACE -> ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* ) );
	public final SparqlifyConfigParser.aggregate_return aggregate() throws RecognitionException {
		SparqlifyConfigParser.aggregate_return retval = new SparqlifyConfigParser.aggregate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COUNT696=null;
		Token OPEN_BRACE697=null;
		Token DISTINCT698=null;
		Token ASTERISK699=null;
		Token CLOSE_BRACE701=null;
		Token SUM702=null;
		Token OPEN_BRACE703=null;
		Token DISTINCT704=null;
		Token CLOSE_BRACE706=null;
		Token MIN707=null;
		Token OPEN_BRACE708=null;
		Token DISTINCT709=null;
		Token CLOSE_BRACE711=null;
		Token MAX712=null;
		Token OPEN_BRACE713=null;
		Token DISTINCT714=null;
		Token CLOSE_BRACE716=null;
		Token AVG717=null;
		Token OPEN_BRACE718=null;
		Token DISTINCT719=null;
		Token CLOSE_BRACE721=null;
		Token SAMPLE722=null;
		Token OPEN_BRACE723=null;
		Token DISTINCT724=null;
		Token CLOSE_BRACE726=null;
		Token GROUP_CONCAT727=null;
		Token OPEN_BRACE728=null;
		Token DISTINCT729=null;
		Token SEMICOLON731=null;
		Token SEPARATOR732=null;
		Token EQUAL733=null;
		Token CLOSE_BRACE735=null;
		ParserRuleReturnScope expression700 =null;
		ParserRuleReturnScope expression705 =null;
		ParserRuleReturnScope expression710 =null;
		ParserRuleReturnScope expression715 =null;
		ParserRuleReturnScope expression720 =null;
		ParserRuleReturnScope expression725 =null;
		ParserRuleReturnScope expression730 =null;
		ParserRuleReturnScope string734 =null;

		CommonTree COUNT696_tree=null;
		CommonTree OPEN_BRACE697_tree=null;
		CommonTree DISTINCT698_tree=null;
		CommonTree ASTERISK699_tree=null;
		CommonTree CLOSE_BRACE701_tree=null;
		CommonTree SUM702_tree=null;
		CommonTree OPEN_BRACE703_tree=null;
		CommonTree DISTINCT704_tree=null;
		CommonTree CLOSE_BRACE706_tree=null;
		CommonTree MIN707_tree=null;
		CommonTree OPEN_BRACE708_tree=null;
		CommonTree DISTINCT709_tree=null;
		CommonTree CLOSE_BRACE711_tree=null;
		CommonTree MAX712_tree=null;
		CommonTree OPEN_BRACE713_tree=null;
		CommonTree DISTINCT714_tree=null;
		CommonTree CLOSE_BRACE716_tree=null;
		CommonTree AVG717_tree=null;
		CommonTree OPEN_BRACE718_tree=null;
		CommonTree DISTINCT719_tree=null;
		CommonTree CLOSE_BRACE721_tree=null;
		CommonTree SAMPLE722_tree=null;
		CommonTree OPEN_BRACE723_tree=null;
		CommonTree DISTINCT724_tree=null;
		CommonTree CLOSE_BRACE726_tree=null;
		CommonTree GROUP_CONCAT727_tree=null;
		CommonTree OPEN_BRACE728_tree=null;
		CommonTree DISTINCT729_tree=null;
		CommonTree SEMICOLON731_tree=null;
		CommonTree SEPARATOR732_tree=null;
		CommonTree EQUAL733_tree=null;
		CommonTree CLOSE_BRACE735_tree=null;
		RewriteRuleTokenStream stream_SAMPLE=new RewriteRuleTokenStream(adaptor,"token SAMPLE");
		RewriteRuleTokenStream stream_AVG=new RewriteRuleTokenStream(adaptor,"token AVG");
		RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
		RewriteRuleTokenStream stream_GROUP_CONCAT=new RewriteRuleTokenStream(adaptor,"token GROUP_CONCAT");
		RewriteRuleTokenStream stream_MAX=new RewriteRuleTokenStream(adaptor,"token MAX");
		RewriteRuleTokenStream stream_COUNT=new RewriteRuleTokenStream(adaptor,"token COUNT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_SEPARATOR=new RewriteRuleTokenStream(adaptor,"token SEPARATOR");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_MIN=new RewriteRuleTokenStream(adaptor,"token MIN");
		RewriteRuleTokenStream stream_SUM=new RewriteRuleTokenStream(adaptor,"token SUM");
		RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:5: ( COUNT OPEN_BRACE ( DISTINCT )? ( ASTERISK | expression ) CLOSE_BRACE -> ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | SUM OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SUM ( DISTINCT )* expression ) | MIN OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MIN ( DISTINCT )* expression ) | MAX OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MAX ( DISTINCT )* expression ) | AVG OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( AVG ( DISTINCT )* expression ) | SAMPLE OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SAMPLE ( DISTINCT )? expression ) | GROUP_CONCAT OPEN_BRACE ( DISTINCT )? expression ( SEMICOLON SEPARATOR EQUAL string )? CLOSE_BRACE -> ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* ) )
			int alt167=7;
			switch ( input.LA(1) ) {
			case COUNT:
				{
				alt167=1;
				}
				break;
			case SUM:
				{
				alt167=2;
				}
				break;
			case MIN:
				{
				alt167=3;
				}
				break;
			case MAX:
				{
				alt167=4;
				}
				break;
			case AVG:
				{
				alt167=5;
				}
				break;
			case SAMPLE:
				{
				alt167=6;
				}
				break;
			case GROUP_CONCAT:
				{
				alt167=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 167, 0, input);
				throw nvae;
			}
			switch (alt167) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:7: COUNT OPEN_BRACE ( DISTINCT )? ( ASTERISK | expression ) CLOSE_BRACE
					{
					COUNT696=(Token)match(input,COUNT,FOLLOW_COUNT_in_aggregate7803);  
					stream_COUNT.add(COUNT696);

					OPEN_BRACE697=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7805);  
					stream_OPEN_BRACE.add(OPEN_BRACE697);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:24: ( DISTINCT )?
					int alt158=2;
					int LA158_0 = input.LA(1);
					if ( (LA158_0==DISTINCT) ) {
						alt158=1;
					}
					switch (alt158) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:24: DISTINCT
							{
							DISTINCT698=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7807);  
							stream_DISTINCT.add(DISTINCT698);

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:34: ( ASTERISK | expression )
					int alt159=2;
					int LA159_0 = input.LA(1);
					if ( (LA159_0==ASTERISK) ) {
						alt159=1;
					}
					else if ( (LA159_0==ABS||LA159_0==AVG||(LA159_0 >= BNODE && LA159_0 <= BOUND)||LA159_0==CEIL||LA159_0==COALESCE||LA159_0==CONCAT||LA159_0==CONTAINS||LA159_0==COUNT||(LA159_0 >= DATATYPE && LA159_0 <= DECIMAL_POSITIVE)||(LA159_0 >= DOUBLE && LA159_0 <= DOUBLE_POSITIVE)||LA159_0==ENCODE_FOR_URI||LA159_0==EXISTS||LA159_0==FALSE||LA159_0==FLOOR||LA159_0==GROUP_CONCAT||(LA159_0 >= HOURS && LA159_0 <= IF)||(LA159_0 >= INTEGER && LA159_0 <= INTEGER_POSITIVE)||(LA159_0 >= IRI && LA159_0 <= IRI_REF)||(LA159_0 >= ISBLANK && LA159_0 <= ISURI)||(LA159_0 >= LANG && LA159_0 <= LANGMATCHES)||LA159_0==LCASE||(LA159_0 >= MAX && LA159_0 <= MINUS)||LA159_0==MINUTES||LA159_0==MONTH||LA159_0==NAME||LA159_0==NEGATION||LA159_0==NOT||LA159_0==NOW||LA159_0==OPEN_BRACE||(LA159_0 >= PLUS && LA159_0 <= PNAME_NS)||LA159_0==RAND||LA159_0==REGEX||(LA159_0 >= ROUND && LA159_0 <= SECONDS)||(LA159_0 >= SHA1 && LA159_0 <= SHA512)||(LA159_0 >= STR && LA159_0 <= STRENDS)||(LA159_0 >= STRING_LITERAL1 && LA159_0 <= STRSTARTS)||(LA159_0 >= SUBSTR && LA159_0 <= SUM)||LA159_0==TIMEZONE||LA159_0==TRUE||(LA159_0 >= TZ && LA159_0 <= UCASE)||LA159_0==URI||(LA159_0 >= VAR1 && LA159_0 <= VAR3)||LA159_0==YEAR) ) {
						alt159=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 159, 0, input);
						throw nvae;
					}

					switch (alt159) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:36: ASTERISK
							{
							ASTERISK699=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_aggregate7812);  
							stream_ASTERISK.add(ASTERISK699);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:47: expression
							{
							pushFollow(FOLLOW_expression_in_aggregate7816);
							expression700=expression();
							state._fsp--;

							stream_expression.add(expression700.getTree());
							}
							break;

					}

					CLOSE_BRACE701=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7820);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE701);

					// AST REWRITE
					// elements: expression, DISTINCT, ASTERISK, COUNT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 937:72: -> ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:75: ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_COUNT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:83: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:93: ( ASTERISK )*
						while ( stream_ASTERISK.hasNext() ) {
							adaptor.addChild(root_1, stream_ASTERISK.nextNode());
						}
						stream_ASTERISK.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:937:103: ( expression )*
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_1, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:938:7: SUM OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					SUM702=(Token)match(input,SUM,FOLLOW_SUM_in_aggregate7843);  
					stream_SUM.add(SUM702);

					OPEN_BRACE703=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7845);  
					stream_OPEN_BRACE.add(OPEN_BRACE703);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:938:22: ( DISTINCT )?
					int alt160=2;
					int LA160_0 = input.LA(1);
					if ( (LA160_0==DISTINCT) ) {
						alt160=1;
					}
					switch (alt160) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:938:22: DISTINCT
							{
							DISTINCT704=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7847);  
							stream_DISTINCT.add(DISTINCT704);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7850);
					expression705=expression();
					state._fsp--;

					stream_expression.add(expression705.getTree());
					CLOSE_BRACE706=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7852);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE706);

					// AST REWRITE
					// elements: SUM, DISTINCT, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 938:55: -> ^( SUM ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:938:58: ^( SUM ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SUM.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:938:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:939:7: MIN OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					MIN707=(Token)match(input,MIN,FOLLOW_MIN_in_aggregate7871);  
					stream_MIN.add(MIN707);

					OPEN_BRACE708=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7873);  
					stream_OPEN_BRACE.add(OPEN_BRACE708);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:939:22: ( DISTINCT )?
					int alt161=2;
					int LA161_0 = input.LA(1);
					if ( (LA161_0==DISTINCT) ) {
						alt161=1;
					}
					switch (alt161) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:939:22: DISTINCT
							{
							DISTINCT709=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7875);  
							stream_DISTINCT.add(DISTINCT709);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7878);
					expression710=expression();
					state._fsp--;

					stream_expression.add(expression710.getTree());
					CLOSE_BRACE711=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7880);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE711);

					// AST REWRITE
					// elements: MIN, DISTINCT, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 939:55: -> ^( MIN ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:939:58: ^( MIN ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MIN.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:939:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:7: MAX OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					MAX712=(Token)match(input,MAX,FOLLOW_MAX_in_aggregate7899);  
					stream_MAX.add(MAX712);

					OPEN_BRACE713=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7901);  
					stream_OPEN_BRACE.add(OPEN_BRACE713);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:22: ( DISTINCT )?
					int alt162=2;
					int LA162_0 = input.LA(1);
					if ( (LA162_0==DISTINCT) ) {
						alt162=1;
					}
					switch (alt162) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:22: DISTINCT
							{
							DISTINCT714=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7903);  
							stream_DISTINCT.add(DISTINCT714);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7906);
					expression715=expression();
					state._fsp--;

					stream_expression.add(expression715.getTree());
					CLOSE_BRACE716=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7908);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE716);

					// AST REWRITE
					// elements: DISTINCT, expression, MAX
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 940:55: -> ^( MAX ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:58: ^( MAX ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MAX.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:941:7: AVG OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					AVG717=(Token)match(input,AVG,FOLLOW_AVG_in_aggregate7927);  
					stream_AVG.add(AVG717);

					OPEN_BRACE718=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7929);  
					stream_OPEN_BRACE.add(OPEN_BRACE718);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:941:22: ( DISTINCT )?
					int alt163=2;
					int LA163_0 = input.LA(1);
					if ( (LA163_0==DISTINCT) ) {
						alt163=1;
					}
					switch (alt163) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:941:22: DISTINCT
							{
							DISTINCT719=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7931);  
							stream_DISTINCT.add(DISTINCT719);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7934);
					expression720=expression();
					state._fsp--;

					stream_expression.add(expression720.getTree());
					CLOSE_BRACE721=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7936);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE721);

					// AST REWRITE
					// elements: AVG, expression, DISTINCT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 941:55: -> ^( AVG ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:941:58: ^( AVG ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AVG.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:941:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:942:7: SAMPLE OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					SAMPLE722=(Token)match(input,SAMPLE,FOLLOW_SAMPLE_in_aggregate7955);  
					stream_SAMPLE.add(SAMPLE722);

					OPEN_BRACE723=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7957);  
					stream_OPEN_BRACE.add(OPEN_BRACE723);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:942:25: ( DISTINCT )?
					int alt164=2;
					int LA164_0 = input.LA(1);
					if ( (LA164_0==DISTINCT) ) {
						alt164=1;
					}
					switch (alt164) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:942:25: DISTINCT
							{
							DISTINCT724=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7959);  
							stream_DISTINCT.add(DISTINCT724);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7962);
					expression725=expression();
					state._fsp--;

					stream_expression.add(expression725.getTree());
					CLOSE_BRACE726=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7964);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE726);

					// AST REWRITE
					// elements: DISTINCT, SAMPLE, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 942:58: -> ^( SAMPLE ( DISTINCT )? expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:942:61: ^( SAMPLE ( DISTINCT )? expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SAMPLE.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:942:70: ( DISTINCT )?
						if ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:7: GROUP_CONCAT OPEN_BRACE ( DISTINCT )? expression ( SEMICOLON SEPARATOR EQUAL string )? CLOSE_BRACE
					{
					GROUP_CONCAT727=(Token)match(input,GROUP_CONCAT,FOLLOW_GROUP_CONCAT_in_aggregate7983);  
					stream_GROUP_CONCAT.add(GROUP_CONCAT727);

					OPEN_BRACE728=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7985);  
					stream_OPEN_BRACE.add(OPEN_BRACE728);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:31: ( DISTINCT )?
					int alt165=2;
					int LA165_0 = input.LA(1);
					if ( (LA165_0==DISTINCT) ) {
						alt165=1;
					}
					switch (alt165) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:31: DISTINCT
							{
							DISTINCT729=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7987);  
							stream_DISTINCT.add(DISTINCT729);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7990);
					expression730=expression();
					state._fsp--;

					stream_expression.add(expression730.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:52: ( SEMICOLON SEPARATOR EQUAL string )?
					int alt166=2;
					int LA166_0 = input.LA(1);
					if ( (LA166_0==SEMICOLON) ) {
						alt166=1;
					}
					switch (alt166) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:54: SEMICOLON SEPARATOR EQUAL string
							{
							SEMICOLON731=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_aggregate7994);  
							stream_SEMICOLON.add(SEMICOLON731);

							SEPARATOR732=(Token)match(input,SEPARATOR,FOLLOW_SEPARATOR_in_aggregate7996);  
							stream_SEPARATOR.add(SEPARATOR732);

							EQUAL733=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_aggregate7998);  
							stream_EQUAL.add(EQUAL733);

							pushFollow(FOLLOW_string_in_aggregate8000);
							string734=string();
							state._fsp--;

							stream_string.add(string734.getTree());
							}
							break;

					}

					CLOSE_BRACE735=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate8005);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE735);

					// AST REWRITE
					// elements: GROUP_CONCAT, string, expression, DISTINCT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 943:102: -> ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:105: ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_GROUP_CONCAT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:120: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:141: ( string )*
						while ( stream_string.hasNext() ) {
							adaptor.addChild(root_1, stream_string.nextTree());
						}
						stream_string.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "aggregate"


	public static class iriRefOrFunction_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "iriRefOrFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:946:1: iriRefOrFunction : ( iriRef | iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) );
	public final SparqlifyConfigParser.iriRefOrFunction_return iriRefOrFunction() throws RecognitionException {
		SparqlifyConfigParser.iriRefOrFunction_return retval = new SparqlifyConfigParser.iriRefOrFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef736 =null;
		ParserRuleReturnScope iriRef737 =null;
		ParserRuleReturnScope argList738 =null;

		RewriteRuleSubtreeStream stream_argList=new RewriteRuleSubtreeStream(adaptor,"rule argList");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:947:5: ( iriRef | iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) )
			int alt168=2;
			int LA168_0 = input.LA(1);
			if ( (LA168_0==IRI_REF) ) {
				int LA168_1 = input.LA(2);
				if ( (LA168_1==EOF||LA168_1==AND||LA168_1==AS||LA168_1==ASTERISK||LA168_1==CLOSE_BRACE||LA168_1==COMMA||LA168_1==CREATE||(LA168_1 >= DECIMAL_NEGATIVE && LA168_1 <= DECLARE)||LA168_1==DEFINE||LA168_1==DIVIDE||(LA168_1 >= DOUBLE_NEGATIVE && LA168_1 <= DOUBLE_POSITIVE)||LA168_1==EQUAL||(LA168_1 >= GREATER && LA168_1 <= GREATER_EQUAL)||LA168_1==IN||(LA168_1 >= INTEGER_NEGATIVE && LA168_1 <= INTEGER_POSITIVE)||(LA168_1 >= LESS && LA168_1 <= LESS_EQUAL)||LA168_1==MINUS||(LA168_1 >= NOT && LA168_1 <= NOT_EQUAL)||LA168_1==OR||LA168_1==PLUS||LA168_1==PREFIX||LA168_1==SEMICOLON) ) {
					alt168=1;
				}
				else if ( (LA168_1==OPEN_BRACE) ) {
					alt168=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 168, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( ((LA168_0 >= PNAME_LN && LA168_0 <= PNAME_NS)) ) {
				int LA168_2 = input.LA(2);
				if ( (LA168_2==EOF||LA168_2==AND||LA168_2==AS||LA168_2==ASTERISK||LA168_2==CLOSE_BRACE||LA168_2==COMMA||LA168_2==CREATE||(LA168_2 >= DECIMAL_NEGATIVE && LA168_2 <= DECLARE)||LA168_2==DEFINE||LA168_2==DIVIDE||(LA168_2 >= DOUBLE_NEGATIVE && LA168_2 <= DOUBLE_POSITIVE)||LA168_2==EQUAL||(LA168_2 >= GREATER && LA168_2 <= GREATER_EQUAL)||LA168_2==IN||(LA168_2 >= INTEGER_NEGATIVE && LA168_2 <= INTEGER_POSITIVE)||(LA168_2 >= LESS && LA168_2 <= LESS_EQUAL)||LA168_2==MINUS||(LA168_2 >= NOT && LA168_2 <= NOT_EQUAL)||LA168_2==OR||LA168_2==PLUS||LA168_2==PREFIX||LA168_2==SEMICOLON) ) {
					alt168=1;
				}
				else if ( (LA168_2==OPEN_BRACE) ) {
					alt168=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 168, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 168, 0, input);
				throw nvae;
			}

			switch (alt168) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:947:7: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction8040);
					iriRef736=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef736.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:7: iriRef argList
					{
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction8049);
					iriRef737=iriRef();
					state._fsp--;

					stream_iriRef.add(iriRef737.getTree());
					pushFollow(FOLLOW_argList_in_iriRefOrFunction8051);
					argList738=argList();
					state._fsp--;

					stream_argList.add(argList738.getTree());
					// AST REWRITE
					// elements: iriRef, argList
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 948:22: -> ^( FUNCTION iriRef ^( ARG_LIST argList ) )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:25: ^( FUNCTION iriRef ^( ARG_LIST argList ) )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION, "FUNCTION"), root_1);
						adaptor.addChild(root_1, stream_iriRef.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:43: ^( ARG_LIST argList )
						{
						CommonTree root_2 = (CommonTree)adaptor.nil();
						root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ARG_LIST, "ARG_LIST"), root_2);
						adaptor.addChild(root_2, stream_argList.nextTree());
						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "iriRefOrFunction"


	public static class rdfLiteral_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "rdfLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:951:1: rdfLiteral : ( string ( LANGTAG )? -> ^( PLAIN_LITERAL string ( LANGTAG )? ) | string REFERENCE iriRef -> ^( TYPED_LITERAL string iriRef ) );
	public final SparqlifyConfigParser.rdfLiteral_return rdfLiteral() throws RecognitionException {
		SparqlifyConfigParser.rdfLiteral_return retval = new SparqlifyConfigParser.rdfLiteral_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token LANGTAG740=null;
		Token REFERENCE742=null;
		ParserRuleReturnScope string739 =null;
		ParserRuleReturnScope string741 =null;
		ParserRuleReturnScope iriRef743 =null;

		CommonTree LANGTAG740_tree=null;
		CommonTree REFERENCE742_tree=null;
		RewriteRuleTokenStream stream_REFERENCE=new RewriteRuleTokenStream(adaptor,"token REFERENCE");
		RewriteRuleTokenStream stream_LANGTAG=new RewriteRuleTokenStream(adaptor,"token LANGTAG");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:952:5: ( string ( LANGTAG )? -> ^( PLAIN_LITERAL string ( LANGTAG )? ) | string REFERENCE iriRef -> ^( TYPED_LITERAL string iriRef ) )
			int alt170=2;
			int LA170_0 = input.LA(1);
			if ( ((LA170_0 >= STRING_LITERAL1 && LA170_0 <= STRING_LITERAL_LONG2)) ) {
				int LA170_1 = input.LA(2);
				if ( (LA170_1==EOF||LA170_1==A||LA170_1==AND||LA170_1==AS||LA170_1==ASTERISK||LA170_1==BIND||LA170_1==BLANK_NODE_LABEL||(LA170_1 >= CLOSE_BRACE && LA170_1 <= CLOSE_SQUARE_BRACKET)||LA170_1==COMMA||LA170_1==CREATE||(LA170_1 >= DECIMAL && LA170_1 <= DECLARE)||LA170_1==DEFINE||(LA170_1 >= DIVIDE && LA170_1 <= DOUBLE_POSITIVE)||LA170_1==EQUAL||(LA170_1 >= FALSE && LA170_1 <= FILTER)||LA170_1==GRAPH||(LA170_1 >= GREATER && LA170_1 <= GREATER_EQUAL)||LA170_1==IN||(LA170_1 >= INTEGER && LA170_1 <= INTEGER_POSITIVE)||LA170_1==INVERSE||LA170_1==IRI_REF||LA170_1==LANGTAG||(LA170_1 >= LESS && LA170_1 <= LESS_EQUAL)||(LA170_1 >= MINUS && LA170_1 <= MINUS_KEYWORD)||LA170_1==NEGATION||(LA170_1 >= NOT && LA170_1 <= NOT_EQUAL)||(LA170_1 >= OPEN_BRACE && LA170_1 <= OR)||(LA170_1 >= PLUS && LA170_1 <= PNAME_NS)||LA170_1==PREFIX||LA170_1==SEMICOLON||LA170_1==SERVICE||(LA170_1 >= STRING_LITERAL1 && LA170_1 <= STRING_LITERAL_LONG2)||LA170_1==TRUE||LA170_1==UNDEF||(LA170_1 >= VAR1 && LA170_1 <= VAR3)) ) {
					alt170=1;
				}
				else if ( (LA170_1==REFERENCE) ) {
					alt170=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 170, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 170, 0, input);
				throw nvae;
			}

			switch (alt170) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:952:7: string ( LANGTAG )?
					{
					pushFollow(FOLLOW_string_in_rdfLiteral8082);
					string739=string();
					state._fsp--;

					stream_string.add(string739.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:952:14: ( LANGTAG )?
					int alt169=2;
					int LA169_0 = input.LA(1);
					if ( (LA169_0==LANGTAG) ) {
						alt169=1;
					}
					switch (alt169) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:952:14: LANGTAG
							{
							LANGTAG740=(Token)match(input,LANGTAG,FOLLOW_LANGTAG_in_rdfLiteral8084);  
							stream_LANGTAG.add(LANGTAG740);

							}
							break;

					}

					// AST REWRITE
					// elements: LANGTAG, string
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 952:23: -> ^( PLAIN_LITERAL string ( LANGTAG )? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:952:26: ^( PLAIN_LITERAL string ( LANGTAG )? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PLAIN_LITERAL, "PLAIN_LITERAL"), root_1);
						adaptor.addChild(root_1, stream_string.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:952:49: ( LANGTAG )?
						if ( stream_LANGTAG.hasNext() ) {
							adaptor.addChild(root_1, stream_LANGTAG.nextNode());
						}
						stream_LANGTAG.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:953:7: string REFERENCE iriRef
					{
					pushFollow(FOLLOW_string_in_rdfLiteral8104);
					string741=string();
					state._fsp--;

					stream_string.add(string741.getTree());
					REFERENCE742=(Token)match(input,REFERENCE,FOLLOW_REFERENCE_in_rdfLiteral8106);  
					stream_REFERENCE.add(REFERENCE742);

					pushFollow(FOLLOW_iriRef_in_rdfLiteral8108);
					iriRef743=iriRef();
					state._fsp--;

					stream_iriRef.add(iriRef743.getTree());
					// AST REWRITE
					// elements: string, iriRef
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 953:31: -> ^( TYPED_LITERAL string iriRef )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:953:34: ^( TYPED_LITERAL string iriRef )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TYPED_LITERAL, "TYPED_LITERAL"), root_1);
						adaptor.addChild(root_1, stream_string.nextTree());
						adaptor.addChild(root_1, stream_iriRef.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rdfLiteral"


	public static class numericLiteral_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:956:1: numericLiteral : ( numericLiteralUnsigned | numericLiteralPositive | numericLiteralNegative );
	public final SparqlifyConfigParser.numericLiteral_return numericLiteral() throws RecognitionException {
		SparqlifyConfigParser.numericLiteral_return retval = new SparqlifyConfigParser.numericLiteral_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope numericLiteralUnsigned744 =null;
		ParserRuleReturnScope numericLiteralPositive745 =null;
		ParserRuleReturnScope numericLiteralNegative746 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:957:5: ( numericLiteralUnsigned | numericLiteralPositive | numericLiteralNegative )
			int alt171=3;
			switch ( input.LA(1) ) {
			case DECIMAL:
			case DOUBLE:
			case INTEGER:
				{
				alt171=1;
				}
				break;
			case DECIMAL_POSITIVE:
			case DOUBLE_POSITIVE:
			case INTEGER_POSITIVE:
				{
				alt171=2;
				}
				break;
			case DECIMAL_NEGATIVE:
			case DOUBLE_NEGATIVE:
			case INTEGER_NEGATIVE:
				{
				alt171=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 171, 0, input);
				throw nvae;
			}
			switch (alt171) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:957:7: numericLiteralUnsigned
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteralUnsigned_in_numericLiteral8135);
					numericLiteralUnsigned744=numericLiteralUnsigned();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteralUnsigned744.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:958:7: numericLiteralPositive
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteralPositive_in_numericLiteral8143);
					numericLiteralPositive745=numericLiteralPositive();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteralPositive745.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:959:7: numericLiteralNegative
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteralNegative_in_numericLiteral8151);
					numericLiteralNegative746=numericLiteralNegative();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteralNegative746.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteral"


	public static class numericLiteralUnsigned_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteralUnsigned"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:962:1: numericLiteralUnsigned : ( INTEGER | DECIMAL | DOUBLE );
	public final SparqlifyConfigParser.numericLiteralUnsigned_return numericLiteralUnsigned() throws RecognitionException {
		SparqlifyConfigParser.numericLiteralUnsigned_return retval = new SparqlifyConfigParser.numericLiteralUnsigned_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set747=null;

		CommonTree set747_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:963:5: ( INTEGER | DECIMAL | DOUBLE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set747=input.LT(1);
			if ( input.LA(1)==DECIMAL||input.LA(1)==DOUBLE||input.LA(1)==INTEGER ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set747));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteralUnsigned"


	public static class numericLiteralPositive_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteralPositive"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:968:1: numericLiteralPositive : ( INTEGER_POSITIVE | DECIMAL_POSITIVE | DOUBLE_POSITIVE );
	public final SparqlifyConfigParser.numericLiteralPositive_return numericLiteralPositive() throws RecognitionException {
		SparqlifyConfigParser.numericLiteralPositive_return retval = new SparqlifyConfigParser.numericLiteralPositive_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set748=null;

		CommonTree set748_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:969:5: ( INTEGER_POSITIVE | DECIMAL_POSITIVE | DOUBLE_POSITIVE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set748=input.LT(1);
			if ( input.LA(1)==DECIMAL_POSITIVE||input.LA(1)==DOUBLE_POSITIVE||input.LA(1)==INTEGER_POSITIVE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set748));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteralPositive"


	public static class numericLiteralNegative_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteralNegative"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:974:1: numericLiteralNegative : ( INTEGER_NEGATIVE | DECIMAL_NEGATIVE | DOUBLE_NEGATIVE );
	public final SparqlifyConfigParser.numericLiteralNegative_return numericLiteralNegative() throws RecognitionException {
		SparqlifyConfigParser.numericLiteralNegative_return retval = new SparqlifyConfigParser.numericLiteralNegative_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set749=null;

		CommonTree set749_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:975:5: ( INTEGER_NEGATIVE | DECIMAL_NEGATIVE | DOUBLE_NEGATIVE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set749=input.LT(1);
			if ( input.LA(1)==DECIMAL_NEGATIVE||input.LA(1)==DOUBLE_NEGATIVE||input.LA(1)==INTEGER_NEGATIVE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set749));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteralNegative"


	public static class booleanLiteral_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "booleanLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:980:1: booleanLiteral : ( TRUE | FALSE );
	public final SparqlifyConfigParser.booleanLiteral_return booleanLiteral() throws RecognitionException {
		SparqlifyConfigParser.booleanLiteral_return retval = new SparqlifyConfigParser.booleanLiteral_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set750=null;

		CommonTree set750_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:981:5: ( TRUE | FALSE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set750=input.LT(1);
			if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set750));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "booleanLiteral"


	public static class string_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "string"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:985:1: string : ( STRING_LITERAL1 | STRING_LITERAL2 | STRING_LITERAL_LONG1 | STRING_LITERAL_LONG2 );
	public final SparqlifyConfigParser.string_return string() throws RecognitionException {
		SparqlifyConfigParser.string_return retval = new SparqlifyConfigParser.string_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set751=null;

		CommonTree set751_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:986:5: ( STRING_LITERAL1 | STRING_LITERAL2 | STRING_LITERAL_LONG1 | STRING_LITERAL_LONG2 )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set751=input.LT(1);
			if ( (input.LA(1) >= STRING_LITERAL1 && input.LA(1) <= STRING_LITERAL_LONG2) ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set751));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "string"


	public static class iriRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "iriRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:992:1: iriRef : ( IRI_REF | prefixedName );
	public final SparqlifyConfigParser.iriRef_return iriRef() throws RecognitionException {
		SparqlifyConfigParser.iriRef_return retval = new SparqlifyConfigParser.iriRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token IRI_REF752=null;
		ParserRuleReturnScope prefixedName753 =null;

		CommonTree IRI_REF752_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:993:5: ( IRI_REF | prefixedName )
			int alt172=2;
			int LA172_0 = input.LA(1);
			if ( (LA172_0==IRI_REF) ) {
				alt172=1;
			}
			else if ( ((LA172_0 >= PNAME_LN && LA172_0 <= PNAME_NS)) ) {
				alt172=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 172, 0, input);
				throw nvae;
			}

			switch (alt172) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:993:7: IRI_REF
					{
					root_0 = (CommonTree)adaptor.nil();


					IRI_REF752=(Token)match(input,IRI_REF,FOLLOW_IRI_REF_in_iriRef8334); 
					IRI_REF752_tree = (CommonTree)adaptor.create(IRI_REF752);
					adaptor.addChild(root_0, IRI_REF752_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:994:7: prefixedName
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixedName_in_iriRef8342);
					prefixedName753=prefixedName();
					state._fsp--;

					adaptor.addChild(root_0, prefixedName753.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "iriRef"


	public static class prefixedName_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixedName"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:997:1: prefixedName : ( PNAME_LN | PNAME_NS );
	public final SparqlifyConfigParser.prefixedName_return prefixedName() throws RecognitionException {
		SparqlifyConfigParser.prefixedName_return retval = new SparqlifyConfigParser.prefixedName_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set754=null;

		CommonTree set754_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:998:5: ( PNAME_LN | PNAME_NS )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set754=input.LT(1);
			if ( (input.LA(1) >= PNAME_LN && input.LA(1) <= PNAME_NS) ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set754));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixedName"


	public static class blankNode_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "blankNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1002:1: blankNode : ( BLANK_NODE_LABEL | anon );
	public final SparqlifyConfigParser.blankNode_return blankNode() throws RecognitionException {
		SparqlifyConfigParser.blankNode_return retval = new SparqlifyConfigParser.blankNode_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BLANK_NODE_LABEL755=null;
		ParserRuleReturnScope anon756 =null;

		CommonTree BLANK_NODE_LABEL755_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1003:5: ( BLANK_NODE_LABEL | anon )
			int alt173=2;
			int LA173_0 = input.LA(1);
			if ( (LA173_0==BLANK_NODE_LABEL) ) {
				alt173=1;
			}
			else if ( (LA173_0==OPEN_SQUARE_BRACKET) ) {
				alt173=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 173, 0, input);
				throw nvae;
			}

			switch (alt173) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1003:7: BLANK_NODE_LABEL
					{
					root_0 = (CommonTree)adaptor.nil();


					BLANK_NODE_LABEL755=(Token)match(input,BLANK_NODE_LABEL,FOLLOW_BLANK_NODE_LABEL_in_blankNode8384); 
					BLANK_NODE_LABEL755_tree = (CommonTree)adaptor.create(BLANK_NODE_LABEL755);
					adaptor.addChild(root_0, BLANK_NODE_LABEL755_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1004:7: anon
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_anon_in_blankNode8392);
					anon756=anon();
					state._fsp--;

					adaptor.addChild(root_0, anon756.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blankNode"


	public static class anon_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "anon"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1007:1: anon : OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET ;
	public final SparqlifyConfigParser.anon_return anon() throws RecognitionException {
		SparqlifyConfigParser.anon_return retval = new SparqlifyConfigParser.anon_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_SQUARE_BRACKET757=null;
		Token CLOSE_SQUARE_BRACKET758=null;

		CommonTree OPEN_SQUARE_BRACKET757_tree=null;
		CommonTree CLOSE_SQUARE_BRACKET758_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1008:5: ( OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1008:7: OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET
			{
			root_0 = (CommonTree)adaptor.nil();


			OPEN_SQUARE_BRACKET757=(Token)match(input,OPEN_SQUARE_BRACKET,FOLLOW_OPEN_SQUARE_BRACKET_in_anon8409); 
			OPEN_SQUARE_BRACKET757_tree = (CommonTree)adaptor.create(OPEN_SQUARE_BRACKET757);
			adaptor.addChild(root_0, OPEN_SQUARE_BRACKET757_tree);

			CLOSE_SQUARE_BRACKET758=(Token)match(input,CLOSE_SQUARE_BRACKET,FOLLOW_CLOSE_SQUARE_BRACKET_in_anon8411); 
			CLOSE_SQUARE_BRACKET758_tree = (CommonTree)adaptor.create(CLOSE_SQUARE_BRACKET758);
			adaptor.addChild(root_0, CLOSE_SQUARE_BRACKET758_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "anon"

	// Delegated rules


	protected DFA32 dfa32 = new DFA32(this);
	static final String DFA32_eotS =
		"\10\uffff";
	static final String DFA32_eofS =
		"\10\uffff";
	static final String DFA32_minS =
		"\1\6\1\147\1\u009e\2\uffff\1\6\1\147\1\6";
	static final String DFA32_maxS =
		"\1\u00f6\1\147\1\u009e\2\uffff\1\u00f6\1\147\1\u00f6";
	static final String DFA32_acceptS =
		"\3\uffff\1\1\1\2\3\uffff";
	static final String DFA32_specialS =
		"\10\uffff}>";
	static final String[] DFA32_transitionS = {
			"\1\4\10\uffff\1\3\2\uffff\1\1\11\uffff\1\4\12\uffff\1\3\4\uffff\1\4\1"+
			"\uffff\1\4\11\uffff\1\4\1\uffff\1\3\7\uffff\1\4\35\uffff\1\4\25\uffff"+
			"\1\4\11\uffff\1\4\44\uffff\1\2\20\uffff\1\3\77\uffff\1\4",
			"\1\5",
			"\1\6",
			"",
			"",
			"\1\4\10\uffff\1\3\2\uffff\1\1\11\uffff\1\4\12\uffff\1\3\4\uffff\1\4"+
			"\1\uffff\1\4\11\uffff\1\4\1\uffff\1\3\7\uffff\1\4\35\uffff\1\4\25\uffff"+
			"\1\4\11\uffff\1\4\44\uffff\1\2\20\uffff\1\3\77\uffff\1\4",
			"\1\7",
			"\1\4\10\uffff\1\3\2\uffff\1\1\11\uffff\1\4\12\uffff\1\3\4\uffff\1\4"+
			"\1\uffff\1\4\11\uffff\1\4\1\uffff\1\3\7\uffff\1\4\35\uffff\1\4\25\uffff"+
			"\1\4\11\uffff\1\4\44\uffff\1\2\20\uffff\1\3\77\uffff\1\4"
	};

	static final short[] DFA32_eot = DFA.unpackEncodedString(DFA32_eotS);
	static final short[] DFA32_eof = DFA.unpackEncodedString(DFA32_eofS);
	static final char[] DFA32_min = DFA.unpackEncodedStringToUnsignedChars(DFA32_minS);
	static final char[] DFA32_max = DFA.unpackEncodedStringToUnsignedChars(DFA32_maxS);
	static final short[] DFA32_accept = DFA.unpackEncodedString(DFA32_acceptS);
	static final short[] DFA32_special = DFA.unpackEncodedString(DFA32_specialS);
	static final short[][] DFA32_transition;

	static {
		int numStates = DFA32_transitionS.length;
		DFA32_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA32_transition[i] = DFA.unpackEncodedString(DFA32_transitionS[i]);
		}
	}

	protected class DFA32 extends DFA {

		public DFA32(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 32;
			this.eot = DFA32_eot;
			this.eof = DFA32_eof;
			this.min = DFA32_min;
			this.max = DFA32_max;
			this.accept = DFA32_accept;
			this.special = DFA32_special;
			this.transition = DFA32_transition;
		}
		@Override
		public String getDescription() {
			return "381:1: query : ( prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | update ( SEMICOLON update )* EOF -> ^( UPDATE ( update )+ ) );";
		}
	}

	public static final BitSet FOLLOW_sparqlifyConfigStmt_in_sparqlifyConfig268 = new BitSet(new long[]{0x00A0400000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_EOF_in_sparqlifyConfig271 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constructViewConfigStmt_in_constructViewConfig290 = new BitSet(new long[]{0x0000400000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_EOF_in_constructViewConfig293 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_viewDefStmtConstruct_in_constructViewConfigStmt312 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDefStmt_in_constructViewConfigStmt320 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_viewDefStmt_in_sparqlifyConfigStmt341 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDefStmt_in_sparqlifyConfigStmt349 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_macroStmt_in_sparqlifyConfigStmt357 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionDeclarationStmt_in_sparqlifyConfigStmt365 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECLARE_in_functionDeclarationStmt386 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_FUNCTION_in_functionDeclarationStmt388 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_functionSignature_in_functionDeclarationStmt390 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_functionDeclarationStmt392 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_functionTemplate_in_functionDeclarationStmt394 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_functionDeclarationStmt396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_functionSignature432 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_functionSignature434 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_parameterTypeList_in_functionSignature436 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_parameterTypeList471 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_parameterTypeList493 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_parameterType_in_parameterTypeList495 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_parameterTypeList498 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_parameterType_in_parameterTypeList500 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_parameterTypeList504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parameterType538 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_parameterType540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_functionTemplate576 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_expressionList_in_functionTemplate578 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_templateConfigStmt_in_templateConfig613 = new BitSet(new long[]{0x0000400000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_EOF_in_templateConfig616 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_viewTemplateDefStmt_in_templateConfigStmt629 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDefStmt_in_templateConfigStmt634 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_importStmt648 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriOrFileRef_in_importStmt650 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_iriOrFileRef667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_viewDefStmt684 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_VIEW_in_viewDefStmt686 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_viewDefStmt688 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_viewDefStmt690 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_CONSTRUCT_in_viewDefStmt692 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_viewTemplateDef_in_viewDefStmt694 = new BitSet(new long[]{0x0000002000000002L,0x0000000000002000L,0x0100000000000000L});
	public static final BitSet FOLLOW_varConstraintsClause_in_viewDefStmt696 = new BitSet(new long[]{0x0000000000000002L,0x0000000000002000L,0x0100000000000000L});
	public static final BitSet FOLLOW_FROM_in_viewDefStmt700 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L,0x0000000000000808L});
	public static final BitSet FOLLOW_relationRef_in_viewDefStmt702 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_viewDefStmt706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_viewDefStmtConstruct745 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_CONSTRUCT_in_viewDefStmtConstruct747 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_VIEW_in_viewDefStmtConstruct749 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_viewDefStmtConstruct751 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_viewDefStmtConstruct753 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_QUERY_in_viewDefStmtConstruct755 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_viewDefStmtConstruct757 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRAIN_in_varConstraintsClause793 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_varConstraint_in_varConstraintsClause795 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_regexValueConstraint_in_varConstraint827 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixValueConstraint_in_varConstraint835 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_regexValueConstraint864 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_REGEX_in_regexValueConstraint866 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_string_in_regexValueConstraint868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_prefixValueConstraint903 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_PREFIX_in_prefixValueConstraint905 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_stringList_in_prefixValueConstraint907 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_stringList942 = new BitSet(new long[]{0x0000000400000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_COMMA_in_stringList945 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_string_in_stringList948 = new BitSet(new long[]{0x0000000400000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_DOT_in_memberAccess982 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_memberAccess984 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_viewTemplateDefStmt1001 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_VIEW_in_viewTemplateDefStmt1003 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_TEMPLATE_in_viewTemplateDefStmt1005 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_viewTemplateDefStmt1007 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_viewTemplateDefStmt1009 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_CONSTRUCT_in_viewTemplateDefStmt1011 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_viewTemplateDef_in_viewTemplateDefStmt1013 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_viewTemplateDefStmt1015 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constructTemplateQuads_in_viewTemplateDef1045 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_varBindingPart_in_viewTemplateDef1047 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_prefixDefStmt1076 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFINE_in_macroStmt1097 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_macroStmt1099 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_joinClause_in_relationRef1126 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_relationRef1129 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_relationRef1133 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause1163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause1170 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_joinClause1172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L,0x0000000000000808L});
	public static final BitSet FOLLOW_joinClause_in_joinClause1176 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_logicalTable_in_joinClauseMember1209 = new BitSet(new long[]{0x0000000000002012L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_joinClauseMember1212 = new BitSet(new long[]{0x0000000000000010L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_name_in_joinClauseMember1217 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_name1249 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_name1259 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SQL_QUERY_in_logicalTable1286 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_logicalTable1305 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL2_in_logicalTable1324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WITH_in_varBindingPart1357 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_varBinding_in_varBindingPart1359 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_varBinding1389 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_EQUAL_in_varBinding1391 = new BitSet(new long[]{0x0000000001000000L,0x0000000000000000L,0x0000000008000000L,0x0000008020000000L});
	public static final BitSet FOLLOW_typeCtorExpression_in_varBinding1393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BNODE_in_typeCtorExpression1421 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1423 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1425 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1427 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_typeCtorExpression1443 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1445 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1447 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_typeCtorExpression1450 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1452 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1456 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_typeCtorExpression1477 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1479 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1481 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_typeCtorExpression1484 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1486 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1490 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_typeCtorExpression1509 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1511 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1513 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_typeCtorExpression1515 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1517 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1519 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prologue_in_query1550 = new BitSet(new long[]{0x0400008000008000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_selectQuery_in_query1554 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_constructQuery_in_query1558 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_describeQuery_in_query1562 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_askQuery_in_query1566 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_bindingsClause_in_query1570 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1572 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_in_query1603 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_query1607 = new BitSet(new long[]{0x0100500010040040L,0x0040000100000004L,0x0000002000000001L,0x0040000000000000L});
	public static final BitSet FOLLOW_update_in_query1609 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1613 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_baseDecl_in_prologue1640 = new BitSet(new long[]{0x0000000000040002L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_prefixDecl_in_prologue1644 = new BitSet(new long[]{0x0000000000040002L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_BASE_in_baseDecl1675 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_IRI_REF_in_baseDecl1677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PREFIX_in_prefixDecl1702 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixDecl1704 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_IRI_REF_in_prefixDecl1706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectClause_in_selectQuery1733 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000004000L,0x0010000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_selectQuery1735 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000004000L,0x0010000000000000L});
	public static final BitSet FOLLOW_whereClause_in_selectQuery1738 = new BitSet(new long[]{0x0000000000000000L,0x0020000008800000L,0x0000000000041000L});
	public static final BitSet FOLLOW_solutionModifier_in_selectQuery1740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectClause_in_subSelect1774 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L,0x0010000000000000L});
	public static final BitSet FOLLOW_whereClause_in_subSelect1776 = new BitSet(new long[]{0x0000000000000000L,0x0020000008800000L,0x0000000000041000L});
	public static final BitSet FOLLOW_solutionModifier_in_subSelect1778 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_selectClause1811 = new BitSet(new long[]{0x1000000000010000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1815 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1819 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1824 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_selectClause1846 = new BitSet(new long[]{0x1000000000000000L,0x0000000000000000L,0x0000200000002000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1850 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1854 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1862 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000002000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_selectVariables1899 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_selectVariables1917 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_selectVariables1921 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_selectVariables1923 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_selectVariables1927 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_selectVariables1929 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1960 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_constructTemplate_in_constructQuery1962 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000004000L,0x0010000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1964 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000004000L,0x0010000000000000L});
	public static final BitSet FOLLOW_whereClause_in_constructQuery1967 = new BitSet(new long[]{0x0000000000000000L,0x0020000008800000L,0x0000000000041000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery1969 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1995 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1997 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_constructQuery2000 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_constructQuery2002 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_triplesTemplate_in_constructQuery2004 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_constructQuery2007 = new BitSet(new long[]{0x0000000000000000L,0x0020000008800000L,0x0000000000041000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery2009 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESCRIBE_in_describeQuery2045 = new BitSet(new long[]{0x0000000000010000L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_describeQuery2052 = new BitSet(new long[]{0x0000000000000000L,0x0020008008802000L,0x0000000060045000L,0x00101C0000000000L});
	public static final BitSet FOLLOW_ASTERISK_in_describeQuery2058 = new BitSet(new long[]{0x0000000000000000L,0x0020000008802000L,0x0000000000045000L,0x0010000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_describeQuery2062 = new BitSet(new long[]{0x0000000000000000L,0x0020000008802000L,0x0000000000045000L,0x0010000000000000L});
	public static final BitSet FOLLOW_whereClause_in_describeQuery2065 = new BitSet(new long[]{0x0000000000000000L,0x0020000008800000L,0x0000000000041000L});
	public static final BitSet FOLLOW_solutionModifier_in_describeQuery2068 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASK_in_askQuery2107 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000004000L,0x0010000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_askQuery2109 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000004000L,0x0010000000000000L});
	public static final BitSet FOLLOW_whereClause_in_askQuery2112 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FROM_in_datasetClause2140 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000004L});
	public static final BitSet FOLLOW_NAMED_in_datasetClause2142 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_datasetClause2145 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WHERE_in_whereClause2173 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_whereClause2176 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_groupClause_in_solutionModifier2201 = new BitSet(new long[]{0x0000000000000002L,0x0020000008000000L,0x0000000000041000L});
	public static final BitSet FOLLOW_havingClause_in_solutionModifier2204 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L,0x0000000000041000L});
	public static final BitSet FOLLOW_orderClause_in_solutionModifier2207 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_limitOffsetClauses_in_solutionModifier2210 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_in_groupClause2242 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_BY_in_groupClause2244 = new BitSet(new long[]{0x000308110B000020L,0xA205BEC030001090L,0xF82C900060002480L,0x01001C80C049C1C0L});
	public static final BitSet FOLLOW_groupCondition_in_groupClause2246 = new BitSet(new long[]{0x000308110B000022L,0xA205BEC030001090L,0xF82C900060002480L,0x01001C80C049C1C0L});
	public static final BitSet FOLLOW_builtInCall_in_groupCondition2280 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_groupCondition2288 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_groupCondition2296 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_groupCondition2298 = new BitSet(new long[]{0x0000000020002000L});
	public static final BitSet FOLLOW_AS_in_groupCondition2301 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition2303 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_groupCondition2307 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_groupCondition2326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HAVING_in_havingClause2347 = new BitSet(new long[]{0x000308110B000020L,0xA205BEC030001090L,0xF82C900060002480L,0x01000080C049C1C0L});
	public static final BitSet FOLLOW_constraint_in_havingClause2349 = new BitSet(new long[]{0x000308110B000022L,0xA205BEC030001090L,0xF82C900060002480L,0x01000080C049C1C0L});
	public static final BitSet FOLLOW_ORDER_in_orderClause2381 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_BY_in_orderClause2383 = new BitSet(new long[]{0x020308110B004020L,0xA205BEC030001090L,0xF82C900060002480L,0x01001C80C049C1C0L});
	public static final BitSet FOLLOW_orderCondition_in_orderClause2385 = new BitSet(new long[]{0x020308110B004022L,0xA205BEC030001090L,0xF82C900060002480L,0x01001C80C049C1C0L});
	public static final BitSet FOLLOW_ASC_in_orderCondition2412 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_brackettedExpression_in_orderCondition2414 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_orderCondition2432 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_brackettedExpression_in_orderCondition2434 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constraint_in_orderCondition2452 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_orderCondition2468 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_limitClause_in_limitOffsetClauses2498 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_offsetClause_in_limitOffsetClauses2500 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_offsetClause_in_limitOffsetClauses2516 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L});
	public static final BitSet FOLLOW_limitClause_in_limitOffsetClauses2518 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIMIT_in_limitClause2543 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_limitClause2545 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFFSET_in_offsetClause2570 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_offsetClause2572 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BINDINGS_in_bindingsClause2598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_bindingsClause2600 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_bindingsClause2603 = new BitSet(new long[]{0x0000000040000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_bindingValueList_in_bindingsClause2605 = new BitSet(new long[]{0x0000000040000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_bindingsClause2608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_bindingValueList2644 = new BitSet(new long[]{0x801C000020000000L,0x0000008E00000403L,0x0000000060000000L,0x0000001010003C00L});
	public static final BitSet FOLLOW_bindingValue_in_bindingValueList2646 = new BitSet(new long[]{0x801C000020000000L,0x0000008E00000403L,0x0000000060000000L,0x0000001010003C00L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_bindingValueList2649 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_bindingValue2680 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_bindingValue2684 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_bindingValue2688 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_bindingValue2692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNDEF_in_bindingValue2696 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prologue_in_update2717 = new BitSet(new long[]{0x0100500010000040L,0x0040000100000004L,0x0000000000000001L,0x0040000000000000L});
	public static final BitSet FOLLOW_load_in_update2720 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_clear_in_update2724 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_in_update2728 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_in_update2732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_move_in_update2736 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_copy_in_update2740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_in_update2744 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insert_in_update2748 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_in_update2752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_modify_in_update2756 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LOAD_in_load2819 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SILENT_in_load2821 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_load2824 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_INTO_in_load2828 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_graphRef_in_load2830 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLEAR_in_clear2868 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_SILENT_in_clear2871 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000004L});
	public static final BitSet FOLLOW_graphRefAll_in_clear2874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop2906 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_SILENT_in_drop2908 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000004L});
	public static final BitSet FOLLOW_graphRefAll_in_drop2911 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create2940 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SILENT_in_create2942 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_graphRef_in_create2945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add2977 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SILENT_in_add2979 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2984 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_TO_in_add2986 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2990 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MOVE_in_move3026 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SILENT_in_move3028 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_move3033 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_TO_in_move3035 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_move3039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COPY_in_copy3075 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SILENT_in_copy3077 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy3082 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_TO_in_copy3084 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy3088 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INSERT_in_insert3120 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_DATA_in_insert3122 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_quadPattern_in_insert3124 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete3158 = new BitSet(new long[]{0x0000800000000000L,0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_deleteData_in_delete3162 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteWhere_in_delete3166 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DATA_in_deleteData3185 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteData3187 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WHERE_in_deleteWhere3214 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteWhere3216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WITH_in_modify3249 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_modify3253 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_deleteClause_in_modify3259 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify3261 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify3266 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify3269 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify3272 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify3274 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_deleteClause3322 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteClause3324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INSERT_in_insertClause3353 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_quadPattern_in_insertClause3355 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_USING_in_usingClause3378 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000004L});
	public static final BitSet FOLLOW_NAMED_in_usingClause3380 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_usingClause3383 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_graphOrDefault3414 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphOrDefault3423 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_graphOrDefault3426 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphRef3453 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_graphRef3455 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphRef_in_graphRefAll3472 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_graphRefAll3476 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAMED_in_graphRefAll3480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_graphRefAll3484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_quadPattern3501 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00080403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_quads_in_quadPattern3503 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_quadPattern3505 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads3530 = new BitSet(new long[]{0x0000000000000002L,0x0000000000080000L});
	public static final BitSet FOLLOW_quadsNotTriples_in_quads3535 = new BitSet(new long[]{0xC01C000000800002L,0x0000008E00080403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_DOT_in_quads3537 = new BitSet(new long[]{0x801C000000800002L,0x0000008E00080403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads3540 = new BitSet(new long[]{0x0000000000000002L,0x0000000000080000L});
	public static final BitSet FOLLOW_GRAPH_in_quadsNotTriples3582 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_quadsNotTriples3584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_quadsNotTriples3586 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_triplesTemplate_in_quadsNotTriples3588 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_quadsNotTriples3591 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesSameSubject_in_triplesTemplate3623 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesTemplate3627 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_triplesSameSubject_in_triplesTemplate3629 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesTemplate3634 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_groupGraphPattern3666 = new BitSet(new long[]{0x801C000040880000L,0x1000008E00080C03L,0x044000006001E000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_subSelect_in_groupGraphPattern3670 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_groupGraphPatternSub_in_groupGraphPattern3674 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_groupGraphPattern3678 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSub3711 = new BitSet(new long[]{0x0000000000080002L,0x1000000000080800L,0x0400000000014000L});
	public static final BitSet FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub3716 = new BitSet(new long[]{0x0000000000080002L,0x1000000000080800L,0x0400000000014000L});
	public static final BitSet FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache3745 = new BitSet(new long[]{0xC01C000000800002L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_DOT_in_groupGraphPatternSubCache3747 = new BitSet(new long[]{0x801C000000800002L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSubCache3750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesBlock3777 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesBlock3781 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesBlock3783 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesBlock3787 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples3814 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_optionalGraphPattern_in_graphPatternNotTriples3818 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_minusGraphPattern_in_graphPatternNotTriples3822 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphGraphPattern_in_graphPatternNotTriples3826 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_serviceGraphPattern_in_graphPatternNotTriples3830 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_filter_in_graphPatternNotTriples3834 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_in_graphPatternNotTriples3838 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONAL_in_optionalGraphPattern3855 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_optionalGraphPattern3857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphGraphPattern3882 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_graphGraphPattern3884 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_graphGraphPattern3886 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SERVICE_in_serviceGraphPattern3913 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000002L});
	public static final BitSet FOLLOW_SILENT_in_serviceGraphPattern3915 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_serviceGraphPattern3918 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_serviceGraphPattern3920 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_in_bind3954 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_bind3956 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_bind3958 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_bind3960 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_bind3962 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_bind3964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_KEYWORD_in_minusGraphPattern4001 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_minusGraphPattern4003 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4031 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_UNION_in_groupOrUnionGraphPattern4039 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4043 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_FILTER_in_filter4075 = new BitSet(new long[]{0x000308110B000020L,0xA205BEC030001090L,0xF82C900060002480L,0x01000080C049C1C0L});
	public static final BitSet FOLLOW_constraint_in_filter4077 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_brackettedExpression_in_constraint4102 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_builtInCall_in_constraint4110 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_constraint4118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_functionCall4135 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_argList_in_functionCall4137 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_argList4168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_argList4180 = new BitSet(new long[]{0x901F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_argList4182 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_argList4185 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_argList4189 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_argList4191 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_argList4196 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_expressionList4224 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_expressionList4228 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_expressionList4230 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_expressionList4234 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_expressionList4236 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_expressionList4241 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_quadPattern_in_constructTemplateQuads4277 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_constructTemplate4303 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_constructTriples_in_constructTemplate4305 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_constructTemplate4308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesSameSubject_in_constructTriples4334 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_constructTriples4338 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_triplesSameSubject_in_constructTriples4340 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_constructTriples4345 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_varOrTerm_in_triplesSameSubject4370 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesSameSubject4372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_triplesSameSubject4388 = new BitSet(new long[]{0x0000000000000012L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesSameSubject4399 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_verb_in_propertyListNotEmpty4435 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmpty4437 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_propertyListNotEmpty4441 = new BitSet(new long[]{0x0000000000000012L,0x0000008000000000L,0x0100000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_verb_in_propertyListNotEmpty4446 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmpty4448 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_graphNode_in_objectList4477 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_COMMA_in_objectList4481 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_graphNode_in_objectList4483 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_varOrIRIref_in_verb4533 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_verb4541 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_varOrTerm_in_triplesSameSubjectPath4558 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x0000000060002020L,0x00001C0000000000L});
	public static final BitSet FOLLOW_propertyListNotEmptyPath_in_triplesSameSubjectPath4560 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_triplesSameSubjectPath4580 = new BitSet(new long[]{0x0000000000000012L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesSameSubjectPath4591 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_verbPath_in_propertyListNotEmptyPath4630 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4633 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_verbSimple_in_propertyListNotEmptyPath4639 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4641 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_propertyListNotEmptyPath4646 = new BitSet(new long[]{0x0000000000000012L,0x000000A000000000L,0x0100000060002020L,0x00001C0000000000L});
	public static final BitSet FOLLOW_verbPath_in_propertyListNotEmptyPath4651 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4653 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_verbSimple_in_propertyListNotEmptyPath4661 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4664 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_path_in_verbPath4696 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_verbSimple4717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathSequence_in_path4739 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_PIPE_in_path4743 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x0000000060002020L});
	public static final BitSet FOLLOW_pathSequence_in_path4745 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence4781 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_DIVIDE_in_pathSequence4785 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x0000000060002020L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence4787 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_pathPrimary_in_pathElt4815 = new BitSet(new long[]{0x0000000000010002L,0x0000000000000000L,0x0000080010004000L});
	public static final BitSet FOLLOW_pathMod_in_pathElt4817 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse4839 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVERSE_in_pathEltOrInverse4843 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x0000000060002020L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse4845 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASTERISK_in_pathMod4868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_MARK_in_pathMod4872 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_pathMod4876 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_pathMod4880 = new BitSet(new long[]{0x0000000400000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod4884 = new BitSet(new long[]{0x0000000440000000L});
	public static final BitSet FOLLOW_COMMA_in_pathMod4888 = new BitSet(new long[]{0x0000000040000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4892 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod4896 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4898 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4904 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pathMod4910 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod4912 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4914 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_pathPrimary4935 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_pathPrimary4951 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEGATION_in_pathPrimary4967 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x0000000060002000L});
	public static final BitSet FOLLOW_pathNegatedPropertySet_in_pathPrimary4969 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_pathPrimary4987 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x0000000060002020L});
	public static final BitSet FOLLOW_path_in_pathPrimary4989 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_pathPrimary4991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_pathNegatedPropertySet5021 = new BitSet(new long[]{0x0000000020000010L,0x000000A000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5025 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_PIPE_in_pathNegatedPropertySet5029 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5031 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_pathNegatedPropertySet5039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVERSE_in_pathOneInPropertySet5069 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_pathOneInPropertySet5074 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_pathOneInPropertySet5078 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_triplesNode5098 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_graphNode_in_triplesNode5100 = new BitSet(new long[]{0x801C000020800000L,0x0000008E00000403L,0x000000006000A000L,0x00001C0010003C00L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_triplesNode5103 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_SQUARE_BRACKET_in_triplesNode5122 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x0000000060000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesNode5124 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_CLOSE_SQUARE_BRACKET_in_triplesNode5127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_varOrTerm_in_graphNode5152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_graphNode5156 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrTerm5173 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphTerm_in_varOrTerm5177 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrIRIref5194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_varOrIRIref5198 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR1_in_var5217 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR2_in_var5234 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR3_in_var5251 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_graphTerm5276 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_graphTerm5284 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_graphTerm5292 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_graphTerm5300 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blankNode_in_graphTerm5308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_graphTerm5316 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_nil5337 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_nil5339 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_conditionalOrExpression_in_expression5356 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_conditionalAndExpression_in_conditionalOrExpression5376 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_OR_in_conditionalOrExpression5385 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_conditionalAndExpression_in_conditionalOrExpression5389 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_valueLogical_in_conditionalAndExpression5423 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_AND_in_conditionalAndExpression5432 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_valueLogical_in_conditionalAndExpression5436 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_relationalExpression_in_valueLogical5467 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5487 = new BitSet(new long[]{0x0000000000000002L,0x0018000080600040L,0x0000000000000180L});
	public static final BitSet FOLLOW_EQUAL_in_relationalExpression5498 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_EQUAL_in_relationalExpression5559 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5563 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESS_in_relationalExpression5618 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5622 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_relationalExpression5677 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5681 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESS_EQUAL_in_relationalExpression5735 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5739 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_EQUAL_in_relationalExpression5793 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5797 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_relationalExpression5853 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_expressionList_in_relationalExpression5857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_relationalExpression5911 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_IN_in_relationalExpression5913 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_expressionList_in_relationalExpression5917 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_additiveExpression_in_numericExpression5952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_multiplicativeExpression_in_additiveExpression5972 = new BitSet(new long[]{0x0018000000000002L,0x0800000C00000003L,0x0000000010000000L});
	public static final BitSet FOLLOW_additiveOperator_in_additiveExpression5983 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_multiplicativeExpression_in_additiveExpression5987 = new BitSet(new long[]{0x0018000000000002L,0x0800000C00000003L,0x0000000010000000L});
	public static final BitSet FOLLOW_numericLiteralPositive_in_additiveExpression6054 = new BitSet(new long[]{0x2018000000010002L,0x0800000C00000003L,0x0000000010000000L});
	public static final BitSet FOLLOW_numericLiteralNegative_in_additiveExpression6072 = new BitSet(new long[]{0x2018000000010002L,0x0800000C00000003L,0x0000000010000000L});
	public static final BitSet FOLLOW_ASTERISK_in_additiveExpression6139 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_unaryExpression_in_additiveExpression6143 = new BitSet(new long[]{0x0018000000000002L,0x0800000C00000003L,0x0000000010000000L});
	public static final BitSet FOLLOW_DIVIDE_in_additiveExpression6211 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_unaryExpression_in_additiveExpression6215 = new BitSet(new long[]{0x0018000000000002L,0x0800000C00000003L,0x0000000010000000L});
	public static final BitSet FOLLOW_unaryExpression_in_multiplicativeExpression6283 = new BitSet(new long[]{0x2000000000010002L});
	public static final BitSet FOLLOW_multiplicativeOperator_in_multiplicativeExpression6292 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_unaryExpression_in_multiplicativeExpression6296 = new BitSet(new long[]{0x2000000000010002L});
	public static final BitSet FOLLOW_NEGATION_in_unaryExpression6354 = new BitSet(new long[]{0x801F28110B020020L,0xA705BECE32001493L,0xF83C900060002482L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6356 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_unaryExpression6375 = new BitSet(new long[]{0x801F28110B020020L,0xA705BECE32001493L,0xF83C900060002482L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_unaryExpression6396 = new BitSet(new long[]{0x801F28110B020020L,0xA705BECE32001493L,0xF83C900060002482L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6398 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6416 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_brackettedExpression_in_primaryExpression6441 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_builtInCall_in_primaryExpression6445 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRefOrFunction_in_primaryExpression6449 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_primaryExpression6453 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_primaryExpression6457 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_primaryExpression6461 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_primaryExpression6465 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_aggregate_in_primaryExpression6469 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_aliasedVar_in_primaryExpression6474 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_aliasedVar6494 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_DOT_in_aliasedVar6496 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_aliasedVar6500 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_brackettedExpression6529 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_brackettedExpression6531 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_brackettedExpression6533 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STR_in_builtInCall6554 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6556 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6558 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6560 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LANG_in_builtInCall6576 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6578 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6580 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6582 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LANGMATCHES_in_builtInCall6598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6600 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6602 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall6604 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6606 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DATATYPE_in_builtInCall6625 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6627 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6629 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6631 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BOUND_in_builtInCall6647 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6649 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00001C0000000000L});
	public static final BitSet FOLLOW_var_in_builtInCall6651 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IRI_in_builtInCall6669 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6671 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6673 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_builtInCall6691 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6693 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6695 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6697 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BNODE_in_builtInCall6713 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6716 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6718 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6720 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_builtInCall6723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RAND_in_builtInCall6740 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_nil_in_builtInCall6742 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ABS_in_builtInCall6754 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6756 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6758 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CEIL_in_builtInCall6776 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6778 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6780 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6782 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOOR_in_builtInCall6798 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6800 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6802 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6804 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ROUND_in_builtInCall6820 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6822 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6824 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6826 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONCAT_in_builtInCall6842 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall6844 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subStringExpression_in_builtInCall6860 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRLEN_in_builtInCall6872 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6874 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6876 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6878 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UCASE_in_builtInCall6894 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6896 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6898 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6900 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LCASE_in_builtInCall6916 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6918 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6920 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6922 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ENCODE_FOR_URI_in_builtInCall6938 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6940 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6942 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6944 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONTAINS_in_builtInCall6960 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6962 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6964 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6966 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRSTARTS_in_builtInCall6982 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6984 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall6986 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6988 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRENDS_in_builtInCall7004 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7006 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7008 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7010 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_YEAR_in_builtInCall7026 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7028 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7030 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7032 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MONTH_in_builtInCall7048 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7050 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7052 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DAY_in_builtInCall7070 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7072 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7074 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7076 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HOURS_in_builtInCall7092 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7094 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7096 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7098 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUTES_in_builtInCall7114 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7116 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7118 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7120 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SECONDS_in_builtInCall7136 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7138 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7140 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TIMEZONE_in_builtInCall7158 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7160 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7162 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7164 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TZ_in_builtInCall7180 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7182 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7184 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOW_in_builtInCall7202 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_nil_in_builtInCall7204 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MD5_in_builtInCall7216 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7218 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7220 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7222 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA1_in_builtInCall7238 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7240 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7242 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7244 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA224_in_builtInCall7260 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7262 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7264 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7266 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA256_in_builtInCall7282 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7284 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7286 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7288 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA384_in_builtInCall7304 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7306 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7308 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7310 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA512_in_builtInCall7326 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7328 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7330 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7332 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COALESCE_in_builtInCall7348 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall7350 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_builtInCall7366 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7368 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7372 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7374 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7378 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7380 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7384 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7386 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRLANG_in_builtInCall7409 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7411 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7413 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7415 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7417 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7419 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRDT_in_builtInCall7437 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7439 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7441 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7443 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7445 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7447 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SAMETERM_in_builtInCall7465 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7467 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7469 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7471 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7473 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7475 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISIRI_in_builtInCall7493 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7495 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7497 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7499 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISURI_in_builtInCall7515 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7517 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7519 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7521 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISBLANK_in_builtInCall7537 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7539 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7541 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7543 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISLITERAL_in_builtInCall7560 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7562 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7564 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7566 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISNUMERIC_in_builtInCall7582 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7584 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_builtInCall7586 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7588 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_regexExpression_in_builtInCall7604 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_existsFunction_in_builtInCall7616 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notExistsFunction_in_builtInCall7628 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_in_regexExpression7649 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_regexExpression7651 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_regexExpression7653 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_regexExpression7655 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_regexExpression7657 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_regexExpression7661 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_regexExpression7663 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_regexExpression7668 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUBSTR_in_subStringExpression7698 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_subStringExpression7700 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_subStringExpression7702 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_subStringExpression7704 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_subStringExpression7706 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_subStringExpression7710 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_subStringExpression7712 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_subStringExpression7717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_existsFunction7747 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_existsFunction7749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_notExistsFunction7774 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_EXISTS_in_notExistsFunction7776 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_notExistsFunction7778 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COUNT_in_aggregate7803 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7805 = new BitSet(new long[]{0x901F28110B030020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7807 = new BitSet(new long[]{0x801F28110B030020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_ASTERISK_in_aggregate7812 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_expression_in_aggregate7816 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7820 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUM_in_aggregate7843 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7845 = new BitSet(new long[]{0x901F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7847 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_aggregate7850 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7852 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MIN_in_aggregate7871 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7873 = new BitSet(new long[]{0x901F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7875 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_aggregate7878 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7880 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MAX_in_aggregate7899 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7901 = new BitSet(new long[]{0x901F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7903 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_aggregate7906 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7908 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AVG_in_aggregate7927 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7929 = new BitSet(new long[]{0x901F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7931 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_aggregate7934 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SAMPLE_in_aggregate7955 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7957 = new BitSet(new long[]{0x901F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7959 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_aggregate7962 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_CONCAT_in_aggregate7983 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7985 = new BitSet(new long[]{0x901F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7987 = new BitSet(new long[]{0x801F28110B020020L,0xAF05BECE32001493L,0xF83C9000700024A2L,0x01001C80D059FDC0L});
	public static final BitSet FOLLOW_expression_in_aggregate7990 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_aggregate7994 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEPARATOR_in_aggregate7996 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_EQUAL_in_aggregate7998 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_string_in_aggregate8000 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate8005 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction8040 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction8049 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_argList_in_iriRefOrFunction8051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_rdfLiteral8082 = new BitSet(new long[]{0x0000000000000002L,0x0002000000000000L});
	public static final BitSet FOLLOW_LANGTAG_in_rdfLiteral8084 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_rdfLiteral8104 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_REFERENCE_in_rdfLiteral8106 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_rdfLiteral8108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralUnsigned_in_numericLiteral8135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralPositive_in_numericLiteral8143 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralNegative_in_numericLiteral8151 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IRI_REF_in_iriRef8334 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixedName_in_iriRef8342 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLANK_NODE_LABEL_in_blankNode8384 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_anon_in_blankNode8392 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_SQUARE_BRACKET_in_anon8409 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_CLOSE_SQUARE_BRACKET_in_anon8411 = new BitSet(new long[]{0x0000000000000002L});
}
