/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.restriction.experiment;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.Pair;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.IndirectEquiMap;
import org.aksw.sparqlify.database.NestedNormalForm;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionSetImpl;
import org.apache.commons.lang.NotImplementedException;
import sparql.CnfUtils;

public class RestrictionManager2 {
    private RestrictionManager2 parent;
    private IndirectEquiMap<Var, RestrictionSetImpl> restrictions = new IndirectEquiMap();
    private NestedNormalForm cnf;
    private Map<Var, Node> binding = new HashMap<Var, Node>();
    private BindingMap bindingMap = new BindingHashMap();
    private Boolean satisfiability = Boolean.TRUE;

    public Set<Var> getVariables() {
        HashSet<Var> result = new HashSet<Var>();
        RestrictionManager2 current = this;
        while (current != null) {
            result.addAll(current.restrictions.keySet());
            current = current.parent;
        }
        return result;
    }

    public RestrictionManager2() {
        this.cnf = new NestedNormalForm(null, false);
        Set<Expr> emptyExprSet = Collections.emptySet();
        this.cnf.add(new Clause(emptyExprSet));
        this.satisfiability = Boolean.TRUE;
    }

    public RestrictionManager2(RestrictionManager2 parent) {
        this.parent = parent;
        this.cnf = new NestedNormalForm(parent.getCnf(), true);
    }

    public RestrictionManager2(NestedNormalForm cnf) {
        this.cnf = cnf;
        this.deriveRestrictions(cnf);
    }

    public NestedNormalForm getCnf() {
        return this.cnf;
    }

    public Boolean getSatisfiability() {
        return this.satisfiability;
    }

    public static RestrictionImpl deriveRestriction(Expr expr) {
        if (expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive) {
            return RestrictionManager2.deriveRestriction(expr);
        }
        if (expr.isConstant()) {
            RestrictionImpl result = new RestrictionImpl();
            result.stateNode(expr.getConstant().asNode());
            return result;
        }
        return null;
    }

    public static RestrictionImpl deriveRestriction(E_StrConcat expr) {
        return RestrictionManager2.deriveRestrictionConcat((ExprFunction)expr);
    }

    public static RestrictionImpl deriveRestriction(E_StrConcatPermissive expr) {
        return RestrictionManager2.deriveRestrictionConcat((ExprFunction)expr);
    }

    public static RestrictionImpl deriveRestrictionConcat(ExprFunction concat) {
        Expr arg;
        String prefix = "";
        Iterator iterator = concat.getArgs().iterator();
        while (iterator.hasNext() && (arg = (Expr)iterator.next()).isConstant()) {
            prefix = prefix + arg.getConstant().asUnquotedString();
        }
        RestrictionImpl result = new RestrictionImpl();
        result.stateUriPrefixes(new PrefixSet(prefix));
        return result;
    }

    public void deriveRestrictions(Set<Clause> cnf) {
        for (Clause clause : cnf) {
            if (clause.getExprs().size() != 1) continue;
            for (Map.Entry<Var, RestrictionImpl> entry : clause.getRestrictions().entrySet()) {
                this.stateRestriction(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean stateRestriction(Var var, RestrictionImpl restriction) {
        return this.stateRestriction(var, new RestrictionSetImpl(restriction));
    }

    public boolean stateRestriction(Var var, RestrictionSetImpl restriction) {
        RestrictionSetImpl r = this.getOrCreateLocalRestriction(var);
        if (r.stateRestriction(restriction)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = Boolean.FALSE;
            } else {
                this.check(var);
            }
            return true;
        }
        return false;
    }

    public void check(Var var) {
        Collection<Var> vars = this.restrictions.getEquivalences(var);
        this.check(vars);
    }

    public Set<Clause> getClausesForVars(Collection<Var> vars) {
        HashSet<Clause> result = new HashSet<Clause>();
        for (Var var : vars) {
            Set<Clause> tmp = this.cnf.getClausesByVar(var);
            if (tmp == null) continue;
            result.addAll(tmp);
        }
        return result;
    }

    public void check(Collection<Var> vars) {
        Set<Clause> clauses = this.getClausesForVars(vars);
        this.checkClauses(clauses);
    }

    public void checkClauses(Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            this.check(clause);
            if (this.satisfiability != Boolean.FALSE) continue;
            return;
        }
    }

    public void check(Clause clause) {
        HashSet<Expr> modify = new HashSet<Expr>();
        Boolean isClauseSat = true;
        for (Expr expr : clause.getExprs()) {
            Boolean satisfiability = this.determineSatisfiability(expr);
            if (satisfiability == null) {
                modify.add(expr);
                continue;
            }
            if (satisfiability.booleanValue()) continue;
            isClauseSat = false;
            break;
        }
        if (!isClauseSat.booleanValue()) {
            this.satisfiability = Boolean.FALSE;
            return;
        }
        if (modify != null) {
            this.cnf.remove(clause);
            this.cnf.add(new Clause(modify));
        }
    }

    public Boolean determineSatisfiability(Expr expr) {
        if (this.binding.keySet().containsAll(expr.getVarsMentioned())) {
            try {
                NodeValue value = ExprUtils.eval((Expr)expr, (Binding)this.bindingMap);
                return value.getBoolean();
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
        }
        if (expr instanceof E_LogicalNot) {
            Boolean tmp = this.determineSatisfiability(((E_LogicalNot)expr).getArg());
            return tmp == null ? null : Boolean.valueOf(tmp == false);
        }
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            RestrictionSetImpl a = this.getRestriction(e.getArg1());
            RestrictionSetImpl b = this.getRestriction(e.getArg2());
            return RestrictionManager2.determineSatisfiabilityEquals(a, b);
        }
        return null;
    }

    public RestrictionSetImpl getRestriction(Expr expr) {
        if (expr.isVariable()) {
            return this.restrictions.get(expr.asVar());
        }
        return new RestrictionSetImpl();
    }

    public static Boolean determineSatisfiabilityEquals(RestrictionImpl a, RestrictionImpl b) {
        if (a == null || b == null) {
            return null;
        }
        RestrictionImpl tmp = new RestrictionImpl(a);
        tmp.stateRestriction(b);
        if (!tmp.isConsistent()) {
            return false;
        }
        return null;
    }

    public static Boolean determineSatisfiabilityEquals(RestrictionSetImpl a, RestrictionSetImpl b) {
        if (a == null || b == null) {
            return null;
        }
        RestrictionSetImpl tmp = new RestrictionSetImpl(a);
        tmp.stateRestriction(b);
        if (tmp.isUnsatisfiable()) {
            return false;
        }
        return null;
    }

    public boolean isEqual(Var a, Var b) {
        boolean e = this.restrictions.isEqual(a, b);
        if (e) {
            return true;
        }
        return this.parent != null ? this.parent.isEqual(a, b) : false;
    }

    public Collection<Var> getEquivalences(Var a) {
        Collection<Var> result = this.restrictions.getEquivalences(a);
        if (result.isEmpty() && this.parent != null) {
            return this.parent.getEquivalences(a);
        }
        return result;
    }

    public void stateEqual(Var a, Var b) {
        boolean didCopy = false;
        if (this.restrictions.isEqual(a, b)) {
            return;
        }
        if (this.parent != null && this.parent.isEqual(a, b)) {
            return;
        }
        Collection<Var> ae = this.getEquivalences(a);
        RestrictionSetImpl ar = this.getRestriction(a);
        Collection<Var> be = this.getEquivalences(b);
        RestrictionSetImpl br = this.getRestriction(b);
        this.restrictions.stateEqual(new HashSet<Var>(ae), ar);
        this.restrictions.stateEqual(new HashSet<Var>(be), br);
        didCopy = true;
        Pair<RestrictionSetImpl, RestrictionSetImpl> conflict = this.restrictions.stateEqual(a, b);
        if (conflict != null) {
            RestrictionSetImpl r = (RestrictionSetImpl)conflict.getKey();
            if (didCopy) {
                r = r.clone();
            }
            r.stateRestriction((RestrictionSetImpl)conflict.getValue());
            this.restrictions.stateEqual(a, b, r);
        }
        this.check(a);
    }

    public RestrictionSetImpl getRestriction(Var a) {
        RestrictionSetImpl result = this.restrictions.get(a);
        if (result == null && this.parent != null) {
            return this.parent.getRestriction(a);
        }
        return result;
    }

    public RestrictionSetImpl getOrCreateLocalRestriction(Var a) {
        RestrictionSetImpl toCopy;
        RestrictionSetImpl result = this.restrictions.get(a);
        if (result == null && this.parent != null && (toCopy = this.parent.getRestriction(a)) != null) {
            result = toCopy.clone();
        }
        if (result == null) {
            result = new RestrictionSetImpl();
            this.restrictions.put(a, result);
        }
        return result;
    }

    public void stateType(Var a, RdfTermType type) {
        RestrictionSetImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateType(type)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = false;
            } else {
                this.check(a);
            }
        }
    }

    public void stateNode(Var a, Node b) {
        RestrictionSetImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateNode(b)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = Boolean.FALSE;
                return;
            }
            this.check(a);
            if (this.satisfiability != Boolean.FALSE) {
                for (Var v : this.restrictions.getEquivalences(a)) {
                    this.binding.put(v, b);
                    this.bindingMap.add(v, b);
                }
            }
        }
    }

    public void stateUri(Var a, String uri) {
        this.stateNode(a, Node.createURI((String)uri));
    }

    public void stateLiteral(Var a, NodeValue b) {
        this.stateNode(a, b.asNode());
    }

    public void stateLexicalValuePrefixes(Var a, PrefixSet prefixes) {
        RestrictionSetImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateUriPrefixes(prefixes)) {
            this.check(a);
        }
    }

    public void stateExpr(Expr expr) {
        NestedNormalForm newCnf = CnfUtils.toCnf(expr);
        this.stateCnf(newCnf);
    }

    public void stateCnf(NestedNormalForm newCnf) {
        this.deriveRestrictions(newCnf);
        if (this.satisfiability == Boolean.FALSE) {
            return;
        }
        this.cnf.addAll(newCnf);
        this.checkClauses(newCnf);
    }

    public void stateNonEqual(Var a, Var b) {
        throw new NotImplementedException();
    }

    public Set<Clause> getEffectiveDnf(Collection<Var> vars) {
        ArrayList<Clause> clauses = new ArrayList<Clause>(this.getClausesForVars(vars));
        Collections.sort(clauses, new Comparator<Clause>(){

            @Override
            public int compare(Clause a, Clause b) {
                return a.size() - b.size();
            }
        });
        HashSet<Clause> result = new HashSet<Clause>();
        this.getEffectiveDnf(0, clauses, null, result);
        return result;
    }

    public void getEffectiveDnf(int index, List<Clause> cnfs, Clause parentClause, Set<Clause> result) {
        if (index >= cnfs.size()) {
            if (parentClause != null) {
                result.add(parentClause);
            }
            return;
        }
        Clause clause = cnfs.get(index);
        for (Expr expr : clause.getExprs()) {
            HashSet<Expr> exprs = new HashSet<Expr>();
            if (parentClause != null) {
                exprs.addAll(parentClause.getExprs());
            }
            exprs.add(expr);
            Clause merged = new Clause(exprs);
            this.getEffectiveDnf(index + 1, cnfs, merged, result);
        }
    }

    public String toString() {
        if (this.satisfiability == Boolean.FALSE) {
            return "inconsistent";
        }
        return this.restrictions + " " + this.cnf.toString();
    }

    public void stateUriPrefixes(Var a, PrefixSet prefixes) {
        RestrictionSetImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateUriPrefixes(prefixes)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = Boolean.FALSE;
                return;
            }
            this.check(a);
        }
    }

    public boolean isUnsatisfiable() {
        return this.satisfiability == Boolean.FALSE;
    }

    public static RestrictionManager2 createUnion(Collection<RestrictionManager2> rms) {
        HashSet<Var> vars = new HashSet<Var>();
        for (RestrictionManager2 rm : rms) {
            if (rm.isUnsatisfiable()) continue;
            vars.addAll(rm.getVariables());
        }
        RestrictionManager2 result = new RestrictionManager2();
        for (Var var : vars) {
            RestrictionSetImpl newRs = new RestrictionSetImpl();
            for (RestrictionManager2 rm : rms) {
                RestrictionSetImpl rs;
                if (rm.isUnsatisfiable() || (rs = rm.getRestriction(var)) == null || rs.isUnsatisfiable()) continue;
                for (RestrictionImpl r : rs.getRestrictions()) {
                    newRs.addAlternative(r);
                }
            }
            result.stateRestriction(var, newRs);
        }
        return result;
    }
}

