/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.expr.util;

import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueNode;
import java.math.BigDecimal;
import org.aksw.sparqlify.algebra.sparql.expr.old.NodeValueGeom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeValueUtils {
    private static final Logger logger = LoggerFactory.getLogger(NodeValueUtils.class);

    public static int getInteger(NodeValue expr) {
        int result;
        if (expr.isInteger()) {
            result = expr.getInteger().intValue();
        } else if (expr.isDecimal()) {
            result = expr.getDecimal().intValue();
        } else {
            throw new RuntimeException("Not an integer value: " + expr);
        }
        return result;
    }

    public static Object getValue(NodeValue expr) {
        if (expr == null) {
            return NodeValue.nvNothing;
        }
        if (expr.isIRI()) {
            return expr.asNode().getURI();
        }
        if (expr.isBoolean()) {
            return expr.getBoolean();
        }
        if (expr.isNumber()) {
            if (expr.isDecimal()) {
                BigDecimal d = expr.getDecimal();
                if (d.scale() > 0) {
                    return d.doubleValue();
                }
                return d.intValue();
            }
            if (expr.isDouble()) {
                return expr.getDouble();
            }
            if (expr.isFloat()) {
                return Float.valueOf(expr.getFloat());
            }
            return expr.getDecimal().longValue();
        }
        if (expr.isString()) {
            return expr.getString();
        }
        if (expr.isDateTime()) {
            return expr.getDateTime();
        }
        if (expr instanceof NodeValueGeom) {
            return ((NodeValueGeom)expr).getGeometry();
        }
        if (expr instanceof NodeValueNode) {
            if (expr.equals((Object)NodeValue.nvNothing)) {
                return null;
            }
            throw new RuntimeException("Unknow datatype of node: " + expr);
        }
        throw new RuntimeException("Unknow datatype of constant: " + expr);
    }
}

