/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import org.aksw.sparqlify.database.Constraint;

public class IsPrefixOfConstraint
implements Constraint {
    private String value;
    private boolean inclusive;

    public IsPrefixOfConstraint(String prefix) {
        this(prefix, true);
    }

    public IsPrefixOfConstraint(String prefix, boolean inclusive) {
        this.value = prefix;
        this.inclusive = inclusive;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    @Override
    public boolean isSatisfiedBy(Object prefix) {
        if (prefix == null) {
            return false;
        }
        String p = prefix.toString();
        return this.value.startsWith(p) && (this.inclusive || !this.value.equals(p));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inclusive ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IsPrefixOfConstraint other = (IsPrefixOfConstraint)obj;
        if (this.inclusive != other.inclusive) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "IsPrefixOfConstraint(" + this.value + ", " + this.inclusive + ")";
    }
}

