/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.google.common.collect.Sets;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Bound;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.factory.Factory2;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfViewPattern;
import org.aksw.sparqlify.core.algorithms.OpMapping;
import org.aksw.sparqlify.core.algorithms.OpViewInstanceJoin;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.FilterSplit;
import org.aksw.sparqlify.database.NestedNormalForm;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.aksw.sparqlify.database.PredicateInstanceOf;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.aksw.sparqlify.sparqlview.OpSparqlViewPattern;
import org.aksw.sparqlify.views.transform.GetVarsMentioned;
import org.apache.commons.collections15.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPlacementOptimizer2 {
    private static final Logger logger = LoggerFactory.getLogger(FilterPlacementOptimizer2.class);
    public static Factory2<Op> joinFactory = new Factory2<Op>(){

        @Override
        public Op create(Op a, Op b) {
            Op result = OpJoin.create((Op)a, (Op)b);
            return result;
        }
    };

    public static Op optimize(Op op) {
        RestrictionManagerImpl cnf = new RestrictionManagerImpl();
        Op result = (Op)MultiMethod.invokeStatic(FilterPlacementOptimizer2.class, (String)"_optimize", (Object[])new Object[]{op, cnf});
        return result;
    }

    public static Op optimize(Op op, RestrictionManagerImpl cnf) {
        Op result = (Op)MultiMethod.invokeStatic(FilterPlacementOptimizer2.class, (String)"_optimize", (Object[])new Object[]{op, cnf});
        return result;
    }

    public static RestrictionManagerImpl filterByVars(RestrictionManagerImpl cnf, Op op) {
        Set<Var> vars = GetVarsMentioned.getVarsMentioned(op);
        Set<Clause> clauses = cnf.getClausesForVars(vars);
        return new RestrictionManagerImpl(new NestedNormalForm(clauses));
    }

    public static Op _optimize(OpOrder op, RestrictionManagerImpl cnf) {
        return new OpOrder(FilterPlacementOptimizer2.optimize(op.getSubOp(), cnf), op.getConditions());
    }

    public static Op _optimize(OpTopN op, RestrictionManagerImpl cnf) {
        return new OpTopN(FilterPlacementOptimizer2.optimize(op.getSubOp(), cnf), op.getLimit(), op.getConditions());
    }

    public static Op _optimize(OpJoin op, RestrictionManagerImpl cnf) {
        Op result = FilterPlacementOptimizer2.handleLeftJoin(op.getLeft(), op.getRight(), cnf, joinFactory);
        return result;
    }

    public static Op _optimizeBreaking(OpJoin op, RestrictionManagerImpl cnf) {
        RestrictionManagerImpl leftCnf = FilterPlacementOptimizer2.filterByVars(cnf, op.getLeft());
        RestrictionManagerImpl rightCnf = FilterPlacementOptimizer2.filterByVars(cnf, op.getRight());
        Sets.SetView union = Sets.union((Set)leftCnf.getCnf(), (Set)rightCnf.getCnf());
        Sets.SetView remaining = Sets.difference((Set)cnf.getCnf(), (Set)union);
        Object result = OpJoin.create((Op)FilterPlacementOptimizer2.optimize(op.getLeft(), leftCnf), (Op)FilterPlacementOptimizer2.optimize(op.getRight(), rightCnf));
        if (!remaining.isEmpty()) {
            result = OpFilterIndexed.filter(new RestrictionManagerImpl(new NestedNormalForm((Set<Clause>)remaining)), result);
        }
        return result;
    }

    public static Op _optimize(OpSequence op, RestrictionManagerImpl cnf) {
        List members = op.getElements();
        ArrayList<Op> newMembers = new ArrayList<Op>(members.size());
        HashSet intersection = new HashSet();
        for (Op member : members) {
            RestrictionManagerImpl restrictions = FilterPlacementOptimizer2.filterByVars(cnf, member);
            Op newMember = FilterPlacementOptimizer2.optimize(member, restrictions);
            newMembers.add(newMember);
            Sets.SetView tmp = Sets.intersection((Set)restrictions.getCnf(), intersection);
            intersection = new HashSet(tmp);
        }
        Sets.SetView remaining = Sets.difference((Set)cnf.getCnf(), intersection);
        Object result = OpSequence.create().copy(newMembers);
        if (!remaining.isEmpty()) {
            result = OpFilterIndexed.filter(new RestrictionManagerImpl(new NestedNormalForm((Set<Clause>)remaining)), (Op)result);
        }
        return result;
    }

    public static Op _optimize(OpDisjunction op, RestrictionManagerImpl cnf) {
        ArrayList<Op> args = new ArrayList<Op>();
        for (Op element : op.getElements()) {
            Set<Var> elementVars = GetVarsMentioned.getVarsMentioned(element);
            boolean elementHasRequiredVars = true;
            for (Clause clause : cnf.getCnf()) {
                Set<Var> clauseVars = clause.getVarsMentioned();
                if (!clauseVars.containsAll(elementVars)) continue;
                elementHasRequiredVars = false;
                break;
            }
            if (!elementHasRequiredVars) continue;
            Op optimizedMember = FilterPlacementOptimizer2.optimize(element, cnf);
            args.add(optimizedMember);
        }
        OpDisjunction result = OpDisjunction.create();
        result.getElements().addAll(args);
        return result;
    }

    public static Op _optimize(OpDistinct op, RestrictionManagerImpl cnf) {
        return new OpDistinct(FilterPlacementOptimizer2.optimize(op.getSubOp(), cnf));
    }

    public static Op _optimize(OpProject op, RestrictionManagerImpl cnf) {
        Op subOp = FilterPlacementOptimizer2.optimize(op.getSubOp(), cnf);
        OpProject result = new OpProject(subOp, op.getVars());
        return result;
    }

    public static Op _optimize(OpExtend op, RestrictionManagerImpl cnf) {
        logger.warn("OpExtend probably not optimally implemented");
        return op.copy(FilterPlacementOptimizer2.optimize(op.getSubOp(), cnf));
    }

    public static Op _optimize(OpGroup op, RestrictionManagerImpl cnf) {
        return new OpGroup(FilterPlacementOptimizer2.optimize(op.getSubOp(), cnf), op.getGroupVars(), op.getAggregators());
    }

    public static Op _optimizeNewButNotSureIfWeNeedSplitsHere(OpFilterIndexed op, RestrictionManagerImpl cnf) {
        RestrictionManagerImpl child = new RestrictionManagerImpl(cnf);
        child.stateRestriction(op.getRestrictions());
        FilterSplit filterSplit = FilterPlacementOptimizer2.splitFilter((Op)op, child);
        RestrictionManagerImpl pushable = filterSplit.getPushable();
        Object result = FilterPlacementOptimizer2.optimize(op.getSubOp(), pushable);
        if (!filterSplit.getNonPushable().getCnf().isEmpty()) {
            result = OpFilterIndexed.filter(filterSplit.getNonPushable(), result);
        }
        return result;
    }

    public static Op _optimize(OpFilterIndexed op, RestrictionManagerImpl cnf) {
        RestrictionManagerImpl child = new RestrictionManagerImpl(cnf);
        child.stateRestriction(op.getRestrictions());
        Op result = FilterPlacementOptimizer2.optimize(op.getSubOp(), child);
        return result;
    }

    public static Op _optimize(OpNull op, RestrictionManagerImpl cnf) {
        return op;
    }

    public static Op _optimize(OpSlice op, RestrictionManagerImpl cnf) {
        return op.copy(FilterPlacementOptimizer2.optimize(op.getSubOp(), cnf));
    }

    public static boolean evalPredicate(Expr expr, Predicate<Expr> predicate) {
        if (predicate.evaluate((Object)expr)) {
            return true;
        }
        if (expr.isFunction()) {
            for (Expr arg : expr.getFunction().getArgs()) {
                if (!FilterPlacementOptimizer2.evalPredicate(arg, predicate)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doesClauseContainBoundExpr(Clause clause) {
        PredicateInstanceOf<Expr> predicate = new PredicateInstanceOf<Expr>(E_Bound.class);
        for (Expr expr : clause.getExprs()) {
            if (!FilterPlacementOptimizer2.evalPredicate(expr, predicate)) continue;
            return true;
        }
        return false;
    }

    public static Op _optimize(final OpLeftJoin op, RestrictionManagerImpl cnf) {
        Factory2<Op> factory = new Factory2<Op>(){

            @Override
            public Op create(Op a, Op b) {
                Op result = OpLeftJoin.create((Op)a, (Op)b, (ExprList)op.getExprs());
                return result;
            }
        };
        Op result = FilterPlacementOptimizer2.handleLeftJoin(op.getLeft(), op.getRight(), cnf, factory);
        return result;
    }

    public static Op _optimize(OpConditional op, RestrictionManagerImpl cnf) {
        Factory2<Op> factory = new Factory2<Op>(){

            @Override
            public Op create(Op a, Op b) {
                OpConditional result = new OpConditional(a, b);
                return result;
            }
        };
        Op result = FilterPlacementOptimizer2.handleLeftJoin(op.getLeft(), op.getRight(), cnf, factory);
        return result;
    }

    public static FilterSplit splitFilter(Op op, RestrictionManagerImpl cnf) {
        Set<Var> opVars = GetVarsMentioned.getVarsMentioned(op);
        HashSet<Clause> leftClauses = new HashSet<Clause>();
        HashSet<Clause> nonPushable = new HashSet<Clause>();
        for (Clause clause : cnf.getCnf()) {
            Set<Var> clauseVars = clause.getVarsMentioned();
            if (opVars.containsAll(clauseVars)) {
                leftClauses.add(clause);
                continue;
            }
            nonPushable.add(clause);
        }
        RestrictionManagerImpl leftRm = new RestrictionManagerImpl(new NestedNormalForm(leftClauses));
        RestrictionManagerImpl np = new RestrictionManagerImpl(new NestedNormalForm(nonPushable));
        for (Map.Entry entry : cnf.getRestrictions().entrySet()) {
            Var var = (Var)entry.getKey();
            RestrictionImpl rest = (RestrictionImpl)entry.getValue();
            leftRm.stateRestriction(var, rest);
            np.stateRestriction(var, rest);
        }
        FilterSplit result = new FilterSplit(leftRm, np);
        return result;
    }

    public static Op handleLeftJoin(Op left, Op right, RestrictionManagerImpl cnf, Factory2<Op> factory) {
        FilterSplit filterSplit = FilterPlacementOptimizer2.splitFilter(left, cnf);
        RestrictionManagerImpl leftRm = filterSplit.getPushable();
        RestrictionManagerImpl np = filterSplit.getNonPushable();
        Op newLeft = FilterPlacementOptimizer2.optimize(left, leftRm);
        FilterSplit rsplit = FilterPlacementOptimizer2.splitFilter(right, leftRm);
        RestrictionManagerImpl rightRm = rsplit.getPushable();
        Op newRight = FilterPlacementOptimizer2.optimize(right, rightRm);
        Op leftJoin = factory.create(newLeft, newRight);
        Op result = FilterPlacementOptimizer2.surroundWithFilterIfNeccessary(leftJoin, np);
        return result;
    }

    public static Op handleLeftJoinOld(Op left, Op right, RestrictionManagerImpl cnf, Factory2<Op> factory) {
        Set<Var> rightVars = GetVarsMentioned.getVarsMentioned(right);
        HashSet<Clause> leftClauses = new HashSet<Clause>();
        HashSet<Clause> nonPushable = new HashSet<Clause>();
        for (Clause clause : cnf.getCnf()) {
            Set<Var> clauseVars = clause.getVarsMentioned();
            if (Sets.intersection(clauseVars, rightVars).isEmpty()) {
                leftClauses.add(clause);
                continue;
            }
            nonPushable.add(clause);
        }
        RestrictionManagerImpl leftRm = new RestrictionManagerImpl(new NestedNormalForm(leftClauses));
        RestrictionManagerImpl np = new RestrictionManagerImpl(new NestedNormalForm(nonPushable));
        Op newLeft = FilterPlacementOptimizer2.optimize(left, leftRm);
        Op newRight = FilterPlacementOptimizer2.optimize(right, leftRm);
        Op leftJoin = factory.create(newLeft, newRight);
        Op result = FilterPlacementOptimizer2.surroundWithFilterIfNeccessary(leftJoin, np);
        return result;
    }

    public static Op surroundWithFilterIfNeccessary(Op op, RestrictionManagerImpl cnf) {
        Object result = cnf.isUnsatisfiable() ? new OpFilterIndexed(op, new RestrictionManagerImpl(new NestedNormalForm(new HashSet<Clause>(Collections.singleton(new Clause(new HashSet<NodeValue>(Collections.singleton(NodeValue.FALSE)))))))) : (cnf.getCnf().isEmpty() ? op : new OpFilterIndexed(op, cnf));
        return result;
    }

    @Deprecated
    public static Op _optimize(OpRdfViewPattern op, RestrictionManagerImpl cnf) {
        return FilterPlacementOptimizer2.surroundWithFilterIfNeccessary((Op)op, cnf);
    }

    public static Op _optimize(OpViewInstanceJoin op, RestrictionManagerImpl cnf) {
        return FilterPlacementOptimizer2.surroundWithFilterIfNeccessary((Op)op, cnf);
    }

    public static Op _optimize(OpMapping op, RestrictionManagerImpl cnf) {
        return FilterPlacementOptimizer2.surroundWithFilterIfNeccessary((Op)op, cnf);
    }

    public static Op _optimize(OpSparqlViewPattern op, RestrictionManagerImpl cnf) {
        return FilterPlacementOptimizer2.surroundWithFilterIfNeccessary((Op)op, cnf);
    }
}

