/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.database.ClauseBase;
import org.aksw.sparqlify.restriction.RestrictionImpl;

public class Clause
extends ClauseBase {
    private Map<Var, RestrictionImpl> varToRestriction = new HashMap<Var, RestrictionImpl>();

    public Clause() {
        this(new HashSet<Expr>());
    }

    public Clause(Expr expr) {
        this(new HashSet<Expr>(Collections.singleton(expr)));
    }

    public Clause(Set<Expr> exprs) {
        super(exprs);
        for (Expr expr : exprs) {
            if (!(expr instanceof E_Equals)) continue;
            this.deriveRestrictionEquals((E_Equals)expr);
        }
    }

    private RestrictionImpl getOrCreateRestriction(Var var) {
        RestrictionImpl result = this.varToRestriction.get(var);
        if (result == null) {
            result = new RestrictionImpl();
            this.varToRestriction.put(var, result);
        }
        return result;
    }

    private void deriveRestrictionEquals(E_Equals expr) {
        if (!this.deriveRestrictionEquals(expr.getArg1(), expr.getArg2())) {
            this.deriveRestrictionEquals(expr.getArg2(), expr.getArg1());
        }
    }

    private boolean deriveRestrictionEquals(Expr a, Expr b) {
        if (a.isVariable() && b.isConstant()) {
            RestrictionImpl r = this.getOrCreateRestriction(a.asVar());
            r.stateNode(b.getConstant().asNode());
            return true;
        }
        return false;
    }

    public RestrictionImpl getRestriction(Var var) {
        return this.varToRestriction.get(var);
    }

    public Map<Var, RestrictionImpl> getRestrictions() {
        return this.varToRestriction;
    }
}

