/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.FunctionLabel;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aksw.commons.factory.Factory2;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.compile.sparql.Alignment;
import org.aksw.sparqlify.compile.sparql.SqlExprOptimizer;
import org.aksw.sparqlify.compile.sparql.SqlPrePusher;
import org.aksw.sparqlify.core.algorithms.ExprEvaluator;
import org.aksw.sparqlify.core.algorithms.ExprFactoryUtils;
import org.aksw.sparqlify.core.transformations.ExprEvaluatorPartial;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.DnfUtils;

public class SqlTranslationUtils {
    public static final Logger logger = LoggerFactory.getLogger(SqlTranslationUtils.class);
    public static final NodeValue TYPE_BLANK = NodeValue.makeInteger((long)0L);
    public static final NodeValue TYPE_URI = NodeValue.makeInteger((long)1L);
    public static final NodeValue TYPE_PLAIN_LITERAL = NodeValue.makeInteger((long)2L);
    public static final NodeValue TYPE_TYPED_LITERAL = NodeValue.makeInteger((long)3L);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expr getTypeOrExpr(Expr expr) {
        NodeValue result = null;
        if (expr.isConstant()) {
            Node node = expr.getConstant().getNode();
            if (node.isBlank()) {
                return TYPE_BLANK;
            }
            if (node.isURI()) {
                return TYPE_URI;
            }
            if (!node.isLiteral()) throw new RuntimeException("Unkown node type: " + expr);
            String datatype = node.getLiteral().getDatatypeURI();
            if (datatype == null) return TYPE_PLAIN_LITERAL;
            if (!datatype.trim().isEmpty()) return TYPE_TYPED_LITERAL;
            return TYPE_PLAIN_LITERAL;
        }
        if (!expr.isFunction()) return null;
        E_RdfTerm rdfTerm = SqlTranslationUtils.expandRdfTerm(expr.getFunction());
        if (rdfTerm == null) return result;
        return rdfTerm.getType();
    }

    public static Expr getLexicalValueOrExpr(Expr expr) {
        E_RdfTerm rdfTerm;
        Expr result = expr.isFunction() ? ((rdfTerm = SqlTranslationUtils.expandRdfTerm(expr.getFunction())) != null ? rdfTerm.getLexicalValue() : expr) : expr;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expr getDatatypeOrExpr(Expr expr) {
        Expr result = null;
        if (expr.isConstant()) {
            Node node = expr.getConstant().getNode();
            if (!node.isLiteral()) throw new RuntimeException("Should not happen");
            String datatype = node.getLiteralDatatypeURI();
            datatype = datatype == null ? "" : datatype;
            return NodeValue.makeString((String)datatype);
        }
        if (!expr.isFunction()) return null;
        E_RdfTerm rdfTerm = SqlTranslationUtils.expandRdfTerm(expr.getFunction());
        if (rdfTerm == null) return result;
        return rdfTerm.getDatatype();
    }

    public static Expr extractLanguageTag(Expr expr) {
        NodeValue result = null;
        if (expr.isConstant()) {
            Node node = expr.getConstant().getNode();
            if (node.isLiteral()) {
                String lang = node.getLiteralLanguage();
                lang = lang == null ? "" : lang;
                result = NodeValue.makeString((String)lang);
            } else {
                result = NodeValue.nvNothing;
            }
        } else if (expr.isFunction()) {
            E_RdfTerm rdfTerm = SqlTranslationUtils.expandRdfTerm(expr.getFunction());
            if (rdfTerm != null) {
                result = rdfTerm.getLanguageTag();
            }
        } else {
            result = null;
        }
        return result;
    }

    public static E_RdfTerm expandAnyToTerm(Expr expr) {
        E_RdfTerm result = expr.isConstant() ? SqlTranslationUtils.expandConstant(expr) : SqlTranslationUtils.expandRdfTerm(expr);
        return result;
    }

    public static E_RdfTerm expandRdfTerm(Expr expr) {
        E_RdfTerm result = null;
        if (expr.isFunction()) {
            result = SqlTranslationUtils.expandRdfTerm(expr.getFunction());
        }
        return result;
    }

    public static E_RdfTerm expandRdfTerm(ExprFunction expr) {
        if (expr instanceof E_RdfTerm) {
            return (E_RdfTerm)expr;
        }
        if ("http://aksw.org/sparqlify/rdfTerm".equals(expr.getFunctionIRI())) {
            if (expr.getArgs().size() != 4) {
                throw new RuntimeException("RdfTerm requires 4 arguments, instead got: " + expr);
            }
            return new E_RdfTerm(expr.getArg(1), expr.getArg(2), expr.getArg(3), expr.getArg(4));
        }
        if ("http://aksw.org/sparqlify/uri".equals(expr.getFunctionIRI())) {
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)1L), (Expr)expr.getArgs().get(0), (Expr)NodeValue.makeString((String)""), (Expr)NodeValue.makeString((String)""));
        }
        if ("http://aksw.org/sparqlify/plainLiteral".equals(expr.getFunctionIRI())) {
            Expr tmp;
            NodeValue lang = NodeValue.makeString((String)"");
            if (expr.getArgs().size() == 2 && (tmp = (Expr)expr.getArgs().get(1)) != null) {
                lang = tmp;
            }
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)2L), (Expr)expr.getArgs().get(0), (Expr)lang, (Expr)NodeValue.makeString((String)""));
        }
        if ("http://aksw.org/sparqlify/typedLiteral".equals(expr.getFunctionIRI())) {
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)3L), (Expr)expr.getArgs().get(0), (Expr)NodeValue.makeString((String)""), (Expr)expr.getArgs().get(1));
        }
        if ("http://aksw.org/sparqlify/blankNode".equals(expr.getFunctionIRI())) {
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)0L), (Expr)expr.getArgs().get(0), (Expr)NodeValue.makeString((String)""), (Expr)NodeValue.makeString((String)""));
        }
        return null;
    }

    public static E_RdfTerm expandConstant(Expr expr) {
        E_RdfTerm result = null;
        if (expr.isConstant()) {
            result = SqlTranslationUtils.expandConstant(expr.getConstant().asNode());
        }
        return result;
    }

    public static E_RdfTerm expandConstant(Node node) {
        int type;
        Object val = "";
        String lang = null;
        String dt = null;
        if (node.isBlank()) {
            type = 0;
            val = node.getBlankNodeId().getLabelString();
        } else if (node.isURI()) {
            type = 1;
            val = node.getURI();
        } else if (node.isLiteral()) {
            val = node.getLiteral().getValue();
            String datatype = node.getLiteralDatatypeURI();
            if (datatype == null || datatype.isEmpty()) {
                logger.warn("Treating plain literals as typed ones");
                type = 2;
                lang = node.getLiteralLanguage();
            } else {
                type = 3;
                dt = node.getLiteralDatatypeURI();
            }
        } else {
            throw new RuntimeException("Should not happen");
        }
        String dtStr = dt == null ? "" : dt;
        String langStr = lang == null ? "" : lang;
        return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)type), (Expr)NodeValue.makeNode((String)val.toString(), (String)lang, (String)dt), (Expr)NodeValue.makeString((String)langStr), (Expr)NodeValue.makeString((String)dtStr));
    }

    public static Expr optimizeRdfTerm(E_Equals expr) {
        E_Equals result = expr;
        Expr a = expr.getArg1();
        Expr b = expr.getArg2();
        if (a.isFunction() && b.isFunction()) {
            ExprFunction fa = a.getFunction();
            ExprFunction fb = b.getFunction();
            FunctionLabel la = fa.getFunctionSymbol();
            FunctionLabel lb = fb.getFunctionSymbol();
            if (fa.getArgs().size() == fb.getArgs().size() && la.equals((Object)lb)) {
                ArrayList<Expr> exprs = new ArrayList<Expr>();
                for (int i = 0; i < fa.getArgs().size(); ++i) {
                    Expr ea = (Expr)fa.getArgs().get(i);
                    Expr eb = (Expr)fb.getArgs().get(i);
                    exprs.add((Expr)new E_Equals(ea, eb));
                }
                result = ExprUtils.andifyBalanced(exprs);
            }
        }
        return result;
    }

    public static ExprList mergeConsecutiveConstants(Iterable<Expr> exprs) {
        String prev = null;
        ExprList newExprs = new ExprList();
        for (Expr expr : exprs) {
            if (expr.isConstant()) {
                prev = (prev == null ? "" : prev) + expr.getConstant().asString();
                continue;
            }
            if (prev != null) {
                newExprs.add((Expr)NodeValue.makeString(prev));
                prev = null;
            }
            newExprs.add(expr);
        }
        if (prev != null) {
            newExprs.add((Expr)NodeValue.makeString(prev));
        }
        return newExprs;
    }

    public static boolean isConcatExpr(Expr expr) {
        return expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive;
    }

    public static Expr optimizeOpConcat(ExprFunction fn) {
        if (fn instanceof ExprFunction2) {
            ExprFunction2 tmp = (ExprFunction2)fn;
            Expr result = SqlTranslationUtils.optimizeOpConcat(tmp);
            return result;
        }
        return fn;
    }

    public static Expr optimizeOpConcat(ExprFunction2 fn) {
        ExprFunction2 result;
        Expr tb;
        Expr ta = fn.getArg1();
        if (!SqlTranslationUtils.isOpConcatExpr(ta, tb = fn.getArg2())) {
            result = fn;
        } else {
            String fnId = ExprUtils.getFunctionId((ExprFunction)fn);
            if (fnId.equals("=")) {
                result = SqlTranslationUtils.optimizeEqualsConcat(ta, tb);
            } else {
                Factory2<Expr> exprFactory = ExprFactoryUtils.getFactory2(fnId);
                assert (exprFactory != null) : "No expr factory for " + fnId;
                result = SqlTranslationUtils.optimizeOpConcat(ta, tb, exprFactory);
            }
        }
        return result;
    }

    public static Expr optimizeEqualsConcat(Expr ta, Expr tb) {
        List<List<Expr>> ors = SqlTranslationUtils.splitEqualsConcat(ta, tb);
        Expr result = DnfUtils.toExpr(ors);
        return result;
    }

    public static Expr optimizeOpConcat(Expr ta, Expr tb, Factory2<Expr> exprFactory) {
        List<Expr> ors = SqlTranslationUtils.splitOpConcat(ta, tb, exprFactory);
        Expr result = ExprUtils.orifyBalanced(ors);
        return result;
    }

    public static boolean isOpConcatExpr(Expr ta, Expr tb) {
        return SqlTranslationUtils.isConcatExpr(ta) || SqlTranslationUtils.isConcatExpr(tb);
    }

    public static List<Expr> getOptimizedConcatArgs(Expr expr) {
        List args = SqlTranslationUtils.isConcatExpr(expr) ? expr.getFunction().getArgs() : Collections.singletonList(expr);
        List result = SqlTranslationUtils.mergeConsecutiveConstants(args).getList();
        return result;
    }

    public static List<List<Expr>> splitEqualsConcat(Expr ta, Expr tb) {
        List<Expr> la = SqlTranslationUtils.getOptimizedConcatArgs(ta);
        List<Expr> lb = SqlTranslationUtils.getOptimizedConcatArgs(tb);
        List<List<Expr>> result = SqlTranslationUtils.splitEqualsConcat(la, lb);
        return result;
    }

    public static List<Expr> splitOpConcat(Expr ta, Expr tb, Factory2<Expr> exprFactory) {
        List<Expr> la = SqlTranslationUtils.getOptimizedConcatArgs(ta);
        List<Expr> lb = SqlTranslationUtils.getOptimizedConcatArgs(tb);
        List<Expr> result = SqlTranslationUtils.splitOpConcat(la, lb, exprFactory);
        return result;
    }

    public static List<Expr> splitOpConcat(List<Expr> la, List<Expr> lb, Factory2<Expr> exprFactory) {
        List<Alignment> cs = SqlExprOptimizer.align(la, lb);
        ArrayList<Expr> ors = new ArrayList<Expr>();
        for (Alignment c : cs) {
            if (c.isSameSize()) {
                E_LogicalAnd headExpr = null;
                for (int i = 0; i < ((List)c.getKey()).size(); ++i) {
                    Expr ea = (Expr)((List)c.getKey()).get(i);
                    Expr eb = (Expr)((List)c.getValue()).get(i);
                    if (ea.isConstant() && ea.equals(eb)) continue;
                    Expr tmpExpr = exprFactory.create(ea, eb);
                    Object expr = headExpr == null ? tmpExpr : new E_LogicalAnd(headExpr, tmpExpr);
                    ors.add((Expr)expr);
                    E_Equals eq = new E_Equals(ea, eb);
                    headExpr = new E_LogicalAnd(headExpr, (Expr)eq);
                }
                continue;
            }
            ors.add((Expr)new E_Equals((Expr)new E_StrConcatPermissive(new ExprList((List)c.getKey())), (Expr)new E_StrConcatPermissive(new ExprList((List)c.getValue()))));
        }
        return ors;
    }

    public static List<List<Expr>> splitEqualsConcat(List<Expr> la, List<Expr> lb) {
        List<Alignment> cs = SqlExprOptimizer.align(la, lb);
        ArrayList<List<Expr>> ors = new ArrayList<List<Expr>>();
        for (Alignment c : cs) {
            ArrayList<E_Equals> ands = new ArrayList<E_Equals>();
            if (c.isSameSize()) {
                for (int i = 0; i < ((List)c.getKey()).size(); ++i) {
                    Expr ea = (Expr)((List)c.getKey()).get(i);
                    Expr eb = (Expr)((List)c.getValue()).get(i);
                    if (ea.isConstant() && ea.equals(eb)) continue;
                    E_Equals eq = new E_Equals(ea, eb);
                    ands.add(eq);
                }
            } else {
                ands.add(new E_Equals((Expr)new E_StrConcatPermissive(new ExprList((List)c.getKey())), (Expr)new E_StrConcatPermissive(new ExprList((List)c.getValue()))));
            }
            ors.add(ands);
        }
        return ors;
    }

    @Deprecated
    public static Expr optimizeEqualsConcatAlign(List<Expr> la, List<Expr> lb) {
        List<List<Expr>> ors = SqlTranslationUtils.splitEqualsConcat(la, lb);
        ArrayList<Expr> tmpOrs = new ArrayList<Expr>();
        for (List<Expr> ands : ors) {
            Expr and = ExprUtils.andifyBalanced(ands);
            tmpOrs.add(and);
        }
        if (ors.size() == 0) {
            return NodeValue.FALSE;
        }
        Expr result = ExprUtils.orifyBalanced(tmpOrs);
        return result;
    }

    public static Expr translate(E_LessThan expr) {
        return SqlTranslationUtils.translateCompare((ExprFunction2)expr);
    }

    public static Expr translate(E_LessThanOrEqual expr) {
        return SqlTranslationUtils.translateCompare((ExprFunction2)expr);
    }

    public static Expr translate(E_GreaterThan expr) {
        return SqlTranslationUtils.translateCompare((ExprFunction2)expr);
    }

    public static Expr translate(E_GreaterThanOrEqual expr) {
        return SqlTranslationUtils.translateCompare((ExprFunction2)expr);
    }

    public static Expr translateCompare(ExprFunction2 expr) {
        return SqlTranslationUtils.translateCompare(expr.getArg1(), expr.getArg2(), expr.getClass());
    }

    public static Expr translateCompare(Expr a, Expr b, final Class<?> clazz) {
        Factory2<Expr> factory = new Factory2<Expr>(){

            @Override
            public Expr create(Expr a, Expr b) {
                try {
                    Constructor<?> ctor = clazz.getConstructors()[0];
                    return (Expr)ctor.newInstance(a, b);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return SqlTranslationUtils.translateCompare(a, b, factory);
    }

    public static Expr translateCompare(Expr ea, Expr eb, Factory2<Expr> factory) {
        E_RdfTerm a = SqlPrePusher.asRdfTerm(ea);
        E_RdfTerm b = SqlPrePusher.asRdfTerm(eb);
        if (a == null || b == null) {
            logger.warn("Arguments are no ExprRdfTerms");
            return factory.create(ea, eb);
        }
        NodeValue zero = NodeValue.makeInteger((long)0L);
        NodeValue one = NodeValue.makeInteger((long)1L);
        NodeValue two = NodeValue.makeInteger((long)2L);
        NodeValue three = NodeValue.makeInteger((long)3L);
        Expr result = ExprUtils.andifyBalanced(factory.create(a.getLexicalValue(), b.getLexicalValue()));
        return result;
    }

    public static ExprEvaluator createDefaultEvaluator() {
        ExprEvaluatorPartial evaluator = new ExprEvaluatorPartial(FunctionRegistry.get());
        return evaluator;
    }
}

