/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatchDog
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WatchDog.class);
    private Statement stmt;
    private long timeOutInMillis;
    private long remaining;
    private boolean isCancelled = false;

    public WatchDog(Statement stmt, long timeOutInMillis) {
        this.stmt = stmt;
        this.timeOutInMillis = timeOutInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        long start = System.currentTimeMillis();
        do {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            this.remaining = this.timeOutInMillis - elapsed;
            try {
                WatchDog watchDog = this;
                synchronized (watchDog) {
                    if (this.remaining > 0L) {
                        this.wait(this.remaining);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!this.isCancelled && this.remaining > 0L);
        if (!this.isCancelled) {
            try {
                logger.error("Cancelling statement due to timeout");
                this.stmt.cancel();
                this.stmt.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void cancel() {
        this.isCancelled = true;
        this.notifyAll();
    }
}

