/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aksw.sparqlify.core.ResultSetSparqlify;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.sparql.IteratorResultSetSparqlifyBinding;

public class ResultSetFactory {
    public static ResultSetSparqlify create(Connection conn, Statement stmt, String sqlQuery, Multimap<Var, RestrictedExpr> sparqlVarMap, List<Var> projectionVars) throws SQLException {
        Object it;
        ArrayList<String> resultVars = new ArrayList<String>();
        if (projectionVars == null) {
            projectionVars = new ArrayList<Var>();
            for (Var var : sparqlVarMap.keySet()) {
                projectionVars.add(var);
            }
        }
        for (Var var : projectionVars) {
            resultVars.add(var.getName());
        }
        if (sqlQuery == null) {
            it = Iterators.emptyIterator();
        } else {
            ResultSet rs = stmt.executeQuery(sqlQuery);
            it = new IteratorResultSetSparqlifyBinding(conn, rs, sparqlVarMap);
        }
        ResultSetSparqlify result = new ResultSetSparqlify((Iterator<Binding>)it, resultVars, 0);
        return result;
    }
}

