/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.sparql.RowMapperSparqlifyCombined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class IteratorResultSetSparqlifyBinding
extends SinglePrefetchIterator<Binding> {
    private static final Logger logger = LoggerFactory.getLogger(IteratorResultSetSparqlifyBinding.class);
    private Connection conn;
    private ResultSet rs;
    private RowMapper<Binding> rowMapper;
    private long nextRowId;

    public IteratorResultSetSparqlifyBinding(Connection conn, ResultSet rs, Multimap<Var, RestrictedExpr> sparqlVarMap) {
        this(conn, rs, sparqlVarMap, 0L, null);
    }

    public IteratorResultSetSparqlifyBinding(Connection conn, ResultSet rs, Multimap<Var, RestrictedExpr> sparqlVarMap, long nextRowId, String rowIdName) {
        this(conn, rs, nextRowId, new RowMapperSparqlifyCombined(sparqlVarMap, rowIdName));
    }

    public IteratorResultSetSparqlifyBinding(Connection conn, ResultSet rs, long nextRowId, RowMapper<Binding> rowMapper) {
        this.conn = conn;
        this.rs = rs;
        this.nextRowId = nextRowId;
        this.rowMapper = rowMapper;
    }

    protected Binding prefetch() throws Exception {
        if (!this.rs.next()) {
            return (Binding)super.finish();
        }
        long rowId = this.nextRowId++;
        Binding result = (Binding)this.rowMapper.mapRow(this.rs, (int)rowId);
        return result;
    }

    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.conn != null) {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

