/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator;
import org.aksw.sparqlify.algebra.sql.exprs2.ExprSqlBridge;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Function;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprFunction;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.ExprSqlRewrite;
import org.aksw.sparqlify.core.cast.ExprHolder;
import org.aksw.sparqlify.core.cast.RewriteState;
import org.aksw.sparqlify.core.cast.SparqlFunctionProvider;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.cast.TypedExprTransformer;
import org.aksw.sparqlify.core.datatypes.SparqlFunction;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.aksw.sparqlify.trash.ExprCopy;
import org.aksw.sparqlify.type_system.CandidateMethod;
import org.aksw.sparqlify.type_system.FunctionModel;
import org.aksw.sparqlify.type_system.FunctionModelMeta;
import org.aksw.sparqlify.type_system.MethodEntry;
import org.aksw.sparqlify.type_system.MethodSignature;
import org.aksw.sparqlify.type_system.TypeSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedExprTransformerImpl
implements TypedExprTransformer {
    private static final Logger logger = LoggerFactory.getLogger(TypedExprTransformerImpl.class);
    private TypeSystem typeSystem;
    private SparqlFunctionProvider functionProvider;

    public TypedExprTransformerImpl(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
        this.functionProvider = typeSystem;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public static List<TypeToken> getTypes(Collection<SqlExpr> sqlExprs) {
        ArrayList<TypeToken> result = new ArrayList<TypeToken>(sqlExprs.size());
        for (SqlExpr sqlExpr : sqlExprs) {
            TypeToken typeName = sqlExpr.getDatatype();
            result.add(typeName);
        }
        return result;
    }

    public static boolean containsTypeError(Iterable<SqlExpr> exprs) {
        for (SqlExpr expr : exprs) {
            if (!S_Constant.TYPE_ERROR.equals(expr)) continue;
            return true;
        }
        return false;
    }

    public ExprVar allocateVariable(SqlExpr sqlExpr, RewriteState state) {
        String varName = state.getGenSym().next();
        Var var = Var.alloc((String)varName);
        ExprVar result = new ExprVar(var);
        state.getProjection().put(varName, sqlExpr);
        return result;
    }

    @Override
    public ExprSqlRewrite rewrite(Expr expr, Map<String, TypeToken> typeMap) {
        Expr resultExpr;
        RewriteState state;
        E_RdfTerm rdfTerm = expr.isConstant() ? SqlTranslationUtils.expandConstant(expr) : SqlTranslationUtils.expandRdfTerm(expr);
        ExprHolder rewrite = this.rewrite((ExprFunction)rdfTerm, typeMap, state = new RewriteState());
        if (rewrite.isSqlExpr()) {
            SqlExpr sqlExpr = rewrite.getSqlExpr();
            resultExpr = this.allocateVariable(sqlExpr, state);
        } else {
            resultExpr = rewrite.getExpr();
        }
        ExprSqlRewrite result = new ExprSqlRewrite(resultExpr, state.getProjection());
        return result;
    }

    public ExprSqlRewrite rewriteOld(Expr expr, Map<String, TypeToken> typeMap) {
        RewriteState state = new RewriteState();
        ExprHolder rewrite = this.rewrite(expr, typeMap, state);
        Object resultExpr = rewrite.isSqlExpr() ? new ExprSqlBridge(rewrite.getSqlExpr()) : rewrite.getExpr();
        ExprSqlRewrite result = new ExprSqlRewrite((Expr)resultExpr, state.getProjection());
        return result;
    }

    public ExprHolder rewrite(Expr expr, Map<String, TypeToken> typeMap, RewriteState state) {
        ExprHolder result;
        if (expr.isConstant()) {
            NodeValue nodeValue = expr.getConstant();
            SqlExpr sqlExpr = this.translate(nodeValue);
            result = new ExprHolder(sqlExpr);
        } else if (expr.isVariable()) {
            ExprVar var = expr.getExprVar();
            SqlExpr sqlExpr = this.translate(var, typeMap);
            result = new ExprHolder(sqlExpr);
        } else if (expr.isFunction()) {
            result = this.rewrite(expr.getFunction(), typeMap, state);
        } else {
            throw new RuntimeException("Should not happen: " + expr);
        }
        if (result.equals(TypeToken.TypeError)) {
            System.err.println("Got type error for " + expr);
        }
        return result;
    }

    public ExprHolder rewrite(ExprFunction fn, Map<String, TypeToken> typeMap, RewriteState state) {
        ExprHolder result;
        ArrayList<Expr> newArgs;
        String functionId = ExprUtils.getFunctionId(fn);
        logger.debug("Processing: " + fn);
        boolean pushConstants = true;
        if (fn instanceof E_RdfTerm) {
            // empty if block
        }
        ArrayList<Object> evaledArgs = new ArrayList<Object>();
        boolean isAllSqlExpr = true;
        for (Expr arg : fn.getArgs()) {
            ExprHolder evaledArg = arg.isConstant() && !pushConstants ? new ExprHolder(arg) : this.rewrite(arg, typeMap, state);
            isAllSqlExpr = isAllSqlExpr && evaledArg.isSqlExpr();
            evaledArgs.add(evaledArg);
        }
        boolean isFnRewritable = isAllSqlExpr;
        if (fn instanceof E_RdfTerm) {
            isFnRewritable = false;
        }
        if (!isFnRewritable) {
            newArgs = new ArrayList<Expr>(evaledArgs.size());
            for (ExprHolder exprHolder : evaledArgs) {
                Expr arg;
                if (exprHolder.isSqlExpr()) {
                    SqlExpr typedExpr = exprHolder.getSqlExpr();
                    arg = this.allocateVariable(typedExpr, state);
                } else {
                    arg = exprHolder.getExpr();
                }
                newArgs.add(arg);
            }
            Expr expr = ExprCopy.getInstance().copy(fn, newArgs);
            result = new ExprHolder(expr);
        } else {
            newArgs = new ArrayList(evaledArgs.size());
            for (ExprHolder exprHolder : evaledArgs) {
                SqlExpr sqlExpr = exprHolder.getSqlExpr();
                newArgs.add((Expr)sqlExpr);
            }
            SqlExpr sqlExpr = this.processFunction(functionId, newArgs);
            result = new ExprHolder(sqlExpr);
        }
        return result;
    }

    public SqlExpr processFunction(String functionId, List<SqlExpr> newArgs) {
        ArrayList<TypeToken> argTypes = new ArrayList<TypeToken>(newArgs.size());
        for (SqlExpr newArg : newArgs) {
            argTypes.add(newArg.getDatatype());
        }
        FunctionModel<TypeToken> functionModel = this.typeSystem.getSqlFunctionModel();
        Multimap<String, String> sparqlSqlDecls = this.typeSystem.getSparqlSqlDecls();
        CandidateMethod candidate = TypeSystemUtils.lookupSqlCandidate(functionModel, sparqlSqlDecls, (String)functionId, argTypes);
        SqlExpr result = null;
        if (candidate != null) {
            FunctionModelMeta sqlMetaModel = this.typeSystem.getSqlFunctionMetaModel();
            String opId = candidate.getMethod().getId();
            if (sqlMetaModel.getLogicalAnds().contains(opId)) {
                SqlExpr a = newArgs.get(0);
                SqlExpr b = newArgs.get(1);
                if (b.isConstant()) {
                    SqlExpr tmp = a;
                    a = b;
                    b = tmp;
                }
                if (a.isConstant() && a.asConstant().equals(S_Constant.TRUE)) {
                    result = b;
                }
            } else if (sqlMetaModel.getComparators().contains(opId)) {
                SqlExpr a = newArgs.get(0);
                SqlExpr b = newArgs.get(1);
                if (b.isConstant()) {
                    SqlExpr tmp = a;
                    a = b;
                    b = tmp;
                }
                if (a.isConstant() && b.isFunction()) {
                    String fnId = b.asFunction().getName();
                    String invId = (String)sqlMetaModel.getInverses().get(fnId);
                    if (invId != null) {
                        Map<String, SqlExprEvaluator> sqlImpls = this.typeSystem.getSqlImpls();
                        SqlExprEvaluator see = sqlImpls.get(invId);
                        SqlExpr c = b.getArgs().get(0);
                        if (see == null) {
                            throw new RuntimeException("Inverse " + invId + " of " + fnId + " declared, but no implementation provided");
                        }
                        SqlExpr d = see.eval(Collections.singletonList(a));
                        List<SqlExpr> aa = Arrays.asList(d, c);
                        result = this.processFunction(functionId, aa);
                    }
                } else if (a.isFunction() && b.isFunction()) {
                    String nameB;
                    SqlExprFunction fnA = a.asFunction();
                    SqlExprFunction fnB = b.asFunction();
                    String nameA = fnA.getName();
                    if (nameA.equals(nameB = fnB.getName())) {
                        List<SqlExpr> argsA = fnA.getArgs();
                        List<SqlExpr> argsB = fnB.getArgs();
                        ArrayList<SqlExpr> bb = new ArrayList<SqlExpr>(argsA.size() + argsB.size());
                        bb.addAll(argsA);
                        bb.addAll(argsB);
                        result = this.processFunction(functionId, bb);
                    }
                }
            }
            if (result == null) {
                result = TypedExprTransformerImpl.createSqlExpr((CandidateMethod<TypeToken>)candidate, newArgs);
            }
        } else {
            logger.info("Yielding type error because no signature found for: " + functionId + " with arguments " + argTypes);
            result = S_Constant.TYPE_ERROR;
        }
        return result;
    }

    public static SqlExpr createSqlExpr(CandidateMethod<TypeToken> candidate, SqlExpr ... args) {
        return TypedExprTransformerImpl.createSqlExpr(candidate, Arrays.asList(args));
    }

    public static SqlExpr createSqlExpr(CandidateMethod<TypeToken> candidate, List<SqlExpr> args) {
        List<SqlExpr> newArgs;
        MethodEntry method = candidate.getMethod();
        List coercions = candidate.getCoercions();
        if (coercions != null) {
            newArgs = new ArrayList<SqlExpr>(args.size());
            for (int i = 0; i < args.size(); ++i) {
                SqlExpr arg = args.get(i);
                CandidateMethod coercion = (CandidateMethod)coercions.get(i);
                SqlExpr newArg = coercion != null ? TypedExprTransformerImpl.createSqlExpr((CandidateMethod<TypeToken>)coercion, Collections.singletonList(arg)) : arg;
                newArgs.add(newArg);
            }
        } else {
            newArgs = args;
        }
        TypeToken returnType = (TypeToken)method.getSignature().getReturnType();
        String functionId = method.getId();
        S_Function result = S_Function.create(returnType, functionId, newArgs);
        return result;
    }

    public SqlExpr translate(ExprFunction fn, Map<String, TypeToken> typeMap) {
        TypeToken returnType;
        ArrayList<SqlExpr> evaledArgs = new ArrayList<SqlExpr>();
        logger.debug("Processing: " + fn);
        for (Expr arg : fn.getArgs()) {
            SqlExpr evaledArg = this.translate(arg, typeMap);
            evaledArgs.add(evaledArg);
        }
        String functionId = ExprUtils.getFunctionId(fn);
        SparqlFunction sparqlFunction = this.functionProvider.getSparqlFunction(functionId);
        if (sparqlFunction == null) {
            throw new RuntimeException("Sparql function not declared: " + functionId);
        }
        SqlExprEvaluator evaluator = sparqlFunction.getEvaluator();
        logger.debug("Evaluator for '" + functionId + "': " + evaluator);
        if (evaluator != null) {
            SqlExpr tmp = evaluator.eval(evaledArgs);
            if (tmp != null) {
                return tmp;
            }
            throw new RuntimeException("Evaluator yeld null value");
        }
        MethodSignature<TypeToken> signature = sparqlFunction.getSignature();
        if (signature != null && (returnType = (TypeToken)signature.getReturnType()) != null) {
            S_Function s_Function = S_Function.create(returnType, functionId, evaledArgs);
        }
        throw new RuntimeException("Neither evaluator nor signature found for " + fn);
    }

    public SqlExpr translate(NodeValue expr) {
        SqlValue sqlValue = this.typeSystem.convertSql(expr);
        S_Constant result = S_Constant.create(sqlValue);
        return result;
    }

    public SqlExpr translate(ExprVar expr, Map<String, TypeToken> typeMap) {
        TypeToken schematicType;
        String varName = expr.getVarName();
        TypeToken datatype = typeMap.get(varName);
        if (datatype == null) {
            throw new RuntimeException("No datatype found for " + varName);
        }
        IBiSetMultimap<TypeToken, TypeToken> ptm = this.typeSystem.getPhysicalTypeMap();
        Set schematicTypes = ptm.get((Object)datatype);
        if (schematicTypes.isEmpty()) {
            schematicType = datatype;
        } else {
            if (schematicTypes.size() > 1) {
                throw new RuntimeException("Multiple mappings for physical type " + datatype + ": " + schematicTypes);
            }
            schematicType = (TypeToken)schematicTypes.iterator().next();
        }
        S_ColumnRef result = new S_ColumnRef(schematicType, varName);
        return result;
    }

    @Override
    public SqlExpr translate(Expr expr, Map<String, TypeToken> typeMap) {
        if (expr == null) {
            throw new NullPointerException();
        }
        SqlExpr result = null;
        if (expr.isConstant()) {
            result = this.translate(expr.getConstant());
        } else if (expr.isFunction()) {
            ExprFunction fn = expr.getFunction();
            result = this.translate(fn, typeMap);
        } else if (expr.isVariable()) {
            result = this.translate(expr.getExprVar(), typeMap);
        } else {
            throw new RuntimeException("Unknown expression type encountered: " + expr);
        }
        return result;
    }
}

