/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.Date;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_ParseDate;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.DatatypeToStringPostgres;
import org.aksw.sparqlify.core.cast.SqlLiteralMapper;
import org.aksw.sparqlify.core.cast.SqlValue;

public class SqlLiteralMapperDefault
implements SqlLiteralMapper {
    private DatatypeToStringPostgres typeSerializer;

    @Deprecated
    public SqlLiteralMapperDefault(DatatypeToStringPostgres typeSerializer) {
        this.typeSerializer = typeSerializer;
    }

    @Override
    public String serialize(SqlValue value) {
        String result;
        Object o = value.getValue();
        if (o == null) {
            throw new RuntimeException("Null values should be handled by the serialize system, which can cast them to appropriate types");
        }
        String lex = o == null ? "NULL" : "" + o;
        TypeToken typeToken = value.getTypeToken();
        if (typeToken.equals(TypeToken.String)) {
            result = "'" + lex + "'::text";
        } else if (typeToken.equals(TypeToken.Date)) {
            Date date = (Date)o;
            lex = SqlExprEvaluator_ParseDate.defaultDateFormat.format(date);
            result = "'" + lex + "'::date";
        } else {
            result = typeToken.equals(TypeToken.DateTime) ? "'" + lex + "'::timestamp" : "" + lex;
        }
        return result;
    }

    public String serialize(NodeValue value) {
        Node node = value.asNode();
        String typeUri = node.getLiteralDatatypeURI();
        String lex = node.getLiteralLexicalForm();
        String result = typeUri == null || typeUri.equals(TypeToken.String.toString()) ? "'" + lex + "'" : "" + lex;
        return result;
    }
}

