/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprConstant;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.SqlExprUtils;

public class ExprSqlRewrite {
    private Expr expr;
    private Projection projection;

    public ExprSqlRewrite(Expr expr, Projection projection) {
        this.expr = expr;
        this.projection = projection;
    }

    public E_RdfTerm getRdfTermExpr() {
        return (E_RdfTerm)this.expr;
    }

    public E_RdfTerm asConstRdfTerm() {
        E_RdfTerm tmp = this.getRdfTermExpr();
        List args = tmp.getArgs();
        ArrayList<Expr> newArgs = new ArrayList<Expr>(4);
        for (int i = 0; i < args.size(); ++i) {
            Expr arg;
            Expr subst = arg = (Expr)args.get(i);
            if (arg.isVariable()) {
                String varName = arg.getVarName();
                SqlExpr sqlExpr = this.projection.getNameToExpr().get(varName);
                if (sqlExpr.isConstant()) {
                    SqlExprConstant con = sqlExpr.asConstant();
                    if (i == 0) {
                        int type = (Integer)con.getValue().getValue();
                        subst = NodeValue.makeInteger((long)type);
                    } else if (con.getDatatype().equals(TypeToken.String)) {
                        String str = (String)con.getValue().getValue();
                        subst = NodeValue.makeString((String)str);
                    }
                }
            }
            newArgs.add(subst);
        }
        E_RdfTerm result = new E_RdfTerm(newArgs);
        return result;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Set<S_ColumnRef> getInvolvedColumns() {
        HashSet<S_ColumnRef> result = new HashSet<S_ColumnRef>();
        Collection<SqlExpr> exprs = this.projection.getNameToExpr().values();
        for (SqlExpr expr : exprs) {
            SqlExprUtils.collectColumnReferences(expr, result);
        }
        return result;
    }

    public List<SqlExpr> getSqlExprs() {
        ArrayList<SqlExpr> result = new ArrayList<SqlExpr>(4);
        for (int i = 0; i < 4; ++i) {
            SqlExpr sqlExpr = this.getSqlExpr(i);
            result.add(sqlExpr);
        }
        return result;
    }

    public SqlExpr getSqlExpr(int index) {
        E_RdfTerm rdfTerm = this.getRdfTermExpr();
        Expr expr = rdfTerm.getArg(index + 1);
        String varName = expr.getVarName();
        Map<String, SqlExpr> map = this.projection.getNameToExpr();
        SqlExpr result = map.get(varName);
        return result;
    }

    public List<String> getReferencedColumnNames() {
        Set vars = this.expr.getVarsMentioned();
        ArrayList<String> result = new ArrayList<String>(vars.size());
        for (Var var : vars) {
            result.add(var.getVarName());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.projection == null ? 0 : this.projection.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExprSqlRewrite other = (ExprSqlRewrite)obj;
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return !(this.projection == null ? other.projection != null : !this.projection.equals(other.projection));
    }

    public String toString() {
        return "ExprSqlRewrite [expr=" + this.expr + ", projection=" + this.projection + "]";
    }
}

