/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpEmpty;
import org.aksw.sparqlify.core.OpQuadPattern2;
import org.aksw.sparqlify.core.algorithms.CandidateViewSelectorBase;
import org.aksw.sparqlify.core.algorithms.OpMapping;
import org.aksw.sparqlify.core.algorithms.OpViewInstanceJoin;
import org.aksw.sparqlify.core.algorithms.RecursionResult;
import org.aksw.sparqlify.core.algorithms.SelfJoinEliminator;
import org.aksw.sparqlify.core.algorithms.UnsatisfiabilityException;
import org.aksw.sparqlify.core.algorithms.VarBinding;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizer;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizerImpl;
import org.aksw.sparqlify.core.algorithms.ViewInstance;
import org.aksw.sparqlify.core.algorithms.ViewInstanceJoin;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.MappingOps;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.aksw.sparqlify.views.transform.GetVarsMentioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateViewSelectorImpl
extends CandidateViewSelectorBase<ViewDefinition, Mapping> {
    private static final Logger logger = LoggerFactory.getLogger(CandidateViewSelectorImpl.class);
    private MappingOps mappingOps;
    private ViewDefinitionNormalizer<ViewDefinition> viewDefinitionNormalizer;
    public static Generator emptyViewNameGenerator = Gensym.create((String)"emptyView");

    public CandidateViewSelectorImpl() {
        this(null);
        logger.warn("No mappingOps provided. This means that view candidates cannot be pruned efficently which is most likely not what you want!!!");
    }

    public CandidateViewSelectorImpl(MappingOps mappingOps) {
        this(mappingOps, new ViewDefinitionNormalizerImpl());
    }

    public CandidateViewSelectorImpl(MappingOps mappingOps, ViewDefinitionNormalizer<ViewDefinition> viewDefinitionNormalizer) {
        this.viewDefinitionNormalizer = viewDefinitionNormalizer;
        this.mappingOps = mappingOps;
    }

    @Override
    public ViewDefinition normalizeView(ViewDefinition view) {
        ViewDefinition normalized = this.viewDefinitionNormalizer.normalize(view);
        logger.trace("Normalized view:\n" + normalized);
        return normalized;
    }

    @Override
    public Mapping createContext(Mapping baseMapping, ViewInstance<ViewDefinition> viewInstance) throws UnsatisfiabilityException {
        Mapping nextMapping = null;
        boolean enablePruningMappingRewrite = true;
        if (enablePruningMappingRewrite && this.mappingOps != null) {
            Mapping mapping = this.mappingOps.createMapping(viewInstance);
            nextMapping = baseMapping == null ? mapping : this.mappingOps.join(baseMapping, mapping);
            if (nextMapping.isEmpty()) {
                throw new UnsatisfiabilityException();
            }
        }
        return nextMapping;
    }

    @Override
    public Op createOp(OpQuadPattern2 opQuadPattern, List<RecursionResult<ViewDefinition, Mapping>> conjunctions) {
        OpDisjunction result = OpDisjunction.create();
        for (RecursionResult<ViewDefinition, Mapping> entry : conjunctions) {
            Mapping mapping = entry.getFinalContext();
            RestrictionManagerImpl restrictions = entry.getViewInstances().getRestrictions();
            OpMapping tmp = new OpMapping(mapping, restrictions);
            result.add((Op)tmp);
        }
        if (result.size() == 0) {
            Op tmp = CandidateViewSelectorImpl.createEmptyViewInstance(opQuadPattern);
            result.add(tmp);
        }
        return result;
    }

    public Op createOpOldButWorking(OpQuadPattern2 opQuadPattern, List<RecursionResult<ViewDefinition, Mapping>> conjunctions) {
        for (RecursionResult<ViewDefinition, Mapping> recursionResult : conjunctions) {
            ViewInstanceJoin<ViewDefinition> viewInstanceJoin = recursionResult.getViewInstances();
            SelfJoinEliminator.merge(viewInstanceJoin);
        }
        OpDisjunction result = OpDisjunction.create();
        for (RecursionResult<ViewDefinition, Mapping> recursionResult : conjunctions) {
            ViewInstanceJoin<ViewDefinition> item = recursionResult.getViewInstances();
            OpViewInstanceJoin<ViewDefinition> tmp = new OpViewInstanceJoin<ViewDefinition>(item);
            result.add(tmp);
        }
        if (result.size() == 0) {
            Op op = CandidateViewSelectorImpl.createEmptyViewInstance(opQuadPattern);
            result.add(op);
        }
        return result;
    }

    public static Op createEmptyViewInstance(OpQuadPattern2 opQuadPattern) {
        Set<Var> vars = GetVarsMentioned.getVarsMentioned((Op)opQuadPattern);
        VarBinding binding = new VarBinding();
        HashMultimap varDefMap = HashMultimap.create();
        String colName = "nll";
        SqlOpEmpty sqlOpEmpty = SqlOpEmpty.create(colName);
        Iterator<Var> iterator = vars.iterator();
        while (iterator.hasNext()) {
            Var queryVar;
            Var viewVar = queryVar = iterator.next();
            binding.put(queryVar, viewVar);
            ExprVar colVar = new ExprVar(colName);
            E_RdfTerm termCtor = E_RdfTerm.createPlainLiteral((Expr)colVar);
            varDefMap.put((Object)viewVar, (Object)new RestrictedExpr((Expr)termCtor));
        }
        VarDefinition varDef = new VarDefinition((Multimap<Var, RestrictedExpr>)varDefMap);
        Mapping mapping = new Mapping(varDef, sqlOpEmpty);
        String viewName = emptyViewNameGenerator.next();
        ViewDefinition viewDef = new ViewDefinition(viewName, new QuadPattern(), null, mapping, null);
        ViewInstance<ViewDefinition> viewInstance = new ViewInstance<ViewDefinition>(viewDef, binding);
        ArrayList tmp = new ArrayList();
        tmp.add(viewInstance);
        ViewInstanceJoin join = new ViewInstanceJoin(tmp, new RestrictionManagerImpl());
        OpViewInstanceJoin result = new OpViewInstanceJoin(join);
        return result;
    }
}

