/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import java.util.HashMap;
import java.util.Map;

public class TypeToken {
    private static final Map<String, TypeToken> cache = new HashMap<String, TypeToken>();
    public static final TypeToken Object = TypeToken.alloc("object");
    public static final TypeToken Numeric = TypeToken.alloc("numeric");
    public static final TypeToken Byte = TypeToken.alloc("byte");
    public static final TypeToken Boolean = TypeToken.alloc("boolean");
    public static final TypeToken Int = TypeToken.alloc("integer");
    public static final TypeToken Long = TypeToken.alloc("long");
    public static final TypeToken Float = TypeToken.alloc("float");
    public static final TypeToken Double = TypeToken.alloc("double");
    public static final TypeToken String = TypeToken.alloc("string");
    public static final TypeToken Date = TypeToken.alloc("date");
    public static final TypeToken DateTime = TypeToken.alloc("dateTime");
    public static final TypeToken TypeError = TypeToken.alloc("type_error");
    public static final TypeToken Special = TypeToken.alloc("special");
    public static final TypeToken Geometry = TypeToken.alloc("geometry");
    @Deprecated
    public static final TypeToken rdfTerm = TypeToken.alloc("rdfTerm");
    private String name;

    public static TypeToken alloc(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        TypeToken result = cache.get(name);
        if (result == null) {
            result = new TypeToken(name);
            cache.put(name, result);
        }
        return result;
    }

    public TypeToken(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeToken other = (TypeToken)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

