/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class RegexUtils {
    public static final Set<Character> specialChars = new HashSet<Character>(Arrays.asList(Character.valueOf('.'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('&'), Character.valueOf(':'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('^'), Character.valueOf('$')));

    public static boolean isSpecialChar(char c) {
        return specialChars.contains(Character.valueOf(c));
    }

    public static String escape(String str) {
        return RegexUtils.genericEscape(str, specialChars, Character.valueOf('\\'));
    }

    public static String genericEscape(String str, Set<Character> specialChars, Character escapeChar) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (specialChars.contains(Character.valueOf(c))) {
                result.append(escapeChar);
            }
            result.append(c);
        }
        return result.toString();
    }
}

