/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.config.v0_2.bridge;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpLeaf;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpTable;
import org.aksw.sparqlify.config.lang.Constraint;
import org.aksw.sparqlify.config.lang.PrefixConstraint;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.config.v0_2.bridge.ExprTransformerUtils;
import org.aksw.sparqlify.config.v0_2.bridge.SchemaProvider;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionSetImpl;
import org.aksw.sparqlify.validation.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxBridge {
    private static final Logger logger = LoggerFactory.getLogger(SyntaxBridge.class);
    private SchemaProvider schemaProvider;

    public SyntaxBridge(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    public SchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    public static String normalizeQueryString(String queryString) {
        Pattern pattern = Pattern.compile("(\\s|;)+$", 8);
        String result = pattern.matcher(queryString).replaceAll("");
        return result;
    }

    public ViewDefinition create(org.aksw.sparqlify.config.syntax.ViewDefinition viewDefinition) {
        String name = viewDefinition.getName();
        QuadPattern template = new QuadPattern();
        for (Quad quad : viewDefinition.getConstructPattern().getList()) {
            template.add(quad);
        }
        VarExprList varExprList = viewDefinition.getViewTemplateDefinition().getVarExprList();
        List<Constraint> constraints = viewDefinition.getConstraints();
        HashMap<Var, PrefixConstraint> varToPrefixConstraint = new HashMap<Var, PrefixConstraint>();
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                if (constraint instanceof PrefixConstraint) {
                    PrefixConstraint prefixConstraint = (PrefixConstraint)constraint;
                    varToPrefixConstraint.put(prefixConstraint.getVar(), prefixConstraint);
                    continue;
                }
                logger.warn("Unknown constraint type: " + constraint.getClass() + " - " + constraint);
            }
        }
        HashMultimap varDefs = HashMultimap.create();
        for (Map.Entry entry : varExprList.getExprs().entrySet()) {
            Var var = (Var)entry.getKey();
            Expr expr = (Expr)entry.getValue();
            RestrictionSetImpl rs = null;
            PrefixConstraint c = (PrefixConstraint)varToPrefixConstraint.get(var);
            if (c != null) {
                PrefixSet ps = c.getPrefixes();
                RestrictionImpl r = new RestrictionImpl(ps);
                rs = new RestrictionSetImpl(r);
            }
            RestrictedExpr rexpr = new RestrictedExpr(expr, rs);
            varDefs.put((Object)var, (Object)rexpr);
        }
        VarDefinition varDefinition = new VarDefinition((Multimap<Var, RestrictedExpr>)varDefs);
        varDefinition.applyExprTransform(ExprTransformerUtils.injectStrsIntoConcats);
        varDefinition.applyExprTransform(ExprTransformerUtils.expandRdfTerms);
        SqlOp sqlOp = viewDefinition.getRelation();
        SqlOpLeaf sqlOp2 = null;
        if (sqlOp == null) {
            logger.warn("No relation given for view '" + name + "', using Select 1");
            Schema schema = this.schemaProvider.createSchemaForQueryString("SELECT 1");
            sqlOp2 = new SqlOpQuery(schema, "SELECT 1");
        } else if (sqlOp instanceof SqlOpQuery) {
            String rawQueryString = ((SqlOpQuery)sqlOp).getQueryString();
            String queryString = SyntaxBridge.normalizeQueryString(rawQueryString);
            Schema schema = this.schemaProvider.createSchemaForQueryString(queryString);
            sqlOp2 = new SqlOpQuery(schema, queryString);
        } else if (sqlOp instanceof SqlOpTable) {
            String relationName = ((SqlOpTable)sqlOp).getTableName();
            Schema schema = this.schemaProvider.createSchemaForRelationName(relationName);
            sqlOp2 = new SqlOpTable(schema, relationName);
        } else {
            throw new RuntimeException("Unsupported relation type: " + sqlOp);
        }
        Mapping mapping = new Mapping(varDefinition, sqlOp2);
        ViewDefinition result = new ViewDefinition(name, template, null, mapping, viewDefinition);
        return result;
    }

    public static List<ViewDefinition> bridge(SyntaxBridge bridge, Collection<org.aksw.sparqlify.config.syntax.ViewDefinition> viewDefinitions, Logger logger) {
        ArrayList<ViewDefinition> result = new ArrayList<ViewDefinition>();
        for (org.aksw.sparqlify.config.syntax.ViewDefinition item : viewDefinitions) {
            ViewDefinition virtualGraph = bridge.create(item);
            if (logger != null) {
                Validation.validateView(virtualGraph, logger);
            }
            result.add(virtualGraph);
        }
        return result;
    }
}

