/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.config.syntax;

import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.syntax.Template;
import java.util.ArrayList;
import java.util.List;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;

public class ViewTemplateDefinition {
    private QuadPattern constructTemplate;
    private List<Expr> varBindings;

    public ViewTemplateDefinition() {
        this.constructTemplate = new QuadPattern();
        this.varBindings = new ArrayList<Expr>();
    }

    public ViewTemplateDefinition(Template template, List<Expr> varBindings) {
        this.constructTemplate = QuadPatternUtils.toQuadPattern((BasicPattern)template.getBGP());
        this.varBindings = varBindings;
    }

    public ViewTemplateDefinition(QuadPattern constructTemplate, List<Expr> varBindings) {
        this.constructTemplate = constructTemplate;
        this.varBindings = varBindings == null ? new ArrayList() : varBindings;
    }

    public QuadPattern getConstructTemplate() {
        return this.constructTemplate;
    }

    public void setConstructTemplate(QuadPattern constructTemplate) {
        this.constructTemplate = constructTemplate;
    }

    public List<Expr> getVarBindings() {
        return this.varBindings;
    }

    public VarExprList getVarExprList() {
        VarExprList result = new VarExprList();
        for (Expr item : this.getVarBindings()) {
            E_Equals e = (E_Equals)item;
            Expr left = e.getArg1();
            if (!left.isVariable()) {
                throw new RuntimeException("Variable expected, instead got: " + left);
            }
            Var var = left.asVar();
            Expr expr = e.getArg2();
            Expr previousValue = result.getExpr(var);
            if (previousValue != null) {
                throw new RuntimeException("Redefinition of variable " + var + " in view '" + "no name" + "' with: " + expr + ", was: " + previousValue);
            }
            result.add(var, expr);
        }
        return result;
    }

    public void setVarBindings(List<Expr> varBindings) {
        this.varBindings = varBindings;
    }

    public String toString() {
        return "ViewTemplateDefinition [constructTemplate=" + this.constructTemplate + ", varBindings=" + this.varBindings + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructTemplate == null ? 0 : this.constructTemplate.hashCode());
        result = 31 * result + (this.varBindings == null ? 0 : this.varBindings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewTemplateDefinition other = (ViewTemplateDefinition)obj;
        if (this.constructTemplate == null ? other.constructTemplate != null : !this.constructTemplate.equals((Object)other.constructTemplate)) {
            return false;
        }
        return !(this.varBindings == null ? other.varBindings != null : !this.varBindings.equals(other.varBindings));
    }
}

