/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.batch;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aksw.commons.util.MapReader;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.sparqlify.batch.TaskletFactoryDump;
import org.aksw.sparqlify.config.lang.ConfigParser;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.config.v0_2.bridge.SyntaxBridge;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.algorithms.SqlOpSelectBlockCollectorImpl;
import org.aksw.sparqlify.core.algorithms.SqlOpSerializerImpl;
import org.aksw.sparqlify.core.cast.SqlExprSerializerSystem;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.util.SparqlifyCoreInit;
import org.aksw.sparqlify.util.SparqlifyUtils;
import org.aksw.sparqlify.validation.LoggerCount;
import org.aksw.sparqlify.web.SparqlifyCliHelper;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.h2.jdbcx.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.transaction.PlatformTransactionManager;

public class MasterDumper {
    private static final Logger logger = LoggerFactory.getLogger(MasterDumper.class);
    private static final Options cliOptions = new Options();

    public void createTasks(InputStream inSpec) throws IOException, RecognitionException {
        Logger loggerCount = null;
        SyntaxBridge bridge = null;
        ConfigParser parser = new ConfigParser();
        Config config = parser.parse(inSpec, loggerCount);
        List<ViewDefinition> viewDefinitions = SyntaxBridge.bridge(bridge, config.getViewDefinitions(), loggerCount);
        for (ViewDefinition viewDefinition : viewDefinitions) {
            String string = viewDefinition.getName();
        }
    }

    public static DataSource createJobDataSource(String name) {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:file:" + name + ";MODE=PostgreSQL;DB_CLOSE_DELAY=-1");
        ds.setUser("sa");
        ds.setPassword("sa");
        return ds;
    }

    public static void populateSpringBatchH2(DataSource dataSource) throws SQLException {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(true);
        populator.addScript((Resource)new ClassPathResource("org/springframework/batch/core/schema-h2.sql"));
        try (Connection conn = dataSource.getConnection();){
            populator.populate(conn);
        }
    }

    public static void main(String[] args) throws Exception {
        RdfViewSystemOld.initSparqlifyFunctions();
        LoggerCount loggerCount = new LoggerCount(logger);
        Class.forName("org.postgresql.Driver");
        GnuParser cliParser = new GnuParser();
        cliOptions.addOption("t", "type", true, "Database type (posgres, mysql,...)");
        cliOptions.addOption("d", "database", true, "Database name");
        cliOptions.addOption("u", "username", true, "");
        cliOptions.addOption("p", "password", true, "");
        cliOptions.addOption("h", "hostname", true, "");
        cliOptions.addOption("c", "class", true, "JDBC driver class");
        cliOptions.addOption("j", "jdbcurl", true, "JDBC URL");
        cliOptions.addOption("m", "mapping", true, "Sparqlify mapping file");
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        DataSource userDataSource = SparqlifyCliHelper.parseDataSource(commandLine, (Logger)loggerCount);
        Config config = SparqlifyCliHelper.parseSmlConfig(commandLine, (Logger)loggerCount);
        SparqlifyCliHelper.onErrorPrintHelpAndExit(cliOptions, loggerCount, -1);
        TypeSystem typeSystem = SparqlifyCoreInit.createDefaultDatatypeSystem();
        SqlExprSerializerSystem serializerSystem = SparqlifyUtils.createSerializerSystem(typeSystem);
        SqlOpSelectBlockCollectorImpl sqlOpSelectBlockCollector = new SqlOpSelectBlockCollectorImpl();
        SqlOpSerializerImpl sqlOpSerializer = new SqlOpSerializerImpl(serializerSystem);
        Map typeAlias = MapReader.readFromResource((String)"/type-map.h2.tsv");
        List<ViewDefinition> viewDefinitions = SparqlifyCliHelper.extractViewDefinitions(config.getViewDefinitions(), userDataSource, typeSystem, typeAlias, (Logger)loggerCount);
        SparqlifyCliHelper.onErrorPrintHelpAndExit(cliOptions, loggerCount, -1);
        DataSource jobDataSource = MasterDumper.createJobDataSource("sparqlify-dump");
        MasterDumper.populateSpringBatchH2(jobDataSource);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(userDataSource);
        JobRepositoryFactoryBean jobRepositoryFactory = new JobRepositoryFactoryBean();
        jobRepositoryFactory.setDatabaseType("h2");
        jobRepositoryFactory.setTransactionManager((PlatformTransactionManager)transactionManager);
        jobRepositoryFactory.setDataSource(jobDataSource);
        jobRepositoryFactory.afterPropertiesSet();
        JobRepository jobRepository = jobRepositoryFactory.getJobRepository();
        String outBaseDir = "/tmp/";
        TaskletFactoryDump taskletFactory = new TaskletFactoryDump(userDataSource, sqlOpSelectBlockCollector, sqlOpSerializer, outBaseDir, viewDefinitions);
        SimpleJob job = new SimpleJob("test");
        job.setJobRepository(jobRepository);
        for (ViewDefinition viewDefinition : viewDefinitions) {
            String baseName = StringUtils.urlEncode((String)viewDefinition.getName());
            String taskletName = "dump-" + baseName;
            loggerCount.info("Processing view [" + viewDefinition.getName() + "]");
            Tasklet tasklet = taskletFactory.createTasklet(viewDefinition);
            TaskletStep taskletStep = new TaskletStep();
            taskletStep.setName(taskletName);
            taskletStep.setJobRepository(jobRepository);
            taskletStep.setTransactionManager((PlatformTransactionManager)transactionManager);
            taskletStep.setTasklet(tasklet);
            taskletStep.afterPropertiesSet();
            job.addStep((Step)taskletStep);
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        JobParameters jobParameters = jobParametersBuilder.toJobParameters();
        job.afterPropertiesSet();
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(jobRepository);
        jobLauncher.afterPropertiesSet();
        JobExecution execution = jobLauncher.run((Job)job, jobParameters);
        logger.info("Exit Status : " + execution.getStatus());
    }
}

