/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.automapper;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.jdbc.Column;
import org.aksw.commons.util.jdbc.ColumnsReference;
import org.aksw.commons.util.jdbc.ForeignKey;
import org.aksw.commons.util.jdbc.JdbcUtils;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Relation;
import org.aksw.commons.util.jdbc.Schema;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.algebra.sql.nodes.VarDef;
import org.aksw.sparqlify.config.syntax.ViewDefinition;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.core.SqlDatatype;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoMapper {
    public static final Logger logger = LoggerFactory.getLogger(AutoMapper.class);

    public static String getBlockKey(String key) {
        return key.replace("_", "").toLowerCase();
    }

    public static List<Column> getNonKeyColumns(Relation relation, PrimaryKey primaryKey, Collection<ForeignKey> fks) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : relation.getColumns().values()) {
            String name = column.getName();
            if (primaryKey != null && primaryKey.getSource().getColumnNames().contains(name)) continue;
            for (ForeignKey fk : fks) {
                if (!fk.getSource().getColumnNames().contains(name)) continue;
            }
            result.add(column);
        }
        return result;
    }

    public static VarDef columnReferenceToUriTermDef(String prefix, ColumnsReference columnsReference) {
        return new VarDef(AutoMapper.columnReferenceToUriExpr(prefix, columnsReference));
    }

    public static Expr columnReferenceToUriExpr(String prefix, ColumnsReference columnsReference) {
        return E_RdfTerm.createUri(AutoMapper.columnReferenceToExpr(prefix, columnsReference));
    }

    public static Expr columnReferenceToExpr(String prefix, ColumnsReference columnsReference) {
        ExprList exprs = new ExprList();
        prefix = prefix + columnsReference.getTableName();
        NodeValue prefixExpr = NodeValue.makeString((String)prefix);
        exprs.add((Expr)prefixExpr);
        List columnNames = columnsReference.getColumnNames();
        for (int i = 0; i < columnNames.size(); ++i) {
            if (i != 0) {
                exprs.add((Expr)NodeValue.makeString((String)"-"));
            }
            exprs.add((Expr)new ExprVar((String)columnNames.get(i)));
        }
        E_StrConcatPermissive result = new E_StrConcatPermissive(exprs);
        return result;
    }

    public static void main(String[] args) throws SQLException {
        AutoMapper mapper = new AutoMapper();
        DatatypeSystemDefault system = new DatatypeSystemDefault();
        HashMap<String, SqlDatatype> datatypeMap = new HashMap<String, SqlDatatype>();
        datatypeMap.put("int4", DatatypeSystemDefault._INT);
        datatypeMap.put("varchar", DatatypeSystemDefault._STRING);
        datatypeMap.put("bpchar", DatatypeSystemDefault._STRING);
        datatypeMap.put("text", DatatypeSystemDefault._STRING);
        datatypeMap.put("date", DatatypeSystemDefault._DATE);
        datatypeMap.put("float8", DatatypeSystemDefault._FLOAT);
        datatypeMap.put("timestamp", DatatypeSystemDefault._DATE_TIME);
        Schema schema = Schema.create((Connection)AutoMapper.getConnection());
        Set relationNames = JdbcUtils.fetchRelationNames((Connection)AutoMapper.getConnection());
        System.out.println(relationNames);
        Map relations = JdbcUtils.fetchColumns((Connection)AutoMapper.getConnection());
        Multimap foreignKeys = schema.getForeignKeys();
        System.out.println(foreignKeys);
        Map primaryKeys = schema.getPrimaryKeys();
        System.out.println(primaryKeys);
        Gensym genFk = Gensym.create((String)"fk_autogen");
        for (Relation relation : relations.values()) {
            Collection fks = foreignKeys.get((Object)relation.getName());
            if (!fks.isEmpty()) continue;
            for (Column column : relation.getColumns().values()) {
                PrimaryKey pk;
                Relation r = (Relation)relations.get(column.getName());
                if (r == null || (pk = (PrimaryKey)primaryKeys.get(r.getName())) == null) continue;
                ColumnsReference source = new ColumnsReference(relation.getName(), new String[0]);
                source.getColumnNames().add(column.getName());
                String fkName = genFk.next();
                ForeignKey fk = new ForeignKey(fkName, source, pk.getSource());
                foreignKeys.put((Object)relation.getName(), (Object)fk);
                System.out.println("Auto FK: " + fk);
            }
        }
        String prefix = "http://localhost/am/";
        for (Relation relation : relations.values()) {
            ViewDefinition viewDefinition = new ViewDefinition();
            viewDefinition.setName("view_" + relation.getName());
            Gensym genFkTargetVar = Gensym.create((String)"fk");
            Gensym genColumnVar = Gensym.create((String)"o");
            if (!relationNames.contains(relation.getName())) continue;
            PrimaryKey primaryKey = (PrimaryKey)primaryKeys.get(relation.getName());
            if (primaryKey == null) {
                logger.warn(relation.getName() + ": No primary key found. Skipping.");
                continue;
            }
            Set<ForeignKey> fks = foreignKeys.get((Object)relation.getName());
            if (fks == null) {
                fks = Collections.emptySet();
            }
            Var mainVar = Var.alloc((String)"s");
            VarDef mainVarDef = AutoMapper.columnReferenceToUriTermDef(prefix, primaryKey.getSource());
            viewDefinition.addVarDef(mainVar, mainVarDef);
            Node classUri = Node.createURI((String)(prefix + StringUtils.toUpperCamelCase((String)relation.getName())));
            viewDefinition.getConstructPattern().add(new Quad(null, new Triple((Node)mainVar, RDF.type.asNode(), classUri)));
            for (ForeignKey fk : fks) {
                Var targetVar = Var.alloc((String)genFkTargetVar.next());
                VarDef targetVarDef = AutoMapper.columnReferenceToUriTermDef(prefix, fk.getSource());
                viewDefinition.addVarDef(targetVar, targetVarDef);
                Node property = Node.createURI((String)(prefix + StringUtils.toLowerCamelCase((String)fk.getTarget().getTableName())));
                Triple triple = new Triple((Node)mainVar, property, (Node)targetVar);
                Quad quad = new Quad(Quad.defaultGraphNodeGenerated, triple);
                viewDefinition.getConstructPattern().add(quad);
            }
            List<Column> nonKeyColumns = AutoMapper.getNonKeyColumns(relation, primaryKey, fks);
            for (Column column : nonKeyColumns) {
                Node xsd;
                Var var = Var.alloc((String)genColumnVar.next());
                SqlDatatype dt = (SqlDatatype)datatypeMap.get(column.getType());
                if (dt == null) {
                    logger.warn(column.getType() + ": no datatype mapping found");
                }
                Node datatype = Node.createURI((String)"http://aksw.org/sparqlify/unknown-datatype");
                if (dt != null && (xsd = dt.getXsd()) != null) {
                    datatype = xsd;
                }
                if (datatype.equals((Object)XSD.xstring.asNode())) {
                    viewDefinition.addVarDef(var, (Expr)E_RdfTerm.createPlainLiteral((Expr)new ExprVar(column.getName())));
                } else {
                    NodeValue dte = NodeValue.makeString((String)datatype.toString());
                    viewDefinition.addVarDef(var, (Expr)E_RdfTerm.createTypedLiteral((Expr)new ExprVar(column.getName()), (Expr)dte));
                }
                Node property = Node.createURI((String)(prefix + column.getName()));
                Triple triple = new Triple((Node)mainVar, property, (Node)var);
                Quad quad = new Quad(Quad.defaultGraphNodeGenerated, triple);
                viewDefinition.getConstructPattern().add(quad);
            }
            viewDefinition.setRelation(new SqlOpQuery(null, relation.getName()));
            System.out.println(viewDefinition.getDefinitionString());
        }
    }

    public static Connection getConnection() throws SQLException {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setDatabaseName("bsbm_default");
        dataSource.setUser("postgres");
        dataSource.setPassword("postgres");
        dataSource.setServerName("localhost");
        dataSource.setPortNumber(5432);
        Connection conn = dataSource.getConnection();
        return conn;
    }

    public static List<String> getColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        ArrayList<String> result = new ArrayList<String>(meta.getColumnCount());
        for (int i = 0; i < meta.getColumnCount(); ++i) {
            result.add(meta.getColumnName(i + 1));
        }
        return result;
    }

    public static List<Object> getRow(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        ArrayList<Object> result = new ArrayList<Object>(meta.getColumnCount());
        for (int i = 0; i < meta.getColumnCount(); ++i) {
            result.add(rs.getObject(i + 1));
        }
        return result;
    }
}

