/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.exprs.evaluators;

import java.util.Set;
import org.aksw.commons.util.Pair;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator2;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Equals;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.TypeSystem;

public class SqlExprEvaluator_Equals
extends SqlExprEvaluator2 {
    private TypeSystem datatypeSystem;

    public SqlExprEvaluator_Equals(TypeSystem datatypeSystem) {
        this.datatypeSystem = datatypeSystem;
    }

    @Override
    public SqlExpr eval(SqlExpr a, SqlExpr b) {
        if (a.equals(S_Constant.TYPE_ERROR) || b.equals(S_Constant.TYPE_ERROR)) {
            return S_Constant.TYPE_ERROR;
        }
        if (SqlExprEvaluator_Equals.getCommonDataype(a, b, this.datatypeSystem) == null) {
            Pair<? extends SqlExpr, ? extends SqlExpr> pair = SqlExprEvaluator_Equals.resolveCast(a, b, this.datatypeSystem);
            if (pair == null) {
                return S_Constant.TYPE_ERROR;
            }
            if (SqlExprEvaluator_Equals.getCommonDataype((SqlExpr)pair.getKey(), (SqlExpr)pair.getValue(), this.datatypeSystem) == null) {
                System.out.println("No commontypes: " + pair.getKey() + "(" + ((SqlExpr)pair.getKey()).getDatatype() + ") --- " + pair.getValue());
                return S_Constant.TYPE_ERROR;
            }
            S_Equals result = S_Equals.create((SqlExpr)pair.getKey(), (SqlExpr)pair.getValue());
            return result;
        }
        S_Equals result = S_Equals.create(a, b);
        return result;
    }

    public static TypeToken getCommonDataype(SqlExpr left, SqlExpr right, TypeSystem system) {
        Set<TypeToken> commons = system.supremumDatatypes(left.getDatatype(), right.getDatatype());
        if (commons.isEmpty()) {
            return null;
        }
        if (commons.size() > 1) {
            throw new RuntimeException("Ambiguous type candidates: " + commons);
        }
        return commons.iterator().next();
    }

    public static S_Constant asConstant(SqlExpr expr) {
        return expr instanceof S_Constant ? (S_Constant)expr : null;
    }

    public static S_ColumnRef asColumn(SqlExpr expr) {
        return expr instanceof S_ColumnRef ? (S_ColumnRef)expr : null;
    }

    public static Pair<? extends SqlExpr, ? extends SqlExpr> resolveCast(SqlExpr left, SqlExpr right, TypeSystem system) {
        Pair<S_ColumnRef, S_Constant> pair = SqlExprEvaluator_Equals.tryMatch(left, right);
        if (pair == null) {
            return Pair.create((Object)left, (Object)right);
        }
        try {
            if (((S_ColumnRef)pair.getKey()).getDatatype().equals(((S_Constant)pair.getValue()).getDatatype())) {
                return pair;
            }
        }
        catch (Throwable t) {
            System.out.println("ffs");
        }
        SqlValue value = ((S_Constant)pair.getValue()).getValue();
        TypeToken targetType = ((S_ColumnRef)pair.getKey()).getDatatype();
        SqlValue castedValue = system.cast(value, targetType);
        if (castedValue == null) {
            return null;
        }
        S_Constant newValue = new S_Constant(castedValue);
        Pair result = Pair.create((Object)pair.getKey(), (Object)newValue);
        return result;
    }

    public static Pair<S_ColumnRef, S_Constant> tryMatch(SqlExpr left, SqlExpr right) {
        Pair<S_ColumnRef, S_Constant> result = SqlExprEvaluator_Equals.tryMatchDirected(left, right);
        if (result == null) {
            result = SqlExprEvaluator_Equals.tryMatchDirected(right, left);
        }
        return result;
    }

    public static Pair<S_ColumnRef, S_Constant> tryMatchDirected(SqlExpr left, SqlExpr right) {
        S_ColumnRef column = SqlExprEvaluator_Equals.asColumn(left);
        if (column == null) {
            return null;
        }
        S_Constant value = SqlExprEvaluator_Equals.asConstant(right);
        if (value == null) {
            return null;
        }
        return Pair.create((Object)column, (Object)value);
    }
}

