/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sparql.transform;

import java.util.ArrayList;
import java.util.List;
import org.aksw.commons.util.Pair;
import org.aksw.sparqlify.algebra.sparql.transform.SqlFunctionDefinition;
import org.aksw.sparqlify.algebra.sql.exprs.S_Function;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprList;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.algebra.sql.exprs.SqlStringTransformer;
import org.aksw.sparqlify.core.DatatypeSystemOld;
import org.aksw.sparqlify.core.SqlDatatype;
import org.aksw.sparqlify.type_system.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericSqlFunctionDefinition
implements SqlFunctionDefinition {
    private static final Logger logger = LoggerFactory.getLogger(GenericSqlFunctionDefinition.class);
    private DatatypeSystemOld datatypeSystem;
    public String sqlFunctionName;
    private List<Pair<MethodSignature<SqlDatatype>, SqlStringTransformer>> signatures = new ArrayList<Pair<MethodSignature<SqlDatatype>, SqlStringTransformer>>();

    public GenericSqlFunctionDefinition(String sqlFunctionName, DatatypeSystemOld datatypeSystem) {
        this.sqlFunctionName = sqlFunctionName;
        this.datatypeSystem = datatypeSystem;
    }

    public static MethodSignature<SqlDatatype> resolve(MethodSignature<String> signature, DatatypeSystemOld datatypeSystem) {
        SqlDatatype returnType = datatypeSystem.requireByName((String)signature.getReturnType());
        ArrayList<SqlDatatype> paramTypes = new ArrayList<SqlDatatype>();
        for (String str : signature.getParameterTypes()) {
            SqlDatatype paramType = datatypeSystem.requireByName(str);
            paramTypes.add(paramType);
        }
        String varArgType = (String)signature.getVarArgType();
        SqlDatatype resVarArgType = null;
        if (varArgType != null) {
            resVarArgType = datatypeSystem.requireByName(varArgType);
        }
        MethodSignature result = MethodSignature.create((Object)returnType, paramTypes, (Object)resVarArgType);
        return result;
    }

    public void add(SqlStringTransformer transformer, MethodSignature<String> signature) {
        MethodSignature<SqlDatatype> resolved = GenericSqlFunctionDefinition.resolve(signature, this.datatypeSystem);
        this.signatures.add((Pair<MethodSignature<SqlDatatype>, SqlStringTransformer>)Pair.create(resolved, (Object)transformer));
    }

    public void add(SqlStringTransformer transformer, String returnType, boolean isVararg, String ... paramTypes) {
        MethodSignature signature = MethodSignature.create((boolean)isVararg, (Object)returnType, (Object[])paramTypes);
        this.add(transformer, (MethodSignature<String>)signature);
    }

    @Override
    public SqlExpr create(SqlExprList args) {
        ArrayList<SqlDatatype> argTypes = new ArrayList<SqlDatatype>();
        for (Object arg : args) {
            argTypes.add(arg.getDatatype());
        }
        ArrayList<Pair> candidates = new ArrayList<Pair>();
        for (Pair pair : this.signatures) {
            MethodSignature signature = (MethodSignature)pair.getKey();
            if (signature.getParameterTypes().size() > argTypes.size() || !signature.isVararg() && signature.getParameterTypes().size() < argTypes.size()) continue;
            int n = Math.min(argTypes.size(), signature.getParameterTypes().size());
            boolean isCandidate = true;
            for (int i = 0; i < n; ++i) {
                SqlDatatype a = (SqlDatatype)argTypes.get(i);
                SqlDatatype b = (SqlDatatype)signature.getParameterTypes().get(i);
                logger.warn("Implement the lookup properly - taking the type hierarchy into account");
                if (!this.datatypeSystem.supremumDatatypes(a, b).isEmpty()) continue;
                isCandidate = false;
            }
            if (!isCandidate) continue;
            candidates.add(pair);
        }
        switch (candidates.size()) {
            case 0: {
                logger.warn("Returning false; although it should be type-error");
                return new SqlExprValue(false);
            }
            case 1: {
                Pair<MethodSignature<SqlDatatype>, SqlStringTransformer> pair = this.signatures.get(0);
                return new S_Function(this.sqlFunctionName, args, (SqlDatatype)((MethodSignature)pair.getKey()).getReturnType(), (SqlStringTransformer)pair.getValue());
            }
        }
        logger.warn("Multiple overloads matched: " + candidates);
        logger.warn("Returning false; although it should be type-error");
        return new SqlExprValue(false);
    }

    @Override
    public String getName() {
        return this.sqlFunctionName;
    }
}

