/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCount;
import com.hp.hpl.jena.sparql.expr.aggregate.AggGroupConcat;
import com.hp.hpl.jena.sparql.expr.aggregate.AggSum;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.util.MapReader;
import org.aksw.commons.util.XmlUtils;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_Arithmetic;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_Compare;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_LogicalAnd;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_LogicalNot;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_LogicalOr;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_ParseInt;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_PassThrough;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_UrlDecode;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_UrlEncode;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializer;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerCase;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerDefault;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerElse;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerOp1;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerOp1Prefix;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerOp2;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerPassThrough;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerWhen;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializer_Join;
import org.aksw.sparqlify.config.xml.Mapping;
import org.aksw.sparqlify.config.xml.SimpleFunction;
import org.aksw.sparqlify.config.xml.SparqlifyConfig;
import org.aksw.sparqlify.core.SparqlifyConstants;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.DatatypeToStringPostgres;
import org.aksw.sparqlify.core.algorithms.ExprEvaluator;
import org.aksw.sparqlify.core.cast.CoercionSystemImpl3;
import org.aksw.sparqlify.core.cast.ExprBindingSubstitutorImpl;
import org.aksw.sparqlify.core.cast.MethodDeclarationParserSimple;
import org.aksw.sparqlify.core.cast.NewWorldTest;
import org.aksw.sparqlify.core.cast.NodeValueToObjectDefault;
import org.aksw.sparqlify.core.cast.SqlDatatypeConstant;
import org.aksw.sparqlify.core.cast.SqlDatatypeDefault;
import org.aksw.sparqlify.core.cast.SqlExprFactoryUtils;
import org.aksw.sparqlify.core.cast.SqlExprSerializerSystem;
import org.aksw.sparqlify.core.cast.SqlExprSerializerSystemImpl;
import org.aksw.sparqlify.core.cast.SqlFunctionSerializerStringTemplate;
import org.aksw.sparqlify.core.cast.SqlLiteralMapperDefault;
import org.aksw.sparqlify.core.cast.SqlTypeMapper;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.SqlValueTransformerFloat;
import org.aksw.sparqlify.core.cast.SqlValueTransformerInteger;
import org.aksw.sparqlify.core.cast.TransformUtils;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.cast.TypeSystemImpl;
import org.aksw.sparqlify.core.cast.TypedExprTransformerImpl;
import org.aksw.sparqlify.core.datatypes.SparqlFunctionImpl;
import org.aksw.sparqlify.core.transformations.ExprTransformer;
import org.aksw.sparqlify.core.transformations.ExprTransformerArithmetic;
import org.aksw.sparqlify.core.transformations.ExprTransformerCast;
import org.aksw.sparqlify.core.transformations.ExprTransformerConcat;
import org.aksw.sparqlify.core.transformations.ExprTransformerFunction;
import org.aksw.sparqlify.core.transformations.ExprTransformerHasRdfTermType;
import org.aksw.sparqlify.core.transformations.ExprTransformerIsNumeric;
import org.aksw.sparqlify.core.transformations.ExprTransformerLang;
import org.aksw.sparqlify.core.transformations.ExprTransformerLangMatches;
import org.aksw.sparqlify.core.transformations.ExprTransformerLogicalConjunction;
import org.aksw.sparqlify.core.transformations.ExprTransformerOneOf;
import org.aksw.sparqlify.core.transformations.ExprTransformerPassAsTypedLiteral;
import org.aksw.sparqlify.core.transformations.ExprTransformerRdfTermComparator;
import org.aksw.sparqlify.core.transformations.ExprTransformerRdfTermCtor;
import org.aksw.sparqlify.core.transformations.ExprTransformerSparqlFunctionModel;
import org.aksw.sparqlify.core.transformations.ExprTransformerStr;
import org.aksw.sparqlify.core.transformations.RdfTermEliminatorImpl;
import org.aksw.sparqlify.core.transformations.RdfTermEliminatorWriteable;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.type_system.FunctionModel;
import org.aksw.sparqlify.type_system.FunctionModelAliased;
import org.aksw.sparqlify.type_system.FunctionModelMeta;
import org.aksw.sparqlify.type_system.MethodDeclaration;
import org.aksw.sparqlify.type_system.MethodSignature;
import org.aksw.sparqlify.type_system.TypeModel;

public class SparqlifyCoreInit {
    public static SqlExprSerializerSystem createSerializerSystem(TypeSystem typeSystem) {
        DatatypeToStringPostgres typeSerializer = new DatatypeToStringPostgres();
        SqlLiteralMapperDefault sqlLiteralMapper = new SqlLiteralMapperDefault(typeSerializer);
        SqlExprSerializerSystemImpl result = new SqlExprSerializerSystemImpl(typeSerializer, sqlLiteralMapper);
        FunctionModel<TypeToken> sqlModel = typeSystem.getSqlFunctionModel();
        SqlFunctionSerializer serializer = new SqlFunctionSerializerOp2("+");
        result.addSerializer(sqlModel.getIdsByName("numericPlus"), serializer);
        serializer = new SqlFunctionSerializerOp2("-");
        result.addSerializer(sqlModel.getIdsByName("numericMinus"), serializer);
        serializer = new SqlFunctionSerializerOp2("*");
        result.addSerializer(sqlModel.getIdsByName("numericMultiply"), serializer);
        serializer = new SqlFunctionSerializerOp2("/");
        result.addSerializer(sqlModel.getIdsByName("numericDivide"), serializer);
        serializer = new SqlFunctionSerializerOp2("=");
        result.addSerializer(sqlModel.getIdsByName("equal"), serializer);
        serializer = new SqlFunctionSerializer_Join(" || ");
        result.addSerializer("concat@str", serializer);
        serializer = new SqlFunctionSerializerDefault("COALESCE");
        result.addSerializer("coalesce", serializer);
        serializer = new SqlFunctionSerializerOp2(">");
        result.addSerializer(sqlModel.getIdsByName("greaterThan"), serializer);
        serializer = new SqlFunctionSerializerOp2(">=");
        result.addSerializer(sqlModel.getIdsByName("greaterThanOrEqual"), serializer);
        serializer = new SqlFunctionSerializerOp2("<");
        result.addSerializer(sqlModel.getIdsByName("lessThan"), serializer);
        serializer = new SqlFunctionSerializerOp2("<=");
        result.addSerializer(sqlModel.getIdsByName("lessThanOrEqual"), serializer);
        serializer = new SqlFunctionSerializerOp2("AND");
        result.addSerializer(sqlModel.getIdsByName("logicalAnd"), serializer);
        result.addSerializer("logicalAnd", serializer);
        serializer = new SqlFunctionSerializerOp2("OR");
        result.addSerializer(sqlModel.getIdsByName("logicalOr"), serializer);
        result.addSerializer("logicalOr", serializer);
        serializer = new SqlFunctionSerializerOp1("NOT");
        result.addSerializer(sqlModel.getIdsByName("logicalNot"), serializer);
        result.addSerializer("logicalNot", serializer);
        serializer = new SqlFunctionSerializerOp1Prefix(" IS NOT NULL");
        result.addSerializer("isNotNull", serializer);
        serializer = new SqlFunctionSerializerOp1Prefix(" IS NOT NULL");
        result.addSerializer(sqlModel.getIdsByName("isNotNull"), serializer);
        serializer = new SqlFunctionSerializerOp1Prefix("::float8");
        result.addSerializer("double@str", serializer);
        serializer = new SqlFunctionSerializerOp1Prefix("::text");
        result.addSerializer("str@float", serializer);
        serializer = new SqlFunctionSerializerOp1Prefix("::text");
        result.addSerializer("str@double", serializer);
        serializer = new SqlFunctionSerializerPassThrough();
        result.addSerializer("str@str", serializer);
        serializer = new SqlFunctionSerializerOp1Prefix("::text");
        result.addSerializer("str@int", serializer);
        serializer = new SqlFunctionSerializerOp1Prefix("::float");
        result.addSerializer("float toFloat(int)", serializer);
        serializer = new SqlFunctionSerializerOp1Prefix("::float");
        result.addSerializer("double toDouble(int)", serializer);
        MethodDeclaration decl = MethodDeclaration.create((Object)TypeToken.Boolean, (String)"ST_DWithin", (boolean)false, (Object[])new TypeToken[]{TypeToken.Geometry, TypeToken.Geometry, TypeToken.Float});
        SqlFunctionSerializer serializer2 = new SqlFunctionSerializerDefault("ST_DWithin");
        result.addSerializer(decl.toString(), serializer2);
        decl = MethodDeclaration.create((Object)TypeToken.Boolean, (String)"ST_Intersects", (boolean)false, (Object[])new TypeToken[]{TypeToken.Geometry, TypeToken.Geometry});
        serializer2 = new SqlFunctionSerializerDefault("ST_Intersects");
        result.addSerializer(decl.toString(), serializer2);
        decl = MethodDeclaration.create((Object)TypeToken.Long, (String)"Count", (boolean)false, (Object[])new TypeToken[0]);
        serializer2 = new SqlFunctionSerializer(){

            @Override
            public String serialize(List<String> args) {
                return "Count(*)";
            }
        };
        result.addSerializer(decl.toString(), serializer2);
        decl = MethodDeclaration.create((Object)TypeToken.String, (String)"http://aksw.org/sparqlify/urlEncode", (boolean)false, (Object[])new TypeToken[]{TypeToken.String});
        result.addSerializer(decl.toString(), (SqlFunctionSerializer)new SqlFunctionSerializerPassThrough());
        decl = MethodDeclaration.create((Object)TypeToken.Int, (String)"Sum", (boolean)false, (Object[])new TypeToken[]{TypeToken.Int});
        serializer2 = new SqlFunctionSerializerDefault("Sum");
        result.addSerializer(decl.toString(), serializer2);
        decl = MethodDeclaration.create((Object)TypeToken.String, (String)"GroupConcat", (boolean)false, (Object[])new TypeToken[]{TypeToken.String, TypeToken.String});
        serializer2 = new SqlFunctionSerializer(){

            @Override
            public String serialize(List<String> args) {
                return "string_agg(" + args.get(0) + ", " + args.get(1) + ")";
            }
        };
        result.addSerializer(decl.toString(), serializer2);
        decl = MethodDeclaration.create((Object)TypeToken.Double, (String)"Sum", (boolean)false, (Object[])new TypeToken[]{TypeToken.Double});
        serializer2 = new SqlFunctionSerializerDefault("Sum");
        result.addSerializer(decl.toString(), serializer2);
        result.addSerializer(sqlModel.getIdsByName("regex"), new SqlFunctionSerializer(){

            @Override
            public String serialize(List<String> args) {
                return "(" + args.get(0) + " ~ " + args.get(1) + ")";
            }
        });
        serializer = new SqlFunctionSerializerWhen();
        result.addSerializer("when", serializer);
        serializer = new SqlFunctionSerializerCase();
        result.addSerializer("case", serializer);
        serializer = new SqlFunctionSerializerElse();
        result.addSerializer("else", serializer);
        serializer = new SqlFunctionSerializerPassThrough();
        result.addSerializer("http://aksw.org/sparqlify/urlEncode", serializer);
        serializer = new SqlFunctionSerializer(){

            @Override
            public String serialize(List<String> args) {
                return "COUNT(*)";
            }
        };
        result.addSerializer("org.aksw.sparqlify.algebra.sql.exprs2.S_AggCount", serializer);
        return result;
    }

    public static RdfTermEliminatorImpl createDefaultTransformer(TypeSystem typeSystem) {
        RdfTermEliminatorImpl exprTransformer = new RdfTermEliminatorImpl();
        Map<String, ExprTransformer> transMap = exprTransformer.getTransformerMap();
        transMap.put("concat", new ExprTransformerConcat());
        transMap.put("lang", new ExprTransformerLang());
        transMap.put("langMatches", new ExprTransformerLangMatches());
        transMap.put("=", new ExprTransformerRdfTermComparator(XSD.xboolean));
        transMap.put(">", new ExprTransformerRdfTermComparator(XSD.xboolean));
        transMap.put(">=", new ExprTransformerRdfTermComparator(XSD.xboolean));
        transMap.put("<", new ExprTransformerRdfTermComparator(XSD.xboolean));
        transMap.put("<=", new ExprTransformerRdfTermComparator(XSD.xboolean));
        FunctionModelAliased<String> sparqlModel = typeSystem.getSparqlFunctionModel();
        transMap.put("+", new ExprTransformerSparqlFunctionModel((FunctionModel<String>)sparqlModel));
        transMap.put("-", new ExprTransformerArithmetic(XSD.decimal));
        transMap.put("*", new ExprTransformerArithmetic(XSD.decimal));
        transMap.put("/", new ExprTransformerArithmetic(XSD.decimal));
        transMap.put("bound", new ExprTransformerPassAsTypedLiteral(XSD.xboolean));
        transMap.put("cast", new ExprTransformerCast());
        transMap.put("str", new ExprTransformerStr());
        transMap.put("regex", new ExprTransformerFunction(XSD.xboolean));
        transMap.put("http://aksw.org/sparqlify/blankNode", new ExprTransformerRdfTermCtor());
        transMap.put("http://aksw.org/sparqlify/uri", new ExprTransformerRdfTermCtor());
        transMap.put("http://aksw.org/sparqlify/plainLiteral", new ExprTransformerRdfTermCtor());
        transMap.put("http://aksw.org/sparqlify/typedLiteral", new ExprTransformerRdfTermCtor());
        transMap.put("http://aksw.org/sparqlify/rdfTerm", new ExprTransformerRdfTermCtor());
        transMap.put("&&", new ExprTransformerLogicalConjunction());
        transMap.put("||", new ExprTransformerLogicalConjunction());
        transMap.put("!", new ExprTransformerPassAsTypedLiteral(XSD.xboolean));
        transMap.put("in", new ExprTransformerOneOf());
        transMap.put(XSD.xdouble.getURI(), new ExprTransformerCast());
        transMap.put("http://aksw.org/sparqlify/urlEncode", new ExprTransformerFunction(XSD.xstring));
        transMap.put("http://aksw.org/sparqlify/urlDecode", new ExprTransformerFunction(XSD.xstring));
        String bif = "http://www.openlinksw.com/schemas/bif#";
        Resource virtGeometry = ResourceFactory.createResource((String)"http://www.openlinksw.com/schemas/virtrdf#Geometry");
        TypeModel<String> sparqlTypeModel = typeSystem.getSparqlTypeModel();
        transMap.put("isNumeric", new ExprTransformerIsNumeric(sparqlTypeModel));
        transMap.put("isURI", new ExprTransformerHasRdfTermType(1));
        transMap.put("isBlank", new ExprTransformerHasRdfTermType(0));
        transMap.put(AggCount.class.getSimpleName(), new ExprTransformerFunction(XSD.xlong));
        transMap.put(AggSum.class.getSimpleName(), new ExprTransformerFunction(XSD.xdouble));
        transMap.put(AggGroupConcat.class.getSimpleName(), new ExprTransformerSparqlFunctionModel((FunctionModel<String>)sparqlModel));
        return exprTransformer;
    }

    public static void registerSqlOperatorBatchNumeric(FunctionModel<TypeToken> sqlModel, String name) {
        sqlModel.registerFunction(name + "@boolean", name, MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Boolean, TypeToken.Boolean}));
        sqlModel.registerFunction(name + "@int", name, MethodSignature.create((boolean)false, (Object)TypeToken.Int, (Object[])new TypeToken[]{TypeToken.Int, TypeToken.Int}));
        sqlModel.registerFunction(name + "@float", name, MethodSignature.create((boolean)false, (Object)TypeToken.Float, (Object[])new TypeToken[]{TypeToken.Float, TypeToken.Float}));
        sqlModel.registerFunction(name + "@double", name, MethodSignature.create((boolean)false, (Object)TypeToken.Double, (Object[])new TypeToken[]{TypeToken.Double, TypeToken.Double}));
    }

    public static void registerSqlOperatorBatchCompare(FunctionModel<TypeToken> sqlModel, String name) {
        sqlModel.registerFunction(name + "@boolean", name, MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Boolean, TypeToken.Boolean}));
        sqlModel.registerFunction(name + "@int", name, MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Int, TypeToken.Int}));
        sqlModel.registerFunction(name + "@float", name, MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Float, TypeToken.Float}));
        sqlModel.registerFunction(name + "@double", name, MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Double, TypeToken.Double}));
        sqlModel.registerFunction(name + "@string", name, MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.String, TypeToken.String}));
        sqlModel.registerFunction(name + "@dateTime", name, MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Date, TypeToken.Date}));
    }

    public static TypeSystem createDefaultDatatypeSystem() {
        try {
            Map typeNameToClass = MapReader.readFromResource((String)"/type-class.tsv");
            Map typeNameToUri = MapReader.readFromResource((String)"/type-uri.tsv");
            Map typeHierarchy = MapReader.readFromResource((String)"/type-hierarchy.default.tsv");
            Map physicalTypeMap = MapReader.readFromResource((String)"/type-map.h2.tsv");
            Map rdfTypeHierarchyRaw = MapReader.readFromResource((String)"/rdf-type-hierarchy.tsv");
            IBiSetMultimap rdfTypeHierarchy = TypeSystemImpl.toBidiMap(rdfTypeHierarchyRaw);
            physicalTypeMap.put("INTEGER", "int");
            physicalTypeMap.put("FLOAT", "float");
            physicalTypeMap.put("DOUBLE", "double");
            TypeSystemImpl result = TypeSystemImpl.create(typeHierarchy, physicalTypeMap);
            result.getSparqlTypeHierarchy().putAll(rdfTypeHierarchy);
            result.getNormSqlTypeToUri().putAll(typeNameToUri);
            SparqlifyCoreInit.initSparqlModel(result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void initSparqlModel(TypeSystem typeSystem) {
        TypeMapper tm = TypeMapper.getInstance();
        String xxx = "http://mytype.org/foo/bar";
        SqlTypeMapper stm = typeSystem.getSqlTypeMapper();
        stm.register(XSD.xstring.getURI(), new SqlDatatypeDefault(TypeToken.String, new NodeValueToObjectDefault()));
        stm.register(XSD.xboolean.getURI(), new SqlDatatypeDefault(TypeToken.Boolean, new NodeValueToObjectDefault()));
        stm.register(XSD.integer.getURI(), new SqlDatatypeDefault(TypeToken.Int, new NodeValueToObjectDefault()));
        stm.register(XSD.xfloat.getURI(), new SqlDatatypeDefault(TypeToken.Float, new NodeValueToObjectDefault()));
        stm.register(XSD.xdouble.getURI(), new SqlDatatypeDefault(TypeToken.Double, new NodeValueToObjectDefault()));
        stm.register(XSD.decimal.getURI(), new SqlDatatypeDefault(TypeToken.Int, new NodeValueToObjectDefault()));
        stm.register(XSD.dateTime.getURI(), new SqlDatatypeDefault(TypeToken.Date, new NodeValueToObjectDefault()));
        stm.register(SparqlifyConstants.nvTypeError.asNode().getLiteralDatatypeURI(), new SqlDatatypeConstant(SqlValue.TYPE_ERROR));
        CoercionSystemImpl3 cs = (CoercionSystemImpl3)typeSystem.getCoercionSystem();
        cs.registerCoercion(TypeToken.alloc(XSD.integer.toString()), TypeToken.Int, new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("int8"), new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("int4"), new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("int"), new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.Int, TypeToken.Float, new SqlValueTransformerFloat());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("INTEGER"), new SqlValueTransformerInteger());
        ExprBindingSubstitutorImpl exprBindingSubstitutor = new ExprBindingSubstitutorImpl();
        ExprEvaluator exprEvaluator = SqlTranslationUtils.createDefaultEvaluator();
        TypedExprTransformerImpl typedExprTransformer = new TypedExprTransformerImpl(typeSystem);
        DatatypeToStringPostgres typeSerializer = new DatatypeToStringPostgres();
        SqlLiteralMapperDefault sqlLiteralMapper = new SqlLiteralMapperDefault(typeSerializer);
        SqlExprSerializerSystemImpl serializerSystem = new SqlExprSerializerSystemImpl(typeSerializer, sqlLiteralMapper);
        FunctionModel<TypeToken> sqlModel = typeSystem.getSqlFunctionModel();
        Multimap<String, String> sparqlSqlDecls = typeSystem.getSparqlSqlDecls();
        Map<String, SqlExprEvaluator> sqlImpls = typeSystem.getSqlImpls();
        SparqlifyCoreInit.registerSqlOperatorBatchCompare(sqlModel, "lessThan");
        SparqlifyCoreInit.registerSqlOperatorBatchCompare(sqlModel, "lessThanOrEqual");
        SparqlifyCoreInit.registerSqlOperatorBatchCompare(sqlModel, "equal");
        SparqlifyCoreInit.registerSqlOperatorBatchCompare(sqlModel, "greaterThan");
        SparqlifyCoreInit.registerSqlOperatorBatchCompare(sqlModel, "greaterThanOrEqual");
        SparqlifyCoreInit.registerSqlOperatorBatchNumeric(sqlModel, "numericPlus");
        SparqlifyCoreInit.registerSqlOperatorBatchNumeric(sqlModel, "numericMinus");
        SparqlifyCoreInit.registerSqlOperatorBatchNumeric(sqlModel, "numericMultiply");
        SparqlifyCoreInit.registerSqlOperatorBatchNumeric(sqlModel, "numericDivide");
        sqlModel.registerFunction("str@str", "str", MethodSignature.create((boolean)false, (Object)TypeToken.String, (Object[])new TypeToken[]{TypeToken.String}));
        sqlModel.registerFunction("str@double", "str", MethodSignature.create((boolean)false, (Object)TypeToken.String, (Object[])new TypeToken[]{TypeToken.Double}));
        sqlModel.registerFunction("str@float", "str", MethodSignature.create((boolean)false, (Object)TypeToken.String, (Object[])new TypeToken[]{TypeToken.Float}));
        sqlModel.registerFunction("str@int", "str", MethodSignature.create((boolean)false, (Object)TypeToken.String, (Object[])new TypeToken[]{TypeToken.Int}));
        sqlModel.registerFunction("double@str", "double", MethodSignature.create((boolean)false, (Object)TypeToken.Double, (Object[])new TypeToken[]{TypeToken.String}));
        sqlModel.registerFunction("isNotNull@object", "isNotNull", MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Object}));
        sparqlSqlDecls.putAll((Object)"<", (Iterable)sqlModel.getIdsByName("lessThan"));
        sparqlSqlDecls.putAll((Object)"<=", (Iterable)sqlModel.getIdsByName("lessThanOrEqual"));
        sparqlSqlDecls.putAll((Object)"=", (Iterable)sqlModel.getIdsByName("equal"));
        sparqlSqlDecls.putAll((Object)">", (Iterable)sqlModel.getIdsByName("greaterThan"));
        sparqlSqlDecls.putAll((Object)">=", (Iterable)sqlModel.getIdsByName("greaterThanOrEqual"));
        sparqlSqlDecls.putAll((Object)"+", (Iterable)sqlModel.getIdsByName("numericPlus"));
        sparqlSqlDecls.putAll((Object)"-", (Iterable)sqlModel.getIdsByName("numericMinus"));
        sparqlSqlDecls.putAll((Object)"/", (Iterable)sqlModel.getIdsByName("numericMultiply"));
        sparqlSqlDecls.putAll((Object)"*", (Iterable)sqlModel.getIdsByName("numericDivide"));
        sparqlSqlDecls.put((Object)"str", (Object)"str@str");
        sparqlSqlDecls.put((Object)"str", (Object)"str@double");
        sparqlSqlDecls.put((Object)"str", (Object)"str@float");
        sparqlSqlDecls.put((Object)"str", (Object)"str@int");
        sparqlSqlDecls.put((Object)XSD.xdouble.getURI(), (Object)"double@str");
        sparqlSqlDecls.put((Object)"bound", (Object)"isNotNull@object");
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("lessThan"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryLessThan));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("lessThanOrEqual"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryLessThanOrEqual));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("equal"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryEqual));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("greaterThan"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryGreaterThan));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("greaterThanOrEqual"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryGreaterThanOrEqual));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("numericPlus"), new SqlExprEvaluator_Arithmetic());
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("+"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryNumericPlus));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("-"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryNumericMinus));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("*"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryNumericMultiply));
        sqlModel.registerFunction("logicalAnd@boolean", "logicalAnd", MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Boolean, TypeToken.Boolean}));
        sparqlSqlDecls.putAll((Object)"&&", (Iterable)sqlModel.getIdsByName("logicalAnd"));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("logicalAnd"), new SqlExprEvaluator_LogicalAnd());
        sqlModel.registerFunction("logicalOr@boolean", "logicalOr", MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Boolean, TypeToken.Boolean}));
        sparqlSqlDecls.putAll((Object)"||", (Iterable)sqlModel.getIdsByName("logicalOr"));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("logicalOr"), new SqlExprEvaluator_LogicalOr());
        sqlModel.registerFunction("logicalNot@boolean", "logicalNot", MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.Boolean}));
        sparqlSqlDecls.putAll((Object)"!", (Iterable)sqlModel.getIdsByName("logicalNot"));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("logicalNot"), new SqlExprEvaluator_LogicalNot());
        sqlModel.registerFunction("concat@str", "concat", MethodSignature.create((boolean)true, (Object)TypeToken.String, (Object[])new TypeToken[]{TypeToken.String}));
        sparqlSqlDecls.put((Object)"concat", (Object)"concat@str");
        sqlModel.registerFunction("parseInt@str", "parseInt", MethodSignature.create((boolean)false, (Object)TypeToken.Int, (Object[])new TypeToken[]{TypeToken.String}));
        FunctionModelMeta sqlMetaModel = typeSystem.getSqlFunctionMetaModel();
        sqlMetaModel.getInverses().put("str@int", "parseInt@str");
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("lessThan"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("lessThanOrEqual"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("equal"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("greaterThanOrEqual"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("greaterThan"));
        sqlMetaModel.getLogicalAnds().addAll(sqlModel.getIdsByName("logicalAnd"));
        sqlMetaModel.getLogicalOrs().addAll(sqlModel.getIdsByName("logicalOr"));
        sqlMetaModel.getLogicalNots().addAll(sqlModel.getIdsByName("logicalNot"));
        sqlImpls.put("parseInt@str", new SqlExprEvaluator_ParseInt());
        TypeToken typeGeometry = TypeToken.alloc("geometry");
        String bif = "http://www.openlinksw.com/schemas/bif#";
        sqlModel.registerCoercion("float toFloat(int)", "toFloat", MethodSignature.create((boolean)false, (Object)TypeToken.Float, (Object[])new TypeToken[]{TypeToken.Int}));
        sqlModel.registerCoercion("double toDouble(int)", "toDouble", MethodSignature.create((boolean)false, (Object)TypeToken.Double, (Object[])new TypeToken[]{TypeToken.Int}));
        sqlModel.registerFunction("boolean regex(string, string)", "regex", MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.String, TypeToken.String}));
        sqlModel.registerFunction("boolean regex(string, string, string)", "regex", MethodSignature.create((boolean)false, (Object)TypeToken.Boolean, (Object[])new TypeToken[]{TypeToken.String, TypeToken.String, TypeToken.String}));
        sparqlSqlDecls.putAll((Object)"regex", (Iterable)sqlModel.getIdsByName("regex"));
        sqlImpls.put("boolean regex(string, string)", new SqlExprEvaluator_PassThrough(TypeToken.Boolean, "regex"));
        sqlImpls.put("boolean regex(string, string, string)", new SqlExprEvaluator_PassThrough(TypeToken.Boolean, "regex"));
        MethodDeclaration urlEncodeDecl = MethodDeclaration.create((Object)TypeToken.String, (String)"http://aksw.org/sparqlify/urlEncode", (boolean)false, (Object[])new TypeToken[]{TypeToken.String});
        sqlModel.registerFunction(urlEncodeDecl);
        sparqlSqlDecls.put((Object)"http://aksw.org/sparqlify/urlEncode", (Object)urlEncodeDecl.toString());
        sqlImpls.put(urlEncodeDecl.toString(), new SqlExprEvaluator_UrlEncode());
        MethodDeclaration urlDecodeDecl = MethodDeclaration.create((Object)TypeToken.String, (String)"http://aksw.org/sparqlify/urlDecode", (boolean)false, (Object[])new TypeToken[]{TypeToken.String});
        sqlModel.registerFunction(urlDecodeDecl);
        sparqlSqlDecls.put((Object)"http://aksw.org/sparqlify/urlDecode", (Object)urlDecodeDecl.toString());
        sqlImpls.put(urlDecodeDecl.toString(), new SqlExprEvaluator_UrlDecode());
        sqlMetaModel.getInverses().put(urlEncodeDecl.toString(), urlDecodeDecl.toString());
        sqlMetaModel.getInverses().put(urlDecodeDecl.toString(), urlEncodeDecl.toString());
        HashMultimap symbolSparqlDecls = HashMultimap.create();
        MethodDeclaration aggCountDecl = MethodDeclaration.create((Object)TypeToken.Long, (String)"Count");
        sqlModel.registerFunction(aggCountDecl);
        sparqlSqlDecls.put((Object)AggCount.class.getSimpleName(), (Object)aggCountDecl.toString());
        MethodDeclaration aggSumDecl1 = MethodDeclaration.create((Object)TypeToken.Long, (String)"Sum", (boolean)false, (Object[])new TypeToken[]{TypeToken.Long});
        MethodDeclaration aggSumDecl2 = MethodDeclaration.create((Object)TypeToken.Double, (String)"Sum", (boolean)false, (Object[])new TypeToken[]{TypeToken.Double});
        sqlModel.registerFunction(aggSumDecl1);
        sqlModel.registerFunction(aggSumDecl2);
        sparqlSqlDecls.put((Object)AggSum.class.getSimpleName(), (Object)aggSumDecl1.toString());
        sparqlSqlDecls.put((Object)AggSum.class.getSimpleName(), (Object)aggSumDecl2.toString());
        MethodDeclaration aggGroupConcatDecl = MethodDeclaration.create((Object)TypeToken.String, (String)"GroupConcat", (boolean)false, (Object[])new TypeToken[]{TypeToken.String});
        sqlModel.registerFunction(aggGroupConcatDecl);
        sparqlSqlDecls.put((Object)AggGroupConcat.class.getSimpleName(), (Object)aggGroupConcatDecl.toString());
        FunctionModelAliased<String> sparqlModel = typeSystem.getSparqlFunctionModel();
        String fn = "http://www.w3.org/2005/xpath-functions#";
        String op = "http://www.w3.org/2005/xpath-functions#";
        String xsdInt = XSD.xint.toString();
        String xsdString = XSD.xstring.toString();
        String xsdFloat = XSD.xfloat.toString();
        String xsdDouble = XSD.xdouble.toString();
        String xsdDecimal = XSD.decimal.toString();
        MethodDeclaration numericAddInt = MethodDeclaration.create((String)"+", (MethodSignature)MethodSignature.create((boolean)false, (Object)xsdInt, (Object[])new String[]{xsdInt, xsdInt}));
        sparqlModel.registerFunction("+", numericAddInt);
        MethodDeclaration numericAddDouble = MethodDeclaration.create((String)"+", (MethodSignature)MethodSignature.create((boolean)false, (Object)xsdDouble, (Object[])new String[]{xsdDouble, xsdDouble}));
        sparqlModel.registerFunction("+", numericAddDouble);
        sparqlModel.registerCoercion(MethodDeclaration.create((String)xsdDouble, (MethodSignature)MethodSignature.create((boolean)false, (Object)xsdDouble, (Object[])new String[]{xsdInt})));
        sparqlModel.registerCoercion(MethodDeclaration.create((String)xsdFloat, (MethodSignature)MethodSignature.create((boolean)false, (Object)xsdFloat, (Object[])new String[]{xsdDecimal})));
        sparqlModel.registerCoercion(MethodDeclaration.create((String)xsdDouble, (MethodSignature)MethodSignature.create((boolean)false, (Object)xsdDouble, (Object[])new String[]{xsdDecimal})));
        MethodDeclaration groupConcat = MethodDeclaration.create((String)AggGroupConcat.class.getSimpleName(), (MethodSignature)MethodSignature.create((boolean)false, (Object)xsdString, (Object[])new String[0]));
        sparqlModel.registerFunction(AggGroupConcat.class.getSimpleName(), groupConcat);
        MethodSignature sig = MethodSignature.create((boolean)false, (Object)TypeToken.String, (Object[])new TypeToken[]{TypeToken.String});
        SparqlFunctionImpl f = new SparqlFunctionImpl("http://aksw.org/sparqlify/urlEncode", (MethodSignature<TypeToken>)sig, null, null);
        typeSystem.registerSparqlFunction(f);
        MethodDeclaration decl = MethodDeclaration.create((Object)TypeToken.String, (String)"http://aksw.org/sparqlify/urlEncode", (boolean)false, (Object[])new TypeToken[]{TypeToken.String});
        f = new SparqlFunctionImpl((MethodDeclaration<TypeToken>)decl, null, null);
        typeSystem.registerSparqlFunction(f);
    }

    public static void loadExtensionFunctions(TypeSystem typeSystem, RdfTermEliminatorWriteable exprTransformer, SqlExprSerializerSystem serializerSystem) {
        try {
            Map typeNameToUri = MapReader.readFromResource((String)"/type-uri.tsv");
            Function fnTypeToUri = Functions.forMap((Map)typeNameToUri);
            InputStream in = NewWorldTest.class.getClassLoader().getResourceAsStream("functions.xml");
            SparqlifyConfig config = (SparqlifyConfig)XmlUtils.unmarshallXml(SparqlifyConfig.class, (InputStream)in);
            FunctionModelAliased<String> sparqlModel = typeSystem.getSparqlFunctionModel();
            Multimap<String, String> sparqlSqlDecls = typeSystem.getSparqlSqlDecls();
            FunctionModel<TypeToken> sqlModel = typeSystem.getSqlFunctionModel();
            for (SimpleFunction simpleFunction : config.getSimpleFunctions().getSimpleFunction()) {
                String sparqlName = simpleFunction.getName();
                for (Mapping mapping : simpleFunction.getMappings().getMapping()) {
                    String decStr = mapping.getSignature();
                    String patternStr = mapping.getPattern();
                    MethodDeclaration<String> dec = MethodDeclarationParserSimple.parse(decStr);
                    SqlFunctionSerializer serializer = patternStr == null ? new SqlFunctionSerializerDefault(dec.getName()) : SqlFunctionSerializerStringTemplate.create(patternStr, dec);
                    MethodDeclaration<TypeToken> sqlDec = NewWorldTest.transform(dec, TransformUtils.toTypeToken);
                    String translationName = sparqlName + "@" + sqlDec.getSignature().getReturnType();
                    MethodDeclaration sparqlDec = MethodDeclaration.create((String)translationName, NewWorldTest.transform(dec.getSignature(), fnTypeToUri));
                    sparqlModel.registerFunction(sparqlName, sparqlDec);
                    String sqlDescriptor = sqlDec.toString();
                    sparqlSqlDecls.put((Object)translationName, (Object)sqlDescriptor);
                    sqlModel.registerFunction(sqlDec);
                    serializerSystem.addSerializer(sqlDescriptor, serializer);
                }
                ExprTransformerSparqlFunctionModel et = new ExprTransformerSparqlFunctionModel((FunctionModel<String>)sparqlModel);
                exprTransformer.register(sparqlName, et);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

