/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.restriction.experiment;

import java.util.HashSet;
import java.util.Set;
import org.aksw.sparqlify.restriction.Polarity;
import org.aksw.sparqlify.restriction.Prefix;

public class PrefixSet {
    private Polarity polarity;
    private Prefix value;
    private Set<PrefixSet> exceptions;

    public PrefixSet(Prefix value) {
        this(value, Polarity.POSITIVE);
    }

    public PrefixSet(Prefix value, Polarity polarity) {
        this(value, polarity, new HashSet<PrefixSet>());
    }

    public PrefixSet(Prefix value, Polarity polarity, Set<PrefixSet> exceptions) {
        this.value = value;
        this.polarity = polarity;
        this.exceptions = exceptions;
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public Prefix getValue() {
        return this.value;
    }

    public Set<PrefixSet> getExceptions() {
        return this.exceptions;
    }

    public boolean isPrefixOf(String str) {
        boolean result = this.value.isConstant() ? str.equals(this.value.getPrefix()) : str.startsWith(this.value.getPrefix());
        return result;
    }

    public boolean contains(String str) {
        boolean result = this.contains(new Prefix(str));
        return result;
    }

    public boolean contains(Prefix that) {
        boolean result = this.value.isPrefixOf(that);
        if (this.polarity.equals((Object)Polarity.NEGATIVE)) {
            result = !result;
        }
        for (PrefixSet exception : this.exceptions) {
            if (!exception.contains(that)) continue;
            result = !result;
            break;
        }
        return result;
    }

    public PrefixSet getExceptionFor(Prefix prefix) {
        for (PrefixSet ex : this.exceptions) {
            if (!ex.value.isPrefixOf(prefix)) continue;
            return ex;
        }
        return null;
    }

    public Set<PrefixSet> getSuffixExceptions(Prefix prefix) {
        HashSet<PrefixSet> result = new HashSet<PrefixSet>();
        for (PrefixSet ex : this.exceptions) {
            if (!prefix.isPrefixOf(ex.value)) continue;
            result.add(ex);
        }
        return result;
    }

    public PrefixSet addException(Prefix exception) {
        boolean isValid = this.contains(exception);
        if (!isValid) {
            throw new RuntimeException("Cannot add exception: " + exception + ", current state: " + this);
        }
        PrefixSet subsumed = this.getExceptionFor(exception);
        if (subsumed == null) {
            subsumed = new PrefixSet(exception);
            this.exceptions.add(subsumed);
        }
        Set<PrefixSet> suffixes = this.getSuffixExceptions(exception);
        this.exceptions.removeAll(suffixes);
        for (PrefixSet suffix : suffixes) {
            subsumed.addException(suffix);
        }
        return subsumed;
    }

    public void addException(PrefixSet that) {
        for (PrefixSet exs : that.exceptions) {
            Prefix p = exs.value;
            PrefixSet added = this.addException(p);
            for (PrefixSet exs2 : exs.exceptions) {
                added.addException(exs2);
            }
        }
    }

    public Set<PrefixSet> getExceptions(String prefix) {
        HashSet<PrefixSet> result = new HashSet<PrefixSet>();
        for (PrefixSet exception : this.exceptions) {
            if (!exception.contains(prefix)) continue;
            result.add(exception);
        }
        return result;
    }

    public static Prefix intersect(Prefix a, Prefix b) {
        Prefix result;
        if (a.isConstant() && b.isConstant()) {
            result = a.getPrefix().equals(b.getPrefix()) ? a : null;
        } else {
            String intersection = PrefixSet.intersect(a.getPrefix(), b.getPrefix());
            result = a.isConstant() ? (a.getPrefix().equals(intersection) ? a : null) : (b.isConstant() ? (b.getPrefix().equals(intersection) ? b : null) : new Prefix(intersection));
        }
        return result;
    }

    public static String intersect(String a, String b) {
        String longer;
        String shorter;
        if (a.length() < b.length()) {
            shorter = a;
            longer = b;
        } else {
            shorter = b;
            longer = a;
        }
        String result = longer.startsWith(shorter) ? shorter : null;
        return result;
    }

    public PrefixSet intersects(PrefixSet that) {
        if (this.polarity.isPositive() && that.polarity.isPositive()) {
            PrefixSet result;
            Prefix intersection = PrefixSet.intersect(this.value, that.value);
            if (intersection == null) {
                Prefix p = new Prefix("");
                result = new PrefixSet(p, Polarity.NEGATIVE);
            } else {
                result = new PrefixSet(intersection, Polarity.POSITIVE);
            }
            for (PrefixSet ps : this.exceptions) {
                result.addException(ps);
            }
            for (PrefixSet ps : that.exceptions) {
                result.addException(ps);
            }
        }
        return that;
    }

    public PrefixSet union(PrefixSet that) {
        return that;
    }

    public PrefixSet negate() {
        HashSet<PrefixSet> newExceptions = new HashSet<PrefixSet>();
        for (PrefixSet exception : this.exceptions) {
            PrefixSet newException = exception.negate();
            newExceptions.add(newException);
        }
        Polarity newPolarity = this.polarity.equals((Object)Polarity.POSITIVE) ? Polarity.POSITIVE : Polarity.NEGATIVE;
        PrefixSet result = new PrefixSet(this.value, newPolarity, newExceptions);
        return result;
    }
}

