/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.inverse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprFunction;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpTable;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.CandidateViewSelectorImpl;
import org.aksw.sparqlify.core.algorithms.MappingOpsImpl;
import org.aksw.sparqlify.core.algorithms.ViewQuad;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.SqlTranslator;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.NestedNormalForm;
import org.aksw.sparqlify.inverse.SparqlSqlInverseMap;
import org.aksw.sparqlify.inverse.SparqlSqlInverseMapper;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;

public class SparqlSqlInverseMapperImpl
implements SparqlSqlInverseMapper {
    private CandidateViewSelectorImpl candidateViewSelector;
    private SqlTranslator sqlTranslator;

    public SparqlSqlInverseMapperImpl(CandidateViewSelectorImpl candidateViewSelector, SqlTranslator sqlTranslator) {
        this.candidateViewSelector = candidateViewSelector;
        this.sqlTranslator = sqlTranslator;
    }

    @Override
    public List<SparqlSqlInverseMap> map(Quad quad) {
        Set<ViewQuad<ViewDefinition>> viewQuads = SparqlSqlInverseMapperImpl.getCandidateViews(this.candidateViewSelector, quad);
        ArrayList<SparqlSqlInverseMap> result = new ArrayList<SparqlSqlInverseMap>();
        for (ViewQuad<ViewDefinition> viewQuad : viewQuads) {
            ViewDefinition viewDef = viewQuad.getView();
            VarDefinition varDef = viewDef.getMapping().getVarDefinition();
            Map<String, TypeToken> typeMap = viewDef.getMapping().getSqlOp().getSchema().getTypeMap();
            SqlOp tmpTable = viewDef.getMapping().getSqlOp();
            if (!(tmpTable instanceof SqlOpTable)) {
                throw new RuntimeException("Not supported: " + tmpTable);
            }
            Quad q = viewQuad.getQuad();
            ExprList exprs = new ExprList();
            for (int i = 0; i < 4; ++i) {
                Node n = QuadUtils.getNode((Quad)q, (int)i);
                if (!n.isVariable()) continue;
                Var v = (Var)n;
                Node insertNode = QuadUtils.getNode((Quad)quad, (int)i);
                if (insertNode.isVariable() || insertNode.isBlank()) continue;
                exprs.add((Expr)new E_Equals((Expr)new ExprVar(v), (Expr)NodeValue.makeNode((Node)insertNode)));
            }
            Expr condition = ExprUtils.andifyBalanced((Iterable)exprs);
            List<SqlExpr> sqlExprs = MappingOpsImpl.createSqlConditionItems(condition, varDef, typeMap, this.sqlTranslator);
            HashMap<S_ColumnRef, SqlValue> columnToValue = new HashMap<S_ColumnRef, SqlValue>();
            for (SqlExpr sqlExpr : sqlExprs) {
                SqlExprFunction fn;
                List<SqlExpr> args = sqlExpr.getArgs();
                SqlExpr left = args.get(0);
                SqlExpr right = args.get(1);
                if (left.isFunction() && (fn = left.asFunction()).getName().equals("str@str")) {
                    left = fn.getArgs().get(0);
                }
                if (left.isConstant()) {
                    SqlExpr tmp = right;
                    right = left;
                    left = tmp;
                }
                if (!left.isVariable()) {
                    throw new RuntimeException("Variable expected, instead got: " + left);
                }
                if (!right.isConstant()) {
                    throw new RuntimeException("Variable expected, instead got: " + right);
                }
                S_ColumnRef columnRef = (S_ColumnRef)left.asVariable();
                SqlValue sqlValue = right.asConstant().getValue();
                columnToValue.put(columnRef, sqlValue);
            }
            SparqlSqlInverseMap inverseMap = new SparqlSqlInverseMap(quad, viewDef, viewQuad.getQuad(), columnToValue);
            result.add(inverseMap);
        }
        return result;
    }

    public static Set<ViewQuad<ViewDefinition>> getCandidateViews(CandidateViewSelectorImpl candidateSelector, Quad quad) {
        Var g = Var.alloc((String)"g");
        Var s = Var.alloc((String)"s");
        Var p = Var.alloc((String)"p");
        Var o = Var.alloc((String)"o");
        Node gv = quad.getGraph();
        Node sv = quad.getSubject();
        Node pv = quad.getPredicate();
        Node ov = quad.getObject();
        Quad tmpQuad = new Quad((Node)g, (Node)s, (Node)p, (Node)o);
        RestrictionManagerImpl r = new RestrictionManagerImpl();
        HashSet<Clause> clauses = new HashSet<Clause>();
        Var[] vars = new Var[]{g, s, p, o};
        Node[] nodes = new Node[]{gv, sv, pv, ov};
        for (int i = 0; i < 4; ++i) {
            Var v = vars[i];
            Node n = nodes[i];
            if (n.isVariable() || n.isBlank()) continue;
            clauses.add(new Clause((Expr)new E_Equals((Expr)new ExprVar(v), (Expr)NodeValue.makeNode((Node)n))));
        }
        NestedNormalForm nnf = new NestedNormalForm(clauses);
        r.stateCnf(nnf);
        Set<ViewQuad<ViewDefinition>> result = candidateSelector.findCandidates(tmpQuad, r);
        return result;
    }
}

