/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.transformations.ExprTransformerBase1;
import org.aksw.sparqlify.type_system.TypeModel;

public class ExprTransformerIsNumeric
extends ExprTransformerBase1 {
    private TypeModel<String> typeModel;

    public ExprTransformerIsNumeric(TypeModel<String> typeModel) {
        this.typeModel = typeModel;
    }

    @Override
    public E_RdfTerm transform(Expr orig, E_RdfTerm a) {
        String subType = a.getDatatype().getConstant().asUnquotedString();
        boolean isDecimal = this.typeModel.isSuperTypeOf((Object)XSD.decimal.toString(), (Object)subType);
        boolean isFloat = this.typeModel.isSuperTypeOf((Object)XSD.xfloat.toString(), (Object)subType);
        boolean isDouble = this.typeModel.isSuperTypeOf((Object)XSD.xdouble.toString(), (Object)subType);
        boolean isNumeric = isDecimal || isFloat || isDouble;
        E_RdfTerm result = isNumeric ? E_RdfTerm.TRUE : E_RdfTerm.FALSE;
        return result;
    }

    public static List<Expr> getTermValues(List<E_RdfTerm> rdfTerms) {
        ArrayList<Expr> result = new ArrayList<Expr>(rdfTerms.size());
        for (E_RdfTerm rdfTerm : rdfTerms) {
            Expr item = rdfTerm.getLexicalValue();
            result.add(item);
        }
        return result;
    }
}

