/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.transformations.ExprTransformer;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.trash.ExprCopy;

public class ExprTransformerConcat
implements ExprTransformer {
    @Override
    public E_RdfTerm transform(Expr fn, List<E_RdfTerm> exprs) {
        ArrayList<Expr> newArgs = new ArrayList<Expr>();
        for (E_RdfTerm expr : exprs) {
            Expr arg = expr.getLexicalValue();
            if (SqlTranslationUtils.isConcatExpr(arg)) {
                ExprFunction fnArg = arg.getFunction();
                for (Expr a : fnArg.getArgs()) {
                    newArgs.add(a);
                }
                continue;
            }
            newArgs.add(arg);
        }
        ExprList merged = SqlTranslationUtils.mergeConsecutiveConstants(newArgs);
        Expr newVal = ExprCopy.getInstance().copy(fn, merged);
        E_RdfTerm result = E_RdfTerm.createTypedLiteral(newVal, XSD.xstring);
        return result;
    }
}

