/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.MakeNodeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class RowMapperSparqlifyBinding
implements RowMapper<Binding> {
    private static final Logger logger = LoggerFactory.getLogger(RowMapperSparqlifyBinding.class);
    private Var rowIdVar;

    public RowMapperSparqlifyBinding() {
        this("rowId");
    }

    public RowMapperSparqlifyBinding(String rowIdName) {
        this.rowIdVar = rowIdName == null ? null : Var.alloc((String)rowIdName);
    }

    public Binding mapRow(ResultSet rs, int rowId) {
        Binding result = RowMapperSparqlifyBinding._map(rs, rowId, this.rowIdVar);
        return result;
    }

    public static Binding _map(ResultSet rs, long rowId, Var rowIdVar) {
        Binding result;
        try {
            result = RowMapperSparqlifyBinding.map(rs, rowId, rowIdVar);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Binding map(ResultSet rs, long rowId, Var rowIdVar) throws SQLException {
        BindingHashMap binding = new BindingHashMap();
        ResultSetMetaData meta = rs.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            NodeValue nodeValue;
            String tmp;
            String colName = meta.getColumnLabel(i);
            Object colValue = rs.getObject(i);
            if (colValue instanceof Date) {
                tmp = colValue.toString();
                nodeValue = NodeValue.makeDate((String)tmp);
            } else if (colValue instanceof Timestamp) {
                tmp = colValue.toString();
                String val = tmp.replace(' ', 'T');
                nodeValue = NodeValue.makeDateTime((String)val);
            } else if (colValue instanceof UUID) {
                nodeValue = NodeValue.makeString((String)colValue.toString());
            } else {
                try {
                    nodeValue = MakeNodeValue.makeNodeValue(colValue);
                }
                catch (Exception e) {
                    logger.error("TODO: Handle unknown column type for " + colValue + " type: " + colValue.getClass());
                    nodeValue = null;
                }
            }
            if (nodeValue == null || nodeValue.equals((Object)E_RdfTerm.TYPE_ERROR)) continue;
            Node node = nodeValue.asNode();
            Var indexVar = Var.alloc((String)("" + i));
            binding.add(indexVar, node);
            Var colVar = Var.alloc((String)colName);
            if (binding.contains(colVar)) continue;
            binding.add(colVar, node);
        }
        if (rowIdVar != null) {
            Node node = NodeValue.makeInteger((long)rowId).asNode();
            binding.add(rowIdVar, node);
        }
        return binding;
    }
}

