/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import org.aksw.sparqlify.core.TypeToken;

public class SqlValue {
    public static final SqlValue TRUE = new SqlValue(TypeToken.Boolean, true);
    public static final SqlValue FALSE = new SqlValue(TypeToken.Boolean, false);
    public static final SqlValue TYPE_ERROR = new SqlValue(TypeToken.TypeError, false);
    private TypeToken typeToken;
    private Object value;

    public SqlValue(TypeToken typeToken, Object value) {
        this.typeToken = typeToken;
        this.value = value;
    }

    public TypeToken getTypeToken() {
        return this.typeToken;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value + "(" + this.typeToken + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeToken == null ? 0 : this.typeToken.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlValue other = (SqlValue)obj;
        if (this.typeToken == null ? other.typeToken != null : !this.typeToken.equals(other.typeToken)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

