/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aksw.commons.util.factory.Factory1;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.DatatypeToString;
import org.aksw.sparqlify.core.algorithms.DatatypeToStringPostgres;
import org.aksw.sparqlify.core.algorithms.SqlExprSerializerDefault;
import org.postgis.PGgeometry;

public class SqlExprSerializerPostgres
extends SqlExprSerializerDefault {
    public SqlExprSerializerPostgres() {
        super(new DatatypeToStringPostgres());
    }

    @Override
    public String serializeConstant(Object value, TypeToken datatype) {
        String result = SqlExprSerializerPostgres.serializeConstantPostgres(this.datatypeSerializer, value, datatype);
        return result;
    }

    public static String serializeConstantPostgres(DatatypeToString datatypeSerializer, Object value, TypeToken datatype) {
        if (datatype.equals(TypeToken.TypeError)) {
            return "FALSE";
        }
        if (value == null) {
            Factory1<String> caster = datatypeSerializer.asString(datatype);
            return (String)caster.create((Object)"NULL");
        }
        if (value instanceof NodeValue) {
            throw new RuntimeException("HACK");
        }
        if (value instanceof String) {
            return SQLUtils.quoteStr((String)value.toString());
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Calendar) {
            Timestamp sqlDateTime = new Timestamp(((Calendar)value).getTime().getTime());
            return SQLUtils.quoteStr((String)sqlDateTime.toString());
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof PGgeometry) {
            return "'SRID=4326;" + value.toString() + "'";
        }
        throw new RuntimeException("Don't know how to serialize " + value + " to an SQL string");
    }
}

