/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprAggregator;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Coalesce;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpExtend;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpGroupBy;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.ExprDatatypeNorm;
import org.aksw.sparqlify.core.algorithms.ExprSqlRewrite;
import org.aksw.sparqlify.core.algorithms.GeneratorBlacklist;
import org.aksw.sparqlify.core.algorithms.MappingOpsImpl;
import org.aksw.sparqlify.core.algorithms.SqlExprContext;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.MappingUnion;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.interfaces.SqlTranslator;
import org.aksw.sparqlify.trash.ExprCommonFactor;

public class MappingRefactor {
    public static ListMultimap<String, Mapping> groupBy(List<Mapping> ms, List<Expr> groupExprs) {
        return null;
    }

    public static ListMultimap<String, Mapping> groupBy(List<Mapping> ms, Expr groupExpr) {
        return null;
    }

    public static String createClusterKey(List<SqlExprContext> contexts, ExprDatatypeNorm exprNormalizer) {
        String result = "";
        for (SqlExprContext context : contexts) {
            E_RdfTerm e = context.getRewrite().asConstRdfTerm();
            result = result + "| " + e.getType() + e.getDatatype();
        }
        return result;
    }

    public static TypeToken getTypeGroup(TypeToken type, TypeSystem typeSystem) {
        HashSet<TypeToken> typeGroupTypes = new HashSet<TypeToken>(Arrays.asList(TypeToken.Int));
        TypeToken result = null;
        for (TypeToken superType : typeGroupTypes) {
            boolean belongsToGroup = typeSystem.isSuperClassOf(type, superType);
            if (!belongsToGroup) continue;
            if (result != null) {
                throw new RuntimeException("Type " + type + " already reassigned to group " + superType + " although already a member of " + result);
            }
            result = superType;
        }
        if (result == null) {
            result = type;
        }
        return result;
    }

    public static <T, U extends Collection<T>> List<List<T>> transpose(Collection<U> items) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (Collection c : items) {
            ArrayList tmp = new ArrayList(c.size());
            result.add(tmp);
        }
        int y = 0;
        for (Collection c : items) {
            int x = 0;
            List col = (List)result.get(x);
            for (Object t : c) {
                col.set(y, t);
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static MappingUnion groupBy(Mapping m, VarExprList groupVars, List<ExprAggregator> aggregators, SqlTranslator sqlTranslator, TypeSystem typeSystem, ExprDatatypeNorm exprNormalizer) {
        MappingUnion result;
        if (groupVars.isEmpty()) {
            Gensym generator = Gensym.create((String)"X");
            Mapping mapping = MappingRefactor.applyAggregators(m, aggregators, (Generator)generator, typeSystem, sqlTranslator);
            result = new MappingUnion();
            result.add(mapping);
        } else {
            result = MappingRefactor.groupByWithExprs(m, groupVars, aggregators, sqlTranslator, typeSystem, exprNormalizer);
        }
        return result;
    }

    public static MappingUnion groupByWithExprs(Mapping m, VarExprList groupVars, List<ExprAggregator> aggregators, SqlTranslator sqlTranslator, TypeSystem typeSystem, ExprDatatypeNorm exprNormalizer) {
        MappingUnion result = new MappingUnion();
        List vars = groupVars.getVars();
        ArrayList<List<SqlExprContext>> contextsLists = new ArrayList<List<SqlExprContext>>();
        for (Var var : vars) {
            Expr expr = groupVars.getExpr(var);
            if (expr == null) {
                expr = new ExprVar(var);
            }
            List<SqlExprContext> contexts = MappingOpsImpl.createExprSqlRewrites(expr, m, sqlTranslator);
            contextsLists.add(contexts);
        }
        ArrayListMultimap sigClusters = ArrayListMultimap.create();
        CartesianProduct cart = CartesianProduct.create(contextsLists);
        for (ArrayList<SqlExprContext> c : cart) {
            c = new ArrayList<SqlExprContext>(c);
            String clusterKey = MappingRefactor.createClusterKey(c, exprNormalizer);
            sigClusters.put((Object)clusterKey, c);
        }
        HashSet<String> columnNameBlacklist = new HashSet<String>(m.getSqlOp().getSchema().getColumnNames());
        GeneratorBlacklist aliasGenUnion = GeneratorBlacklist.create("X", columnNameBlacklist);
        ExprCommonFactor factorizer = new ExprCommonFactor(aliasGenUnion);
        HashMap<String, ArrayListMultimap> groups = new HashMap<String, ArrayListMultimap>();
        for (Map.Entry entry : sigClusters.asMap().entrySet()) {
            String sigKey = (String)entry.getKey();
            Collection sigCluster = (Collection)entry.getValue();
            ArrayListMultimap typeGroup = ArrayListMultimap.create();
            groups.put(sigKey, typeGroup);
            for (List rewriteEntry : sigCluster) {
                String typeKey = "";
                for (SqlExprContext context : rewriteEntry) {
                    TypeToken type = context.getSqlExpr().getDatatype();
                    TypeToken groupType = MappingRefactor.getTypeGroup(type, typeSystem);
                    typeKey = typeKey + "| " + groupType;
                }
                typeGroup.put((Object)typeKey, (Object)rewriteEntry);
            }
        }
        for (Multimap multimap : groups.values()) {
            List args;
            Collection typeGroup = multimap.values();
            ArrayList<E_RdfTerm> grouped = new ArrayList<E_RdfTerm>();
            for (int i = 0; i < vars.size(); ++i) {
                grouped.add(null);
            }
            for (List rewriteEntry : typeGroup) {
                for (int i = 0; i < vars.size(); ++i) {
                    SqlExprContext rewrite = (SqlExprContext)rewriteEntry.get(i);
                    E_RdfTerm gTerm = (E_RdfTerm)((Object)grouped.get(i));
                    E_RdfTerm rdfTerm = rewrite.getRewrite().asConstRdfTerm();
                    E_RdfTerm tmp = gTerm == null ? rdfTerm : (E_RdfTerm)factorizer.transformMM((Expr)gTerm, (Expr)rdfTerm);
                    grouped.set(i, tmp);
                }
            }
            ArrayList sqlExprss = new ArrayList(vars.size());
            for (int i = 0; i < vars.size(); ++i) {
                E_RdfTerm gTerm = (E_RdfTerm)((Object)grouped.get(i));
                ArrayList<Projection> sqlExprs = new ArrayList<Projection>(typeGroup.size());
                for (List rewriteEntry : typeGroup) {
                    SqlExprContext rewrite = (SqlExprContext)rewriteEntry.get(i);
                    sqlExprss.add(sqlExprs);
                    Projection proj = new Projection();
                    args = gTerm.getArgs();
                    for (int j = 0; j < args.size(); ++j) {
                        Expr arg = (Expr)args.get(j);
                        if (arg.isVariable()) {
                            Var var = arg.asVar();
                            ExprSqlRewrite r = rewrite.getRewrite();
                            E_RdfTerm t = r.getRdfTermExpr();
                            Expr e = t.getArg(j + 1);
                            Var v = e.asVar();
                            SqlExpr sqlExpr = r.getProjection().getNameToExpr().get(v.getVarName());
                            proj.put(var.getName(), sqlExpr);
                            continue;
                        }
                        if (arg.isConstant()) continue;
                        throw new RuntimeException("Should not happen");
                    }
                    sqlExprs.add(proj);
                }
            }
            Projection proj = new Projection();
            ArrayList<String> groupColumnNames = new ArrayList<String>();
            HashMultimap varDef = HashMultimap.create();
            for (int i = 0; i < vars.size(); ++i) {
                Var var = (Var)vars.get(i);
                E_RdfTerm group = (E_RdfTerm)((Object)grouped.get(i));
                List sqlExprs = (List)sqlExprss.get(i);
                args = group.getArgs();
                ArrayList<Expr> newArgs = new ArrayList<Expr>(args.size());
                for (Expr arg : args) {
                    Expr newArg;
                    if (arg.isConstant()) {
                        newArg = arg;
                    } else if (arg.isVariable()) {
                        String varName = arg.getVarName();
                        ArrayList<SqlExpr> ss = new ArrayList<SqlExpr>();
                        for (Projection p : sqlExprs) {
                            SqlExpr s = p.getNameToExpr().get(varName);
                            ss.add(s);
                        }
                        SqlExpr sqlCoalesce = S_Coalesce.create(ss);
                        String columnName = aliasGenUnion.next();
                        groupColumnNames.add(columnName);
                        proj.put(columnName, sqlCoalesce);
                        newArg = new ExprVar(columnName);
                    } else {
                        throw new RuntimeException("Should not happen");
                    }
                    newArgs.add(newArg);
                }
                E_RdfTerm groupTerm = new E_RdfTerm(newArgs);
                varDef.put((Object)var, (Object)new RestrictedExpr((Expr)groupTerm));
            }
            HashSet varRefs = new HashSet();
            for (ExprAggregator exprAgg : aggregators) {
                Aggregator agg = exprAgg.getAggregator();
                for (Expr expr : agg.getExprList()) {
                    Set tmp = expr.getVarsMentioned();
                    varRefs.addAll(tmp);
                }
            }
            varRefs.removeAll(varDef.keySet());
            for (Var varRef : varRefs) {
                Collection<RestrictedExpr> tmp = m.getVarDefinition().getDefinitions(varRef);
                varDef.putAll((Object)varRef, tmp);
            }
            SqlOp subOp = m.getSqlOp();
            ArrayList<SqlExpr> groupByExprs = new ArrayList<SqlExpr>(groupColumnNames.size());
            for (String columnName : groupColumnNames) {
                SqlExpr sqlExpr = proj.getNameToExpr().get(columnName);
                groupByExprs.add(sqlExpr);
            }
            SqlOpGroupBy sqlOp = SqlOpGroupBy.create(subOp, groupByExprs, new ArrayList<SqlExprAggregator>());
            VarDefinition vd = new VarDefinition((Multimap<Var, RestrictedExpr>)varDef);
            SqlOpExtend sqlOpExtend = SqlOpExtend.create(sqlOp, proj);
            Mapping mapping = new Mapping(vd, sqlOpExtend);
            Mapping done = MappingRefactor.applyAggregators(mapping, aggregators, aliasGenUnion, typeSystem, sqlTranslator);
            result.add(done);
        }
        return result;
    }

    public static Mapping applyAggregators(Mapping mapping, List<ExprAggregator> aggregators, Generator generator, TypeSystem typeSystem, SqlTranslator sqlTranslator) {
        HashMultimap varDef2 = HashMultimap.create();
        varDef2.putAll(mapping.getVarDefinition().getMap());
        Projection proj2 = new Projection();
        for (ExprAggregator exprAgg : aggregators) {
            Var var = exprAgg.getVar();
            Aggregator agg = exprAgg.getAggregator();
            ExprSqlRewrite rewrite = MappingOpsImpl.rewrite(mapping, agg, generator, typeSystem, sqlTranslator);
            E_RdfTerm rdfTerm = rewrite.getRdfTermExpr();
            varDef2.put((Object)var, (Object)new RestrictedExpr((Expr)rdfTerm));
            proj2.add(rewrite.getProjection());
        }
        SqlOpExtend sqlOpExtend2 = SqlOpExtend.create(mapping.getSqlOp(), proj2);
        VarDefinition vd2 = new VarDefinition((Multimap<Var, RestrictedExpr>)varDef2);
        Mapping result = new Mapping(vd2, sqlOpExtend2);
        return result;
    }

    public static ListMultimap<String, Mapping> groupByOld(ExprDatatypeNorm exprNormalizer, List<Mapping> ms, List<Var> vars) {
        LinkedListMultimap cluster = LinkedListMultimap.create();
        for (Mapping m : ms) {
            Map<String, TypeToken> tmpTypeMap = m.getSqlOp().getSchema().getTypeMap();
            ArrayList<String> hashes = new ArrayList<String>(vars.size());
            for (Var var : vars) {
                String hash;
                Expr expr;
                Collection<RestrictedExpr> defs = m.getVarDefinition().getDefinitions(var);
                if (defs.size() > 1) {
                    throw new RuntimeException("Encountered multiple variable definitions during group by. Var: " + var + " vardef: " + m.getVarDefinition());
                }
                if (defs.isEmpty()) {
                    expr = null;
                } else {
                    RestrictedExpr restExpr = defs.iterator().next();
                    expr = restExpr.getExpr();
                }
                if (expr == null) {
                    hash = "null";
                } else {
                    Expr datatypeNorm = exprNormalizer.normalize(expr, tmpTypeMap);
                    hash = datatypeNorm.toString();
                }
                hashes.add(hash);
            }
            String key = Joiner.on((String)",").join(hashes);
            cluster.put((Object)key, (Object)m);
        }
        return cluster;
    }

    public static List<Mapping> refactorToUnion(Mapping m, List<Var> tmpVars) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        VarDefinition varDef = m.getVarDefinition();
        ArrayList<Var> vars = new ArrayList<Var>(tmpVars.size());
        ArrayList<Collection<RestrictedExpr>> c = new ArrayList<Collection<RestrictedExpr>>(tmpVars.size());
        if (tmpVars.isEmpty()) {
            result.add(m);
            return result;
        }
        for (Var var : tmpVars) {
            Collection<RestrictedExpr> defs = varDef.getDefinitions(var);
            if (defs.isEmpty()) continue;
            vars.add(var);
            c.add(defs);
        }
        HashMultimap baseMap = HashMultimap.create(varDef.getMap());
        baseMap.keySet().removeAll(vars);
        CartesianProduct cart = CartesianProduct.create(c);
        for (List item : cart) {
            HashMultimap map = HashMultimap.create(varDef.getMap());
            for (int i = 0; i < vars.size(); ++i) {
                Var var = (Var)vars.get(i);
                RestrictedExpr restExpr = (RestrictedExpr)item.get(i);
                map.put((Object)var, (Object)restExpr);
            }
            VarDefinition newVd = new VarDefinition((Multimap<Var, RestrictedExpr>)map);
            Mapping newM = new Mapping(newVd, m.getSqlOp());
            result.add(newM);
        }
        return result;
    }

    class SqlTypeGroup {
        RdfTermTypeGroup parent;
        TypeToken groupType;
        private List<SqlExprContext> contexts;

        SqlTypeGroup() {
        }
    }

    class RdfTermTypeGroup {
        private String groupKey;
        private Map<TypeToken, SqlTypeGroup> groupTypeToMembers;

        RdfTermTypeGroup() {
        }
    }
}

