/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.sparqlify.algebra.sparql.transform.E_SqlFunctionRegistered;
import org.aksw.sparqlify.algebra.sql.exprs.ExprSql;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.config.syntax.FunctionDeclarationTemplate;
import org.aksw.sparqlify.config.syntax.ParamType;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.RegisteredFunction;
import org.aksw.sparqlify.core.datatypes.TypeSystem;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.aksw.sparqlify.type_system.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRegistrySql {
    private static final Logger logger = LoggerFactory.getLogger(FunctionRegistrySql.class);
    private TypeSystem datatypeSystem;
    private Multimap<String, RegisteredFunction> registry = HashMultimap.create();

    public FunctionRegistrySql(TypeSystem datatypeSystem) {
        this.datatypeSystem = datatypeSystem;
    }

    public void add(FunctionDeclarationTemplate declaration) {
        String returnTypeName = declaration.getSignature().getReturnTypeName();
        List<ParamType> paramTypeList = declaration.getSignature().getParamTypeList();
        XClass returnType = this.datatypeSystem.requireByName(returnTypeName);
        ArrayList<XClass> parameterTypes = new ArrayList<XClass>();
        for (ParamType paramType : paramTypeList) {
            XClass resPt = this.datatypeSystem.requireByName(paramType.getDatatypeName());
            parameterTypes.add(resPt);
        }
        MethodSignature typeSignature = MethodSignature.create((Object)returnType, parameterTypes, null);
        RegisteredFunction registeredFn = new RegisteredFunction(declaration, (MethodSignature<XClass>)typeSignature);
        this.registry.put((Object)declaration.getSignature().getFunctionName(), (Object)registeredFn);
    }

    public Collection<RegisteredFunction> lookup(String functionName, Iterable<SqlExpr> sqlArgs) {
        ArrayList<TypeToken> argTypes = new ArrayList<TypeToken>();
        for (SqlExpr arg : sqlArgs) {
            if (!(arg instanceof ExprSql)) {
                throw new RuntimeException("Argument does not have an SQL datatype assigned: " + arg + " in function " + functionName);
            }
            argTypes.add(arg.getDatatype());
        }
        Collection signatures = this.registry.get((Object)functionName);
        Collection<RegisteredFunction> result = this.lookup(signatures, argTypes);
        return result;
    }

    public Collection<RegisteredFunction> lookup(Collection<RegisteredFunction> regFns, List<TypeToken> argTypes) {
        ArrayList<RegisteredFunction> result = new ArrayList<RegisteredFunction>();
        for (RegisteredFunction regFn : regFns) {
            MethodSignature<XClass> signature = regFn.getTypeSignature();
            if (signature.getParameterTypes().size() > argTypes.size() || !signature.isVararg() && signature.getParameterTypes().size() < argTypes.size()) continue;
            int n = Math.min(argTypes.size(), signature.getParameterTypes().size());
            boolean isCandidate = true;
            for (int i = 0; i < n; ++i) {
                TypeToken a = argTypes.get(i);
                TypeToken b = null;
                logger.warn("Implement the lookup properly - taking the type hierarchy into account");
                if (!this.datatypeSystem.supremumDatatypes(a, b).isEmpty()) continue;
                isCandidate = false;
            }
            if (!isCandidate) continue;
            result.add(regFn);
        }
        return result;
    }

    public Collection<RegisteredFunction> lookup(ExprFunction fn) {
        String fnId = ExprUtils.getFunctionId(fn);
        Collection<RegisteredFunction> result = null;
        return result;
    }

    public ExprFunction transform(String functionName, List<Expr> args) {
        Collection<RegisteredFunction> candidates = null;
        ExprFunction result = this.pickCandidate(candidates, args);
        return result;
    }

    public ExprFunction transform(ExprFunction func, List<Expr> args) {
        String fnId = ExprUtils.getFunctionId(func);
        ExprFunction result = this.transform(fnId, args);
        return result;
    }

    public ExprFunction transform(ExprFunction func) {
        ExprFunction result = this.transform(func, (List<Expr>)func.getArgs());
        return result;
    }

    public ExprFunction pickCandidate(Collection<RegisteredFunction> candidates, List<Expr> args) {
        switch (candidates.size()) {
            case 0: {
                logger.warn("Returning false; although it should be type-error");
                return null;
            }
            case 1: {
                RegisteredFunction regFn = candidates.iterator().next();
                E_SqlFunctionRegistered result = new E_SqlFunctionRegistered(regFn, args);
                return result;
            }
        }
        logger.warn("Multiple overloads matched: " + candidates);
        logger.warn("Returning false; although it should be type-error");
        return null;
    }
}

