/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.core.algorithms.ExprTransformer;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprTransformerMapOld
implements ExprTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ExprTransformerMapOld.class);
    private Map<String, ExprTransformer> idToTransformer = new HashMap<String, ExprTransformer>();
    private static Set<Expr> seenErrors = new HashSet<Expr>();

    public ExprTransformerMapOld() {
    }

    public ExprTransformerMapOld(Map<String, ExprTransformer> idToTransformer) {
        this.idToTransformer = idToTransformer;
    }

    public Map<String, ExprTransformer> getTransformerMap() {
        return this.idToTransformer;
    }

    public ExprTransformer lookup(ExprFunction fn) {
        String id = ExprUtils.getFunctionId(fn);
        ExprTransformer result = this.idToTransformer.get(id);
        return result;
    }

    @Override
    public Expr transform(ExprFunction expr) {
        ExprFunction result = expr;
        if (expr.isFunction()) {
            ExprFunction fn = expr.getFunction();
            ExprTransformer transformer = this.lookup(fn);
            if (transformer != null) {
                result = transformer.transform(expr);
            } else if (!seenErrors.contains(fn)) {
                logger.warn("No transformer registered for " + fn);
                seenErrors.add((Expr)fn);
            }
        }
        return result;
    }
}

