/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.List;
import org.aksw.sparqlify.core.algorithms.ExprTransformer;

public class ExprTransformerLogicalAnd
implements ExprTransformer {
    public static NodeValue min(NodeValue a, NodeValue b) {
        if (a.equals((Object)NodeValue.nvNothing)) {
            if (!b.equals((Object)NodeValue.FALSE)) {
                return a;
            }
            return b;
        }
        if (a.equals((Object)NodeValue.FALSE)) {
            return a;
        }
        return b;
    }

    public static Expr getLowerConstant(Expr a, Expr b) {
        NodeValue result = null;
        if (a.isConstant()) {
            result = a.getConstant();
        }
        if (b.isConstant()) {
            NodeValue bValue = b.getConstant();
            result = result != null ? ExprTransformerLogicalAnd.min(result, bValue) : bValue;
        }
        return result;
    }

    @Override
    public Expr transform(ExprFunction fn) {
        Expr fnArg;
        Expr right;
        List args = fn.getArgs();
        if (args.size() != 2) {
            throw new RuntimeException("Invalid number of arguments; 1 expected, got: " + fn);
        }
        Expr left = (Expr)args.get(0);
        Expr tmp = ExprTransformerLogicalAnd.getLowerConstant(left, right = (Expr)args.get(1));
        if (tmp == null) {
            return fn;
        }
        if (tmp.equals(NodeValue.FALSE)) {
            return NodeValue.FALSE;
        }
        Expr expr = fnArg = left.isFunction() ? left : right;
        if (fnArg.isFunction()) {
            if (tmp.equals(NodeValue.TRUE)) {
                return fnArg;
            }
            return new E_LogicalAnd(tmp, fnArg);
        }
        return tmp;
    }
}

