/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.config.v0_2.bridge;

import com.google.common.base.Function;
import com.hp.hpl.jena.sparql.expr.E_Str;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.trash.ExprCopy;

class ExprTransformerUtils {
    public static final Function<Expr, Expr> expandRdfTerms = new Function<Expr, Expr>(){

        public Expr apply(@Nullable Expr expr) {
            E_RdfTerm result = SqlTranslationUtils.expandAnyToTerm(expr);
            if (result == null) {
                throw new RuntimeException("Could not expand rdf terms in " + expr);
            }
            return result;
        }
    };
    public static final Function<Expr, Expr> injectStrsIntoConcats = new Function<Expr, Expr>(){

        public Expr apply(@Nullable Expr expr) {
            Expr result;
            if (expr.isFunction()) {
                ExprFunction fn = expr.getFunction();
                boolean isConcat = SqlTranslationUtils.isConcatExpr((Expr)fn);
                List args = fn.getArgs();
                ArrayList<Expr> newArgs = new ArrayList<Expr>(args.size());
                for (Expr arg : args) {
                    Expr newArg;
                    Expr tmpArg = this.apply(arg);
                    if (isConcat && tmpArg.isVariable()) {
                        ExprVar ev = tmpArg.getExprVar();
                        newArg = new E_Str((Expr)ev);
                    } else {
                        newArg = tmpArg;
                    }
                    newArgs.add(newArg);
                }
                result = ExprCopy.getInstance().copy(expr, newArgs);
            } else {
                result = expr;
            }
            return result;
        }
    };

    ExprTransformerUtils() {
    }
}

